/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.control;

import com.fr.data.dao.DAOBean;
import com.fr.data.dao.RelationObject;
import com.fr.fs.FSConfig;
import com.fr.fs.PlateFactory;
import com.fr.fs.RoleCheckUtils;
import com.fr.fs.base.entity.CustomRole;
import com.fr.fs.base.entity.RoleDataConnectionPrivilege;
import com.fr.fs.base.entity.RoleDepAndCRolePrivilege;
import com.fr.fs.base.entity.RoleEntryPrivilege;
import com.fr.fs.base.entity.RoleHomePagePrivilege;
import com.fr.fs.base.entity.RoleModulePrivilege;
import com.fr.fs.base.entity.RoleTemplatePrivilege;
import com.fr.fs.base.entity.User;
import com.fr.fs.cache.CustomRoleCache;
import com.fr.fs.cache.EntryTypeAndID;
import com.fr.fs.cache.IDLockCreator;
import com.fr.fs.cache.UserCache;
import com.fr.fs.control.CompanyRoleControl;
import com.fr.fs.control.DepartmentControl;
import com.fr.fs.control.HomePageControl;
import com.fr.fs.control.ModuleControl;
import com.fr.fs.control.PostControl;
import com.fr.fs.web.FSConstants;
import com.fr.general.FRLogger;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomRoleControl {
    private static CustomRoleControl sc;
    private final IDLockCreator sroleDaoIDLockCreator = new IDLockCreator();

    public static CustomRoleControl getInstance() {
        if (sc == null) {
            sc = new CustomRoleControl();
        }
        return sc;
    }

    public long getSuperCustomRoleID() {
        return -999L;
    }

    public String getSupperRoleName() {
        return "SUPERROLE";
    }

    public CustomRole getCustomRole(long l) throws Exception {
        if (l == this.getSuperCustomRoleID()) {
            CustomRole customRole = new CustomRole(l);
            customRole.setRolename(this.getSupperRoleName());
            customRole.setDescription(FSConstants.CUSTOMROLE.COMPATIABLE_SUPER_SROLE_NAME);
            return customRole;
        }
        return FSConfig.getInstance().getControl().getCustomRoleDAO().findByID(l);
    }

    public Set<CustomRole> getCustomRoleSet(long l) throws Exception {
        HashSet<CustomRole> hashSet = new HashSet<CustomRole>();
        List<CustomRole> list = this.getAllCustomRole();
        for (CustomRole customRole : list) {
            if (!this.getUsersID(customRole.getId()).contains(l)) continue;
            hashSet.add(customRole);
        }
        return hashSet;
    }

    public boolean addCustomRole(CustomRole customRole) throws Exception {
        if (customRole == null) {
            return false;
        }
        customRole.setId(-1L);
        FSConfig.getInstance().getControl().getCustomRoleDAO().save(customRole);
        if (customRole.getId() >= 0L) {
            try {
                CustomRoleCache.cacheNew(customRole);
            }
            catch (Exception exception) {
                CustomRoleCache.reInitCache();
            }
            return true;
        }
        return false;
    }

    public List<CustomRole> getAllCustomRole() throws Exception {
        List list = FSConfig.getInstance().getControl().getCustomRoleDAO().findAll();
        return list;
    }

    public JSONArray getCustomRoleInfoPrivilege(long l) throws Exception {
        if (l == this.getSuperCustomRoleID()) {
            return this.getAllCustomRoleInfo();
        }
        JSONArray jSONArray = new JSONArray();
        Set<Object> set = new HashSet();
        try {
            set = UserCache.getAllDepAndCRolePrivileges(l);
        }
        catch (Exception exception) {
            FRLogger.getLogger().error(exception.getMessage());
        }
        List<CustomRole> list = this.getAllCustomRole();
        if (list != null) {
            int n = list.size();
            block2: for (int i = 0; i < n; ++i) {
                CustomRole customRole = list.get(i);
                for (RoleDepAndCRolePrivilege roleDepAndCRolePrivilege : set) {
                    if (roleDepAndCRolePrivilege.getDeporcroleid() == -2L && roleDepAndCRolePrivilege.getType() == 0) {
                        return this.getAllCustomRoleInfo();
                    }
                    if (roleDepAndCRolePrivilege.getType() != 2 || customRole.getId() != roleDepAndCRolePrivilege.getDeporcroleid()) continue;
                    jSONArray.put((Object)customRole.createJSONConfig());
                    continue block2;
                }
            }
        }
        return jSONArray;
    }

    public JSONArray getAllCustomRoleInfo() throws Exception {
        JSONArray jSONArray = new JSONArray();
        List<CustomRole> list = this.getAllCustomRole();
        if (list != null) {
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                CustomRole customRole = list.get(i);
                jSONArray.put((Object)customRole.createJSONConfig());
            }
        }
        return jSONArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteCustomRole(long l) throws Exception {
        boolean bl;
        if (l < 0L) {
            return false;
        }
        Object object = this.sroleDaoIDLockCreator.getIDLock(l);
        List<EntryTypeAndID> list = CustomRoleControl.getInstance().getAllEntryPrivileges(l);
        List<RoleModulePrivilege> list2 = CustomRoleControl.getInstance().getAllModulePrivileges(l);
        List<String> list3 = CustomRoleControl.getInstance().getAllDepAndCRolePrivilegeDescriptions(l);
        CustomRoleControl.getInstance().updateEntryPrivileges(l, null, new HashSet<EntryTypeAndID>(list));
        CustomRoleControl.getInstance().updateModulePrivileges(l, null, new HashSet<RoleModulePrivilege>(list2));
        CustomRoleControl.getInstance().updateDepAndCRolePrivileges(l, null, new HashSet<String>(list3));
        try {
            Object object2 = object;
            synchronized (object2) {
                bl = FSConfig.getInstance().getControl().getCustomRoleDAO().deleteByID(l);
            }
        }
        finally {
            this.sroleDaoIDLockCreator.releaseIDLock();
        }
        if (bl) {
            try {
                CustomRoleCache.removeCache(l);
                UserCache.refreshAfterDelSRole(l);
            }
            catch (Exception exception) {
                CustomRoleCache.reInitCache();
            }
            try {
                UserCache.refreshAfterDelSRole(l);
            }
            catch (Exception exception) {
                UserCache.removeAllCache();
            }
        }
        return bl;
    }

    public String getCustomRoleName(long l) {
        if (l == this.getSuperCustomRoleID()) {
            return this.getSupperRoleName();
        }
        return CustomRoleCache.getSRoleName(l);
    }

    public boolean updateCustomRoleName(long l, String string) throws Exception {
        if (FSConfig.getInstance().getControl().getCustomRoleDAO().updateRoleName(l, string)) {
            try {
                CustomRoleCache.refreshCustomRoleName(l, string);
            }
            catch (Exception exception) {
                CustomRoleCache.reInitCache();
            }
        }
        return false;
    }

    public CustomRole findByCustomRoleName(String string) throws Exception {
        return FSConfig.getInstance().getControl().getCustomRoleDAO().findByRoleName(string);
    }

    public List<EntryTypeAndID> getAllEntryPrivileges(long l) {
        if (l == this.getSuperCustomRoleID()) {
            ArrayList<EntryTypeAndID> arrayList = new ArrayList<EntryTypeAndID>(1);
            arrayList.add(EntryTypeAndID.getInstance(0, -1L, 1L, 1L, 1L));
            return arrayList;
        }
        return CustomRoleCache.getAllEntryPrivileges(l);
    }

    public List<JSONObject> getAllEntryPrivilegesJO(long l) {
        ArrayList<JSONObject> arrayList = new ArrayList<JSONObject>();
        List<EntryTypeAndID> list = this.getAllEntryPrivileges(l);
        for (EntryTypeAndID entryTypeAndID : list) {
            try {
                arrayList.add(entryTypeAndID.toJSONObject());
            }
            catch (JSONException jSONException) {
                FRLogger.getLogger().error(jSONException.getMessage());
            }
        }
        return arrayList;
    }

    public List<String> getAllESPrivilegeDescriptions(long l) {
        if (l == this.getSuperCustomRoleID()) {
            ArrayList<String> arrayList = new ArrayList<String>(1);
            arrayList.add("0-1");
            return arrayList;
        }
        return CustomRoleCache.getAllESPrivilegeDescriptions(l);
    }

    public List<EntryTypeAndID> getAllEntryPrivileges4Obj(long l) {
        if (l == this.getSuperCustomRoleID()) {
            ArrayList<EntryTypeAndID> arrayList = new ArrayList<EntryTypeAndID>(1);
            arrayList.add(EntryTypeAndID.getInstance(0, -1L, 1L, 1L, 1L));
            return arrayList;
        }
        return CustomRoleCache.getAllEntryPrivileges(l);
    }

    public JSONArray getAllDepAndCRoleInfo(long l) throws Exception {
        if (l == this.getSuperCustomRoleID()) {
            JSONArray jSONArray = CompanyRoleControl.getInstance().getAllCompanyRoleInfo();
            JSONArray jSONArray2 = this.getAllCustomRoleInfo();
            int n = jSONArray2.length();
            for (int i = 0; i < n; ++i) {
                jSONArray.put(jSONArray2.get(i));
            }
            return jSONArray;
        }
        JSONArray jSONArray = new JSONArray();
        List<RoleDepAndCRolePrivilege> list = CustomRoleCache.getAllDepAndCRolePrivileges(l);
        for (RoleDepAndCRolePrivilege roleDepAndCRolePrivilege : list) {
            DAOBean dAOBean;
            if (roleDepAndCRolePrivilege.getType() == 1) {
                dAOBean = CompanyRoleControl.getInstance().getJRole(roleDepAndCRolePrivilege.getRoleid());
                JSONObject jSONObject = dAOBean.createJSONConfig();
                String string = DepartmentControl.getInstance().getDepartmentShowName(dAOBean.getDepartmentId(), ",");
                String string2 = PostControl.getInstance().getPostName(dAOBean.getPostId());
                if (string == null || string2 == null) continue;
                jSONObject.put("departmentname", (Object)string);
                jSONObject.put("postname", (Object)string2);
                jSONArray.put((Object)jSONObject);
                continue;
            }
            if (roleDepAndCRolePrivilege.getType() != 2) continue;
            dAOBean = CustomRoleControl.getInstance().getCustomRole(roleDepAndCRolePrivilege.getRoleid());
            jSONArray.put((Object)dAOBean.createJSONConfig());
        }
        return jSONArray;
    }

    public List getAllModulePrivilegesJO(long l) {
        ArrayList<JSONObject> arrayList = new ArrayList<JSONObject>();
        List<RoleModulePrivilege> list = this.getAllModulePrivileges(l);
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            arrayList.add(list.get(i).toJSONObject());
        }
        return arrayList;
    }

    public List<RoleDepAndCRolePrivilege> getAllDepAndCRolePrivileges(long l) {
        return CustomRoleCache.getAllDepAndCRolePrivileges(l);
    }

    public List<String> getAllDepAndCRolePrivilegeDescriptions(long l) {
        return CustomRoleCache.getAllDepAndCRolePrivilegeDescriptions(l);
    }

    public List getAllDepAndCRolePrivileges(long l, boolean bl) throws JSONException {
        return CustomRoleCache.getAllDepAndCRolePrivileges(l, bl);
    }

    public Set<RoleDataConnectionPrivilege> getAllDataConnectionPrivileges(long l) {
        return CustomRoleCache.getAllDataConnectionPrivileges(l);
    }

    public List<RoleTemplatePrivilege> getAllTemplatePrivileges(long l) {
        return CustomRoleCache.getAllTemplatePrivileges(l);
    }

    public List<RoleModulePrivilege> getAllModulePrivileges(long l) {
        if (l == this.getSuperCustomRoleID()) {
            return ModuleControl.getInstance().getAllRoleModulePrivilege();
        }
        return CustomRoleCache.getAllModulePrivileges(l);
    }

    public List<RoleHomePagePrivilege> getAllHomePagePrivileges(long l) {
        if (l == this.getSuperCustomRoleID()) {
            return HomePageControl.getInstance().getAllRoleHomePagePrivilege();
        }
        return CustomRoleCache.getAllHomePagePrivileges(l);
    }

    public List<String> getAllPlatePrivileges(long l, String string) {
        if (l == this.getSuperCustomRoleID()) {
            return PlateFactory.getPlateByName(string).getAllPrivilegesID();
        }
        return CustomRoleCache.getAllPrivilegesWithPlateName(l, string);
    }

    public boolean containModulePrivilege(long l, long l2) {
        if (l == this.getSuperCustomRoleID()) {
            return true;
        }
        if (l2 < 0L) {
            return false;
        }
        return CustomRoleCache.containModulePrivilege(l, l2);
    }

    public boolean containHomPagePrivilege(long l, long l2) {
        if (l == this.getSuperCustomRoleID()) {
            return true;
        }
        if (l2 < 0L) {
            return false;
        }
        return CustomRoleCache.containHomePagePrivilege(l, l2);
    }

    public boolean containPlatePrivilege(long l, long l2, String string) {
        if (l == this.getSuperCustomRoleID()) {
            return true;
        }
        if (l2 < 0L) {
            return false;
        }
        return CustomRoleCache.containPlatePrivilege(l, l2, string);
    }

    public boolean containEntryPrivilege(long l, int n, long l2) {
        if (l == this.getSuperCustomRoleID()) {
            return true;
        }
        if (l2 < -1L) {
            return false;
        }
        return CustomRoleCache.containEntryPrivilege(l, n, l2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateModulePrivileges(long l, Set<RoleModulePrivilege> set, Set<RoleModulePrivilege> set2) throws Exception {
        if (l < 0L) {
            return;
        }
        Object object = this.sroleDaoIDLockCreator.getIDLock(l);
        try {
            Object object2 = object;
            synchronized (object2) {
                ArrayList<RoleModulePrivilege> arrayList = new ArrayList<RoleModulePrivilege>();
                if (set != null) {
                    arrayList.addAll(set);
                }
                ArrayList<RoleModulePrivilege> arrayList2 = new ArrayList<RoleModulePrivilege>();
                if (set2 != null) {
                    arrayList2.addAll(set2);
                }
                FSConfig.getInstance().getControl().getCustomRoleDAO().updateModulePrivileges(l, arrayList, arrayList2);
            }
        }
        finally {
            this.sroleDaoIDLockCreator.releaseIDLock();
        }
        try {
            CustomRoleCache.refreshModulePrivileges(l, FSConfig.getInstance().getControl().getCustomRoleDAO().getModulePrivileges(l));
        }
        catch (Exception exception) {
            CustomRoleCache.reInitCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateHomePagePrivileges(long l, Set<RoleHomePagePrivilege> set, Set<RoleHomePagePrivilege> set2) throws Exception {
        if (l < 0L) {
            return;
        }
        Object object = this.sroleDaoIDLockCreator.getIDLock(l);
        try {
            Object object2 = object;
            synchronized (object2) {
                ArrayList<RoleHomePagePrivilege> arrayList = new ArrayList<RoleHomePagePrivilege>();
                if (set != null) {
                    arrayList.addAll(set);
                }
                ArrayList<RoleHomePagePrivilege> arrayList2 = new ArrayList<RoleHomePagePrivilege>();
                if (set2 != null) {
                    arrayList2.addAll(set2);
                }
                FSConfig.getInstance().getControl().getCustomRoleDAO().updateHomePagePrivileges(l, arrayList, arrayList2);
            }
        }
        finally {
            this.sroleDaoIDLockCreator.releaseIDLock();
        }
        try {
            CustomRoleCache.refreshHomePagePrivileges(l, FSConfig.getInstance().getControl().getCustomRoleDAO().getHomePagePrivileges(l));
        }
        catch (Exception exception) {
            CustomRoleCache.reInitCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDepAndCRolePrivileges(long l, Set<String> set, Set<String> set2) throws Exception {
        if (l < 0L) {
            return;
        }
        Object object = this.sroleDaoIDLockCreator.getIDLock(l);
        try {
            Object object2 = object;
            synchronized (object2) {
                ArrayList<String> arrayList = new ArrayList<String>();
                if (set != null) {
                    arrayList.addAll(set);
                }
                ArrayList<String> arrayList2 = new ArrayList<String>();
                if (set2 != null) {
                    arrayList2.addAll(set2);
                }
                FSConfig.getInstance().getControl().getCustomRoleDAO().updateDepAndCrolePrivilege(l, arrayList, arrayList2);
            }
        }
        finally {
            this.sroleDaoIDLockCreator.releaseIDLock();
        }
        try {
            CustomRoleCache.refreshDepAndCRolePrivileges(l, FSConfig.getInstance().getControl().getCustomRoleDAO().getDepAndCrolePrivileges(l));
        }
        catch (Exception exception) {
            CustomRoleCache.reInitCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDataConnectionPrivileges(long l, Set set, Set set2) throws Exception {
        if (l < 0L) {
            return;
        }
        Object object = this.sroleDaoIDLockCreator.getIDLock(l);
        try {
            Object object2 = object;
            synchronized (object2) {
                ArrayList<String> arrayList = new ArrayList<String>();
                if (set != null) {
                    arrayList.addAll(set);
                }
                ArrayList<String> arrayList2 = new ArrayList<String>();
                if (set2 != null) {
                    arrayList2.addAll(set2);
                }
                FSConfig.getInstance().getControl().getCustomRoleDAO().updateDataConnectionPrivileges(l, arrayList, arrayList2);
            }
        }
        finally {
            this.sroleDaoIDLockCreator.releaseIDLock();
        }
        try {
            CustomRoleCache.refreshDataConnectionPrivileges(l, FSConfig.getInstance().getControl().getCustomRoleDAO().getDataConnectionPrivileges(l));
        }
        catch (Exception exception) {
            CustomRoleCache.reInitCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updatePlatePrivileges(long l, Set set, Set set2, String string) throws Exception {
        if (RoleCheckUtils.isNotNormalID(l)) {
            return;
        }
        Object object = this.sroleDaoIDLockCreator.getIDLock(l);
        try {
            Object object2 = object;
            synchronized (object2) {
                ArrayList<RoleEntryPrivilege> arrayList = new ArrayList<RoleEntryPrivilege>();
                if (set != null) {
                    arrayList.addAll(set);
                }
                ArrayList<RoleEntryPrivilege> arrayList2 = new ArrayList<RoleEntryPrivilege>();
                if (set2 != null) {
                    arrayList2.addAll(set2);
                }
                FSConfig.getInstance().getControl().getCustomRoleDAO().updatePlatePrivileges(l, arrayList, arrayList2, string);
            }
        }
        finally {
            this.sroleDaoIDLockCreator.releaseIDLock();
        }
        try {
            CustomRoleCache.refreshPrivilegesWithPlateName(l, FSConfig.getInstance().getControl().getCustomRoleDAO().getPrivilegesWithPlateName(l, string), string);
        }
        catch (Exception exception) {
            CustomRoleCache.reInitCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateEntryPrivileges(long l, Set<EntryTypeAndID> set, Set<EntryTypeAndID> set2) throws Exception {
        if (l < 0L) {
            return;
        }
        Object object = this.sroleDaoIDLockCreator.getIDLock(l);
        try {
            Object object2 = object;
            synchronized (object2) {
                ArrayList<EntryTypeAndID> arrayList = new ArrayList<EntryTypeAndID>();
                if (set != null) {
                    arrayList.addAll(set);
                }
                ArrayList<EntryTypeAndID> arrayList2 = new ArrayList<EntryTypeAndID>();
                if (set2 != null) {
                    arrayList2.addAll(set2);
                }
                FSConfig.getInstance().getControl().getCustomRoleDAO().updateEntryPrivileges(l, arrayList, arrayList2);
            }
        }
        finally {
            this.sroleDaoIDLockCreator.releaseIDLock();
        }
        try {
            CustomRoleCache.refreshEntryPrivileges(l, FSConfig.getInstance().getControl().getCustomRoleDAO().getEntryPrivileges(l));
        }
        catch (Exception exception) {
            CustomRoleCache.reInitCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTemplatePrivileges(long l, Set<RoleTemplatePrivilege> set, Set<RoleTemplatePrivilege> set2) throws Exception {
        if (l < 0L) {
            return;
        }
        Object object = this.sroleDaoIDLockCreator.getIDLock(l);
        try {
            Object object2 = object;
            synchronized (object2) {
                ArrayList<RoleTemplatePrivilege> arrayList = new ArrayList<RoleTemplatePrivilege>();
                if (set != null) {
                    arrayList.addAll(set);
                }
                ArrayList<RoleTemplatePrivilege> arrayList2 = new ArrayList<RoleTemplatePrivilege>();
                if (set2 != null) {
                    arrayList2.addAll(set2);
                }
                FSConfig.getInstance().getControl().getCustomRoleDAO().updateTemplatePrivileges(l, arrayList, arrayList2);
            }
        }
        finally {
            this.sroleDaoIDLockCreator.releaseIDLock();
        }
        try {
            CustomRoleCache.refreshTemplatePrivileges(l, FSConfig.getInstance().getControl().getCustomRoleDAO().getTemplatePrivileges(l));
        }
        catch (Exception exception) {
            CustomRoleCache.reInitCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateESPrivileges(long l, Set<EntryTypeAndID> set, Set<EntryTypeAndID> set2) throws Exception {
        if (l < 0L) {
            return;
        }
        Object object = this.sroleDaoIDLockCreator.getIDLock(l);
        try {
            Object object2 = object;
            synchronized (object2) {
                ArrayList<EntryTypeAndID> arrayList = new ArrayList<EntryTypeAndID>();
                if (set != null) {
                    arrayList.addAll(set);
                }
                ArrayList<EntryTypeAndID> arrayList2 = new ArrayList<EntryTypeAndID>();
                if (set2 != null) {
                    arrayList2.addAll(set2);
                }
                FSConfig.getInstance().getControl().getCustomRoleDAO().updateESPrivileges(l, arrayList, arrayList2);
            }
        }
        finally {
            this.sroleDaoIDLockCreator.releaseIDLock();
        }
        try {
            CustomRoleCache.refreshESPrivileges(l, FSConfig.getInstance().getControl().getCustomRoleDAO().getESPrivileges(l));
        }
        catch (Exception exception) {
            CustomRoleCache.reInitCache();
        }
    }

    public Set getUsersID(long l) throws Exception {
        HashSet<Long> hashSet = new HashSet<Long>();
        Set<RelationObject> set = this.getUsers(l, true);
        if (set != null) {
            for (RelationObject relationObject : set) {
                User user = (User)((Object)relationObject.getValue(User.class));
                hashSet.add(new Long(user.getId()));
            }
        }
        return hashSet;
    }

    public Set<RelationObject> getUsers(long l, boolean bl) throws Exception {
        return FSConfig.getInstance().getControl().getCustomRoleDAO().getUserSet(l, bl);
    }

    public JSONArray getUsersInfo(long l) throws Exception {
        JSONArray jSONArray = new JSONArray();
        Set<RelationObject> set = this.getUsers(l, true);
        if (set != null) {
            for (RelationObject relationObject : set) {
                User user = (User)((Object)relationObject.getValue(User.class));
                JSONObject jSONObject = new JSONObject();
                jSONObject.put("userid", user.getId());
                jSONObject.put("text", (Object)user.getUsername());
                jSONArray.put((Object)jSONObject);
            }
        }
        return jSONArray;
    }

    public void addUsers(long l, long[] lArray) throws Exception {
        if (l < 0L || lArray == null) {
            return;
        }
        HashSet<User> hashSet = new HashSet<User>();
        for (int i = 0; i < lArray.length; ++i) {
            hashSet.add(new User(lArray[i]));
        }
        FSConfig.getInstance().getControl().getCustomRoleDAO().addUsers(l, hashSet);
        UserCache.refreshAfterAddSRole(lArray, l);
    }

    public void removeUsers(long l, long[] lArray) throws Exception {
        if (l < 0L || lArray == null) {
            return;
        }
        HashSet<User> hashSet = new HashSet<User>();
        for (int i = 0; i < lArray.length; ++i) {
            hashSet.add(new User(lArray[i]));
        }
        FSConfig.getInstance().getControl().getCustomRoleDAO().removeUsers(l, hashSet);
        UserCache.refreshAfterDelSRoleUser(lArray, l);
    }

    public void reset() {
        sc = null;
    }
}

