/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.cache.tabledata;

import com.fr.base.FRContext;
import com.fr.base.TableData;
import com.fr.data.dao.ClassArrayKey;
import com.fr.data.dao.DAOBean;
import com.fr.data.dao.RelationObject;
import com.fr.data.impl.EmbeddedTableData;
import com.fr.data.impl.RecursionDataModel;
import com.fr.data.impl.RecursionTableData;
import com.fr.file.DatasourceManager;
import com.fr.fs.FSContext;
import com.fr.fs.PlateFactory;
import com.fr.fs.base.entity.CompanyRole;
import com.fr.fs.base.entity.CompanyRoleDataConnectionPrivilege;
import com.fr.fs.base.entity.CompanyRoleDepAndCRolePrivilege;
import com.fr.fs.base.entity.CompanyRoleESPrivilege;
import com.fr.fs.base.entity.CompanyRoleEntryPrivilege;
import com.fr.fs.base.entity.CompanyRoleHomePagePrivilege;
import com.fr.fs.base.entity.CompanyRoleModulePrivilege;
import com.fr.fs.base.entity.CompanyRoleTemplatePrivilege;
import com.fr.fs.base.entity.CustomRole;
import com.fr.fs.base.entity.CustomRoleDataConnectionPrivilege;
import com.fr.fs.base.entity.CustomRoleDepAndCRolePrivilege;
import com.fr.fs.base.entity.CustomRoleESPrivilege;
import com.fr.fs.base.entity.CustomRoleEntryPrivilege;
import com.fr.fs.base.entity.CustomRoleHomePagePrivilege;
import com.fr.fs.base.entity.CustomRoleModulePrivilege;
import com.fr.fs.base.entity.CustomRoleTemplatePrivilege;
import com.fr.fs.base.entity.Department;
import com.fr.fs.base.entity.FavoriteNode;
import com.fr.fs.base.entity.Post;
import com.fr.fs.base.entity.RoleDataConnectionPrivilege;
import com.fr.fs.base.entity.RoleDepAndCRolePrivilege;
import com.fr.fs.base.entity.RoleESPrivilege;
import com.fr.fs.base.entity.RoleEntryPrivilege;
import com.fr.fs.base.entity.RoleHomePagePrivilege;
import com.fr.fs.base.entity.RoleModulePrivilege;
import com.fr.fs.base.entity.RoleTemplatePrivilege;
import com.fr.fs.base.entity.User;
import com.fr.fs.cache.EntryTypeAndID;
import com.fr.fs.cache.Job;
import com.fr.fs.cache.tabledata.TableDataDAOBean;
import com.fr.fs.cache.tabledata.TableDataFavoriteNode;
import com.fr.fs.cache.tabledata.TableDataJRole;
import com.fr.fs.cache.tabledata.TableDataSRole_User;
import com.fr.fs.cache.tabledata.TableDataUser;
import com.fr.fs.control.dao.tabledata.TableDataDAOControl;
import com.fr.fs.web.FSConstants;
import com.fr.general.ComparatorUtils;
import com.fr.general.data.DataModel;
import com.fr.script.Calculator;
import com.fr.stable.Primitive;
import com.fr.stable.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableDataSyncDB {
    private static final long DEFAULT_PID = -1L;
    public static final long SYNCROLEIDSTARTINGID = -1000L;
    private static Department ALL_DEPARTMENT = new Department(0L, FSConstants.COMPANYROLE.DEPARTMENT_ALL_NAME, "", -2L);
    private static TableDataSyncDB tdc;
    private Map<String, Long> departIdMap = new ConcurrentHashMap<String, Long>();
    private Set<Long> excludeIdMap = new HashSet<Long>();
    private Map<String, Long> unrepeatUserIdMap = new ConcurrentHashMap<String, Long>();
    private Set companyRoleIdGen = new HashSet();
    private final Map<Long, TableDataUser> tdUser_idListMap = new Hashtable<Long, TableDataUser>();
    private Map<String, TableDataUser> tdUser_NameListMap = new Hashtable<String, TableDataUser>();
    private Map<Long, Department> dp_idMap = new Hashtable<Long, Department>();
    private Map<String, Department> dp_nameMap = new Hashtable<String, Department>();
    private Map<String, Long> id_postMap = new Hashtable<String, Long>();
    private Map<Long, CustomRole> customRoleIDListMap = new Hashtable<Long, CustomRole>();
    private final Map<String, CustomRole> customRoleNameListMap = new Hashtable<String, CustomRole>();
    private final Map<Long, TableDataSRole_User> customRoleUserIDMap = new Hashtable<Long, TableDataSRole_User>();
    private final Map<Long, RoleEntryPrivilege> customRolePrivilegeIDMap = new Hashtable<Long, RoleEntryPrivilege>();
    private final Map<Long, RoleESPrivilege> customRoleESPrivilegeIDMap = new Hashtable<Long, RoleESPrivilege>();
    private final Map<Long, RoleModulePrivilege> customRoleModuleIDMap = new Hashtable<Long, RoleModulePrivilege>();
    private final Map<Long, RoleHomePagePrivilege> customRoleHomePageIDMap = new Hashtable<Long, RoleHomePagePrivilege>();
    private final Map<String, Map<Long, RoleEntryPrivilege>> customRolePlateIDMap = new ConcurrentHashMap<String, Map<Long, RoleEntryPrivilege>>();
    private final Map<Long, RoleDepAndCRolePrivilege> customRoleDepAndCRoleIDMap = new ConcurrentHashMap<Long, RoleDepAndCRolePrivilege>();
    private final Map<Long, RoleTemplatePrivilege> customRoleTemplateIDMap = new ConcurrentHashMap<Long, RoleTemplatePrivilege>();
    private final Map<Long, RoleDataConnectionPrivilege> customRoleDataConnectionIDMap = new ConcurrentHashMap<Long, RoleDataConnectionPrivilege>();
    private final Map<Long, TableDataJRole> tmpCompanyRoleIDListMap = new Hashtable<Long, TableDataJRole>();
    private final Map<Long, TableDataJRole> companyRoleIDListMap = new Hashtable<Long, TableDataJRole>();
    private final Map<Long, RoleEntryPrivilege> companyRolePrivilegeIDMap = new Hashtable<Long, RoleEntryPrivilege>();
    private final Map<Long, RoleESPrivilege> companyRoleESPrivilegeIDMap = new Hashtable<Long, RoleESPrivilege>();
    private final Map<Long, RoleModulePrivilege> companyRoleModuleIDMap = new Hashtable<Long, RoleModulePrivilege>();
    private final Map<Long, RoleHomePagePrivilege> companyRoleHomePageIDMap = new Hashtable<Long, RoleHomePagePrivilege>();
    private final Map<String, Map<Long, RoleEntryPrivilege>> companyRolePlateIDMap = new ConcurrentHashMap<String, Map<Long, RoleEntryPrivilege>>();
    private final Map<Long, RoleDepAndCRolePrivilege> companyRoleDepAndCRoleIDMap = new ConcurrentHashMap<Long, RoleDepAndCRolePrivilege>();
    private final Map<Long, RoleTemplatePrivilege> companyRoleTemplateIDMap = new ConcurrentHashMap<Long, RoleTemplatePrivilege>();
    private final Map<Long, RoleDataConnectionPrivilege> companyRoleDataConnectionIDMap = new ConcurrentHashMap<Long, RoleDataConnectionPrivilege>();
    private final Map<Long, TableDataFavoriteNode> tdFavorite_idMap = new Hashtable<Long, TableDataFavoriteNode>();
    private Map<Long, Set<RelationObject>> roleObjSet_idMap = new Hashtable<Long, Set<RelationObject>>();
    private Map<Long, Set<RelationObject>> roleNonObjSet_idMap = new Hashtable<Long, Set<RelationObject>>();
    private static long reInitTime;
    private final Object lock = new Object();
    private volatile long initGapTime = 10000L;
    private Set<Long> noPidDepSet = new HashSet<Long>();

    private TableDataSyncDB() {
    }

    public static synchronized TableDataSyncDB getInstance() {
        if (tdc == null) {
            tdc = new TableDataSyncDB();
        }
        return tdc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reinit() throws Exception {
        Map<Long, TableDataUser> map = this.tdUser_idListMap;
        synchronized (map) {
            this.customRoleIDListMap.clear();
            this.customRoleNameListMap.clear();
            this.customRoleUserIDMap.clear();
            this.customRolePrivilegeIDMap.clear();
            this.customRoleESPrivilegeIDMap.clear();
            this.customRoleModuleIDMap.clear();
            this.customRoleHomePageIDMap.clear();
            this.customRoleTemplateIDMap.clear();
            this.customRoleDataConnectionIDMap.clear();
            this.initCustomRole();
            this.initUser();
            this.companyRolePrivilegeIDMap.clear();
            this.companyRoleESPrivilegeIDMap.clear();
            this.companyRoleModuleIDMap.clear();
            this.companyRoleHomePageIDMap.clear();
            this.companyRoleDepAndCRoleIDMap.clear();
            this.companyRoleTemplateIDMap.clear();
            this.companyRoleDataConnectionIDMap.clear();
            this.initCompanyRolePrivilege();
            this.roleObjSet_idMap.clear();
            this.roleNonObjSet_idMap.clear();
            this.tdFavorite_idMap.clear();
            this.initFavorite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initFavorite() {
        Map<Long, TableDataFavoriteNode> map = this.tdFavorite_idMap;
        synchronized (map) {
            if (this.tdFavorite_idMap.isEmpty()) {
                EmbeddedTableData embeddedTableData = TableDataDAOControl.getInstance().getFavoriteNodeTableData();
                int n = embeddedTableData.getRowCount();
                for (int i = 0; i < n; ++i) {
                    Long l = new Long(embeddedTableData.getValueAt(i, 0).toString());
                    TableDataFavoriteNode tableDataFavoriteNode = new TableDataFavoriteNode(l);
                    tableDataFavoriteNode.setUserName(embeddedTableData.getValueAt(i, 1).toString());
                    tableDataFavoriteNode.setType((Integer)embeddedTableData.getValueAt(i, 2));
                    tableDataFavoriteNode.setEntryid(Long.parseLong(embeddedTableData.getValueAt(i, 3).toString()));
                    this.tdFavorite_idMap.put(l, tableDataFavoriteNode);
                }
            }
        }
    }

    private void clearUserMap() {
        this.tdUser_idListMap.clear();
        this.tdUser_NameListMap.clear();
        this.dp_idMap.clear();
        this.dp_nameMap.clear();
        this.id_postMap.clear();
        this.tmpCompanyRoleIDListMap.clear();
        this.companyRoleIDListMap.clear();
        this.companyRoleIdGen.clear();
        this.noPidDepSet.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initUser() throws Exception {
        Map<Long, TableDataUser> map = this.tdUser_idListMap;
        synchronized (map) {
            this.clearUserMap();
            this.initCompanyRole();
            this.addDepartOrPostAll();
            if (this.tdUser_idListMap.isEmpty() && TableDataDAOControl.getInstance().hasSetTableDataSync()) {
                this.initUserData();
            }
        }
    }

    private void addDepartOrPostAll() {
        this.dp_idMap.put(ALL_DEPARTMENT.getId(), ALL_DEPARTMENT);
        this.dp_nameMap.put(ALL_DEPARTMENT.getName(), ALL_DEPARTMENT);
        this.id_postMap.put(FSConstants.COMPANYROLE.POST_ALL_NAME, new Long(this.id_postMap.size()));
        this.saveDepartmentPost(ALL_DEPARTMENT, ALL_DEPARTMENT.getName(), FSConstants.COMPANYROLE.POST_ALL_NAME);
    }

    private void initUserData() throws Exception {
        TableData tableData = DatasourceManager.getInstance().getTableData(TableDataDAOControl.getInstance().getDsName());
        int n = TableDataDAOControl.getInstance().getUserNameIndex();
        int n2 = TableDataDAOControl.getInstance().getPasswordIndex();
        int n3 = TableDataDAOControl.getInstance().getDepartmentIndex();
        int n4 = TableDataDAOControl.getInstance().getPostIndex();
        int n5 = TableDataDAOControl.getInstance().getRoleIndex();
        int n6 = TableDataDAOControl.getInstance().getNameIndex();
        int n7 = TableDataDAOControl.getInstance().getEmailIndex();
        int n8 = TableDataDAOControl.getInstance().getMobileIndex();
        boolean bl = n2 > -1;
        boolean bl2 = n6 > -1;
        boolean bl3 = n7 > -1;
        boolean bl4 = n8 > -1;
        boolean bl5 = n5 > -1;
        boolean bl6 = n4 > -1;
        boolean bl7 = n3 > -1;
        DataModel dataModel = tableData.createDataModel(Calculator.createCalculator());
        int n9 = dataModel.getRowCount();
        for (int i = 0; i < n9; ++i) {
            Object object;
            Object object2;
            String string = "";
            String string2 = dataModel.getValueAt(i, n).toString();
            if (bl) {
                object2 = dataModel.getValueAt(i, n2);
                string = object2 != null ? object2.toString() : "";
            }
            object2 = new TableDataUser(this.generateUnrepeatUserId(string2), string2, string);
            if (bl2) {
                object = dataModel.getValueAt(i, n6);
                ((TableDataUser)object2).setName(object != null ? object.toString() : "");
            }
            if (bl3) {
                object = dataModel.getValueAt(i, n7);
                ((TableDataUser)object2).setEmail(object != null ? object.toString() : "");
            }
            if (bl4) {
                object = dataModel.getValueAt(i, n8);
                ((TableDataUser)object2).setMobile(object != null ? object.toString() : "");
            }
            if (bl7 && bl6) {
                object = dataModel.getValueAt(i, n3);
                Object object3 = dataModel.getValueAt(i, n4);
                this.initCompanyRoleUser(i, tableData, dataModel, object, object3, (TableDataUser)object2);
            }
            if (bl5) {
                object = dataModel.getValueAt(i, n5);
                this.initCustomRoleUser(object, (TableDataUser)object2);
            }
            this.dealWithDuplicateUser(bl7, bl5, (TableDataUser)object2);
        }
        this.dealWithDeptNoPid();
        TableDataDAOControl.getInstance().writeJRoleTableData(this.companyRoleIDListMap.entrySet());
    }

    private void dealWithDeptNoPid() {
        for (Long l : this.noPidDepSet) {
            Department department = this.dp_idMap.get(l);
            if (department == null || this.dp_idMap.get(department.getPid()) != null) continue;
            department.setPid(-1L);
        }
    }

    private void dealWithDuplicateUser(boolean bl, boolean bl2, TableDataUser tableDataUser) throws Exception {
        String string = tableDataUser.getUserName();
        TableDataUser tableDataUser2 = this.tdUser_NameListMap.get(string);
        if (tableDataUser2 == null) {
            this.tdUser_NameListMap.put(string, tableDataUser);
            this.tdUser_idListMap.put(tableDataUser.getId(), tableDataUser);
        } else {
            TableDataUser tableDataUser3 = this.tdUser_NameListMap.get(tableDataUser.getUserName());
            if (bl) {
                tableDataUser3.addJob(tableDataUser.getDepartmentValue(), tableDataUser.getPostValue(), tableDataUser.getDepartmentPid());
            }
            if (bl2) {
                tableDataUser3.addSrole(tableDataUser.getRoleValue());
            }
            this.tdUser_NameListMap.put(tableDataUser.getUserName(), tableDataUser3);
            this.tdUser_idListMap.put(tableDataUser3.getId(), tableDataUser3);
        }
    }

    private void initCompanyRoleUser(int n, TableData tableData, DataModel dataModel, Object object, Object object2, TableDataUser tableDataUser) throws Exception {
        boolean bl = tableData instanceof RecursionTableData;
        if (object != null && object2 != null) {
            String string = object.toString();
            String string2 = object2.toString();
            Department department = new Department(string, "", -1L);
            String string3 = string;
            if (bl) {
                int n2 = ((RecursionTableData)tableData).getMarkFieldIndex();
                string3 = dataModel.getValueAt(n, n2).toString();
                this.initRecursionTableDataDepartment(department, (RecursionDataModel)dataModel, n);
                if (this.dp_idMap.get(department.getPid()) == null) {
                    this.noPidDepSet.add(department.getId());
                }
                this.dp_idMap.put(department.getId(), department);
                this.dp_nameMap.put(department.getName(), department);
                this.saveDepartmentPost(department, string3, FSConstants.COMPANYROLE.POST_ALL_NAME);
            } else if (!this.dp_nameMap.containsKey(string)) {
                long l = this.dp_idMap.size();
                department.setId(l);
                this.dp_idMap.put(l, department);
                this.dp_nameMap.put(string, department);
                this.saveDepartmentPost(department, string3, FSConstants.COMPANYROLE.POST_ALL_NAME);
            } else {
                department = this.dp_nameMap.get(string);
            }
            if (!this.id_postMap.containsKey(string2)) {
                this.id_postMap.put(string2, Long.valueOf(this.id_postMap.size()));
                this.saveDepartmentPost(ALL_DEPARTMENT, FSConstants.COMPANYROLE.DEPARTMENT_ALL_NAME, string2);
            }
            this.saveDepartmentPost(department, string3, string2);
            tableDataUser.setDepartmentValue(string);
            tableDataUser.setDepartmentPid(department.getPid());
            tableDataUser.setPostValue(string2);
            tableDataUser.addJob(string, string2, department.getPid());
        }
    }

    private void initCustomRoleUser(Object object, TableDataUser tableDataUser) throws Exception {
        if (object != null && StringUtils.isNotBlank((String)object.toString())) {
            String string = object.toString();
            CustomRole customRole = new CustomRole(string, null);
            long l = this.generateNegativeID(this.customRoleIDListMap);
            if (!this.customRoleNameListMap.containsKey(string)) {
                customRole.setId(l);
                this.customRoleIDListMap.put(l, customRole);
                this.customRoleNameListMap.put(string, customRole);
            } else {
                customRole = this.customRoleNameListMap.get(string);
            }
            long l2 = this.generateID(this.customRoleUserIDMap);
            TableDataSRole_User tableDataSRole_User = new TableDataSRole_User(l2, customRole.getId(), tableDataUser.getUserName());
            this.customRoleUserIDMap.put(l2, tableDataSRole_User);
            tableDataUser.setRoleValue(string);
            tableDataUser.addSrole(string);
        }
    }

    private long generateCompanyRoleID(Set set) {
        long l = 1L;
        while (set.contains(new Long(l))) {
            ++l;
        }
        return l;
    }

    private Long generateUnrepeatUserId(String string) {
        Long l = this.unrepeatUserIdMap.get(string);
        if (l == null) {
            l = this.unrepeatUserIdMap.size() + 1;
            this.unrepeatUserIdMap.put(string, l);
        }
        return l;
    }

    private void saveDepartmentPost(Department department, String string, String string2) {
        long l = this.generateCompanyRoleID(this.companyRoleIdGen);
        TableDataJRole tableDataJRole = new TableDataJRole(l);
        tableDataJRole.setDpName(department.getName());
        tableDataJRole.setDpMarkValue(string);
        tableDataJRole.setDpId(department.getId());
        tableDataJRole.setPostName(string2);
        Iterator<Map.Entry<Long, TableDataJRole>> iterator = this.tmpCompanyRoleIDListMap.entrySet().iterator();
        TableDataDAOBean tableDataDAOBean = null;
        while (iterator.hasNext()) {
            Map.Entry<Long, TableDataJRole> entry = iterator.next();
            TableDataJRole tableDataJRole2 = entry.getValue();
            if (tableDataJRole2.getDpMarkValue() == null && ComparatorUtils.equals((Object)department.getName(), (Object)tableDataJRole2.getDpName())) {
                tableDataJRole2.setDpMarkValue(department.getName());
            }
            if (!ComparatorUtils.equals((Object)string, (Object)tableDataJRole2.getDpMarkValue()) || !ComparatorUtils.equals((Object)string2, (Object)tableDataJRole2.getPostName())) continue;
            tableDataDAOBean = tableDataJRole2;
            break;
        }
        if (tableDataDAOBean != null) {
            tableDataJRole.setId(tableDataDAOBean.getId());
        } else {
            this.companyRoleIdGen.add(tableDataJRole.getId());
        }
        this.companyRoleIDListMap.put(tableDataJRole.getId(), tableDataJRole);
        this.excludeIdMap.add(department.getId());
    }

    public void initRecursionTableDataDepartment(Department department, RecursionDataModel recursionDataModel, int n) throws Exception {
        int n2 = recursionDataModel.getMarkField();
        int n3 = recursionDataModel.getParentMarkField();
        if (n3 < 0) {
            String string = recursionDataModel.getValueAt(n, n2).toString();
            String string2 = recursionDataModel.getParentValue(n);
            if (StringUtils.isEmpty((String)string2)) {
                string2 = "-1";
            }
            department.setId(this.genIdFromString(string));
            department.setPid(this.genIdFromString(string2));
        } else {
            String string;
            String string3 = recursionDataModel.getValueAt(n, n2).toString();
            Object object = recursionDataModel.getValueAt(n, n3);
            String string4 = string = object == null ? "-1" : object.toString();
            if (StringUtils.isEmpty((String)string)) {
                string = "-1";
            }
            department.setId(this.genIdFromString(string3));
            department.setPid(this.genIdFromString(string));
        }
    }

    private long genIdFromString(String string) {
        try {
            long l = Long.parseLong(string);
            if (!this.excludeIdMap.contains(l)) {
                this.departIdMap.put(string, l);
                return l;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        Long l = this.departIdMap.get(string);
        if (l != null) {
            return l;
        }
        long l2 = this.departIdMap.size() + 1;
        while (this.departIdMap.containsValue(l2)) {
            ++l2;
        }
        this.excludeIdMap.add(l2);
        this.departIdMap.put(string, l2);
        return l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initCustomRole() {
        Map<Object, Object> map = this.customRoleNameListMap;
        synchronized (map) {
            this.init_customRoleNameList(TableDataDAOControl.getInstance().getSRoleTableData());
        }
        map = this.customRoleUserIDMap;
        synchronized (map) {
            EmbeddedTableData embeddedTableData = TableDataDAOControl.getInstance().getSRole_UserTableData();
            int n = embeddedTableData.getRowCount();
            for (int i = 0; i < n; ++i) {
                Long l = new Long(embeddedTableData.getValueAt(i, 0).toString());
                Long l2 = new Long(embeddedTableData.getValueAt(i, 1).toString());
                String string = embeddedTableData.getValueAt(i, 2).toString();
                TableDataSRole_User tableDataSRole_User = new TableDataSRole_User(l, l2, string);
                this.customRoleUserIDMap.put(l, tableDataSRole_User);
            }
        }
        map = this.customRolePrivilegeIDMap;
        synchronized (map) {
            this.initRole_privilege(TableDataDAOControl.getInstance().getSRolePrivilegeTableData(), this.customRolePrivilegeIDMap, false);
        }
        map = this.customRoleESPrivilegeIDMap;
        synchronized (map) {
            this.initRole_ESPrivilege(TableDataDAOControl.getInstance().getSRoleESPrivilegeTableData(), this.customRoleESPrivilegeIDMap, false);
        }
        map = this.customRoleModuleIDMap;
        synchronized (map) {
            this.initRole_ModulePrivilege(TableDataDAOControl.getInstance().getSRole_ModuleTableData(), this.customRoleModuleIDMap, false);
        }
        map = this.customRoleHomePageIDMap;
        synchronized (map) {
            this.initRole_HomePagePrivilege(TableDataDAOControl.getInstance().getCustomRoleHomePageTableData(), this.customRoleHomePageIDMap, false);
        }
        map = this.customRoleDepAndCRoleIDMap;
        synchronized (map) {
            this.initRole_DepAndCRolePrivilege(TableDataDAOControl.getInstance().getCustomRoleDepAndCRolePrivilegeTableData(), this.customRoleDepAndCRoleIDMap, false);
        }
        map = this.customRoleTemplateIDMap;
        synchronized (map) {
            this.initRole_TemplatePrivilege(TableDataDAOControl.getInstance().getSRoleTemplatePrivilegeTableData(), this.customRoleTemplateIDMap, false);
        }
        map = this.customRoleDataConnectionIDMap;
        synchronized (map) {
            this.initRole_DataConnectionPrivilege(TableDataDAOControl.getInstance().getSRoleDataConnectionPrivilegeTableData(), this.customRoleDataConnectionIDMap, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initCompanyRole() {
        Map<Long, TableDataJRole> map = this.tmpCompanyRoleIDListMap;
        synchronized (map) {
            EmbeddedTableData embeddedTableData = TableDataDAOControl.getInstance().getJRoleTableData();
            int n = embeddedTableData.getRowCount();
            for (int i = 0; i < n; ++i) {
                Object object;
                Object object2;
                Long l = new Long((String)embeddedTableData.getValueAt(i, 0));
                TableDataJRole tableDataJRole = new TableDataJRole(l);
                Object object3 = embeddedTableData.getValueAt(i, 1);
                Object object4 = embeddedTableData.getValueAt(i, 2);
                if (object3 == null || object4 == null) continue;
                tableDataJRole.setDpName(object3.toString());
                tableDataJRole.setPostName(object4.toString());
                Object object5 = embeddedTableData.getValueAt(i, 3);
                if (object5 != Primitive.NULL && object5 != null) {
                    tableDataJRole.setDescription(object5.toString());
                }
                if ((object2 = embeddedTableData.getValueAt(i, 4)) != Primitive.NULL && object2 != null) {
                    tableDataJRole.setDpId(Long.valueOf(object2.toString()));
                }
                if ((object = embeddedTableData.getValueAt(i, 5)) != Primitive.NULL && object != null) {
                    tableDataJRole.setDpMarkValue(object.toString());
                }
                this.tmpCompanyRoleIDListMap.put(l, tableDataJRole);
                this.companyRoleIdGen.add(l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initCompanyRolePrivilege() {
        Map<Long, DAOBean> map = this.companyRolePrivilegeIDMap;
        synchronized (map) {
            this.initRole_privilege(TableDataDAOControl.getInstance().getJRolePrivilegeTableData(), this.companyRolePrivilegeIDMap, true);
        }
        map = this.companyRoleESPrivilegeIDMap;
        synchronized (map) {
            this.initRole_ESPrivilege(TableDataDAOControl.getInstance().getJRoleESPrivilegeTableData(), this.companyRoleESPrivilegeIDMap, true);
        }
        map = this.companyRoleModuleIDMap;
        synchronized (map) {
            this.initRole_ModulePrivilege(TableDataDAOControl.getInstance().getJRole_ModuleTableData(), this.companyRoleModuleIDMap, true);
        }
        map = this.companyRoleHomePageIDMap;
        synchronized (map) {
            this.initRole_HomePagePrivilege(TableDataDAOControl.getInstance().getCompanyRoleHomePageTableData(), this.companyRoleHomePageIDMap, true);
        }
        map = this.companyRoleDepAndCRoleIDMap;
        synchronized (map) {
            this.initRole_DepAndCRolePrivilege(TableDataDAOControl.getInstance().getCompanyRoleDepAndCRolePrivilegeTableData(), this.companyRoleDepAndCRoleIDMap, true);
        }
        map = this.companyRoleTemplateIDMap;
        synchronized (map) {
            this.initRole_TemplatePrivilege(TableDataDAOControl.getInstance().getJRoleTemplatePrivilegeTableData(), this.companyRoleTemplateIDMap, true);
        }
        map = this.companyRoleDataConnectionIDMap;
        synchronized (map) {
            this.initRole_DataConnectionPrivilege(TableDataDAOControl.getInstance().getJRoleDataConnectionPrivilegeTableData(), this.companyRoleDataConnectionIDMap, true);
        }
    }

    private void init_customRoleNameList(EmbeddedTableData embeddedTableData) {
        int n = embeddedTableData.getRowCount();
        for (int i = 0; i < n; ++i) {
            Long l = new Long(embeddedTableData.getValueAt(i, 0).toString());
            CustomRole customRole = new CustomRole(l);
            Object object = embeddedTableData.getValueAt(i, 1);
            if (object == null || StringUtils.isBlank((String)object.toString())) continue;
            customRole.setRolename(object.toString());
            Object object2 = embeddedTableData.getValueAt(i, 2);
            if (object2 != Primitive.NULL && object2 != null) {
                customRole.setDescription(object2.toString());
            }
            this.customRoleIDListMap.put(l, customRole);
            this.customRoleNameListMap.put(customRole.getRolename(), customRole);
        }
    }

    private void initRole_privilege(EmbeddedTableData embeddedTableData, Map<Long, RoleEntryPrivilege> map, boolean bl) {
        int n = embeddedTableData.getRowCount();
        for (int i = 0; i < n; ++i) {
            Long l = new Long(embeddedTableData.getValueAt(i, 0).toString());
            long l2 = Long.parseLong(embeddedTableData.getValueAt(i, 1).toString());
            int n2 = Integer.parseInt(embeddedTableData.getValueAt(i, 2).toString());
            long l3 = Long.parseLong(embeddedTableData.getValueAt(i, 3).toString());
            long l4 = embeddedTableData.getValueAt(i, 4) == null ? 1L : Long.parseLong(embeddedTableData.getValueAt(i, 4).toString());
            long l5 = embeddedTableData.getValueAt(i, 5) == null ? 0L : Long.parseLong(embeddedTableData.getValueAt(i, 5).toString());
            long l6 = embeddedTableData.getValueAt(i, 6) == null ? 0L : Long.parseLong(embeddedTableData.getValueAt(i, 6).toString());
            RoleEntryPrivilege roleEntryPrivilege = bl ? new CompanyRoleEntryPrivilege(l) : new CustomRoleEntryPrivilege(l);
            roleEntryPrivilege.setRoleId(l2);
            roleEntryPrivilege.setType(n2);
            roleEntryPrivilege.setEntryid(l3);
            roleEntryPrivilege.setView(l4);
            roleEntryPrivilege.setAuthorized(l5);
            roleEntryPrivilege.setEdit(l6);
            if (!bl) {
                String string = embeddedTableData.getValueAt(i, 7) == null ? "" : embeddedTableData.getValueAt(i, 7).toString();
                ((CustomRoleEntryPrivilege)roleEntryPrivilege).setRoleName(string);
            }
            map.put(l, roleEntryPrivilege);
        }
    }

    private void initRole_ModulePrivilege(EmbeddedTableData embeddedTableData, Map<Long, RoleModulePrivilege> map, boolean bl) {
        int n = embeddedTableData.getRowCount();
        for (int i = 0; i < n; ++i) {
            Long l = new Long(embeddedTableData.getValueAt(i, 0).toString());
            long l2 = Long.parseLong(embeddedTableData.getValueAt(i, 1).toString());
            long l3 = Long.parseLong(embeddedTableData.getValueAt(i, 3).toString());
            long l4 = embeddedTableData.getValueAt(i, 4) == null ? 1L : Long.parseLong(embeddedTableData.getValueAt(i, 4).toString());
            long l5 = embeddedTableData.getValueAt(i, 5) == null ? 0L : Long.parseLong(embeddedTableData.getValueAt(i, 5).toString());
            RoleModulePrivilege roleModulePrivilege = bl ? new CompanyRoleModulePrivilege(l) : new CustomRoleModulePrivilege(l);
            roleModulePrivilege.setRoleId(l2);
            roleModulePrivilege.setModuleid(l3);
            roleModulePrivilege.setView(l4);
            roleModulePrivilege.setAuthorized(l5);
            if (!bl) {
                String string = embeddedTableData.getValueAt(i, 6) == null ? "" : embeddedTableData.getValueAt(i, 6).toString();
                ((CustomRoleModulePrivilege)roleModulePrivilege).setRoleName(string);
            }
            map.put(l, roleModulePrivilege);
        }
    }

    private void initRole_HomePagePrivilege(EmbeddedTableData embeddedTableData, Map<Long, RoleHomePagePrivilege> map, boolean bl) {
        int n = embeddedTableData.getRowCount();
        for (int i = 0; i < n; ++i) {
            Long l = new Long(embeddedTableData.getValueAt(i, 0).toString());
            long l2 = Long.parseLong(embeddedTableData.getValueAt(i, 1).toString());
            long l3 = Long.parseLong(embeddedTableData.getValueAt(i, 2).toString());
            long l4 = embeddedTableData.getValueAt(i, 3) == null ? 1L : Long.parseLong(embeddedTableData.getValueAt(i, 3).toString());
            RoleHomePagePrivilege roleHomePagePrivilege = bl ? new CompanyRoleHomePagePrivilege(l) : new CustomRoleHomePagePrivilege(l);
            roleHomePagePrivilege.setRoleId(l2);
            roleHomePagePrivilege.setHomePageId(l3);
            roleHomePagePrivilege.setView(l4);
            if (!bl) {
                String string = embeddedTableData.getValueAt(i, 4) == null ? "" : embeddedTableData.getValueAt(i, 4).toString();
                ((CustomRoleHomePagePrivilege)roleHomePagePrivilege).setRoleName(string);
            }
            map.put(l, roleHomePagePrivilege);
        }
    }

    private void initRole_TemplatePrivilege(EmbeddedTableData embeddedTableData, Map<Long, RoleTemplatePrivilege> map, boolean bl) {
        int n = embeddedTableData.getRowCount();
        for (int i = 0; i < n; ++i) {
            long l = Long.parseLong(embeddedTableData.getValueAt(i, 0).toString());
            long l2 = Long.parseLong(embeddedTableData.getValueAt(i, 1).toString());
            String string = embeddedTableData.getValueAt(i, 2).toString();
            long l3 = embeddedTableData.getValueAt(i, 3) == null ? 0L : Long.parseLong(embeddedTableData.getValueAt(i, 3).toString());
            long l4 = embeddedTableData.getValueAt(i, 4) == null ? 0L : Long.parseLong(embeddedTableData.getValueAt(i, 4).toString());
            long l5 = embeddedTableData.getValueAt(i, 5) == null ? 0L : Long.parseLong(embeddedTableData.getValueAt(i, 5).toString());
            RoleTemplatePrivilege roleTemplatePrivilege = bl ? new CompanyRoleTemplatePrivilege(l) : new CustomRoleTemplatePrivilege(l);
            roleTemplatePrivilege.setRoleId(l2);
            roleTemplatePrivilege.setPath(string);
            roleTemplatePrivilege.setPage(l3);
            roleTemplatePrivilege.setWrite(l4);
            roleTemplatePrivilege.setDesign(l5);
            if (!bl) {
                String string2 = embeddedTableData.getValueAt(i, 6) == null ? "" : embeddedTableData.getValueAt(i, 6).toString();
                ((CustomRoleTemplatePrivilege)roleTemplatePrivilege).setRoleName(string2);
            }
            map.put(l, roleTemplatePrivilege);
        }
    }

    private void initRole_DataConnectionPrivilege(EmbeddedTableData embeddedTableData, Map<Long, RoleDataConnectionPrivilege> map, boolean bl) {
        int n = embeddedTableData.getRowCount();
        for (int i = 0; i < n; ++i) {
            long l = Long.parseLong(embeddedTableData.getValueAt(i, 0).toString());
            long l2 = Long.parseLong(embeddedTableData.getValueAt(i, 1).toString());
            String string = embeddedTableData.getValueAt(i, 2).toString();
            long l3 = embeddedTableData.getValueAt(i, 3) == null ? 0L : Long.parseLong(embeddedTableData.getValueAt(i, 3).toString());
            RoleDataConnectionPrivilege roleDataConnectionPrivilege = bl ? new CompanyRoleDataConnectionPrivilege(l) : new CustomRoleDataConnectionPrivilege(l);
            roleDataConnectionPrivilege.setRoleId(l2);
            roleDataConnectionPrivilege.setName(string);
            roleDataConnectionPrivilege.setView(l3);
            if (!bl) {
                String string2 = embeddedTableData.getValueAt(i, 4) == null ? "" : embeddedTableData.getValueAt(i, 4).toString();
                ((CustomRoleDataConnectionPrivilege)roleDataConnectionPrivilege).setRoleName(string2);
            }
            map.put(l, roleDataConnectionPrivilege);
        }
    }

    private void initRole_DepAndCRolePrivilege(EmbeddedTableData embeddedTableData, Map<Long, RoleDepAndCRolePrivilege> map, boolean bl) {
        int n = embeddedTableData.getRowCount();
        for (int i = 0; i < n; ++i) {
            Long l = new Long(embeddedTableData.getValueAt(i, 0).toString());
            long l2 = Long.parseLong(embeddedTableData.getValueAt(i, 1).toString());
            int n2 = Integer.parseInt(embeddedTableData.getValueAt(i, 2).toString());
            long l3 = Long.parseLong(embeddedTableData.getValueAt(i, 3).toString());
            RoleDepAndCRolePrivilege roleDepAndCRolePrivilege = bl ? new CompanyRoleDepAndCRolePrivilege(l) : new CustomRoleDepAndCRolePrivilege(l);
            roleDepAndCRolePrivilege.setRoleid(l2);
            roleDepAndCRolePrivilege.setType(n2);
            roleDepAndCRolePrivilege.setDeporcroleid(l3);
            if (!bl) {
                String string = embeddedTableData.getValueAt(i, 4) == null ? "" : embeddedTableData.getValueAt(i, 4).toString();
                ((CustomRoleDepAndCRolePrivilege)roleDepAndCRolePrivilege).setRoleName(string);
            }
            map.put(l, roleDepAndCRolePrivilege);
        }
    }

    private void initRole_ESPrivilege(EmbeddedTableData embeddedTableData, Map<Long, RoleESPrivilege> map, boolean bl) {
        int n = embeddedTableData.getRowCount();
        for (int i = 0; i < n; ++i) {
            Long l = new Long(embeddedTableData.getValueAt(i, 0).toString());
            long l2 = Long.parseLong(embeddedTableData.getValueAt(i, 1).toString());
            int n2 = Integer.parseInt(embeddedTableData.getValueAt(i, 2).toString());
            long l3 = Long.parseLong(embeddedTableData.getValueAt(i, 3).toString());
            RoleESPrivilege roleESPrivilege = bl ? new CompanyRoleESPrivilege(l) : new CustomRoleESPrivilege(l);
            roleESPrivilege.setRoleId(l2);
            roleESPrivilege.setType(n2);
            roleESPrivilege.setEntryID(l3);
            map.put(l, roleESPrivilege);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkReInit() throws Exception {
        Object object = this.lock;
        synchronized (object) {
            if (reInitTime == 0L || reInitTime + this.initGapTime < new Date().getTime()) {
                TableDataDAOControl.getInstance().init();
                FSContext.resetDataOn();
                FSContext.initData();
                reInitTime = new Date().getTime();
            }
        }
    }

    public static void release() {
        tdc = null;
    }

    public CustomRole findSRoleBySRoleName(String string) throws CloneNotSupportedException {
        CustomRole customRole = this.customRoleNameListMap.get(string);
        return customRole == null ? null : (CustomRole)((Object)customRole.clone());
    }

    public CustomRole findSRoleBySRoleID(long l) throws CloneNotSupportedException {
        CustomRole customRole = this.customRoleIDListMap.get(l);
        return customRole == null ? null : (CustomRole)((Object)customRole.clone());
    }

    public Set<RelationObject> findSRoleByUserName(String string) throws CloneNotSupportedException {
        ArrayList<CustomRole> arrayList = new ArrayList<CustomRole>();
        for (Map.Entry<Long, TableDataSRole_User> entry : this.customRoleUserIDMap.entrySet()) {
            TableDataSRole_User tableDataSRole_User = entry.getValue();
            if (!ComparatorUtils.equals((Object)tableDataSRole_User.getUserName(), (Object)string)) continue;
            long l = tableDataSRole_User.getsRoleId();
            arrayList.add(this.customRoleIDListMap.get(l));
        }
        return this.getSetFromList(arrayList, ClassArrayKey.getInstance((Class[])new Class[]{CustomRole.class}), false);
    }

    public User findUserByUserId(long l) {
        TableDataUser tableDataUser = this.tdUser_idListMap.get(l);
        if (tableDataUser != null) {
            return tableDataUser.getUser();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<User> findAllUser() {
        TableDataSyncDB tableDataSyncDB = this;
        synchronized (tableDataSyncDB) {
            try {
                this.checkReInit();
            }
            catch (Exception exception) {
                FRContext.getLogger().error(exception.getMessage(), (Throwable)exception);
            }
            ArrayList<User> arrayList = new ArrayList<User>();
            for (Map.Entry<Long, TableDataUser> entry : this.tdUser_idListMap.entrySet()) {
                TableDataUser tableDataUser = entry.getValue();
                arrayList.add(tableDataUser.getUser());
            }
            return arrayList;
        }
    }

    public List<TableDataUser> getAllTableDataUsers() {
        ArrayList<TableDataUser> arrayList = new ArrayList<TableDataUser>();
        for (Map.Entry<Long, TableDataUser> entry : this.tdUser_idListMap.entrySet()) {
            TableDataUser tableDataUser = entry.getValue();
            arrayList.add(tableDataUser);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public User findUserByUserName(String string) {
        TableDataSyncDB tableDataSyncDB = this;
        synchronized (tableDataSyncDB) {
            if (string == null) {
                return null;
            }
            try {
                this.checkReInit();
            }
            catch (Exception exception) {
                FRContext.getLogger().error(exception.getMessage(), (Throwable)exception);
            }
            TableDataUser tableDataUser = this.tdUser_NameListMap.get(string);
            if (tableDataUser != null) {
                return tableDataUser.getUser();
            }
            return null;
        }
    }

    public Iterator findJobsByUserId(long l) {
        TableDataUser tableDataUser = this.tdUser_idListMap.get(l);
        return tableDataUser.getJobIterator();
    }

    public String findPostNameById(long l) {
        for (Map.Entry<String, Long> entry : this.id_postMap.entrySet()) {
            long l2 = entry.getValue();
            if (l2 != l) continue;
            return entry.getKey();
        }
        return null;
    }

    public Set<Long> findUserSetByDpAndPost(Department department, String string) throws CloneNotSupportedException {
        HashSet<Long> hashSet = new HashSet<Long>();
        for (Map.Entry<String, TableDataUser> entry : this.tdUser_NameListMap.entrySet()) {
            TableDataUser tableDataUser = entry.getValue();
            if (!this.hasDepartAndPost(tableDataUser, department, string)) continue;
            hashSet.add(tableDataUser.getUser().getId());
        }
        return hashSet;
    }

    private boolean hasDepartAndPost(TableDataUser tableDataUser, Department department, String string) {
        Iterator iterator = tableDataUser.getJobIterator();
        if (iterator != null) {
            while (iterator.hasNext()) {
                Job job = (Job)iterator.next();
                if (!this.departEqual(job, department) || !this.postEqual(job, string)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean departEqual(Job job, Department department) {
        return department == null || ComparatorUtils.equals((Object)job.getDepartmentID(), (Object)department.getId());
    }

    private boolean postEqual(Job job, String string) {
        return string == null || ComparatorUtils.equals((Object)job.getPostID(), (Object)this.findPostByPostName(string).getId());
    }

    public boolean addSRole(String string, CustomRole customRole) {
        if (customRole == null) {
            return false;
        }
        this.addSRoleToMap(string, customRole);
        return true;
    }

    public boolean addSRole(CustomRole customRole) {
        if (this.customRoleNameListMap.containsKey(customRole.getRolename())) {
            return false;
        }
        customRole.setId(this.generateID(this.customRoleIDListMap));
        this.customRoleNameListMap.put(customRole.getRolename(), customRole);
        this.customRoleIDListMap.put(customRole.getId(), customRole);
        TableDataDAOControl.getInstance().writeSRoleTableData(this.customRoleIDListMap.entrySet());
        return true;
    }

    private long generateID(Map map) {
        long l = 1L;
        while (map.get(l) != null) {
            ++l;
        }
        return l;
    }

    private long generateNegativeID(Map map) {
        long l = -1000L;
        while (map.get(l) != null) {
            --l;
        }
        return l;
    }

    private void addSRoleToMap(String string, CustomRole customRole) {
        long l = this.generateID(this.customRoleUserIDMap);
        TableDataSRole_User tableDataSRole_User = new TableDataSRole_User(l, customRole.getId(), string);
        this.customRoleUserIDMap.put(l, tableDataSRole_User);
        TableDataDAOControl.getInstance().writeSRole_UserTableData(this.customRoleUserIDMap.entrySet());
    }

    public boolean removeSRole(String string, CustomRole customRole) {
        for (Map.Entry<Long, TableDataSRole_User> entry : this.customRoleUserIDMap.entrySet()) {
            TableDataSRole_User tableDataSRole_User = entry.getValue();
            if (!ComparatorUtils.equals((Object)string, (Object)tableDataSRole_User.getUserName()) || customRole.getId() != tableDataSRole_User.getsRoleId()) continue;
            this.customRoleNameListMap.remove(string);
            this.customRoleUserIDMap.remove(entry.getKey());
            break;
        }
        TableDataDAOControl.getInstance().writeSRole_UserTableData(this.customRoleUserIDMap.entrySet());
        return true;
    }

    public boolean removeSRole(CustomRole customRole) {
        this.customRoleNameListMap.remove(customRole.getRolename());
        this.customRoleIDListMap.remove(customRole.getId());
        this.removeUsersFromSRole(customRole);
        this.saveSRole();
        return true;
    }

    private void removeUsersFromSRole(CustomRole customRole) {
        ArrayList<Long> arrayList = new ArrayList<Long>();
        for (Map.Entry<Long, TableDataSRole_User> object : this.customRoleUserIDMap.entrySet()) {
            TableDataSRole_User tableDataSRole_User = object.getValue();
            if (customRole.getId() != tableDataSRole_User.getsRoleId()) continue;
            arrayList.add(object.getKey());
        }
        for (Long l : arrayList) {
            this.customRoleUserIDMap.remove(l);
        }
    }

    private void saveSRole() {
        TableDataDAOControl.getInstance().writeSRoleTableData(this.customRoleIDListMap.entrySet());
        TableDataDAOControl.getInstance().writeSRole_UserTableData(this.customRoleUserIDMap.entrySet());
    }

    private Set<RelationObject> getSetFromList(List list, ClassArrayKey classArrayKey, boolean bl) throws CloneNotSupportedException {
        Iterator iterator = list.iterator();
        HashSet<RelationObject> hashSet = new HashSet<RelationObject>();
        while (iterator.hasNext()) {
            DAOBean[] dAOBeanArray = new DAOBean[]{(DAOBean)((DAOBean)iterator.next()).clone()};
            hashSet.add(RelationObject.getInstance((long)dAOBeanArray[0].getId(), (ClassArrayKey)classArrayKey, (DAOBean[])dAOBeanArray, (boolean)bl));
        }
        return hashSet;
    }

    public boolean updateSRoleName(long l, String string) throws CloneNotSupportedException {
        CustomRole customRole = this.customRoleIDListMap.get(l);
        if (customRole != null && this.findSRoleBySRoleName(string) == null) {
            this.customRoleNameListMap.remove(customRole.getRolename());
            customRole.setRolename(string);
            this.customRoleNameListMap.put(string, customRole);
            TableDataDAOControl.getInstance().writeSRoleTableData(this.customRoleIDListMap.entrySet());
            return true;
        }
        return false;
    }

    public List<Object> findAllSRole() throws CloneNotSupportedException {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Map.Entry<String, CustomRole> entry : this.customRoleNameListMap.entrySet()) {
            arrayList.add(entry.getValue().clone());
        }
        return arrayList;
    }

    public Set<RelationObject> findUserSetBySRoleId(long l, boolean bl) throws CloneNotSupportedException {
        List<String> list = this.getUserNameListBySRoleId(l);
        if (bl) {
            ArrayList<User> arrayList = new ArrayList<User>();
            for (String string : list) {
                User user = this.findUserByUserName(string);
                if (user == null) continue;
                arrayList.add(user);
            }
            return this.getSetFromList(arrayList, ClassArrayKey.getInstance((Class[])new Class[]{User.class}), true);
        }
        HashSet<RelationObject> hashSet = new HashSet<RelationObject>();
        for (String string : list) {
            User user = this.findUserByUserName(string);
            DAOBean[] dAOBeanArray = new User[]{user};
            hashSet.add(RelationObject.getInstance((long)user.getId(), (ClassArrayKey)ClassArrayKey.getInstance((Class[])new Class[]{User.class}), (DAOBean[])dAOBeanArray, (boolean)false));
        }
        return hashSet;
    }

    private List<String> getUserNameListBySRoleId(long l) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Map.Entry<Long, TableDataSRole_User> entry : this.customRoleUserIDMap.entrySet()) {
            TableDataSRole_User tableDataSRole_User = entry.getValue();
            if (l != tableDataSRole_User.getsRoleId()) continue;
            arrayList.add(tableDataSRole_User.getUserName());
        }
        return arrayList;
    }

    public void addUsersToSRole(CustomRole customRole, Set<User> set) {
        List<String> list = this.getUserNameListBySRoleId(customRole.getId());
        for (User user : set) {
            TableDataUser tableDataUser = this.tdUser_idListMap.get(user.getId());
            if (tableDataUser == null || list.contains(tableDataUser.getUserName())) continue;
            long l = this.generateID(this.customRoleUserIDMap);
            TableDataSRole_User tableDataSRole_User = new TableDataSRole_User(l, customRole.getId(), tableDataUser.getUserName());
            this.customRoleUserIDMap.put(l, tableDataSRole_User);
        }
        TableDataDAOControl.getInstance().writeSRole_UserTableData(this.customRoleUserIDMap.entrySet());
    }

    public void removeUsersFromSRole(Set<User> set) {
        TableDataDAOBean tableDataDAOBean;
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList arrayList2 = new ArrayList();
        for (User object : set) {
            tableDataDAOBean = this.tdUser_idListMap.get(object.getId());
            if (tableDataDAOBean == null) continue;
            arrayList.add(((TableDataUser)tableDataDAOBean).getUserName());
        }
        for (Map.Entry entry : this.customRoleUserIDMap.entrySet()) {
            tableDataDAOBean = (TableDataSRole_User)entry.getValue();
            if (!arrayList.contains(((TableDataSRole_User)tableDataDAOBean).getUserName())) continue;
            arrayList2.add(entry.getKey());
        }
        for (Long l : arrayList2) {
            this.customRoleUserIDMap.remove(l);
        }
        TableDataDAOControl.getInstance().writeSRole_UserTableData(this.customRoleUserIDMap.entrySet());
    }

    public Post findPostById(long l) {
        String string = this.findPostNameById(l);
        if (string != null) {
            Post post = new Post(l);
            post.setPostname(string);
            return post;
        }
        return null;
    }

    public List<Post> findAllPost() {
        ArrayList<Post> arrayList = new ArrayList<Post>();
        for (Map.Entry<String, Long> entry : this.id_postMap.entrySet()) {
            Post post = new Post(entry.getValue());
            post.setPostname(entry.getKey());
            arrayList.add(post);
        }
        return arrayList;
    }

    public Post findPostByPostName(String string) {
        Long l = this.id_postMap.get(string);
        if (l != null) {
            Post post = new Post(l);
            post.setPostname(string);
            return post;
        }
        return null;
    }

    public Department findDepartmentByID(long l) {
        return this.dp_idMap.get(l);
    }

    public List<Department> findAllDepartment() throws CloneNotSupportedException {
        ArrayList<Department> arrayList = new ArrayList<Department>();
        for (Map.Entry<Long, Department> entry : this.dp_idMap.entrySet()) {
            Department department = (Department)((Object)entry.getValue().clone());
            arrayList.add(department);
        }
        return arrayList;
    }

    public Department findDepartmentByDPNameAndPid(String string, long l) throws CloneNotSupportedException {
        for (Map.Entry<Long, Department> entry : this.dp_idMap.entrySet()) {
            Department department = (Department)((Object)entry.getValue().clone());
            if (!ComparatorUtils.equals((Object)department.getName(), (Object)string) || !ComparatorUtils.equals((Object)department.getPid(), (Object)l)) continue;
            return department;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator findUserAndPostIterator(long l, boolean bl) {
        Set<RelationObject> set;
        Set<RelationObject> set2 = set = bl ? this.roleObjSet_idMap.get(l) : this.roleNonObjSet_idMap.get(l);
        if (set == null) {
            Map<Long, TableDataUser> map = this.tdUser_idListMap;
            synchronized (map) {
                set = this.findDeptRoleSet(l, bl);
                if (bl) {
                    this.roleObjSet_idMap.put(l, set);
                } else {
                    this.roleNonObjSet_idMap.put(l, set);
                }
            }
        }
        return set.iterator();
    }

    private Set<RelationObject> findDeptRoleSet(long l, boolean bl) {
        Department department = this.findDepartmentByID(l);
        HashSet<RelationObject> hashSet = new HashSet<RelationObject>();
        if (department != null) {
            for (Map.Entry<Long, TableDataUser> entry : this.tdUser_idListMap.entrySet()) {
                TableDataUser tableDataUser = entry.getValue();
                Iterator iterator = tableDataUser.getJobIterator();
                while (iterator.hasNext()) {
                    Job job = (Job)iterator.next();
                    if (l != job.getDepartmentID()) continue;
                    Post post = this.findPostById(job.getPostID());
                    User user = tableDataUser.getUser();
                    if (post == null || user == null) continue;
                    DAOBean[] dAOBeanArray = new DAOBean[]{post, user};
                    hashSet.add(RelationObject.getInstance((long)tableDataUser.getId(), (ClassArrayKey)ClassArrayKey.getInstance((Class[])new Class[]{Post.class, User.class}), (DAOBean[])dAOBeanArray, (boolean)bl));
                }
            }
        }
        return hashSet;
    }

    public void saveFavoriteNode(FavoriteNode favoriteNode) {
        long l = this.generateID(this.tdFavorite_idMap);
        favoriteNode.setId(l);
        long l2 = favoriteNode.getUserId();
        User user = this.findUserByUserId(l2);
        if (user != null) {
            TableDataFavoriteNode tableDataFavoriteNode = new TableDataFavoriteNode(user.getUsername(), favoriteNode);
            this.tdFavorite_idMap.put(l, tableDataFavoriteNode);
            TableDataDAOControl.getInstance().writeTableDataFavoriteMap(this.tdFavorite_idMap.entrySet());
        }
    }

    public FavoriteNode findFavoriteById(long l) {
        TableDataUser tableDataUser;
        TableDataFavoriteNode tableDataFavoriteNode = this.tdFavorite_idMap.get(l);
        if (tableDataFavoriteNode != null && (tableDataUser = this.tdUser_NameListMap.get(tableDataFavoriteNode.getUserName())) != null) {
            return tableDataFavoriteNode.getFavoriteNode(tableDataUser.getId());
        }
        return null;
    }

    public void deleteFavoriteNode(FavoriteNode favoriteNode) {
        ArrayList arrayList = new ArrayList();
        TableDataUser tableDataUser = this.tdUser_idListMap.get(favoriteNode.getUserId());
        if (tableDataUser != null) {
            for (Map.Entry object : this.tdFavorite_idMap.entrySet()) {
                TableDataFavoriteNode tableDataFavoriteNode = (TableDataFavoriteNode)object.getValue();
                if (!ComparatorUtils.equals((Object)tableDataUser.getUserName(), (Object)tableDataFavoriteNode.getUserName()) || favoriteNode.getEntryid() != tableDataFavoriteNode.getEntryid()) continue;
                arrayList.add(object.getKey());
            }
        }
        for (Long l : arrayList) {
            this.tdFavorite_idMap.remove(l);
        }
        TableDataDAOControl.getInstance().writeTableDataFavoriteMap(this.tdFavorite_idMap.entrySet());
    }

    public List<FavoriteNode> findFavoriteNodes(long l) {
        TableDataUser tableDataUser = this.tdUser_idListMap.get(l);
        ArrayList<FavoriteNode> arrayList = new ArrayList<FavoriteNode>();
        if (tableDataUser != null) {
            for (Map.Entry<Long, TableDataFavoriteNode> entry : this.tdFavorite_idMap.entrySet()) {
                TableDataFavoriteNode tableDataFavoriteNode = entry.getValue();
                if (!ComparatorUtils.equals((Object)tableDataUser.getUserName(), (Object)tableDataFavoriteNode.getUserName())) continue;
                arrayList.add(tableDataFavoriteNode.getFavoriteNode(l));
            }
        }
        return arrayList;
    }

    public void deleteFavoriteNode(long l, int n, long l2) {
        TableDataUser tableDataUser = this.tdUser_idListMap.get(l);
        if (tableDataUser != null) {
            ArrayList<Long> arrayList = new ArrayList<Long>();
            for (Map.Entry<Long, TableDataFavoriteNode> object : this.tdFavorite_idMap.entrySet()) {
                TableDataFavoriteNode tableDataFavoriteNode = object.getValue();
                if (!ComparatorUtils.equals((Object)tableDataUser.getUserName(), (Object)tableDataFavoriteNode.getUserName()) || l2 != tableDataFavoriteNode.getEntryid() || tableDataFavoriteNode.getType() != n) continue;
                arrayList.add(object.getKey());
            }
            for (Long l3 : arrayList) {
                this.tdFavorite_idMap.remove(l3);
            }
            TableDataDAOControl.getInstance().writeTableDataFavoriteMap(this.tdFavorite_idMap.entrySet());
        }
    }

    public CompanyRole findJRoleByCompanyRoleID(long l) {
        TableDataJRole tableDataJRole = this.companyRoleIDListMap.get(l);
        return this.getJRoleByTdJRole(tableDataJRole);
    }

    private CompanyRole getJRoleByTdJRole(TableDataJRole tableDataJRole) {
        Long l;
        if (tableDataJRole != null && (l = tableDataJRole.getDpId()) != null) {
            Department department = this.dp_idMap.get(l);
            Long l2 = this.id_postMap.get(tableDataJRole.getPostName());
            if (department != null && l2 != null) {
                CompanyRole companyRole = new CompanyRole(tableDataJRole.getId());
                companyRole.setDepartmentId(l);
                companyRole.setPostId(l2);
                companyRole.setDescription(tableDataJRole.getDescription());
                return companyRole;
            }
        }
        return null;
    }

    public List<CompanyRole> findAllJRole() {
        ArrayList<CompanyRole> arrayList = new ArrayList<CompanyRole>();
        for (Map.Entry<Long, TableDataJRole> entry : this.companyRoleIDListMap.entrySet()) {
            CompanyRole companyRole = this.getJRoleByTdJRole(entry.getValue());
            if (companyRole == null) continue;
            arrayList.add(companyRole);
        }
        return arrayList;
    }

    public void saveJRole(CompanyRole companyRole) {
        Department department = this.findDepartmentByID(companyRole.getDepartmentId());
        String string = this.findPostNameById(companyRole.getPostId());
        if (department != null && string != null) {
            TableDataJRole tableDataJRole;
            boolean bl = false;
            for (Map.Entry<Long, TableDataJRole> entry : this.companyRoleIDListMap.entrySet()) {
                tableDataJRole = entry.getValue();
                if (!ComparatorUtils.equals((Object)department.getId(), (Object)tableDataJRole.getDpId()) || !ComparatorUtils.equals((Object)string, (Object)tableDataJRole.getPostName())) continue;
                bl = true;
            }
            if (!bl) {
                long l = this.generateID(this.companyRoleIDListMap);
                companyRole.setId(l);
                tableDataJRole = new TableDataJRole(l);
                tableDataJRole.setDpName(department.getName());
                tableDataJRole.setPostName(string);
                tableDataJRole.setDpId(department.getId());
                tableDataJRole.setDescription(companyRole.getDescription());
                this.companyRoleIDListMap.put(l, tableDataJRole);
                TableDataDAOControl.getInstance().writeJRoleTableData(this.companyRoleIDListMap.entrySet());
            }
        }
    }

    public List<CompanyRole> findJRoleByPost(Post post) {
        long l;
        String string;
        ArrayList<CompanyRole> arrayList = new ArrayList<CompanyRole>();
        if (post != null && (string = this.findPostNameById(l = post.getId())) != null) {
            for (Map.Entry<Long, TableDataJRole> entry : this.companyRoleIDListMap.entrySet()) {
                CompanyRole companyRole;
                TableDataJRole tableDataJRole = entry.getValue();
                if (!ComparatorUtils.equals((Object)string, (Object)tableDataJRole.getPostName()) || (companyRole = this.getJRoleByTdJRole(tableDataJRole)) == null) continue;
                arrayList.add(companyRole);
            }
        }
        return arrayList;
    }

    public List<CompanyRole> findJRoleByDepartment(Long l) {
        ArrayList<CompanyRole> arrayList = new ArrayList<CompanyRole>();
        if (l != null) {
            for (Map.Entry<Long, TableDataJRole> entry : this.companyRoleIDListMap.entrySet()) {
                TableDataJRole tableDataJRole = entry.getValue();
                CompanyRole companyRole = this.getJRoleByTdJRole(tableDataJRole);
                if (companyRole == null || !ComparatorUtils.equals((Object)l, (Object)companyRole.getDepartmentId())) continue;
                arrayList.add(companyRole);
            }
        }
        return arrayList;
    }

    public List<CompanyRole> findJRoleByPostAndDepartment(Long l, Long[] longArray) {
        List<CompanyRole> list = this.findJRoleByPost(new Post(l));
        ArrayList<CompanyRole> arrayList = new ArrayList<CompanyRole>();
        for (CompanyRole companyRole : list) {
            boolean bl = false;
            for (Long l2 : longArray) {
                if (companyRole.getDepartmentId() != l2.longValue()) continue;
                bl = true;
                break;
            }
            if (!bl) continue;
            arrayList.add(companyRole);
        }
        return arrayList;
    }

    public Set<RoleTemplatePrivilege> findTemplatePrivilegeByCompanyRoleId(long l) {
        return this.getTemplatePrivilegeByRoleId(this.companyRoleTemplateIDMap.entrySet(), l);
    }

    public Set<RoleTemplatePrivilege> findTemplatePrivilegeByCustomRoleId(long l) {
        return this.getTemplatePrivilegeByRoleId(this.customRoleTemplateIDMap.entrySet(), l);
    }

    public Set<RoleTemplatePrivilege> findTemplatePrivilegeByCustomRoleName(String string) {
        return this.getTemplatePrivilegeByRoleName(this.customRoleTemplateIDMap.entrySet(), string);
    }

    private Set<RoleTemplatePrivilege> getTemplatePrivilegeByRoleId(Set<Map.Entry<Long, RoleTemplatePrivilege>> set, long l) {
        HashSet<RoleTemplatePrivilege> hashSet = new HashSet<RoleTemplatePrivilege>();
        for (Map.Entry<Long, RoleTemplatePrivilege> entry : set) {
            RoleTemplatePrivilege roleTemplatePrivilege = entry.getValue();
            if (roleTemplatePrivilege.getRoleId() != l) continue;
            hashSet.add(roleTemplatePrivilege);
        }
        return hashSet;
    }

    private Set<RoleTemplatePrivilege> getTemplatePrivilegeByRoleName(Set<Map.Entry<Long, RoleTemplatePrivilege>> set, String string) {
        HashSet<RoleTemplatePrivilege> hashSet = new HashSet<RoleTemplatePrivilege>();
        for (Map.Entry<Long, RoleTemplatePrivilege> entry : set) {
            CustomRoleTemplatePrivilege customRoleTemplatePrivilege = (CustomRoleTemplatePrivilege)entry.getValue();
            if (!ComparatorUtils.equals((Object)customRoleTemplatePrivilege.getRoleName(), (Object)string)) continue;
            hashSet.add(customRoleTemplatePrivilege);
        }
        return hashSet;
    }

    public Set<RoleDataConnectionPrivilege> findDataConnectionPrivilegesByCompanyRoleId(long l) {
        return this.getDataConnectionPrivilegeByRoleId(this.companyRoleDataConnectionIDMap.entrySet(), l);
    }

    public Set<RoleDataConnectionPrivilege> findDataConnectionPrivilegesByCustomRoleId(long l) {
        return this.getDataConnectionPrivilegeByRoleId(this.customRoleDataConnectionIDMap.entrySet(), l);
    }

    public Set<RoleDataConnectionPrivilege> findDataConnectionPrivilegesByCustomRoleName(String string) {
        return this.getDataConnectionPrivilegeByRoleName(this.customRoleDataConnectionIDMap.entrySet(), string);
    }

    private Set<RoleDataConnectionPrivilege> getDataConnectionPrivilegeByRoleId(Set<Map.Entry<Long, RoleDataConnectionPrivilege>> set, long l) {
        HashSet<RoleDataConnectionPrivilege> hashSet = new HashSet<RoleDataConnectionPrivilege>();
        for (Map.Entry<Long, RoleDataConnectionPrivilege> entry : set) {
            RoleDataConnectionPrivilege roleDataConnectionPrivilege = entry.getValue();
            if (roleDataConnectionPrivilege.getRoleId() != l) continue;
            hashSet.add(roleDataConnectionPrivilege);
        }
        return hashSet;
    }

    private Set<RoleDataConnectionPrivilege> getDataConnectionPrivilegeByRoleName(Set<Map.Entry<Long, RoleDataConnectionPrivilege>> set, String string) {
        HashSet<RoleDataConnectionPrivilege> hashSet = new HashSet<RoleDataConnectionPrivilege>();
        for (Map.Entry<Long, RoleDataConnectionPrivilege> entry : set) {
            CustomRoleDataConnectionPrivilege customRoleDataConnectionPrivilege = (CustomRoleDataConnectionPrivilege)entry.getValue();
            if (!ComparatorUtils.equals((Object)customRoleDataConnectionPrivilege.getRoleName(), (Object)string)) continue;
            hashSet.add(customRoleDataConnectionPrivilege);
        }
        return hashSet;
    }

    public Set<RoleDepAndCRolePrivilege> findDepAndCRolePrivilegeByCompanyRoleId(long l) {
        return this.getDepAndCRolePrivilegeByRoleId(this.companyRoleDepAndCRoleIDMap.entrySet(), l);
    }

    public Set<RoleDepAndCRolePrivilege> findDepAndCRolePrivilegeByCustomRoleId(long l) {
        return this.getDepAndCRolePrivilegeByRoleId(this.customRoleDepAndCRoleIDMap.entrySet(), l);
    }

    public Set<RoleDepAndCRolePrivilege> findDepAndCRolePrivilegeByCustomRoleName(String string) {
        return this.getDepAndCRolePrivilegeByRoleName(this.customRoleDepAndCRoleIDMap.entrySet(), string);
    }

    private Set<RoleDepAndCRolePrivilege> getDepAndCRolePrivilegeByRoleId(Set<Map.Entry<Long, RoleDepAndCRolePrivilege>> set, long l) {
        HashSet<RoleDepAndCRolePrivilege> hashSet = new HashSet<RoleDepAndCRolePrivilege>();
        for (Map.Entry<Long, RoleDepAndCRolePrivilege> entry : set) {
            RoleDepAndCRolePrivilege roleDepAndCRolePrivilege = entry.getValue();
            if (roleDepAndCRolePrivilege.getRoleid() != l) continue;
            hashSet.add(roleDepAndCRolePrivilege);
        }
        return hashSet;
    }

    private Set<RoleDepAndCRolePrivilege> getDepAndCRolePrivilegeByRoleName(Set<Map.Entry<Long, RoleDepAndCRolePrivilege>> set, String string) {
        HashSet<RoleDepAndCRolePrivilege> hashSet = new HashSet<RoleDepAndCRolePrivilege>();
        for (Map.Entry<Long, RoleDepAndCRolePrivilege> entry : set) {
            CustomRoleDepAndCRolePrivilege customRoleDepAndCRolePrivilege = (CustomRoleDepAndCRolePrivilege)entry.getValue();
            if (!ComparatorUtils.equals((Object)customRoleDepAndCRolePrivilege.getRoleName(), (Object)string)) continue;
            hashSet.add(customRoleDepAndCRolePrivilege);
        }
        return hashSet;
    }

    public Set<RoleEntryPrivilege> findEntryPrivilegesByJRoleId(long l) {
        return this.getEntryPrivilegeByRoleId(this.companyRolePrivilegeIDMap.entrySet(), l);
    }

    public Set<RoleEntryPrivilege> findEntryPrivilegesBySRoleId(long l) {
        return this.getEntryPrivilegeByRoleId(this.customRolePrivilegeIDMap.entrySet(), l);
    }

    public Set<RoleEntryPrivilege> findEntryPrivilegesBySRoleName(String string) {
        return this.getEntryPrivilegeByRoleName(this.customRolePrivilegeIDMap.entrySet(), string);
    }

    private Set<RoleEntryPrivilege> getEntryPrivilegeByRoleId(Set<Map.Entry<Long, RoleEntryPrivilege>> set, long l) {
        HashSet<RoleEntryPrivilege> hashSet = new HashSet<RoleEntryPrivilege>();
        for (Map.Entry<Long, RoleEntryPrivilege> entry : set) {
            RoleEntryPrivilege roleEntryPrivilege = entry.getValue();
            if (roleEntryPrivilege.getRoleId() != l) continue;
            hashSet.add(roleEntryPrivilege);
        }
        return hashSet;
    }

    private Set<RoleEntryPrivilege> getEntryPrivilegeByRoleName(Set<Map.Entry<Long, RoleEntryPrivilege>> set, String string) {
        HashSet<RoleEntryPrivilege> hashSet = new HashSet<RoleEntryPrivilege>();
        for (Map.Entry<Long, RoleEntryPrivilege> entry : set) {
            CustomRoleEntryPrivilege customRoleEntryPrivilege = (CustomRoleEntryPrivilege)entry.getValue();
            if (!ComparatorUtils.equals((Object)customRoleEntryPrivilege.getRoleName(), (Object)string)) continue;
            hashSet.add(customRoleEntryPrivilege);
        }
        return hashSet;
    }

    public Set<RoleESPrivilege> findESPrivilegesByJRoleId(long l) {
        return this.getESPrivilegeByRoleId(this.companyRoleESPrivilegeIDMap.entrySet(), l);
    }

    public Set<RoleESPrivilege> findESPrivilegesBySRoleId(long l) {
        return this.getESPrivilegeByRoleId(this.customRoleESPrivilegeIDMap.entrySet(), l);
    }

    private Set<RoleESPrivilege> getESPrivilegeByRoleId(Set<Map.Entry<Long, RoleESPrivilege>> set, long l) {
        HashSet<RoleESPrivilege> hashSet = new HashSet<RoleESPrivilege>();
        for (Map.Entry<Long, RoleESPrivilege> entry : set) {
            RoleESPrivilege roleESPrivilege = entry.getValue();
            if (roleESPrivilege.getRoleId() != l) continue;
            hashSet.add(roleESPrivilege);
        }
        return hashSet;
    }

    public Set<RoleModulePrivilege> findModulePrivilegesByJRoleId(long l) throws CloneNotSupportedException {
        return this.getModulePrivilegeByRoldId(this.companyRoleModuleIDMap.entrySet(), l);
    }

    public Set<RoleModulePrivilege> findModulePrivilegesBySRoleId(long l) throws CloneNotSupportedException {
        return this.getModulePrivilegeByRoldId(this.customRoleModuleIDMap.entrySet(), l);
    }

    public Set<RoleModulePrivilege> findModulePrivilegeBySRoleName(String string) throws CloneNotSupportedException {
        return this.getModulePrivilegeByRoleName(this.customRoleModuleIDMap.entrySet(), string);
    }

    private Set<RoleModulePrivilege> getModulePrivilegeByRoleName(Set<Map.Entry<Long, RoleModulePrivilege>> set, String string) {
        HashSet<RoleModulePrivilege> hashSet = new HashSet<RoleModulePrivilege>();
        for (Map.Entry<Long, RoleModulePrivilege> entry : set) {
            CustomRoleModulePrivilege customRoleModulePrivilege = (CustomRoleModulePrivilege)entry.getValue();
            if (!ComparatorUtils.equals((Object)customRoleModulePrivilege.getRoleName(), (Object)string)) continue;
            hashSet.add(customRoleModulePrivilege);
        }
        return hashSet;
    }

    private Set<RoleModulePrivilege> getModulePrivilegeByRoldId(Set<Map.Entry<Long, RoleModulePrivilege>> set, long l) throws CloneNotSupportedException {
        HashSet<RoleModulePrivilege> hashSet = new HashSet<RoleModulePrivilege>();
        for (Map.Entry<Long, RoleModulePrivilege> entry : set) {
            RoleModulePrivilege roleModulePrivilege = entry.getValue();
            if (roleModulePrivilege.getRoleId() != l) continue;
            hashSet.add(roleModulePrivilege);
        }
        return hashSet;
    }

    public Set<RoleHomePagePrivilege> findHomePagePrivilegesByJRoleId(long l) throws CloneNotSupportedException {
        return this.getHomePagePrivilegeByRoleId(this.companyRoleHomePageIDMap.entrySet(), l);
    }

    public Set<RoleHomePagePrivilege> findHomePagePrivilegesBySRoleId(long l) throws CloneNotSupportedException {
        return this.getHomePagePrivilegeByRoleId(this.customRoleHomePageIDMap.entrySet(), l);
    }

    public Set<RoleHomePagePrivilege> findHomePagePrivilegeBySRoleName(String string) throws CloneNotSupportedException {
        return this.getHomePagePrivilegeByRoleName(this.customRoleHomePageIDMap.entrySet(), string);
    }

    private Set<RoleHomePagePrivilege> getHomePagePrivilegeByRoleName(Set<Map.Entry<Long, RoleHomePagePrivilege>> set, String string) {
        HashSet<RoleHomePagePrivilege> hashSet = new HashSet<RoleHomePagePrivilege>();
        for (Map.Entry<Long, RoleHomePagePrivilege> entry : set) {
            CustomRoleHomePagePrivilege customRoleHomePagePrivilege = (CustomRoleHomePagePrivilege)entry.getValue();
            if (!ComparatorUtils.equals((Object)customRoleHomePagePrivilege.getRoleName(), (Object)string) || customRoleHomePagePrivilege.getView() <= 0L) continue;
            hashSet.add(customRoleHomePagePrivilege);
        }
        return hashSet;
    }

    private Set<RoleHomePagePrivilege> getHomePagePrivilegeByRoleId(Set<Map.Entry<Long, RoleHomePagePrivilege>> set, long l) throws CloneNotSupportedException {
        HashSet<RoleHomePagePrivilege> hashSet = new HashSet<RoleHomePagePrivilege>();
        for (Map.Entry<Long, RoleHomePagePrivilege> entry : set) {
            RoleHomePagePrivilege roleHomePagePrivilege = entry.getValue();
            if (roleHomePagePrivilege.getRoleId() != l) continue;
            hashSet.add(roleHomePagePrivilege);
        }
        return hashSet;
    }

    public Set<RelationObject> findPrivilegesByCompanyRoleIDWithPlateName(long l, String string) throws CloneNotSupportedException {
        Map<Long, RoleEntryPrivilege> map = this.companyRolePlateIDMap.get(string);
        if (map == null) {
            return new HashSet<RelationObject>();
        }
        return this.getPrivilegesByRoleIdWithPlateName(map.entrySet(), l, string);
    }

    public Set<RelationObject> findPrivilegesByCustomRoleIDWithPlateName(long l, String string) throws CloneNotSupportedException {
        Map<Long, RoleEntryPrivilege> map = this.customRolePlateIDMap.get(string);
        if (map == null) {
            return new HashSet<RelationObject>();
        }
        return this.getPrivilegesByRoleIdWithPlateName(map.entrySet(), l, string);
    }

    private Set<RelationObject> getPrivilegesByRoleIdWithPlateName(Set<Map.Entry<Long, RoleEntryPrivilege>> set, long l, String string) throws CloneNotSupportedException {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Map.Entry<Long, RoleEntryPrivilege> entry : set) {
            RoleEntryPrivilege roleEntryPrivilege = entry.getValue();
            if (roleEntryPrivilege.getRoleId() != l) continue;
            arrayList.add(PlateFactory.createPrivilegeObject4Plate(roleEntryPrivilege.getEntryid(), string));
        }
        return this.getSetFromList(arrayList, ClassArrayKey.getInstance((Class[])new Class[]{PlateFactory.getRelationClassByName(string)}), false);
    }

    public boolean updateSRoleTemplatePrivileges(String string, List<RoleTemplatePrivilege> list, List<RoleTemplatePrivilege> list2) throws CloneNotSupportedException {
        CustomRole customRole = this.findSRoleBySRoleName(string);
        return this.updateRoleTemplatePrivileges(customRole, list, list2, this.customRoleTemplateIDMap, false);
    }

    public boolean updateJRoleTemplatePrivileges(long l, List<RoleTemplatePrivilege> list, List<RoleTemplatePrivilege> list2) {
        CompanyRole companyRole = this.findJRoleByCompanyRoleID(l);
        return this.updateRoleTemplatePrivileges(companyRole, list, list2, this.companyRoleTemplateIDMap, true);
    }

    public boolean updateSRoleTemplatePrivileges(long l, List<RoleTemplatePrivilege> list, List<RoleTemplatePrivilege> list2) throws CloneNotSupportedException {
        CustomRole customRole = this.findSRoleBySRoleID(l);
        return this.updateRoleTemplatePrivileges(customRole, list, list2, this.customRoleTemplateIDMap, false);
    }

    private boolean updateRoleTemplatePrivileges(DAOBean dAOBean, List<RoleTemplatePrivilege> list, List<RoleTemplatePrivilege> list2, Map<Long, RoleTemplatePrivilege> map, boolean bl) {
        if (dAOBean != null) {
            map = this.makeTemplateTable(dAOBean, list, list2, map, bl);
            if (bl) {
                TableDataDAOControl.getInstance().writeJRoleTemplatePrivilegeTableData(map.entrySet());
            } else {
                TableDataDAOControl.getInstance().writeSRoleTemplatePrivilegeTableData(map.entrySet());
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private Map<Long, RoleTemplatePrivilege> makeTemplateTable(DAOBean dAOBean, List<RoleTemplatePrivilege> list, List<RoleTemplatePrivilege> list2, Map<Long, RoleTemplatePrivilege> map, boolean bl) {
        if (list2 != null && !list2.isEmpty()) {
            ArrayList arrayList = new ArrayList();
            block0: for (Map.Entry<Long, RoleTemplatePrivilege> entry : map.entrySet()) {
                RoleTemplatePrivilege roleTemplatePrivilege = entry.getValue();
                if (!this.isSameRole(roleTemplatePrivilege, dAOBean)) continue;
                for (RoleTemplatePrivilege roleTemplatePrivilege2 : list2) {
                    if (!ComparatorUtils.equals((Object)roleTemplatePrivilege.getPath(), (Object)roleTemplatePrivilege2.getPath())) continue;
                    arrayList.add(entry.getKey());
                    continue block0;
                }
            }
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                Map.Entry<Long, RoleTemplatePrivilege> entry;
                entry = (Long)iterator.next();
                map.remove(entry);
            }
        }
        if (list != null && !list.isEmpty()) {
            for (RoleTemplatePrivilege roleTemplatePrivilege : list) {
                void var7_12;
                long l = this.generateID(map);
                roleTemplatePrivilege.setId(l);
                roleTemplatePrivilege.setRoleId(dAOBean.getId());
                if (!bl) {
                    CustomRoleTemplatePrivilege customRoleTemplatePrivilege = new CustomRoleTemplatePrivilege(dAOBean.getId(), roleTemplatePrivilege.getPath(), roleTemplatePrivilege.getPage(), roleTemplatePrivilege.getWrite(), roleTemplatePrivilege.getDesign(), ((CustomRole)dAOBean).getRolename());
                    customRoleTemplatePrivilege.setId(l);
                }
                map.put(l, (RoleTemplatePrivilege)var7_12);
            }
        }
        return map;
    }

    public boolean updateJRoleDataConnectionPrivileges(long l, List<String> list, List<String> list2) {
        CompanyRole companyRole = this.findJRoleByCompanyRoleID(l);
        return this.updateRoleDataConnectionPrivileges(companyRole, list, list2, this.companyRoleDataConnectionIDMap, true);
    }

    public boolean updateSRoleDataConnectionPrivileges(long l, List<String> list, List<String> list2) throws CloneNotSupportedException {
        CustomRole customRole = this.findSRoleBySRoleID(l);
        return this.updateRoleDataConnectionPrivileges(customRole, list, list2, this.customRoleDataConnectionIDMap, false);
    }

    public boolean updateSRoleDataConnectionPrivileges(String string, List<String> list, List<String> list2) throws CloneNotSupportedException {
        CustomRole customRole = this.findSRoleBySRoleName(string);
        return this.updateRoleDataConnectionPrivileges(customRole, list, list2, this.customRoleDataConnectionIDMap, false);
    }

    private boolean updateRoleDataConnectionPrivileges(DAOBean dAOBean, List<String> list, List<String> list2, Map<Long, RoleDataConnectionPrivilege> map, boolean bl) {
        if (dAOBean != null) {
            map = this.makeDataConnectionTable(dAOBean, list, list2, map, bl);
            if (bl) {
                TableDataDAOControl.getInstance().writeJRoleDataConnectionPrivilegeTableData(map.entrySet());
            } else {
                TableDataDAOControl.getInstance().writeSRoleDataConnectionPrivilegeTableData(map.entrySet());
            }
            return true;
        }
        return false;
    }

    private Map<Long, RoleDataConnectionPrivilege> makeDataConnectionTable(DAOBean dAOBean, List<String> list, List<String> list2, Map<Long, RoleDataConnectionPrivilege> map, boolean bl) {
        Object object2;
        if (list2 != null && !list2.isEmpty()) {
            ArrayList arrayList = new ArrayList();
            block0: for (Object object2 : map.entrySet()) {
                RoleDataConnectionPrivilege roleDataConnectionPrivilege = object2.getValue();
                if (!this.isSameRole(roleDataConnectionPrivilege, dAOBean)) continue;
                for (String string : list2) {
                    if (!ComparatorUtils.equals((Object)roleDataConnectionPrivilege.getName(), (Object)string)) continue;
                    arrayList.add(object2.getKey());
                    continue block0;
                }
            }
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                object2 = (Long)iterator.next();
                map.remove(object2);
            }
        }
        if (list != null && !list.isEmpty()) {
            for (String string : list) {
                object2 = new RoleDataConnectionPrivilege();
                long l = this.generateID(map);
                object2.setId(l);
                ((RoleDataConnectionPrivilege)((Object)object2)).setRoleId(dAOBean.getId());
                ((RoleDataConnectionPrivilege)((Object)object2)).setName(string);
                ((RoleDataConnectionPrivilege)((Object)object2)).setView(1L);
                if (!bl) {
                    object2 = new CustomRoleDataConnectionPrivilege(dAOBean.getId(), string, 1L, ((CustomRole)dAOBean).getRolename());
                    object2.setId(l);
                }
                map.put(l, (RoleDataConnectionPrivilege)((Object)object2));
            }
        }
        return map;
    }

    public boolean updateSRoleEntryPrivileges(long l, List<EntryTypeAndID> list, List<EntryTypeAndID> list2) throws CloneNotSupportedException {
        CustomRole customRole = this.findSRoleBySRoleID(l);
        return this.updateRoleEntryPrivileges(customRole, list, list2, this.customRolePrivilegeIDMap, false);
    }

    public boolean updateJRoleEntryPrivileges(long l, List<EntryTypeAndID> list, List<EntryTypeAndID> list2) {
        CompanyRole companyRole = this.findJRoleByCompanyRoleID(l);
        return this.updateRoleEntryPrivileges(companyRole, list, list2, this.companyRolePrivilegeIDMap, true);
    }

    public boolean updateSRoleEntryPrivileges(String string, List<EntryTypeAndID> list, List<EntryTypeAndID> list2) throws CloneNotSupportedException {
        CustomRole customRole = this.findSRoleBySRoleName(string);
        return this.updateRoleEntryPrivileges(customRole, list, list2, this.customRolePrivilegeIDMap, false);
    }

    private boolean updateRoleEntryPrivileges(DAOBean dAOBean, List<EntryTypeAndID> list, List<EntryTypeAndID> list2, Map<Long, RoleEntryPrivilege> map, boolean bl) {
        if (dAOBean != null) {
            map = this.makeTable(dAOBean, list, list2, map, bl);
            if (bl) {
                TableDataDAOControl.getInstance().writeJRoleEnrtyPrivilegeTableData(map.entrySet());
            } else {
                TableDataDAOControl.getInstance().writeSRoleEnrtyPrivilegeTableData(map.entrySet());
            }
            return true;
        }
        return false;
    }

    private Map<Long, RoleEntryPrivilege> makeTable(DAOBean dAOBean, List<EntryTypeAndID> list, List<EntryTypeAndID> list2, Map<Long, RoleEntryPrivilege> map, boolean bl) {
        if (list2 != null && !list2.isEmpty()) {
            ArrayList arrayList = new ArrayList();
            block0: for (Map.Entry<Long, RoleEntryPrivilege> entry : map.entrySet()) {
                RoleEntryPrivilege roleEntryPrivilege = entry.getValue();
                if (!this.isSameRole(roleEntryPrivilege, dAOBean)) continue;
                for (EntryTypeAndID entryTypeAndID : list2) {
                    if (entryTypeAndID.getId() != roleEntryPrivilege.getEntryid() || entryTypeAndID.getType() != roleEntryPrivilege.getType()) continue;
                    arrayList.add(entry.getKey());
                    continue block0;
                }
            }
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                Map.Entry<Long, RoleEntryPrivilege> entry;
                entry = (Long)iterator.next();
                map.remove(entry);
            }
        }
        if (list != null && !list.isEmpty()) {
            for (EntryTypeAndID entryTypeAndID : list) {
                long l = this.generateID(map);
                RoleEntryPrivilege roleEntryPrivilege = bl ? new CompanyRoleEntryPrivilege(l) : new CustomRoleEntryPrivilege(l);
                roleEntryPrivilege.setEntryid(entryTypeAndID.getId());
                roleEntryPrivilege.setRoleId(dAOBean.getId());
                roleEntryPrivilege.setType(entryTypeAndID.getType());
                roleEntryPrivilege.setView(entryTypeAndID.getView());
                roleEntryPrivilege.setAuthorized(entryTypeAndID.getAuthorized());
                roleEntryPrivilege.setEdit(entryTypeAndID.getEdit());
                if (!bl) {
                    ((CustomRoleEntryPrivilege)roleEntryPrivilege).setRoleName(((CustomRole)dAOBean).getRolename());
                }
                map.put(l, roleEntryPrivilege);
            }
        }
        return map;
    }

    public boolean updateJRoleESPrivileges(long l, List<EntryTypeAndID> list, List<EntryTypeAndID> list2) {
        CompanyRole companyRole = this.findJRoleByCompanyRoleID(l);
        return this.updateRoleESPrivileges(companyRole, list, list2, this.companyRoleESPrivilegeIDMap, true);
    }

    public boolean updateSRoleESPrivileges(long l, List<EntryTypeAndID> list, List<EntryTypeAndID> list2) throws CloneNotSupportedException {
        CustomRole customRole = this.findSRoleBySRoleID(l);
        return this.updateRoleESPrivileges(customRole, list, list2, this.customRoleESPrivilegeIDMap, false);
    }

    private boolean updateRoleESPrivileges(DAOBean dAOBean, List<EntryTypeAndID> list, List<EntryTypeAndID> list2, Map<Long, RoleESPrivilege> map, boolean bl) {
        if (dAOBean != null) {
            map = this.makeESTable(dAOBean, list, list2, map, bl);
            if (bl) {
                TableDataDAOControl.getInstance().writeJRoleESPrivilegeTableData(map.entrySet());
            } else {
                TableDataDAOControl.getInstance().writeSRoleESPrivilegeTableData(map.entrySet());
            }
            return true;
        }
        return false;
    }

    private Map<Long, RoleESPrivilege> makeESTable(DAOBean dAOBean, List<EntryTypeAndID> list, List<EntryTypeAndID> list2, Map<Long, RoleESPrivilege> map, boolean bl) {
        if (list2 != null && !list2.isEmpty()) {
            ArrayList arrayList = new ArrayList();
            block0: for (Map.Entry<Long, RoleESPrivilege> entry : map.entrySet()) {
                RoleESPrivilege roleESPrivilege = entry.getValue();
                if (roleESPrivilege.getRoleId() != dAOBean.getId()) continue;
                for (EntryTypeAndID entryTypeAndID : list2) {
                    if (entryTypeAndID.getId() != roleESPrivilege.getEntryID() || entryTypeAndID.getType() != roleESPrivilege.getType()) continue;
                    arrayList.add(entry.getKey());
                    continue block0;
                }
            }
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                Map.Entry<Long, RoleESPrivilege> entry;
                entry = (Long)iterator.next();
                map.remove(entry);
            }
        }
        if (list != null && !list.isEmpty()) {
            for (EntryTypeAndID entryTypeAndID : list) {
                long l = this.generateID(map);
                RoleESPrivilege roleESPrivilege = bl ? new CompanyRoleESPrivilege(l) : new CustomRoleESPrivilege(l);
                roleESPrivilege.setEntryID(entryTypeAndID.getId());
                roleESPrivilege.setRoleId(dAOBean.getId());
                roleESPrivilege.setType(entryTypeAndID.getType());
                map.put(l, roleESPrivilege);
            }
        }
        return map;
    }

    public boolean updateCompanyRoleDepAndCRolePrivileges(long l, List<String> list, List<String> list2) {
        CompanyRole companyRole = this.findJRoleByCompanyRoleID(l);
        if (this.updateRoleDepAndCRolePrivileges(companyRole, list, list2, this.companyRoleDepAndCRoleIDMap, true)) {
            TableDataDAOControl.getInstance().writeCompanyRoleDepAndCRolePrivilegeTableData(this.companyRoleDepAndCRoleIDMap.entrySet());
            return true;
        }
        return false;
    }

    public boolean updateCustomRoleDepAndCRolePrivileges(long l, List<String> list, List<String> list2) throws CloneNotSupportedException {
        CustomRole customRole = this.findSRoleBySRoleID(l);
        if (this.updateRoleDepAndCRolePrivileges(customRole, list, list2, this.customRoleDepAndCRoleIDMap, false)) {
            TableDataDAOControl.getInstance().writeCustomRoleDepAndCRolePrivilegeTableData(this.customRoleDepAndCRoleIDMap.entrySet());
            return true;
        }
        return false;
    }

    public boolean updateCustomRoleDepAndCRolePrivileges(String string, List<String> list, List<String> list2) throws Exception {
        CustomRole customRole = this.findSRoleBySRoleName(string);
        if (this.updateRoleDepAndCRolePrivileges(customRole, list, list2, this.customRoleDepAndCRoleIDMap, false)) {
            TableDataDAOControl.getInstance().writeCustomRoleDepAndCRolePrivilegeTableData(this.customRoleDepAndCRoleIDMap.entrySet());
            return true;
        }
        return false;
    }

    private boolean updateRoleDepAndCRolePrivileges(DAOBean dAOBean, List<String> list, List<String> list2, Map<Long, RoleDepAndCRolePrivilege> map, boolean bl) {
        if (dAOBean != null) {
            if (map == null) {
                return true;
            }
            this.removeRoleDepAndCRolePrivilege(dAOBean, list2, map);
            this.addRoleDepAndCRolePrivilege(dAOBean, list, map, bl);
            return true;
        }
        return false;
    }

    private void addRoleDepAndCRolePrivilege(DAOBean dAOBean, List<String> list, Map<Long, RoleDepAndCRolePrivilege> map, boolean bl) {
        if (list != null && !list.isEmpty()) {
            for (String string : list) {
                RoleDepAndCRolePrivilege roleDepAndCRolePrivilege = new RoleDepAndCRolePrivilege();
                long l = this.generateID(map);
                roleDepAndCRolePrivilege.setId(l);
                roleDepAndCRolePrivilege.setRoleid(dAOBean.getId());
                roleDepAndCRolePrivilege.setType(Integer.parseInt(string.substring(0, 1)));
                if (string.substring(1).startsWith("-")) {
                    roleDepAndCRolePrivilege.setDeporcroleid(0L - Long.parseLong(string.substring(2)));
                } else {
                    roleDepAndCRolePrivilege.setDeporcroleid(Long.parseLong(string.substring(1)));
                }
                if (!bl) {
                    roleDepAndCRolePrivilege = new CustomRoleDepAndCRolePrivilege(roleDepAndCRolePrivilege.getRoleid(), roleDepAndCRolePrivilege.getType(), roleDepAndCRolePrivilege.getDeporcroleid(), ((CustomRole)dAOBean).getRolename());
                    roleDepAndCRolePrivilege.setId(l);
                }
                map.put(l, roleDepAndCRolePrivilege);
            }
        }
    }

    private void removeRoleDepAndCRolePrivilege(DAOBean dAOBean, List<String> list, Map<Long, RoleDepAndCRolePrivilege> map) {
        if (list != null && !list.isEmpty()) {
            ArrayList arrayList = new ArrayList();
            block0: for (Map.Entry<Long, RoleDepAndCRolePrivilege> entry : map.entrySet()) {
                RoleDepAndCRolePrivilege roleDepAndCRolePrivilege = entry.getValue();
                if (!this.isSameRole(roleDepAndCRolePrivilege, dAOBean)) continue;
                for (String string : list) {
                    long l;
                    long l2;
                    if (string.startsWith("2")) {
                        l2 = 2L;
                        l = string.substring(1).startsWith("-") ? 0L - Long.parseLong(string.substring(2)) : Long.parseLong(string.substring(1));
                    } else {
                        l2 = 1L;
                        l = Long.parseLong(string.substring(1));
                    }
                    if (roleDepAndCRolePrivilege.getDeporcroleid() != l || (long)roleDepAndCRolePrivilege.getType() != l2) continue;
                    arrayList.add(entry.getKey());
                    continue block0;
                }
            }
            for (Map.Entry<Long, RoleDepAndCRolePrivilege> entry : arrayList) {
                map.remove(entry);
            }
        }
    }

    private boolean isSameRole(RoleEntryPrivilege roleEntryPrivilege, DAOBean dAOBean) {
        if (dAOBean.getId() <= -1000L) {
            return roleEntryPrivilege instanceof CustomRoleEntryPrivilege && dAOBean instanceof CustomRole && ComparatorUtils.equals((Object)((CustomRoleEntryPrivilege)roleEntryPrivilege).getRoleName(), (Object)((CustomRole)dAOBean).getRolename());
        }
        return dAOBean.getId() == roleEntryPrivilege.getRoleId();
    }

    private boolean isSameRole(RoleModulePrivilege roleModulePrivilege, DAOBean dAOBean) {
        if (dAOBean.getId() <= -1000L) {
            return roleModulePrivilege instanceof CustomRoleModulePrivilege && dAOBean instanceof CustomRole && ComparatorUtils.equals((Object)((CustomRoleModulePrivilege)roleModulePrivilege).getRoleName(), (Object)((CustomRole)dAOBean).getRolename());
        }
        return dAOBean.getId() == roleModulePrivilege.getRoleId();
    }

    private boolean isSameRole(RoleHomePagePrivilege roleHomePagePrivilege, DAOBean dAOBean) {
        if (dAOBean.getId() <= -1000L) {
            return roleHomePagePrivilege instanceof CustomRoleHomePagePrivilege && dAOBean instanceof CustomRole && ComparatorUtils.equals((Object)((CustomRoleHomePagePrivilege)roleHomePagePrivilege).getRoleName(), (Object)((CustomRole)dAOBean).getRolename());
        }
        return dAOBean.getId() == roleHomePagePrivilege.getRoleId();
    }

    private boolean isSameRole(RoleTemplatePrivilege roleTemplatePrivilege, DAOBean dAOBean) {
        if (dAOBean.getId() <= -1000L) {
            return roleTemplatePrivilege instanceof CustomRoleTemplatePrivilege && dAOBean instanceof CustomRole && ComparatorUtils.equals((Object)((CustomRoleTemplatePrivilege)roleTemplatePrivilege).getRoleName(), (Object)((CustomRole)dAOBean).getRolename());
        }
        return dAOBean.getId() == roleTemplatePrivilege.getRoleId();
    }

    private boolean isSameRole(RoleDataConnectionPrivilege roleDataConnectionPrivilege, DAOBean dAOBean) {
        if (dAOBean.getId() <= -1000L) {
            return roleDataConnectionPrivilege instanceof CustomRoleDataConnectionPrivilege && dAOBean instanceof CustomRole && ComparatorUtils.equals((Object)((CustomRoleDataConnectionPrivilege)roleDataConnectionPrivilege).getRoleName(), (Object)((CustomRole)dAOBean).getRolename());
        }
        return dAOBean.getId() == roleDataConnectionPrivilege.getRoleId();
    }

    private boolean isSameRole(RoleDepAndCRolePrivilege roleDepAndCRolePrivilege, DAOBean dAOBean) {
        if (dAOBean.getId() <= -1000L) {
            return roleDepAndCRolePrivilege instanceof CustomRoleDepAndCRolePrivilege && dAOBean instanceof CustomRole && ComparatorUtils.equals((Object)((CustomRoleDepAndCRolePrivilege)roleDepAndCRolePrivilege).getRoleName(), (Object)((CustomRole)dAOBean).getRolename());
        }
        return dAOBean.getId() == roleDepAndCRolePrivilege.getRoleid();
    }

    public boolean updateJRoleModulePrivileges(long l, List<RoleModulePrivilege> list, List<RoleModulePrivilege> list2) {
        CompanyRole companyRole = this.findJRoleByCompanyRoleID(l);
        if (this.updateRoleModulePrivileges(companyRole, list, list2, this.companyRoleModuleIDMap, true)) {
            TableDataDAOControl.getInstance().writeJRole_ModulePrivilegeTableData(this.companyRoleModuleIDMap.entrySet());
            return true;
        }
        return false;
    }

    public boolean updateSRoleModulePrivileges(long l, List<RoleModulePrivilege> list, List<RoleModulePrivilege> list2) throws CloneNotSupportedException {
        CustomRole customRole = this.findSRoleBySRoleID(l);
        if (this.updateRoleModulePrivileges(customRole, list, list2, this.customRoleModuleIDMap, false)) {
            TableDataDAOControl.getInstance().writeSRole_ModulePrivilegeTableData(this.customRoleModuleIDMap.entrySet());
            return true;
        }
        return false;
    }

    public boolean updateSRoleModulePrivileges(String string, List<RoleModulePrivilege> list, List<RoleModulePrivilege> list2) throws CloneNotSupportedException {
        CustomRole customRole = this.findSRoleBySRoleName(string);
        if (this.updateRoleModulePrivileges(customRole, list, list2, this.customRoleModuleIDMap, false)) {
            TableDataDAOControl.getInstance().writeSRole_ModulePrivilegeTableData(this.customRoleModuleIDMap.entrySet());
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private boolean updateRoleModulePrivileges(DAOBean dAOBean, List<RoleModulePrivilege> list, List<RoleModulePrivilege> list2, Map<Long, RoleModulePrivilege> map, boolean bl) {
        if (dAOBean != null) {
            if (map == null) {
                return true;
            }
            if (list2 != null && !list2.isEmpty()) {
                ArrayList arrayList = new ArrayList();
                block0: for (Map.Entry<Long, RoleModulePrivilege> entry : map.entrySet()) {
                    RoleModulePrivilege roleModulePrivilege = entry.getValue();
                    if (!this.isSameRole(roleModulePrivilege, dAOBean)) continue;
                    for (RoleModulePrivilege roleModulePrivilege2 : list2) {
                        long l = roleModulePrivilege2.getModuleid();
                        if (l != roleModulePrivilege.getModuleid()) continue;
                        arrayList.add(entry.getKey());
                        continue block0;
                    }
                }
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    Map.Entry<Long, RoleModulePrivilege> entry;
                    entry = (Long)iterator.next();
                    map.remove(entry);
                }
            }
            if (list != null && !list.isEmpty()) {
                for (RoleModulePrivilege roleModulePrivilege : list) {
                    void var7_12;
                    long l = this.generateID(map);
                    roleModulePrivilege.setId(l);
                    roleModulePrivilege.setRoleId(dAOBean.getId());
                    if (!bl) {
                        CustomRoleModulePrivilege customRoleModulePrivilege = new CustomRoleModulePrivilege(roleModulePrivilege.getRoleId(), roleModulePrivilege.getModuleid(), roleModulePrivilege.getView(), roleModulePrivilege.getAuthorized(), ((CustomRole)dAOBean).getRolename());
                        customRoleModulePrivilege.setId(l);
                    }
                    map.put(l, (RoleModulePrivilege)var7_12);
                }
            }
            return true;
        }
        return false;
    }

    public boolean updateCompanyRolePlatePrivileges(long l, List<RoleEntryPrivilege> list, List<RoleEntryPrivilege> list2, String string) {
        CompanyRole companyRole = this.findJRoleByCompanyRoleID(l);
        Map<Long, RoleEntryPrivilege> map = this.companyRolePlateIDMap.get(string);
        if (map == null) {
            return true;
        }
        if (this.updateRolePlatesPrivileges(companyRole, list, list2, map, true)) {
            TableDataDAOControl.getInstance().writeJRole_PlatePrivilegeTableData(map.entrySet(), string);
            return true;
        }
        return false;
    }

    public boolean updateCustomRolePlatePrivileges(long l, List<RoleEntryPrivilege> list, List<RoleEntryPrivilege> list2, String string) throws CloneNotSupportedException {
        CustomRole customRole = this.findSRoleBySRoleID(l);
        Map<Long, RoleEntryPrivilege> map = this.customRolePlateIDMap.get(string);
        if (map == null) {
            return true;
        }
        if (this.updateRolePlatesPrivileges(customRole, list, list2, map, true)) {
            TableDataDAOControl.getInstance().writeSRole_PlatePrivilegeTableData(map.entrySet(), string);
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private boolean updateRolePlatesPrivileges(DAOBean dAOBean, List<RoleEntryPrivilege> list, List<RoleEntryPrivilege> list2, Map<Long, RoleEntryPrivilege> map, boolean bl) {
        if (dAOBean != null) {
            if (map == null) {
                return true;
            }
            if (list2 != null && !list2.isEmpty()) {
                ArrayList arrayList = new ArrayList();
                block0: for (Map.Entry<Long, RoleEntryPrivilege> entry : map.entrySet()) {
                    RoleEntryPrivilege roleEntryPrivilege = entry.getValue();
                    if (!this.isSameRole(roleEntryPrivilege, dAOBean)) continue;
                    for (RoleEntryPrivilege roleEntryPrivilege2 : list2) {
                        long l = roleEntryPrivilege2.getEntryid();
                        if (l != roleEntryPrivilege.getEntryid()) continue;
                        arrayList.add(entry.getKey());
                        continue block0;
                    }
                }
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    Map.Entry<Long, RoleEntryPrivilege> entry;
                    entry = (Long)iterator.next();
                    map.remove(entry);
                }
            }
            if (list != null && !list.isEmpty()) {
                for (RoleEntryPrivilege roleEntryPrivilege : list) {
                    void var7_12;
                    long l = this.generateID(map);
                    roleEntryPrivilege.setId(l);
                    roleEntryPrivilege.setRoleId(dAOBean.getId());
                    if (!bl) {
                        CustomRoleEntryPrivilege customRoleEntryPrivilege = new CustomRoleEntryPrivilege(roleEntryPrivilege.getRoleId(), roleEntryPrivilege.getType(), roleEntryPrivilege.getEntryid(), roleEntryPrivilege.getView(), roleEntryPrivilege.getAuthorized(), roleEntryPrivilege.getEdit());
                        customRoleEntryPrivilege.setId(l);
                    }
                    map.put(l, (RoleEntryPrivilege)var7_12);
                }
            }
            return true;
        }
        return false;
    }

    public boolean updateJRoleHomePagePrivileges(long l, List<RoleHomePagePrivilege> list, List<RoleHomePagePrivilege> list2) {
        CompanyRole companyRole = this.findJRoleByCompanyRoleID(l);
        if (this.updateRoleHomePagePrivileges(companyRole, list, list2, this.companyRoleHomePageIDMap, true)) {
            TableDataDAOControl.getInstance().writeJRole_HomePagePrivilegeTableData(this.companyRoleHomePageIDMap.entrySet());
            return true;
        }
        return false;
    }

    public boolean updateSRoleHomePagePrivileges(long l, List<RoleHomePagePrivilege> list, List<RoleHomePagePrivilege> list2) throws CloneNotSupportedException {
        CustomRole customRole = this.findSRoleBySRoleID(l);
        if (this.updateRoleHomePagePrivileges(customRole, list, list2, this.customRoleHomePageIDMap, false)) {
            TableDataDAOControl.getInstance().writeSRole_HomePagePrivilegeTableData(this.customRoleHomePageIDMap.entrySet());
            return true;
        }
        return false;
    }

    public boolean updateSRoleHomePagePrivileges(String string, List<RoleHomePagePrivilege> list, List<RoleHomePagePrivilege> list2) throws CloneNotSupportedException {
        CustomRole customRole = this.findSRoleBySRoleName(string);
        if (this.updateRoleHomePagePrivileges(customRole, list, list2, this.customRoleHomePageIDMap, false)) {
            TableDataDAOControl.getInstance().writeSRole_HomePagePrivilegeTableData(this.customRoleHomePageIDMap.entrySet());
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private boolean updateRoleHomePagePrivileges(DAOBean dAOBean, List<RoleHomePagePrivilege> list, List<RoleHomePagePrivilege> list2, Map<Long, RoleHomePagePrivilege> map, boolean bl) {
        if (dAOBean != null) {
            if (map == null) {
                return true;
            }
            if (list2 != null && !list2.isEmpty()) {
                ArrayList arrayList = new ArrayList();
                block0: for (Map.Entry<Long, RoleHomePagePrivilege> entry : map.entrySet()) {
                    RoleHomePagePrivilege roleHomePagePrivilege = entry.getValue();
                    if (!this.isSameRole(roleHomePagePrivilege, dAOBean)) continue;
                    for (RoleHomePagePrivilege roleHomePagePrivilege2 : list2) {
                        long l = roleHomePagePrivilege2.getHomePageId();
                        if (l != roleHomePagePrivilege.getHomePageId()) continue;
                        arrayList.add(entry.getKey());
                        continue block0;
                    }
                }
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    Map.Entry<Long, RoleHomePagePrivilege> entry;
                    entry = (Long)iterator.next();
                    map.remove(entry);
                }
            }
            if (list != null && !list.isEmpty()) {
                for (RoleHomePagePrivilege roleHomePagePrivilege : list) {
                    void var7_12;
                    long l = this.generateID(map);
                    roleHomePagePrivilege.setId(l);
                    roleHomePagePrivilege.setRoleId(dAOBean.getId());
                    if (!bl) {
                        CustomRoleHomePagePrivilege customRoleHomePagePrivilege = new CustomRoleHomePagePrivilege(roleHomePagePrivilege.getRoleId(), roleHomePagePrivilege.getHomePageId(), roleHomePagePrivilege.getView(), ((CustomRole)dAOBean).getRolename());
                        customRoleHomePagePrivilege.setId(l);
                    }
                    map.put(l, (RoleHomePagePrivilege)var7_12);
                }
            }
            return true;
        }
        return false;
    }
}

