/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.cache;

import com.fr.data.dao.RelationObject;
import com.fr.fs.RoleCheckUtils;
import com.fr.fs.base.entity.RoleDataConnectionPrivilege;
import com.fr.fs.base.entity.RoleDepAndCRolePrivilege;
import com.fr.fs.base.entity.RoleESPrivilege;
import com.fr.fs.base.entity.RoleEntryPrivilege;
import com.fr.fs.base.entity.RoleHomePagePrivilege;
import com.fr.fs.base.entity.RoleModulePrivilege;
import com.fr.fs.base.entity.RoleTemplatePrivilege;
import com.fr.fs.cache.EntryTypeAndID;
import com.fr.fs.cache.RoleCacheInfo;
import com.fr.fs.privilege.base.FSPrivilegeTools;
import com.fr.stable.StringUtils;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RoleCacheUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static boolean containModulePrivilege(Map<Long, RoleCacheInfo> map, long l, long l2) {
        if (l2 < 0L) {
            return false;
        }
        RoleCacheInfo roleCacheInfo = map.get(l);
        if (roleCacheInfo != null) {
            RoleCacheInfo roleCacheInfo2 = roleCacheInfo;
            synchronized (roleCacheInfo2) {
                for (RoleModulePrivilege roleModulePrivilege : roleCacheInfo.moduleSet) {
                    if (roleModulePrivilege.getModuleid() != l2) continue;
                    return true;
                }
                return false;
            }
        }
        throw new RuntimeException("No role exist!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static boolean containHomePagePrivilege(Map<Long, RoleCacheInfo> map, long l, long l2) {
        if (l2 < 0L) {
            return false;
        }
        RoleCacheInfo roleCacheInfo = map.get(l);
        if (roleCacheInfo != null) {
            RoleCacheInfo roleCacheInfo2 = roleCacheInfo;
            synchronized (roleCacheInfo2) {
                for (RoleHomePagePrivilege roleHomePagePrivilege : roleCacheInfo.homePagePrivilegeSet) {
                    if (roleHomePagePrivilege.getHomePageId() != l2) continue;
                    return true;
                }
                return false;
            }
        }
        throw new RuntimeException("No role exist!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static boolean containEntryPrivilege(Map<Long, RoleCacheInfo> map, long l, int n, long l2) {
        if (l2 < -1L) {
            return false;
        }
        RoleCacheInfo roleCacheInfo = map.get(l);
        if (roleCacheInfo != null) {
            RoleCacheInfo roleCacheInfo2 = roleCacheInfo;
            synchronized (roleCacheInfo2) {
                EntryTypeAndID entryTypeAndID = FSPrivilegeTools.getInstance().getEntryPrivilege(roleCacheInfo.entryPrivilegeSet, EntryTypeAndID.getInstance(n, l2));
                return entryTypeAndID.getView() == 1L;
            }
        }
        throw new RuntimeException("No role exist!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static boolean containPlatePrivilege(Map<Long, RoleCacheInfo> map, long l, long l2, String string) {
        if (l2 < -1L) {
            return false;
        }
        RoleCacheInfo roleCacheInfo = map.get(l);
        if (roleCacheInfo != null) {
            RoleCacheInfo roleCacheInfo2 = roleCacheInfo;
            synchronized (roleCacheInfo2) {
                return roleCacheInfo.containPlatePrivilege(l2, string);
            }
        }
        throw new RuntimeException("Not role exist");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void refreshModulePrivileges(Map<Long, RoleCacheInfo> map, long l, Set<RoleModulePrivilege> set) {
        RoleCacheInfo roleCacheInfo = map.get(l);
        if (roleCacheInfo != null) {
            RoleCacheInfo roleCacheInfo2 = roleCacheInfo;
            synchronized (roleCacheInfo2) {
                roleCacheInfo.moduleSet.clear();
                if (set != null) {
                    for (RoleModulePrivilege roleModulePrivilege : set) {
                        roleCacheInfo.moduleSet.add(roleModulePrivilege);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void refreshModulePrivileges(Map map, String string, Set<RoleModulePrivilege> set) {
        if (StringUtils.isBlank((String)string)) {
            return;
        }
        RoleCacheInfo roleCacheInfo = (RoleCacheInfo)map.get(string);
        if (roleCacheInfo != null) {
            RoleCacheInfo roleCacheInfo2 = roleCacheInfo;
            synchronized (roleCacheInfo2) {
                roleCacheInfo.moduleSet.clear();
                if (set != null) {
                    for (RoleModulePrivilege roleModulePrivilege : set) {
                        roleCacheInfo.moduleSet.add(roleModulePrivilege);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void refreshHomePagePrivileges(Map<Long, RoleCacheInfo> map, long l, Set<RoleHomePagePrivilege> set) {
        RoleCacheInfo roleCacheInfo = map.get(l);
        if (roleCacheInfo != null) {
            RoleCacheInfo roleCacheInfo2 = roleCacheInfo;
            synchronized (roleCacheInfo2) {
                roleCacheInfo.homePagePrivilegeSet.clear();
                if (set != null) {
                    for (RoleHomePagePrivilege roleHomePagePrivilege : set) {
                        roleCacheInfo.homePagePrivilegeSet.add(roleHomePagePrivilege);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void refreshHomePagePrivileges(Map map, String string, Set<RoleHomePagePrivilege> set) {
        if (StringUtils.isBlank((String)string)) {
            return;
        }
        RoleCacheInfo roleCacheInfo = (RoleCacheInfo)map.get(string);
        if (roleCacheInfo != null) {
            RoleCacheInfo roleCacheInfo2 = roleCacheInfo;
            synchronized (roleCacheInfo2) {
                roleCacheInfo.homePagePrivilegeSet.clear();
                if (set != null) {
                    for (RoleHomePagePrivilege roleHomePagePrivilege : set) {
                        roleCacheInfo.homePagePrivilegeSet.add(roleHomePagePrivilege);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void refreshTemplatePrivileges(Map<Long, RoleCacheInfo> map, long l, Set<RoleTemplatePrivilege> set) {
        RoleCacheInfo roleCacheInfo = map.get(l);
        if (roleCacheInfo != null) {
            RoleCacheInfo roleCacheInfo2 = roleCacheInfo;
            synchronized (roleCacheInfo2) {
                roleCacheInfo.templateSet.clear();
                if (set != null) {
                    for (RoleTemplatePrivilege roleTemplatePrivilege : set) {
                        roleCacheInfo.templateSet.add(roleTemplatePrivilege);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void refreshTemplatePrivileges(Map map, String string, Set<RoleTemplatePrivilege> set) {
        if (StringUtils.isBlank((String)string)) {
            return;
        }
        RoleCacheInfo roleCacheInfo = (RoleCacheInfo)map.get(string);
        if (roleCacheInfo != null) {
            RoleCacheInfo roleCacheInfo2 = roleCacheInfo;
            synchronized (roleCacheInfo2) {
                roleCacheInfo.templateSet.clear();
                if (set != null) {
                    for (RoleTemplatePrivilege roleTemplatePrivilege : set) {
                        roleCacheInfo.templateSet.add(roleTemplatePrivilege);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void refreshEntryPrivileges(Map<Long, RoleCacheInfo> map, long l, Set<RoleEntryPrivilege> set) {
        RoleCacheInfo roleCacheInfo = map.get(l);
        if (roleCacheInfo != null) {
            RoleCacheInfo roleCacheInfo2 = roleCacheInfo;
            synchronized (roleCacheInfo2) {
                roleCacheInfo.entryPrivilegeSet.clear();
                if (set != null) {
                    for (RoleEntryPrivilege roleEntryPrivilege : set) {
                        roleCacheInfo.entryPrivilegeSet.add(EntryTypeAndID.getInstance(roleEntryPrivilege.getType(), roleEntryPrivilege.getEntryid(), roleEntryPrivilege.getView(), roleEntryPrivilege.getAuthorized(), roleEntryPrivilege.getEdit()));
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void refreshEntryPrivileges(Map map, String string, Set<RoleEntryPrivilege> set) {
        if (StringUtils.isBlank((String)string)) {
            return;
        }
        RoleCacheInfo roleCacheInfo = (RoleCacheInfo)map.get(string);
        if (roleCacheInfo != null) {
            RoleCacheInfo roleCacheInfo2 = roleCacheInfo;
            synchronized (roleCacheInfo2) {
                roleCacheInfo.entryPrivilegeSet.clear();
                if (set != null) {
                    for (RoleEntryPrivilege roleEntryPrivilege : set) {
                        roleCacheInfo.entryPrivilegeSet.add(EntryTypeAndID.getInstance(roleEntryPrivilege.getType(), roleEntryPrivilege.getEntryid(), roleEntryPrivilege.getView(), roleEntryPrivilege.getAuthorized(), roleEntryPrivilege.getEdit()));
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void refreshDepAndCRolePrivileges(Map<Long, RoleCacheInfo> map, long l, Set<RoleDepAndCRolePrivilege> set) {
        RoleCacheInfo roleCacheInfo = map.get(l);
        if (roleCacheInfo != null) {
            RoleCacheInfo roleCacheInfo2 = roleCacheInfo;
            synchronized (roleCacheInfo2) {
                roleCacheInfo.deptAndCustomRolePrivilegeSet.clear();
                if (set != null) {
                    for (RoleDepAndCRolePrivilege roleDepAndCRolePrivilege : set) {
                        roleCacheInfo.deptAndCustomRolePrivilegeSet.add(roleDepAndCRolePrivilege);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void refreshDepAndCRolePrivileges(Map map, String string, Set<RoleDepAndCRolePrivilege> set) {
        if (StringUtils.isBlank((String)string)) {
            return;
        }
        RoleCacheInfo roleCacheInfo = (RoleCacheInfo)map.get(string);
        if (roleCacheInfo != null) {
            RoleCacheInfo roleCacheInfo2 = roleCacheInfo;
            synchronized (roleCacheInfo2) {
                roleCacheInfo.deptAndCustomRolePrivilegeSet.clear();
                if (set != null) {
                    for (RoleDepAndCRolePrivilege roleDepAndCRolePrivilege : set) {
                        roleCacheInfo.deptAndCustomRolePrivilegeSet.add(roleDepAndCRolePrivilege);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void refreshDataConnectionPrivileges(Map<Long, RoleCacheInfo> map, long l, Set<RoleDataConnectionPrivilege> set) {
        RoleCacheInfo roleCacheInfo = map.get(l);
        if (roleCacheInfo != null) {
            RoleCacheInfo roleCacheInfo2 = roleCacheInfo;
            synchronized (roleCacheInfo2) {
                roleCacheInfo.dataConnectionSet.clear();
                if (set != null) {
                    for (RoleDataConnectionPrivilege roleDataConnectionPrivilege : set) {
                        roleCacheInfo.dataConnectionSet.add(roleDataConnectionPrivilege);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void refreshDataConnectionPrivileges(Map map, String string, Set<RoleDataConnectionPrivilege> set) {
        if (StringUtils.isBlank((String)string)) {
            return;
        }
        RoleCacheInfo roleCacheInfo = (RoleCacheInfo)map.get(string);
        if (roleCacheInfo != null) {
            RoleCacheInfo roleCacheInfo2 = roleCacheInfo;
            synchronized (roleCacheInfo2) {
                roleCacheInfo.dataConnectionSet.clear();
                if (set != null) {
                    for (RoleDataConnectionPrivilege roleDataConnectionPrivilege : set) {
                        roleCacheInfo.dataConnectionSet.add(roleDataConnectionPrivilege);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void refreshESPrivileges(Map<Long, RoleCacheInfo> map, long l, Set<RoleESPrivilege> set) {
        if (l < 0L) {
            return;
        }
        RoleCacheInfo roleCacheInfo = map.get(l);
        if (roleCacheInfo != null) {
            RoleCacheInfo roleCacheInfo2 = roleCacheInfo;
            synchronized (roleCacheInfo2) {
                roleCacheInfo.ESPrivilegeSet.clear();
                if (set != null) {
                    for (RoleESPrivilege roleESPrivilege : set) {
                        roleCacheInfo.ESPrivilegeSet.add(EntryTypeAndID.getInstance(roleESPrivilege.getType(), roleESPrivilege.getEntryID()));
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void refreshPlatePrivileges(Map<Long, RoleCacheInfo> map, long l, Set<RelationObject> set, String string) {
        if (RoleCheckUtils.isNotNormalID(l)) {
            return;
        }
        RoleCacheInfo roleCacheInfo = map.get(l);
        if (roleCacheInfo != null) {
            RoleCacheInfo roleCacheInfo2 = roleCacheInfo;
            synchronized (roleCacheInfo2) {
                roleCacheInfo.clearPlatePrivileges(string);
                if (set != null) {
                    for (RelationObject relationObject : set) {
                        roleCacheInfo.addPlatePrivileges(relationObject, string);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void refreshEntryPrivileges(Map<Long, RoleCacheInfo> map, long l, int n, long l2, long l3) {
        if (l < 0L) {
            return;
        }
        RoleCacheInfo roleCacheInfo = map.get(l);
        if (roleCacheInfo != null) {
            RoleCacheInfo roleCacheInfo2 = roleCacheInfo;
            synchronized (roleCacheInfo2) {
                roleCacheInfo.entryPrivilegeSet.remove(EntryTypeAndID.getInstance(n, l2));
                roleCacheInfo.entryPrivilegeSet.add(EntryTypeAndID.getInstance(n, l3));
            }
        }
    }
}

