/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.cache;

import com.fr.fs.base.entity.PlatformManageModule;
import com.fr.fs.base.entity.RoleModulePrivilege;
import com.fr.fs.control.UserControl;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.ArrayUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class ModuleTreeNode
implements Comparable {
    private PlatformManageModule platformManageModule;
    private final Map<Long, ModuleTreeNode> nodeMap = new TreeMap<Long, ModuleTreeNode>();
    private int sortIndex;

    protected ModuleTreeNode(PlatformManageModule platformManageModule) {
        this.platformManageModule = platformManageModule;
        this.sortIndex = platformManageModule.getPriority();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addNode(long l, ModuleTreeNode moduleTreeNode) {
        Map<Long, ModuleTreeNode> map = this.nodeMap;
        synchronized (map) {
            this.nodeMap.put(l, moduleTreeNode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ModuleTreeNode[] getNodeValues() {
        Map<Long, ModuleTreeNode> map = this.nodeMap;
        synchronized (map) {
            ArrayList<ModuleTreeNode> arrayList = new ArrayList<ModuleTreeNode>();
            for (Map.Entry<Long, ModuleTreeNode> entry : this.nodeMap.entrySet()) {
                arrayList.add(entry.getValue());
            }
            Collections.sort(arrayList);
            return arrayList.toArray(new ModuleTreeNode[arrayList.size()]);
        }
    }

    public int getSortIndex() {
        return this.sortIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Long[] getNodeIDs() {
        Map<Long, ModuleTreeNode> map = this.nodeMap;
        synchronized (map) {
            ArrayList<Long> arrayList = new ArrayList<Long>();
            for (Map.Entry<Long, ModuleTreeNode> entry : this.nodeMap.entrySet()) {
                arrayList.add(entry.getKey());
            }
            return arrayList.toArray(new Long[arrayList.size()]);
        }
    }

    protected PlatformManageModule getPlatformManageModule() {
        return this.platformManageModule;
    }

    public JSONArray createShowModuleConfig(long l) throws Exception {
        JSONArray jSONArray = new JSONArray();
        if (l < 0L && l != UserControl.getInstance().getSuperManagerID()) {
            return jSONArray;
        }
        Set set = UserControl.getInstance().getAllModulePrivileges(l);
        if (set == null) {
            return jSONArray;
        }
        ModuleTreeNode[] moduleTreeNodeArray = this.getNodeValues();
        for (int i = 0; i < moduleTreeNodeArray.length; ++i) {
            if (!moduleTreeNodeArray[i].isVisible(set)) continue;
            jSONArray.put((Object)moduleTreeNodeArray[i].platformManageModule.createJSONConfig());
        }
        return jSONArray;
    }

    private boolean isVisible(Set set) {
        Object object2;
        if (set == null) {
            return false;
        }
        for (Object object2 : set) {
            if (object2.getModuleid() != this.platformManageModule.getId()) continue;
            return true;
        }
        object2 = this.getNodeValues();
        if (!ArrayUtils.isEmpty((Object[])object2)) {
            for (int i = 0; i < ((Object[])object2).length; ++i) {
                if (!super.isVisible(set)) continue;
                return true;
            }
        }
        return false;
    }

    public JSONObject createJSONConfig() throws JSONException {
        JSONObject jSONObject = this.platformManageModule.createJSONConfig();
        Object[] objectArray = this.getNodeValues();
        if (!ArrayUtils.isEmpty((Object[])objectArray)) {
            JSONArray jSONArray = new JSONArray();
            for (int i = 0; i < objectArray.length; ++i) {
                jSONArray.put((Object)((ModuleTreeNode)objectArray[i]).createJSONConfig());
            }
            jSONObject.put("ChildNodes", (Object)jSONArray);
        } else {
            jSONObject.put("leaf", true);
        }
        return jSONObject;
    }

    public JSONArray createAllChildrenJSONConfig() throws JSONException {
        Object[] objectArray = this.getNodeValues();
        JSONArray jSONArray = new JSONArray();
        if (!ArrayUtils.isEmpty((Object[])objectArray)) {
            for (int i = 0; i < objectArray.length; ++i) {
                jSONArray.put((Object)((ModuleTreeNode)objectArray[i]).createJSONConfig());
            }
        }
        return jSONArray;
    }

    public JSONObject createShowJSONConfig(long l) throws Exception {
        Set set = UserControl.getInstance().getAllModulePrivileges(l);
        JSONObject jSONObject = this.createShowJSONConfig(set, false);
        if (jSONObject == null) {
            jSONObject = new JSONObject();
        }
        return jSONObject;
    }

    private JSONObject createShowJSONConfig(Set set, boolean bl) throws JSONException {
        RoleModulePrivilege roleModulePrivilege2;
        if (!bl && set == null) {
            return null;
        }
        for (RoleModulePrivilege roleModulePrivilege2 : set) {
            if (roleModulePrivilege2.getModuleid() != this.platformManageModule.getId()) continue;
            bl = true;
            break;
        }
        roleModulePrivilege2 = null;
        Object[] objectArray = this.getNodeValues();
        if (!ArrayUtils.isEmpty((Object[])objectArray)) {
            JSONArray jSONArray = new JSONArray();
            for (int i = 0; i < objectArray.length; ++i) {
                JSONObject jSONObject = super.createShowJSONConfig(set, bl);
                if (jSONObject == null) continue;
                jSONArray.put((Object)jSONObject);
            }
            if (bl || jSONArray.length() > 0) {
                roleModulePrivilege2 = this.platformManageModule.createJSONConfig();
                roleModulePrivilege2.put("ChildNodes", jSONArray);
            }
        } else if (bl) {
            roleModulePrivilege2 = this.platformManageModule.createJSONConfig();
            roleModulePrivilege2.put("leaf", true);
        }
        return roleModulePrivilege2;
    }

    public int compareTo(Object object) {
        return this.sortIndex - ((ModuleTreeNode)object).getSortIndex();
    }
}

