/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.cache;

import com.fr.fs.base.entity.PlatformManageModule;
import com.fr.fs.base.entity.RoleModulePrivilege;
import com.fr.fs.cache.ModuleTreeNode;
import com.fr.fs.dao.PlatformManageModuleDataAccessObject;
import com.fr.general.GeneralContext;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.EnvChangedListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModuleCache {
    private static PlatformManageModuleDataAccessObject mDao = PlatformManageModuleDataAccessObject.getInstance();
    private static ModuleTreeNode root;
    private static final Map<Long, ModuleTreeNode> listMap;

    public static void clearModuleCache() {
        PlatformManageModule platformManageModule = new PlatformManageModule(-1L);
        platformManageModule.setName("root");
        platformManageModule.setParentId(-2L);
        root = new ModuleTreeNode(platformManageModule);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void initCacheTree() throws Exception {
        Map<Long, ModuleTreeNode> map = listMap;
        synchronized (map) {
            if (listMap.isEmpty()) {
                try {
                    Object object2;
                    listMap.put(-1L, root);
                    List list = mDao.findAll();
                    for (Object object2 : list) {
                        listMap.put(object2.getId(), new ModuleTreeNode((PlatformManageModule)((Object)object2)));
                    }
                    Set<Map.Entry<Long, ModuleTreeNode>> set = listMap.entrySet();
                    object2 = set.iterator();
                    while (object2.hasNext()) {
                        Map.Entry entry = (Map.Entry)object2.next();
                        ModuleTreeNode moduleTreeNode = (ModuleTreeNode)entry.getValue();
                        ModuleTreeNode moduleTreeNode2 = listMap.get(moduleTreeNode.getPlatformManageModule().getParentId());
                        if (moduleTreeNode2 == null) continue;
                        moduleTreeNode2.addNode(moduleTreeNode.getPlatformManageModule().getId(), moduleTreeNode);
                    }
                }
                catch (Exception exception) {
                    listMap.clear();
                    throw exception;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reInit() throws Exception {
        Map<Long, ModuleTreeNode> map = listMap;
        synchronized (map) {
            ModuleCache.clearModuleCache();
            listMap.clear();
            ModuleCache.initCacheTree();
        }
    }

    public static JSONArray getModuleRootShowInfo(long l) throws Exception {
        return root.createShowModuleConfig(l);
    }

    public static JSONArray getRootNodeInfo() throws JSONException {
        return root.createAllChildrenJSONConfig();
    }

    public static JSONObject getNodeInfo(long l, long l2) throws Exception {
        ModuleTreeNode moduleTreeNode = listMap.get(l);
        if (moduleTreeNode != null) {
            return moduleTreeNode.createShowJSONConfig(l2);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JSONArray getAuthorizedModuleItemsFromPrivilegeSet(Set<RoleModulePrivilege> set) throws JSONException {
        Map<Long, ModuleTreeNode> map = listMap;
        synchronized (map) {
            Collection<ModuleTreeNode> collection = listMap.values();
            JSONObject jSONObject = collection.toArray(new ModuleTreeNode[collection.size()]);
            Arrays.sort((Object[])jSONObject);
            JSONArray jSONArray = new JSONArray();
            Object object = null;
            block3: for (Object object2 : jSONObject) {
                for (RoleModulePrivilege roleModulePrivilege : set) {
                    if (roleModulePrivilege.getModuleid() != ((ModuleTreeNode)object2).getPlatformManageModule().getId()) continue;
                    if (((ModuleTreeNode)object2).getPlatformManageModule().getId() == 18L) {
                        object = object2;
                        continue;
                    }
                    JSONObject jSONObject2 = ((ModuleTreeNode)object2).createJSONConfig();
                    jSONObject2.put("view", 0);
                    jSONObject2.put("design", 0);
                    jSONArray.put((Object)jSONObject2);
                    continue block3;
                }
            }
            if (object != null) {
                JSONObject jSONObject3 = ((ModuleTreeNode)object).createJSONConfig();
                jSONObject3.put("view", 0);
                jSONObject3.put("design", 0);
                jSONArray.put((Object)jSONObject3);
            }
            return jSONArray;
        }
    }

    public static List<PlatformManageModule> getAllModules() {
        return ModuleCache.getAllModules(false);
    }

    public static List<PlatformManageModule> getClonedAllModules() {
        return ModuleCache.getAllModules(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<PlatformManageModule> getAllModules(boolean bl) {
        Map<Long, ModuleTreeNode> map = listMap;
        synchronized (map) {
            Set<Map.Entry<Long, ModuleTreeNode>> set = listMap.entrySet();
            Iterator<Map.Entry<Long, ModuleTreeNode>> iterator = set.iterator();
            ArrayList<PlatformManageModule> arrayList = new ArrayList<PlatformManageModule>(listMap.size());
            while (iterator.hasNext()) {
                Map.Entry<Long, ModuleTreeNode> entry = iterator.next();
                ModuleTreeNode moduleTreeNode = entry.getValue();
                if (bl) {
                    try {
                        arrayList.add((PlatformManageModule)((Object)moduleTreeNode.getPlatformManageModule().clone()));
                    }
                    catch (CloneNotSupportedException cloneNotSupportedException) {}
                    continue;
                }
                arrayList.add(moduleTreeNode.getPlatformManageModule());
            }
            return arrayList;
        }
    }

    public static synchronized void cache(PlatformManageModule platformManageModule) {
        if (platformManageModule == null || listMap.containsKey(platformManageModule.getId())) {
            return;
        }
        ModuleTreeNode moduleTreeNode = listMap.get(platformManageModule.getParentId());
        if (moduleTreeNode != null) {
            ModuleTreeNode moduleTreeNode2 = new ModuleTreeNode(platformManageModule);
            listMap.put(platformManageModule.getParentId(), moduleTreeNode2);
            moduleTreeNode.addNode(platformManageModule.getId(), moduleTreeNode2);
        }
    }

    public static synchronized void removeCache(long l) {
        Long[] longArray;
        if (l < 0L) {
            return;
        }
        ModuleTreeNode moduleTreeNode = listMap.get(l);
        if (moduleTreeNode != null && (longArray = moduleTreeNode.getNodeIDs()) != null) {
            for (Long l2 : longArray) {
                ModuleCache.removeCache(l2);
            }
        }
    }

    static {
        listMap = new ConcurrentHashMap<Long, ModuleTreeNode>(128);
        ModuleCache.clearModuleCache();
        GeneralContext.addEnvChangedListener((EnvChangedListener)new EnvChangedListener(){

            public void envChanged() {
                ModuleCache.clearModuleCache();
                listMap.clear();
            }
        });
    }
}

