/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.cache;

import com.fr.fs.base.entity.HomePage;
import com.fr.fs.cache.EntryTreeFolderNode;
import com.fr.fs.dao.HomePageDAO;
import com.fr.general.GeneralContext;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.EnvChangedListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HomePageCache {
    public static final long DEFAULT_HOMEPAGE_ID = 0L;
    private static HomePageDAO hDao = HomePageDAO.getInstance();
    private static final Map<Long, HomePage> HOME_PAGE_MAP = new ConcurrentHashMap<Long, HomePage>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void initHomePageCache() throws Exception {
        Map<Long, HomePage> map = HOME_PAGE_MAP;
        synchronized (map) {
            try {
                List list = hDao.findAll();
                for (HomePage homePage : list) {
                    HOME_PAGE_MAP.put(homePage.getId(), homePage);
                }
            }
            catch (Exception exception) {
                HOME_PAGE_MAP.clear();
                throw exception;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reInit() throws Exception {
        Map<Long, HomePage> map = HOME_PAGE_MAP;
        synchronized (map) {
            HOME_PAGE_MAP.clear();
            HomePageCache.initHomePageCache();
        }
    }

    public static boolean containCache(long l) {
        return HOME_PAGE_MAP.get(l) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getHomePageCount() {
        Map<Long, HomePage> map = HOME_PAGE_MAP;
        synchronized (map) {
            return HOME_PAGE_MAP.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<HomePage> getAllHomePages() {
        Map<Long, HomePage> map = HOME_PAGE_MAP;
        synchronized (map) {
            Set<Map.Entry<Long, HomePage>> set = HOME_PAGE_MAP.entrySet();
            ArrayList<HomePage> arrayList = new ArrayList<HomePage>(HOME_PAGE_MAP.size());
            for (Map.Entry<Long, HomePage> entry : set) {
                arrayList.add(entry.getValue());
            }
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HomePage[] getAllHomePagesSorted() {
        Map<Long, HomePage> map = HOME_PAGE_MAP;
        synchronized (map) {
            List<HomePage> list = HomePageCache.getAllHomePages();
            HomePage[] homePageArray = list.toArray(new HomePage[list.size()]);
            Arrays.sort(homePageArray, SORTINFOComparator.getInstance());
            return homePageArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JSONArray getAllHomePageInfo() throws JSONException {
        Map<Long, HomePage> map = HOME_PAGE_MAP;
        synchronized (map) {
            JSONArray jSONArray = new JSONArray();
            Set<Map.Entry<Long, HomePage>> set = HOME_PAGE_MAP.entrySet();
            for (Map.Entry<Long, HomePage> entry : set) {
                jSONArray.put((Object)entry.getValue().createJSONConfig());
            }
            return jSONArray;
        }
    }

    public static HomePage getHomePage(long l) {
        HomePage homePage = HOME_PAGE_MAP.get(l);
        if (homePage != null) {
            return homePage;
        }
        return null;
    }

    public static JSONObject getHomePageInfo(long l) throws Exception {
        HomePage homePage = HOME_PAGE_MAP.get(l);
        if (homePage != null) {
            return homePage.createJSONConfig();
        }
        return null;
    }

    public static synchronized void cache(HomePage homePage) {
        if (homePage == null) {
            return;
        }
        HOME_PAGE_MAP.put(homePage.getId(), homePage);
    }

    public static synchronized void removeCache(long l) {
        if (l < 0L) {
            return;
        }
        HomePage homePage = HOME_PAGE_MAP.get(l);
        if (homePage != null) {
            HOME_PAGE_MAP.remove(l);
        }
    }

    static {
        GeneralContext.addEnvChangedListener((EnvChangedListener)new EnvChangedListener(){

            public void envChanged() {
                HOME_PAGE_MAP.clear();
            }
        });
    }

    private static class SORTINFOComparator
    implements Comparator {
        private static SORTINFOComparator SC = new SORTINFOComparator();

        private SORTINFOComparator() {
        }

        public static SORTINFOComparator getInstance() {
            return SC;
        }

        public int compare(Object object, Object object2) {
            long l;
            if (object instanceof EntryTreeFolderNode) {
                object = ((EntryTreeFolderNode)object).getFolder();
                object2 = ((EntryTreeFolderNode)object2).getFolder();
            }
            if (!(object instanceof HomePage) || !(object2 instanceof HomePage)) {
                return 0;
            }
            HomePage homePage = (HomePage)((Object)object);
            HomePage homePage2 = (HomePage)((Object)object2);
            long l2 = homePage.getSortindex() == 0L ? Integer.MAX_VALUE : homePage.getSortindex();
            long l3 = l2 - (l = homePage2.getSortindex() == 0L ? Integer.MAX_VALUE : homePage2.getSortindex());
            if (l3 < 0L) {
                return 1;
            }
            if (l3 == 0L) {
                long l4 = homePage.getId() - homePage2.getId();
                if (l4 > 0L) {
                    return 1;
                }
                if (l4 == 0L) {
                    return 0;
                }
                return -1;
            }
            return -1;
        }
    }
}

