/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.cache;

import com.fr.fs.FSConfig;
import com.fr.fs.base.entity.Department;
import com.fr.fs.cache.DepartmentTreeNode;
import com.fr.fs.cache.IDLockCreator;
import com.fr.general.ComparatorUtils;
import com.fr.general.FRLogger;
import com.fr.stable.DeathCycleException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DepartmentCache {
    private static DepartmentTreeNode root;
    private static Map listMap;
    private static final IDLockCreator DIDLOCKCREATER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initCacheTree() {
        Map map = listMap;
        synchronized (map) {
            if (listMap.isEmpty()) {
                try {
                    listMap.put(new Long(-1L), root);
                    List list = FSConfig.getInstance().getControl().getDepartmentDAO().findAll();
                    int n = list.size();
                    for (int i = 0; i < n; ++i) {
                        Department department = (Department)((Object)list.get(i));
                        listMap.put(new Long(department.getId()), new DepartmentTreeNode(department));
                    }
                    Set set = listMap.entrySet();
                    Iterator iterator = set.iterator();
                    ArrayList<Department> arrayList = new ArrayList<Department>();
                    while (iterator.hasNext()) {
                        Map.Entry entry = iterator.next();
                        DepartmentTreeNode departmentTreeNode = (DepartmentTreeNode)entry.getValue();
                        DepartmentTreeNode departmentTreeNode2 = (DepartmentTreeNode)listMap.get(new Long(departmentTreeNode.getDepartment().getPid()));
                        if (departmentTreeNode2 != null) {
                            departmentTreeNode2.addNode(departmentTreeNode.getDepartment().getId(), departmentTreeNode);
                            continue;
                        }
                        arrayList.add(departmentTreeNode.getDepartment());
                    }
                }
                catch (Exception exception) {
                    listMap.clear();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reInit() {
        Map map = listMap;
        synchronized (map) {
            Department department = new Department();
            department.setName("root");
            department.setId(-1L);
            department.setPid(-2L);
            root = new DepartmentTreeNode(department);
            listMap.clear();
            try {
                DepartmentCache.initCacheTree();
            }
            catch (Exception exception) {
                FRLogger.getLogger().info(exception.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearCache() throws Exception {
        Map map = listMap;
        synchronized (map) {
            Department department = new Department();
            department.setName("root");
            department.setId(-1L);
            department.setPid(-2L);
            root = new DepartmentTreeNode(department);
            listMap.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cache(Department department) {
        if (department == null || department.getId() < 0L) {
            return;
        }
        Object object = DIDLOCKCREATER.getIDLock(department.getId());
        try {
            Object object2 = object;
            synchronized (object2) {
                block10: {
                    if (!listMap.containsKey(new Long(department.getId()))) break block10;
                    return;
                }
                DepartmentTreeNode departmentTreeNode = (DepartmentTreeNode)listMap.get(new Long(department.getPid()));
                if (departmentTreeNode != null) {
                    DepartmentTreeNode departmentTreeNode2 = new DepartmentTreeNode(department);
                    departmentTreeNode.addNode(department.getId(), departmentTreeNode2);
                    listMap.put(new Long(department.getId()), departmentTreeNode2);
                }
            }
        }
        finally {
            DIDLOCKCREATER.releaseIDLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cacheNewName(long l, String string) {
        if (l < 0L) {
            return;
        }
        Object object = DIDLOCKCREATER.getIDLock(l);
        try {
            Object object2 = object;
            synchronized (object2) {
                DepartmentTreeNode departmentTreeNode = (DepartmentTreeNode)listMap.get(l);
                if (departmentTreeNode != null) {
                    departmentTreeNode.getDepartment().setName(string);
                }
            }
        }
        finally {
            DIDLOCKCREATER.releaseIDLock();
        }
    }

    public static DepartmentTreeNode getRootNode() {
        return root;
    }

    public static Department getDepartment(long l) {
        DepartmentCache.initCacheTree();
        DepartmentTreeNode departmentTreeNode = (DepartmentTreeNode)listMap.get(l);
        if (departmentTreeNode != null) {
            try {
                return (Department)((Object)departmentTreeNode.getDepartment().clone());
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
        }
        return null;
    }

    public static Long[] getDpidsByPid(long l) {
        DepartmentCache.initCacheTree();
        DepartmentTreeNode departmentTreeNode = (DepartmentTreeNode)listMap.get(l);
        if (departmentTreeNode != null) {
            return departmentTreeNode.getNodeIDs();
        }
        return new Long[0];
    }

    public static Department getDepartmentByNameAndPid(String string, long l) {
        DepartmentCache.initCacheTree();
        Long[] longArray = DepartmentCache.getDpidsByPid(l);
        if (longArray != null) {
            int n = longArray.length;
            for (int i = 0; i < n; ++i) {
                DepartmentTreeNode departmentTreeNode = (DepartmentTreeNode)listMap.get(longArray[i]);
                Department department = departmentTreeNode.getDepartment();
                if (!ComparatorUtils.equals((Object)department.getName(), (Object)string)) continue;
                return department;
            }
        }
        return null;
    }

    public static String getShowDepartmentName(long l, String string) {
        if (l < 0L) {
            return null;
        }
        DepartmentCache.initCacheTree();
        DepartmentTreeNode departmentTreeNode = (DepartmentTreeNode)listMap.get(l);
        if (departmentTreeNode != null) {
            return departmentTreeNode.getShowName(string);
        }
        return null;
    }

    public static Long[] getDepartmentPath(long l) {
        if (l < 0L) {
            return null;
        }
        DepartmentCache.initCacheTree();
        DepartmentTreeNode departmentTreeNode = (DepartmentTreeNode)listMap.get(l);
        if (departmentTreeNode != null) {
            return departmentTreeNode.getPath();
        }
        return null;
    }

    public static boolean removeCache(long l) throws Exception {
        return DepartmentCache.removeCache(l, new ArrayList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean removeCache(long l, List list) throws Exception {
        if (l < 0L) {
            return false;
        }
        if (list.contains(new Long(l))) {
            throw new DeathCycleException("A Point Cycle in Deparment Cache Tree.");
        }
        DepartmentCache.initCacheTree();
        list.add(l);
        Object object = DIDLOCKCREATER.getIDLock(l);
        try {
            Object object2 = object;
            synchronized (object2) {
                DepartmentTreeNode departmentTreeNode = (DepartmentTreeNode)listMap.remove(l);
                if (departmentTreeNode != null) {
                    departmentTreeNode.removeSelf();
                    Long[] longArray = departmentTreeNode.getNodeIDs();
                    if (longArray != null) {
                        for (int i = 0; i < longArray.length; ++i) {
                            DepartmentCache.removeCache(longArray[i]);
                        }
                    }
                }
            }
        }
        finally {
            DIDLOCKCREATER.releaseIDLock();
        }
        return FSConfig.getInstance().getControl().getDepartmentDAO().deleteByID(l);
    }

    static {
        listMap = new Hashtable();
        DIDLOCKCREATER = new IDLockCreator();
        Department department = new Department();
        department.setName("root");
        department.setId(-1L);
        department.setPid(-2L);
        root = new DepartmentTreeNode(department);
    }
}

