/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.basic;

import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLable;
import com.fr.stable.xml.XMLableReader;

public class Theme
implements XMLable {
    public static final String XML_TAG = "fstheme";
    private String name;
    private String jsPath;
    private String stylePath;
    private boolean custom;

    public Theme() {
    }

    public Theme(String string) {
        this.name = string;
    }

    public Theme(String string, boolean bl) {
        this.name = string;
        this.custom = bl;
    }

    public String getName() {
        return this.name;
    }

    public boolean isCustom() {
        return this.custom;
    }

    public JSONObject createJSONObject() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("isCustom", this.custom);
        jSONObject.put("name", (Object)this.name);
        return jSONObject;
    }

    public String getJavaScriptPath() {
        return this.jsPath;
    }

    public void setJavaScriptPath(String string) {
        this.jsPath = string;
    }

    public String getStylePath() {
        return this.stylePath;
    }

    public void setStylePath(String string) {
        this.stylePath = string;
    }

    public void readXML(XMLableReader xMLableReader) {
        String string;
        if (xMLableReader.isChildNode() && (string = xMLableReader.getTagName()).equals(XML_TAG)) {
            this.name = xMLableReader.getAttrAsString("name", "default");
            this.custom = xMLableReader.getAttrAsBoolean("custom", false);
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG);
        xMLPrintWriter.attr("name", this.name);
        if (this.custom) {
            xMLPrintWriter.attr("custom", true);
        }
        xMLPrintWriter.end();
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

