/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs;

import com.fr.data.dao.RelationFCMapper;
import com.fr.fs.FSPlate;
import com.fr.fs.base.entity.PlatformManageModule;
import com.fr.fs.control.dao.tabledata.TableDataDAOControl;
import com.fr.general.FRLogger;
import com.fr.general.GeneralUtils;
import com.fr.stable.bridge.StableFactory;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlateFactory {
    private static Map<String, FSPlate> map = new HashMap<String, FSPlate>();

    private PlateFactory() {
    }

    public static void startPlate(String string, String string2) {
        try {
            FSPlate fSPlate = (FSPlate)GeneralUtils.classForName((String)string2).newInstance();
            if (fSPlate != null && fSPlate.isSupport()) {
                fSPlate.initData();
                PlateFactory.putPlate2Factory(string, fSPlate);
                PlatformManageModule[] platformManageModuleArray = fSPlate.supportPlatformManageModules();
                StableFactory.registerMarkedObjectToCollection((String)"PlatformManageModule", (Object[])platformManageModuleArray);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            FRLogger.getLogger().info("Plate " + string2 + " is not exist!");
        }
        catch (Exception exception) {
            FRLogger.getLogger().error("Cannot start plate:" + string2);
        }
    }

    public static void releaseAll() {
        for (FSPlate fSPlate : map.values()) {
            fSPlate.release();
        }
    }

    public static String[] supportModules() {
        Set<String> set = map.keySet();
        return set.toArray(new String[set.size()]);
    }

    public static Iterator<String> plateNameIterator() {
        return map.keySet().iterator();
    }

    public static Class getRelationClassByName(String string) {
        return PlateFactory.getPlateByName(string).getRelationClass();
    }

    public static TableDataDAOControl.ColumnColumn[] getTableDataColumnsByName(String string) {
        FSPlate fSPlate = PlateFactory.getPlateByName(string);
        if (fSPlate != null) {
            return PlateFactory.getPlateByName(string).getTableDataColumns();
        }
        return new TableDataDAOControl.ColumnColumn[0];
    }

    public static void putPlate2Factory(String string, FSPlate fSPlate) {
        if (fSPlate != null) {
            map.put(string, fSPlate);
        }
    }

    public static FSPlate getPlateByName(String string) {
        return map.get(string);
    }

    public static RelationFCMapper getRelationFCMapper4Company(String string) {
        return PlateFactory.getPlateByName(string).getRelationFCMapper4Company();
    }

    public static RelationFCMapper getRelationFCMapper4Custom(String string) {
        return PlateFactory.getPlateByName(string).getRelationFCMapper4Custom();
    }

    public static Object createPrivilegeObject4Plate(long l, String string) {
        return PlateFactory.getPlateByName(string).createPrivilegeObject(l);
    }

    public static boolean containsPlate(String string) {
        return map.containsKey(string);
    }
}

