/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs;

import com.fr.base.Env;
import com.fr.base.FRContext;
import com.fr.cache.Attachment;
import com.fr.cache.AttachmentSource;
import com.fr.file.filetree.FileNode;
import com.fr.fs.basic.Theme;
import com.fr.general.ComparatorUtils;
import com.fr.json.JSONArray;
import com.fr.json.JSONObject;
import com.fr.stable.StableUtils;
import com.fr.stable.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class FSTheme {
    private static FSTheme FSTHEME = null;
    private static final String THEMEDIR = "fstheme";
    private static final String THEME_PREFIX = "fs-theme-";
    private static final int BUFFER_SIZE = 1024;
    private static final String THEME_ENV_PATH = StableUtils.pathJoin((String[])new String[]{"resources", "fstheme"});
    private static final String COVER_NAME = "cover.png";
    private static final String JS_NAME = "theme.js";
    private static final String CSS_NAME = "style.css";

    public static FSTheme getInstance() {
        if (FSTHEME != null) {
            return FSTHEME;
        }
        FSTHEME = new FSTheme();
        return FSTHEME;
    }

    public JSONArray readCustomThemeList() {
        JSONArray jSONArray = new JSONArray();
        try {
            Env env = FRContext.getCurrentEnv();
            for (FileNode fileNode : env.listFile(THEME_ENV_PATH)) {
                String string = fileNode.getName();
                if (!fileNode.isDirectory() || !string.startsWith(THEME_PREFIX)) continue;
                JSONObject jSONObject = new JSONObject();
                String string2 = string.substring(THEME_PREFIX.length());
                jSONObject.put("name", (Object)string2);
                jSONObject.put("text", (Object)string2);
                jSONObject.put("isCustom", true);
                InputStream inputStream = env.readBean(StableUtils.pathJoin((String[])new String[]{fileNode.getEnvPath(), COVER_NAME}), null);
                if (inputStream != null) {
                    jSONObject.put("cover", (Object)("fstheme/" + string + "/" + COVER_NAME));
                }
                jSONArray.put((Object)jSONObject);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return jSONArray;
    }

    public void loadThemeByName(Theme theme) {
        Env env = FRContext.getCurrentEnv();
        String string = theme.getName();
        try {
            String string2 = "";
            String string3 = "";
            for (FileNode fileNode : env.listFile(StableUtils.pathJoin((String[])new String[]{THEME_ENV_PATH, THEME_PREFIX + string}))) {
                String string4 = fileNode.getName();
                if (fileNode.isDirectory()) continue;
                if (ComparatorUtils.equals((Object)string4, (Object)JS_NAME)) {
                    string2 = StableUtils.pathJoin((String[])new String[]{THEMEDIR, THEME_PREFIX + string, JS_NAME});
                    continue;
                }
                if (!ComparatorUtils.equals((Object)string4, (Object)CSS_NAME)) continue;
                string3 = StableUtils.pathJoin((String[])new String[]{THEMEDIR, THEME_PREFIX + string, CSS_NAME});
            }
            theme.setJavaScriptPath(string2);
            theme.setStylePath(string3);
        }
        catch (Exception exception) {
            FRContext.getLogger().error("Cannot find theme: " + string);
        }
    }

    public JSONObject saveTheme(String string) {
        String string2;
        File file;
        JSONObject jSONObject = new JSONObject();
        Attachment attachment = AttachmentSource.getAttachment((String)string);
        String string3 = attachment.getFilename();
        if (string3.indexOf(46) != -1) {
            string3 = string3.substring(0, string3.lastIndexOf(46));
        }
        if (!(file = new File(string2 = StableUtils.pathJoin((String[])new String[]{FRContext.getCurrentEnv().getPath(), THEME_ENV_PATH}))).exists()) {
            file.mkdir();
        }
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(attachment.getBytes());
            String string4 = StringUtils.perfectStart((String)string3, (String)THEME_PREFIX);
            this.unzipFile(byteArrayInputStream, StableUtils.pathJoin((String[])new String[]{string2, string4}));
            jSONObject.put("name", (Object)string3);
            jSONObject.put("text", (Object)string3);
            jSONObject.put("isCustom", true);
            File file2 = new File(StableUtils.pathJoin((String[])new String[]{string2, string4, COVER_NAME}));
            if (file2.exists()) {
                jSONObject.put("cover", (Object)("fstheme/" + string4 + "/" + COVER_NAME));
            }
        }
        catch (Exception exception) {
            FRContext.getLogger().error("Cannot save theme: " + string3, (Throwable)exception);
        }
        return jSONObject;
    }

    private void unzipFile(InputStream inputStream, String string) throws IOException {
        byte[] byArray = new byte[1024];
        File file = new File(string);
        if (!file.exists()) {
            file.mkdir();
        }
        ZipInputStream zipInputStream = new ZipInputStream(inputStream);
        ZipEntry zipEntry = zipInputStream.getNextEntry();
        while (zipEntry != null) {
            int n;
            String string2 = zipEntry.getName();
            File file2 = new File(StableUtils.pathJoin((String[])new String[]{string, string2}));
            new File(file2.getParent()).mkdirs();
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            while ((n = zipInputStream.read(byArray)) > 0) {
                fileOutputStream.write(byArray, 0, n);
            }
            fileOutputStream.close();
            zipEntry = zipInputStream.getNextEntry();
        }
        zipInputStream.closeEntry();
        zipInputStream.close();
    }

    public String importStyle(String string, String string2, String string3, String string4) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(".fui-seb{background-color: ").append(string).append(";}").append(".fui-fbc{color: ").append(string2).append(";}").append(".fui-fbt{text-shadow: 0 0 1px ").append(string2).append(";}").append(".fui-fhc{color: ").append(string3).append(";}").append(".fui-fht{text-shadow: 0 0 3px ").append(string3).append(";}").append(".fui-bsb{background-color: ").append(string4).append(";}").append(".fui-bsc{color: ").append(string4).append(";}").append(".fui-bsd{border-color: ").append(string4).append(";}");
        return "<style name=\"theme\" type=\"text/css\">" + stringBuilder.toString() + "</style>";
    }
}

