/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs;

import com.fr.base.FRContext;
import com.fr.data.load.LazyExecutionJob;
import com.fr.data.load.LazyExecutionManager;
import com.fr.fs.FSBridge;
import com.fr.fs.FSConfig;
import com.fr.fs.FSContext;
import com.fr.fs.PlateFactory;
import com.fr.fs.fun.PlateProvider;
import com.fr.fs.plugin.ExtraPlatformClassManager;
import com.fr.fs.privilege.base.AuthErrorHandler;
import com.fr.fs.privilege.base.AuthTimeoutHandler;
import com.fr.fs.privilege.base.EncryptSignInHandler;
import com.fr.fs.privilege.base.RoleErrorHandler;
import com.fr.fs.web.service.EmailService;
import com.fr.fs.web.service.FSEntryService;
import com.fr.fs.web.service.FSLoadService;
import com.fr.fs.web.service.FSMainService;
import com.fr.fs.web.service.FSManagerService;
import com.fr.fs.web.service.FSOpenEntryService;
import com.fr.fs.web.service.FSSetService;
import com.fr.fs.web.service.FSSystemExamineService;
import com.fr.fs.web.service.FSTouchService;
import com.fr.fs.web.service.LogInServiceForOld;
import com.fr.fs.web.service.LogInUIServiceForOld;
import com.fr.fs.web.service.LogOutServiceForOld;
import com.fr.fs.web.service.LoginOutService;
import com.fr.fs.web.service.PlatFormTouchService;
import com.fr.fs.web.service.PlatformEntryService;
import com.fr.fs.web.service.ServerConfigService;
import com.fr.plugin.PluginLoader;
import com.fr.privilege.PrivilegeHandler;
import com.fr.privilege.PrivilegeHandlerFactory;
import com.fr.report.module.EngineModule;
import com.fr.stable.ArrayUtils;
import com.fr.stable.bridge.StableFactory;
import com.fr.stable.fun.Service;
import com.fr.web.core.A.BA;
import com.fr.write.ProcessProvider;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FSModule
extends EngineModule {
    public Service[] service4Register() {
        return (Service[])ArrayUtils.addAll((Object[])super.service4Register(), (Object[])new Service[]{new FSOpenEntryService(), new FSEntryService(), new FSMainService(), new FSSetService(), new FSManagerService(), new FSSystemExamineService(), new FSLoadService(), new FSTouchService(), new PlatformEntryService(), new EmailService(), new ServerConfigService(), new LoginOutService(), new PlatFormTouchService(), new LogInServiceForOld(), new LogOutServiceForOld(), new LogInUIServiceForOld()});
    }

    public String[] filterParameters4BaseSession() {
        return new String[]{"fr_fs_auth_key"};
    }

    public void startFinish() {
        StableFactory.registerJavaScriptFiles((String)"finereport.fs.js", (String[])this.getFSJavaScriptFiles4WebClient());
        StableFactory.registerStyleFiles((String)"finereport.fs.css", (String[])this.getFSCssFiles4WebClient());
        StableFactory.registerMarkedObject((String)"PlatformProvider", (Object)FSBridge.getInstance());
        StableFactory.registerMarkedClass((String)"ExtraPlatformClassManagerProvider", ExtraPlatformClassManager.class);
        PluginLoader.getLoader().readPluginsWaitForRead();
        this.init();
    }

    private void init() {
        this.startPlate();
        if (FSContext.isUseFS()) {
            FSContext.initData();
        }
        this.registerPrivilegeHandler();
        ProcessProvider processProvider = (ProcessProvider)StableFactory.getMarkedInstanceObjectFromClass((String)"processBridge", ProcessProvider.class);
        if (processProvider != null) {
            LazyExecutionManager.addJob((LazyExecutionJob)processProvider);
        }
    }

    private String[] getFSJavaScriptFiles4WebClient() {
        return new String[]{"/com/fr/fs/web/frame/fs.base.js", "/com/fr/fs/web/frame/fs.bridge.js", "/com/fr/fs/web/js/third/slimscroll.js", "/com/fr/fs/web/js/fstools.js", "/com/fr/fs/web/frame/fs.frame.js", "/com/fr/fs/web/frame/fs.tabpane.js", "/com/fr/fs/web/js/widget/fs_widget.js", "/com/fr/fs/web/js/widget/fs.tabletree.js", "/com/fr/fs/web/frame/fs.menutree.js"};
    }

    private String[] getFSCssFiles4WebClient() {
        return new String[]{"/com/fr/fs/web/css/fs.all.css", "/com/fr/fs/web/css/fs.widget.css"};
    }

    private void startPlate() {
        Map<String, String> map = this.platesForStart();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String string = entry.getKey();
            String string2 = entry.getValue();
            PlateFactory.startPlate(string, string2);
        }
    }

    public void stop() {
        try {
            FSConfig.release();
            PlateFactory.releaseAll();
        }
        catch (Throwable throwable) {
            FRContext.getLogger().error("shutdown fs module schedule failed" + throwable.getMessage());
        }
    }

    public boolean isNeedReleaseResource() {
        return true;
    }

    public BA loginUIExecutor4Register() {
        return (BA)StableFactory.getMarkedInstanceObjectFromClass((String)"LoginUIExecutor", BA.class, (Object)BA.A);
    }

    private void registerPrivilegeHandler() {
        PrivilegeHandlerFactory.registerAuthErrorHandler((PrivilegeHandler)AuthErrorHandler.getInstance());
        PrivilegeHandlerFactory.registerRoleErrorHandler((PrivilegeHandler)RoleErrorHandler.getInstance());
        PrivilegeHandlerFactory.registerAuthTimeoutHandler((PrivilegeHandler)AuthTimeoutHandler.getInstance());
        PrivilegeHandlerFactory.registerEncryptSignInHandler((PrivilegeHandler)EncryptSignInHandler.getInstance());
    }

    public String[] getLocaleFile() {
        Object[] objectArray = super.getLocaleFile();
        return (String[])ArrayUtils.add((Object[])objectArray, (Object)"com/fr/fs/locale/fs");
    }

    private Map<String, String> platesForStart() {
        PlateProvider[] plateProviderArray;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("schedule", "com.fr.schedule.SchedulePlate");
        hashMap.put("mobile", "com.fr.mobile.FMobilePlate");
        hashMap.put("bi", "com.fr.bi.BIPlate");
        hashMap.put("reportprocess", "com.fr.fs.process.ReportProcessPlate");
        for (PlateProvider plateProvider : plateProviderArray = ExtraPlatformClassManager.getInstance().getPlateProviders()) {
            hashMap.put(plateProvider.mark(), plateProvider.classForPlate().getName());
        }
        return hashMap;
    }
}

