/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs;

import com.fr.base.FRContext;
import com.fr.data.load.LazyExecutionException;
import com.fr.data.load.LazyExecutionJob;
import com.fr.data.load.LazyExecutionManager;
import com.fr.fs.FSConfig;
import com.fr.fs.cache.CompanyRoleCache;
import com.fr.fs.cache.CustomRoleCache;
import com.fr.fs.cache.DepartmentCache;
import com.fr.fs.cache.EntryCache;
import com.fr.fs.cache.HomePageCache;
import com.fr.fs.cache.LoginUserCache;
import com.fr.fs.cache.ModuleCache;
import com.fr.general.GeneralContext;
import com.fr.stable.EnvChangedListener;
import com.fr.stable.file.XMLFileManagerProvider;

public class FSContext {
    private static boolean DATA_ON = false;

    public static boolean isUseFS() {
        return FSConfig.getInstance().isUseFS();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setUsingFS() {
        if (!FSContext.isUseFS()) {
            FSConfig fSConfig;
            FSConfig fSConfig2 = fSConfig = FSConfig.getInstance();
            synchronized (fSConfig2) {
                if (!fSConfig.isUseFS()) {
                    fSConfig.setUseFS(true);
                    try {
                        FRContext.getCurrentEnv().writeResource((XMLFileManagerProvider)fSConfig);
                    }
                    catch (Exception exception) {
                        FRContext.getLogger().error(exception.getMessage(), (Throwable)exception);
                    }
                }
            }
        }
    }

    public static boolean isDataOn() {
        return DATA_ON;
    }

    public static void resetDataOn() {
        DATA_ON = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initData() {
        if (DATA_ON) {
            return;
        }
        Class<FSContext> clazz = FSContext.class;
        synchronized (FSContext.class) {
            if (!DATA_ON) {
                LazyExecutionManager.addJob((LazyExecutionJob)new LazyExecutionJob(){

                    public void waitForRun() throws LazyExecutionException {
                        FSContext.initCache();
                        FSConfig.getInstance().initLoginUserListByType(1);
                        FSConfig.getInstance().initLoginUserListByType(2);
                        DATA_ON = true;
                    }
                });
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private static void initCache() {
        try {
            EntryCache.initCacheTree();
        }
        catch (Exception exception) {
            FRContext.getLogger().error("Entry Data inited failed! :" + exception.getMessage(), (Throwable)exception);
        }
        try {
            CustomRoleCache.initCache();
        }
        catch (Exception exception) {
            FRContext.getLogger().error("Simple Role Data inited failed! :" + exception.getMessage(), (Throwable)exception);
        }
        try {
            CompanyRoleCache.initCache();
        }
        catch (Exception exception) {
            FRContext.getLogger().error("Job Role Data inited failed! :" + exception.getMessage(), (Throwable)exception);
        }
        try {
            DepartmentCache.initCacheTree();
        }
        catch (Exception exception) {
            FRContext.getLogger().error("Department Data inited failed! :" + exception.getMessage(), (Throwable)exception);
        }
        try {
            ModuleCache.initCacheTree();
        }
        catch (Exception exception) {
            FRContext.getLogger().error("Module Data inited failed! :" + exception.getMessage(), (Throwable)exception);
        }
        try {
            HomePageCache.initHomePageCache();
        }
        catch (Exception exception) {
            FRContext.getLogger().error("Homepage Data inited failed! :" + exception.getMessage(), (Throwable)exception);
        }
        try {
            LoginUserCache.initLoginUserCache();
        }
        catch (Exception exception) {
            FRContext.getLogger().error("LoginUser Data inited failed! :" + exception.getMessage(), (Throwable)exception);
        }
    }

    static {
        GeneralContext.addEnvChangedListener((EnvChangedListener)new EnvChangedListener(){

            public void envChanged() {
                DATA_ON = false;
            }
        });
    }
}

