/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs;

import com.fr.base.FRContext;
import com.fr.base.platform.PlatformProvider;
import com.fr.data.dao.RelationObject;
import com.fr.file.DatasourceManager;
import com.fr.file.filetree.FileNode;
import com.fr.fs.FSConfig;
import com.fr.fs.base.entity.CompanyRole;
import com.fr.fs.base.entity.CustomRole;
import com.fr.fs.base.entity.Department;
import com.fr.fs.base.entity.Post;
import com.fr.fs.base.entity.User;
import com.fr.fs.cache.EntryTreeFolderNode;
import com.fr.fs.control.CompanyRoleControl;
import com.fr.fs.control.CustomRoleControl;
import com.fr.fs.control.DepartmentControl;
import com.fr.fs.control.EntryControl;
import com.fr.fs.control.PostControl;
import com.fr.fs.control.UserControl;
import com.fr.fs.privilege.auth.AuthenticateResult;
import com.fr.fs.privilege.auth.FailResult;
import com.fr.fs.privilege.auth.UserNamePassWordFSAuthenticationProvider;
import com.fr.fs.privilege.base.FSPrivilegeTools;
import com.fr.fs.web.service.AbstractFSAuthService;
import com.fr.fs.web.service.ServiceUtils;
import com.fr.general.ComparatorUtils;
import com.fr.json.JSONArray;
import com.fr.json.JSONObject;
import com.fr.privilege.PrivilegeManager;
import com.fr.privilege.authentication.CommonAuthentication;
import com.fr.privilege.base.PrivilegeFilter;
import com.fr.stable.StringUtils;
import com.fr.web.utils.WebUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class FSBridge
implements PlatformProvider {
    private static FSBridge SC = new FSBridge();

    public static FSBridge getInstance() {
        return SC;
    }

    public String[] getAllCompanyRole4Designer() throws Exception {
        return CompanyRoleControl.getInstance().getAllCompanyRole4Designer();
    }

    public long getCurrentUserID(HttpServletRequest httpServletRequest) {
        return ServiceUtils.getCurrentUserID(httpServletRequest);
    }

    public long[] getCompanyRolesByUserId(long l) {
        try {
            Set set = UserControl.getInstance().getJobs(l);
            int n = set.size();
            long[] lArray = new long[n];
            RelationObject[] relationObjectArray = set.toArray(new RelationObject[n]);
            for (int i = 0; i < n; ++i) {
                RelationObject relationObject = relationObjectArray[i];
                Long l2 = (Long)relationObject.getValue(Department.class);
                Long l3 = (Long)relationObject.getValue(Post.class);
                List<CompanyRole> list = CompanyRoleControl.getInstance().getJRole(l2, l3);
                if (list == null || list.isEmpty()) continue;
                CompanyRole companyRole = list.get(0);
                lArray[i] = companyRole.getId();
            }
            return lArray;
        }
        catch (Exception exception) {
            return new long[0];
        }
    }

    public long getUserIdByName(String string) {
        try {
            return UserControl.getInstance().getUser(string);
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage());
            return -1L;
        }
    }

    public long[] getCustomRolesByUserId(long l) {
        try {
            Set<CustomRole> set = UserControl.getInstance().getSRoles(l);
            int n = set.size();
            long[] lArray = new long[n];
            CustomRole[] customRoleArray = set.toArray(new CustomRole[n]);
            for (int i = 0; i < n; ++i) {
                CustomRole customRole = customRoleArray[i];
                lArray[i] = customRole.getId();
            }
            return lArray;
        }
        catch (Exception exception) {
            return new long[0];
        }
    }

    public long[] getUsersByCompanyRoleId(long l) {
        return this.getUsersByRoleId(l, true);
    }

    public long[] getUsersByCustomRoleId(long l) {
        return this.getUsersByRoleId(l, false);
    }

    private long[] getUsersByRoleId(long l, boolean bl) {
        try {
            JSONArray jSONArray;
            Object object;
            if (bl) {
                object = CompanyRoleControl.getInstance().getJRole(l);
                jSONArray = DepartmentControl.getInstance().getUserInfoByDepartAndPost(object.getDepartmentId(), object.getPostId());
            } else {
                jSONArray = CustomRoleControl.getInstance().getUsersInfo(l);
            }
            object = new long[jSONArray.length()];
            for (int i = 0; i < jSONArray.length(); ++i) {
                object[i] = (CompanyRole)jSONArray.getJSONObject(i).optLong("userid");
            }
            return object;
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage());
            return new long[0];
        }
    }

    public JSONObject getUserInfoById(long l) {
        try {
            return UserControl.getInstance().getUser(l).createEditInfoJSONConfig();
        }
        catch (Exception exception) {
            return new JSONObject();
        }
    }

    public JSONObject getCompanyRoleInfoById(long l) {
        try {
            CompanyRole companyRole = CompanyRoleControl.getInstance().getJRole(l);
            JSONObject jSONObject = companyRole.createJSONConfig();
            jSONObject.put("departmentname", (Object)DepartmentControl.getInstance().getDepartmentShowName(companyRole.getDepartmentId(), ","));
            jSONObject.put("postname", (Object)PostControl.getInstance().getPostName(companyRole.getPostId()));
            return jSONObject;
        }
        catch (Exception exception) {
            return new JSONObject();
        }
    }

    public JSONObject getCustomRoleInfoById(long l) {
        try {
            return CustomRoleControl.getInstance().getCustomRole(l).createJSONConfig();
        }
        catch (Exception exception) {
            return new JSONObject();
        }
    }

    public JSONArray getAllRoles() {
        try {
            JSONArray jSONArray = UserControl.getInstance().getAllDepAndCRoleInfo(-999L);
            int n = jSONArray.length();
            for (int i = 0; i < n; ++i) {
                JSONObject jSONObject = jSONArray.getJSONObject(i);
                if (jSONObject.opt("departmentid") == null) {
                    jSONObject.put("value", (Object)("2_" + jSONObject.get("id")));
                    continue;
                }
                jSONObject.put("value", (Object)("1_" + jSONObject.get("id")));
                jSONObject.put("text", (Object)(jSONObject.optString("departmentname") + jSONObject.getString("postname")));
            }
            return jSONArray;
        }
        catch (Exception exception) {
            return new JSONArray();
        }
    }

    public JSONArray getAllUsers(boolean bl) {
        try {
            List list = UserControl.getInstance().findAllUser();
            JSONArray jSONArray = new JSONArray();
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                User user = (User)((Object)list.get(i));
                if (bl && StringUtils.isBlank((String)user.getEmail())) continue;
                JSONObject jSONObject = user.createUnEditInfoJSONConfig();
                jSONObject.put("value", (Object)jSONObject.optString("username"));
                jSONObject.put("text", (Object)(jSONObject.optString("realname") + "(" + jSONObject.optString("username") + ")"));
                jSONArray.put((Object)jSONObject);
            }
            return jSONArray;
        }
        catch (Exception exception) {
            return new JSONArray();
        }
    }

    public JSONArray getAllDepart() {
        try {
            JSONArray jSONArray = DepartmentControl.getInstance().getAllDepartmentInfo(false);
            int n = jSONArray.length();
            for (int i = 0; i < n; ++i) {
                JSONObject jSONObject = jSONArray.getJSONObject(i);
                jSONObject.put("value", jSONObject.get("id"));
            }
            return jSONArray;
        }
        catch (Exception exception) {
            return new JSONArray();
        }
    }

    public JSONArray getAllMailUsers() {
        return this.getAllMailUsers(false);
    }

    public JSONArray getAllMailUsers(Boolean bl) {
        try {
            return UserControl.getInstance().getAllMailUser(bl);
        }
        catch (Exception exception) {
            return new JSONArray();
        }
    }

    public boolean hasProcessTask(long l) {
        EntryTreeFolderNode entryTreeFolderNode = EntryControl.getInstance().getFolderNode(-1L);
        try {
            JSONArray jSONArray = entryTreeFolderNode.createAllEntryJSONArray(l, true);
            return this.hasProcessTask(jSONArray);
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean hasProcessTask(JSONArray jSONArray) throws Exception {
        int n = jSONArray.length();
        for (int i = 0; i < n; ++i) {
            JSONObject jSONObject = jSONArray.getJSONObject(i);
            if (!(jSONObject.optBoolean("hasChildren") ? this.hasProcessTask(jSONObject.getJSONArray("ChildNodes")) : ComparatorUtils.equals((Object)jSONObject.optString("type"), (Object)"8") && ComparatorUtils.equals((Object)jSONObject.optString("processType"), (Object)1))) continue;
            return true;
        }
        return false;
    }

    public boolean isReportEntryRequest(HttpServletRequest httpServletRequest) {
        return ComparatorUtils.equals((Object)WebUtils.getHTTPRequestParameter((HttpServletRequest)httpServletRequest, (String)"op"), (Object)"fs_main") && ComparatorUtils.equals((Object)WebUtils.getHTTPRequestParameter((HttpServletRequest)httpServletRequest, (String)"cmd"), (Object)"entry_report");
    }

    public boolean hasFilePrivilege(String string, String string2) throws Exception {
        long l = UserControl.getInstance().getUser(string);
        Set set = UserControl.getInstance().getAllTemplatePrivileges(l);
        return l == UserControl.getInstance().getSuperManagerID() || FSPrivilegeTools.getInstance().hasDesignPrivilege(string2, set);
    }

    public JSONArray getDataSourcePrivilege(String string) throws Exception {
        PrivilegeManager privilegeManager = PrivilegeManager.getInstance();
        JSONArray jSONArray = new JSONArray();
        if (FSConfig.getInstance().getAuthorizeAttr().isDataConnectionAuthority() && !ComparatorUtils.equals((Object)privilegeManager.getRootManagerName(), (Object)string)) {
            long l = UserControl.getInstance().getUser(string);
            Set<String> set = UserControl.getInstance().getAllDataConnectionPrivilegeNames(l);
            DatasourceManager datasourceManager = DatasourceManager.getInstance();
            Iterator iterator = datasourceManager.getConnectionNameIterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                if (set.contains(string2)) continue;
                JSONObject jSONObject = new JSONObject();
                jSONObject.put("name", (Object)string2);
                jSONArray.put((Object)jSONObject);
            }
        }
        return jSONArray;
    }

    public FileNode[] getDesignFilterFile(String string, FileNode[] fileNodeArray, ArrayList arrayList) throws Exception {
        FileNode[] fileNodeArray2;
        long l = UserControl.getInstance().getUser(string);
        if (l != UserControl.getInstance().getSuperManagerID()) {
            Set set = UserControl.getInstance().getAllTemplatePrivileges(l);
            FSPrivilegeTools.getInstance().filterFile(fileNodeArray, set, arrayList, 3);
            fileNodeArray2 = new FileNode[arrayList.size()];
            for (int i = 0; i < arrayList.size(); ++i) {
                fileNodeArray2[i] = (FileNode)arrayList.get(i);
            }
        } else {
            fileNodeArray2 = fileNodeArray;
        }
        return fileNodeArray2;
    }

    public AuthenticateResult doAuthenticate(CommonAuthentication commonAuthentication) throws Exception {
        PrivilegeFilter privilegeFilter = PrivilegeManager.getInstance().getPrivilegeFilter();
        int n = privilegeFilter == null ? -1 : privilegeFilter.getID();
        if (!commonAuthentication.isRoot() && n != 1) {
            return new FailResult("No User & Password Exist!");
        }
        UserNamePassWordFSAuthenticationProvider userNamePassWordFSAuthenticationProvider = UserNamePassWordFSAuthenticationProvider.getInstance();
        return AbstractFSAuthService.doAuthenticate(commonAuthentication, userNamePassWordFSAuthenticationProvider, true);
    }
}

