/*
 * Decompiled with CFR 0.152.
 */
package com.esri.ges.util;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;

class ThreadSafeDateFormatter {
    private static final ThreadLocal<Map<String, DateFormat>> DATE_PARSERS = new ThreadLocal<Map<String, DateFormat>>(){

        @Override
        protected Map<String, DateFormat> initialValue() {
            return new HashMap<String, DateFormat>();
        }
    };

    ThreadSafeDateFormatter() {
    }

    private static final DateFormat getParser(String pattern) {
        Map<String, DateFormat> parserMap = DATE_PARSERS.get();
        if (pattern == null) {
            return DateFormat.getDateInstance();
        }
        DateFormat df = parserMap.get(pattern);
        if (df == null) {
            df = new SimpleDateFormat(pattern);
            if ("yyyy-MM-dd'T'HH:mm:ss".equals(pattern)) {
                df.setTimeZone(TimeZone.getTimeZone("UTC"));
            }
            parserMap.put(pattern, df);
        }
        return df;
    }

    public static Date parse(String date, String pattern) throws ParseException {
        return ThreadSafeDateFormatter.getParser(pattern).parse(date);
    }

    public static long parseLongDate(String date, String pattern) throws ParseException {
        return ThreadSafeDateFormatter.parse(date, pattern).getTime();
    }

    public static String format(Date date, String pattern) {
        return ThreadSafeDateFormatter.getParser(pattern).format(date);
    }

    public static String format(long date, String pattern) {
        return ThreadSafeDateFormatter.getParser(pattern).format(new Date(date));
    }
}

