/*
 * Decompiled with CFR 0.152.
 */
package com.esri.ges.util;

import com.esri.arcgis.discovery.admin.SiteManager;
import com.esri.arcgis.discovery.admin.machine.ServerMachine;
import com.esri.arcgis.discovery.admin.machine.ServerMachineConfigurator;
import com.esri.arcgis.discovery.admin.store.ConfigStore;
import com.esri.ges.framework.i18n.BundleResourceUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SiteConfigUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(SiteConfigUtil.class);
    private static boolean initComplete = false;

    public static boolean isSiteConfigure(SiteManager siteManager) {
        try {
            return siteManager.isSiteConfigured();
        }
        catch (Throwable t) {
            LOGGER.error(t.getMessage(), t);
            return false;
        }
    }

    public static boolean isSiteConfigured() {
        try {
            return SiteConfigUtil.isSiteConfigure(SiteManager.getInstance());
        }
        catch (Throwable t) {
            LOGGER.error(t.getMessage(), t);
            return false;
        }
    }

    public static boolean isClusterMember() {
        try {
            return SiteConfigUtil.isClusterMember(SiteManager.getInstance());
        }
        catch (Throwable t) {
            LOGGER.error(t.getMessage(), t);
            return false;
        }
    }

    public static boolean isClusterMember(SiteManager site) {
        try {
            ConfigStore configStore = site.getConfigStore();
            ServerMachine thisMachine = configStore.getServerMachine(ServerMachineConfigurator.getServerMachineConfig().getMachineName());
            return null != site.getClusterManager().getClusterForMachine(thisMachine.getMachineName());
        }
        catch (Throwable t) {
            LOGGER.error(t.getMessage(), t);
            return false;
        }
    }

    public static boolean isSiteReadOnly(SiteManager site) {
        try {
            return initComplete && site.isSiteReadOnly();
        }
        catch (Throwable t) {
            LOGGER.error(t.getMessage(), t);
            return false;
        }
    }

    public static boolean isSiteReadOnly() {
        try {
            return SiteConfigUtil.isSiteReadOnly(SiteManager.getInstance());
        }
        catch (Throwable t) {
            LOGGER.error(t.getMessage(), t);
            return false;
        }
    }

    public static String getReadOnlyErrorMessage() {
        return BundleResourceUtil.translate("${com.esri.ges.persistence.zookeeper.zk-utils.SITE_MODE_READONLY}");
    }

    public static void checkSiteMode() {
        if (SiteConfigUtil.isSiteReadOnly()) {
            throw new RuntimeException(SiteConfigUtil.getReadOnlyErrorMessage());
        }
    }

    public static void setInitComplete(boolean initComplete) {
        SiteConfigUtil.initComplete = initComplete;
    }
}

