/*
 * Decompiled with CFR 0.152.
 */
package com.esri.ges.util;

import java.util.LinkedHashMap;
import java.util.Map;

public class LRUCache<LV>
extends LinkedHashMap<String, LV> {
    private static final long serialVersionUID = 1L;
    private Remover<Map.Entry<String, LV>> remover = null;
    final int maxEntries;

    public LRUCache(int maxEntries) {
        super(maxEntries + 1, 1.0f, true);
        this.maxEntries = maxEntries;
    }

    public void setRemover(Remover<Map.Entry<String, LV>> remover) {
        this.remover = remover;
    }

    @Override
    public LV put(String key, LV value) {
        if (super.containsKey(key)) {
            super.remove(key);
        }
        return super.put(key, value);
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry<String, LV> eldest) {
        boolean retVal;
        boolean bl = retVal = super.size() > this.maxEntries;
        if (retVal && this.remover != null) {
            this.remover.remove(eldest);
        }
        return retVal;
    }

    public static interface Remover<E> {
        public void remove(E var1);
    }
}

