/*
 * Decompiled with CFR 0.152.
 */
package com.esri.ges.util;

import com.esri.ges.framework.i18n.BundleLogger;
import com.esri.ges.framework.i18n.BundleLoggerFactory;
import com.esri.ges.util.DateFormatID;
import com.esri.ges.util.ThreadSafeDateFormatter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public abstract class DateUtil {
    private static final BundleLogger LOGGER = BundleLoggerFactory.getLogger(DateUtil.class);

    public static String format(Date d) {
        return ThreadSafeDateFormatter.format(d, "yyyy-MM-dd'T'HH:mm:ss");
    }

    public static String format(Date d, String format) {
        return ThreadSafeDateFormatter.format(d, format);
    }

    public static Date convert(String s) {
        try {
            return DateUtil.checkedConvert(s);
        }
        catch (ParseException e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("DATE_UTILS_PARSE_ERROR", e, s);
            }
            return null;
        }
    }

    public static Date convert(String s, DateFormatID id) {
        try {
            return DateUtil.checkedConvert(s, id);
        }
        catch (ParseException e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("DATE_UTILS_PARSE_ERROR", e, s);
            }
            return null;
        }
    }

    public static Date convert(String s, String format) {
        if (format == null || format.isEmpty()) {
            return DateUtil.convert(s);
        }
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(format);
            sdf.setLenient(false);
            return sdf.parse(s);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static Date convert(String s, String format, DateFormatID id) {
        if (format != null && !format.isEmpty()) {
            return DateUtil.convert(s, format);
        }
        return DateUtil.convert(s, id);
    }

    public static Date checkedConvert(String s, DateFormatID id) throws ParseException {
        int count = 0;
        int go = id.value();
        block23: while (count < 7) {
            switch (go) {
                case 0: {
                    try {
                        id.set(go);
                        return new Date(ISODateTimeFormat.dateTimeParser().withZoneUTC().parseMillis(s));
                    }
                    catch (IllegalArgumentException e) {
                        ++count;
                        go = 1;
                        continue block23;
                    }
                }
                case 1: {
                    try {
                        id.set(go);
                        return ThreadSafeDateFormatter.parse(s, null);
                    }
                    catch (Exception e) {
                        ++count;
                        go = 2;
                        continue block23;
                    }
                }
                case 2: {
                    try {
                        id.set(go);
                        return ThreadSafeDateFormatter.parse(s, "EEE MMM dd HH:mm:ss zzz yyyy");
                    }
                    catch (Exception e) {
                        ++count;
                        go = 3;
                        continue block23;
                    }
                }
                case 3: {
                    try {
                        id.set(go);
                        return new Date(DateTimeFormat.forPattern((String)"MM/dd/yy hh:mm:ss aa").parseMillis(s));
                    }
                    catch (IllegalArgumentException e) {
                        ++count;
                        go = 4;
                        continue block23;
                    }
                }
                case 4: {
                    try {
                        id.set(go);
                        return new Date(DateTimeFormat.forPattern((String)"MM/dd/yy HH:mm:ss").parseMillis(s));
                    }
                    catch (IllegalArgumentException e) {
                        ++count;
                        go = 5;
                        continue block23;
                    }
                }
                case 5: {
                    try {
                        id.set(go);
                        return new Date(DateTimeFormat.forPattern((String)"MM/dd/yy HH:mm").parseMillis(s));
                    }
                    catch (IllegalArgumentException e) {
                        ++count;
                        go = 6;
                        continue block23;
                    }
                }
                case 6: {
                    try {
                        id.set(go);
                        return new Date(Long.parseLong(s));
                    }
                    catch (Exception e) {
                        ++count;
                        go = 0;
                        continue block23;
                    }
                }
            }
            go = 0;
        }
        throw new ParseException(LOGGER.translate("DATE_UTILS_PARSE_ERROR", s), 0);
    }

    public static Date checkedConvert(String s) throws ParseException {
        try {
            DateTimeFormatter formatter2 = ISODateTimeFormat.dateTimeParser().withZoneUTC();
            long millis = formatter2.parseMillis(s);
            return new Date(millis);
        }
        catch (IllegalArgumentException formatter2) {
            try {
                return ThreadSafeDateFormatter.parse(s, null);
            }
            catch (ParseException formatter2) {
            }
            catch (NumberFormatException formatter2) {
                // empty catch block
            }
            try {
                return ThreadSafeDateFormatter.parse(s, "EEE MMM dd HH:mm:ss zzz yyyy");
            }
            catch (ParseException formatter2) {
            }
            catch (NumberFormatException formatter2) {
                // empty catch block
            }
            try {
                DateTimeFormatter formatter3 = DateTimeFormat.forPattern((String)"MM/dd/yy hh:mm:ss aa");
                long millis = formatter3.parseMillis(s);
                return new Date(millis);
            }
            catch (IllegalArgumentException formatter3) {
                try {
                    DateTimeFormatter formatter4 = DateTimeFormat.forPattern((String)"MM/dd/yy HH:mm:ss");
                    long millis = formatter4.parseMillis(s);
                    return new Date(millis);
                }
                catch (IllegalArgumentException formatter4) {
                    try {
                        DateTimeFormatter formatter5 = DateTimeFormat.forPattern((String)"MM/dd/yy HH:mm");
                        long millis = formatter5.parseMillis(s);
                        return new Date(millis);
                    }
                    catch (IllegalArgumentException formatter5) {
                        try {
                            long millis = Long.parseLong(s);
                            return new Date(millis);
                        }
                        catch (Exception exception) {
                            throw new ParseException(LOGGER.translate("DATE_UTILS_PARSE_ERROR", s), 0);
                        }
                    }
                }
            }
        }
    }

    public static boolean beforeOrEqual(Date d1, Date d2) {
        return d1 == null || d2 == null ? false : d1.before(d2) || d1.equals(d2);
    }

    public static Date addMins(Date d, long minutes) {
        return new Date(d.getTime() + minutes * 60L * 1000L);
    }

    public static Date getEarliestTime(List<Date> dates) {
        Date earliest = null;
        for (Date d : dates) {
            if (earliest == null) {
                earliest = d;
                continue;
            }
            if (!earliest.after(d)) continue;
            earliest = d;
        }
        return earliest;
    }

    public static Date getNowDateAtHour(int hour) {
        Calendar c = Calendar.getInstance();
        c.set(11, 8);
        c.set(12, 0);
        c.set(13, 0);
        return c.getTime();
    }

    public static long minutesBetween(Date d1, Date d2) {
        return DateUtil.secondsBetween(d1, d2) / 60L;
    }

    public static long secondsBetween(Date d1, Date d2) {
        return DateUtil.millisecondsBetween(d1, d2) / 1000L;
    }

    public static long millisecondsBetween(Date d1, Date d2) {
        return d1 != null && d2 != null && d1.getTime() - d2.getTime() != 0L ? Math.abs(d1.getTime() - d2.getTime()) : 0L;
    }

    public static void main(String[] args) {
        try {
            String string = "07/02/2012 08:00:00 AM";
            SimpleDateFormat localFormatter = new SimpleDateFormat("MM/dd/yyyy hh:mm:ss aa");
            Date date = localFormatter.parse(string);
            long longVal = date.getTime();
            System.out.println("Default formatter tz is " + localFormatter.getTimeZone().getDisplayName());
            System.out.println("Original string = " + string);
            System.out.println("Parsed date = " + date);
            System.out.println("It's long value is " + longVal);
            System.out.println();
            Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
            cal.setTimeInMillis(longVal);
            System.out.println("Now I'm processing the long value, interpreting it as UTC timestamp.");
            System.out.println("cal.getTime() <Date> is " + cal.getTime());
            System.out.println();
            string = "2012-07-02T08:00:00";
            SimpleDateFormat isoFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
            isoFormatter.setTimeZone(TimeZone.getTimeZone("UTC"));
            date = isoFormatter.parse(string);
            longVal = date.getTime();
            System.out.println("ISO formatter tz is " + isoFormatter.getTimeZone().getDisplayName());
            System.out.println("The iso string is " + string);
            System.out.println("Parsed iso date = " + date);
            System.out.println("It's long value is " + longVal);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

