/*
 * Decompiled with CFR 0.152.
 */
package com.esri.ges.manager.datastore.agsconnection;

import com.esri.arcgis.bds.Defaults;
import com.esri.core.geometry.SpatialReference;
import com.esri.ges.core.geoevent.GeoEventDefinition;
import com.esri.ges.manager.datastore.agsconnection.BDSObjectIdStrategy;
import com.esri.ges.util.GeometryUtil;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class PublishFeatureServiceRequest {
    private String clusterName;
    private String path;
    private String serviceName;
    private String layerName = "layer";
    private GeoEventDefinition def;
    private SpatialReference sr = GeometryUtil.WGS84_SR;
    private String geometryType;
    private int maxRecordCount = 10000;
    private BDSObjectIdStrategy objectIdStrategy = BDSObjectIdStrategy.getObjectIdStrategy(Defaults.DEFAULT_OBJECTID_STRATEGY.toString());
    private String displayFieldName;
    private String objectIdFieldName = "objectid";
    private String globalIdFieldName = "globalid";
    private String definitionExpression;
    private String layerDrawingInfo;
    private String timeInterval;
    private String timeIntervalUnits;
    private String hasLiveData;
    private boolean hasZ;
    private boolean enableZDefaults;
    private double zDefault;
    private boolean preferBDS;
    private boolean sdsProvider;
    private String featureServiceUrl;
    private String datastoreUrl;
    private String dataSourceName;
    private String dataSourceLayerName;

    public PublishFeatureServiceRequest(String clusterName, String path, String serviceName, String layerName, GeoEventDefinition def, String srid, String geometryType, int maxRecordCount, String objectIdStrategyStr, String displayFieldName, String objectIdFieldName, String globalIdFieldName, String definitionExpression, String layerDrawingInfo, String timeInterval, String timeIntervalUnits, String hasLiveData, boolean hasZ, boolean enableZDefaults, double zDefault, boolean preferBDS, boolean sdsProvider) {
        this.clusterName = clusterName;
        this.path = path;
        this.serviceName = serviceName;
        this.layerName = layerName;
        this.def = def;
        this.sr = GeometryUtil.lookupSpatialReference(srid);
        this.geometryType = geometryType;
        this.maxRecordCount = maxRecordCount;
        this.objectIdStrategy = BDSObjectIdStrategy.getObjectIdStrategy(objectIdStrategyStr);
        this.displayFieldName = displayFieldName;
        this.objectIdFieldName = objectIdFieldName;
        this.globalIdFieldName = globalIdFieldName;
        this.definitionExpression = definitionExpression;
        this.timeInterval = timeInterval;
        this.timeIntervalUnits = timeIntervalUnits;
        this.hasLiveData = hasLiveData;
        this.hasZ = hasZ;
        this.enableZDefaults = enableZDefaults;
        this.zDefault = zDefault;
        this.preferBDS = preferBDS;
        this.sdsProvider = sdsProvider;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public SpatialReference getSR() {
        return this.sr;
    }

    public void setSR(SpatialReference sr) {
        this.sr = sr;
    }

    public void setSR(String srid) {
        this.sr = GeometryUtil.lookupSpatialReference(srid);
    }

    public String getGeometryType() {
        return this.geometryType;
    }

    public void setGeometryType(String geometryType) {
        this.geometryType = geometryType;
    }

    public BDSObjectIdStrategy getObjectIdStrategy() {
        return this.objectIdStrategy;
    }

    public void setObjectIdStrategy(BDSObjectIdStrategy objectIdStrategy) {
        this.objectIdStrategy = objectIdStrategy;
    }

    public void setObjectIdStrategy(String objectIdStrategyStr) {
        this.objectIdStrategy = BDSObjectIdStrategy.getObjectIdStrategy(objectIdStrategyStr);
    }

    public String getDisplayFieldName() {
        return this.displayFieldName;
    }

    public void setDisplayFieldName(String displayFieldName) {
        this.displayFieldName = displayFieldName;
    }

    public String getLayerDrawingInfo() {
        return this.layerDrawingInfo;
    }

    public void setLayerDrawingInfo(String layerDrawingInfo) {
        this.layerDrawingInfo = layerDrawingInfo;
    }

    public GeoEventDefinition getDef() {
        return this.def;
    }

    public void setDef(GeoEventDefinition def) {
        this.def = def;
    }

    public String getLayerName() {
        return this.layerName;
    }

    public void setLayerName(String layerName) {
        this.layerName = layerName;
    }

    public boolean isPreferBDS() {
        return this.preferBDS;
    }

    public void setPreferBDS(boolean preferBDS) {
        this.preferBDS = preferBDS;
    }

    public boolean isSdsProvider() {
        return this.sdsProvider;
    }

    public void setSdsProvider(boolean sdsProvider) {
        this.sdsProvider = sdsProvider;
    }

    public String getFeatureServiceUrl() {
        return this.featureServiceUrl;
    }

    public void setFeatureServiceUrl(String featureServiceUrl) {
        this.featureServiceUrl = featureServiceUrl;
    }

    public String getDatastoreUrl() {
        return this.datastoreUrl;
    }

    public void setDatastoreUrl(String datastoreUrl) {
        this.datastoreUrl = datastoreUrl;
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public void setDataSourceName(String dataSourceName) {
        this.dataSourceName = dataSourceName;
    }

    public String getDataSourceLayerName() {
        return this.dataSourceLayerName;
    }

    public void setDataSourceLayerName(String dataSourceLayerName) {
        this.dataSourceLayerName = dataSourceLayerName;
    }

    public String getObjectIdFieldName() {
        return this.objectIdFieldName;
    }

    public void setObjectIdFieldName(String objectIdFieldName) {
        this.objectIdFieldName = objectIdFieldName;
    }

    public String getGlobalIdFieldName() {
        return this.globalIdFieldName;
    }

    public void setGlobalIdFieldName(String globalIdFieldName) {
        this.globalIdFieldName = globalIdFieldName;
    }

    public String getTimeInterval() {
        return this.timeInterval;
    }

    public void setTimeInterval(String timeInterval) {
        this.timeInterval = timeInterval;
    }

    public String getTimeIntervalUnits() {
        return this.timeIntervalUnits;
    }

    public void setTimeIntervalUnits(String timeIntervalUnits) {
        this.timeIntervalUnits = timeIntervalUnits;
    }

    public String getHasLiveData() {
        return this.hasLiveData;
    }

    public void setHasLiveData(String hasLiveData) {
        this.hasLiveData = hasLiveData;
    }

    public boolean getHasZ() {
        return this.hasZ;
    }

    public void setHasZ(boolean hasZ) {
        this.hasZ = hasZ;
    }

    public boolean getEnableZDefaults() {
        return this.enableZDefaults;
    }

    public void setEnableZDefaults(boolean enableZDefaults) {
        this.enableZDefaults = enableZDefaults;
    }

    public double getZDefault() {
        return this.zDefault;
    }

    public void setZDefault(double zDefault) {
        this.zDefault = zDefault;
    }

    public int getMaxRecordCount() {
        return this.maxRecordCount;
    }

    public void setMaxRecordCount(int maxRecordCount) {
        this.maxRecordCount = maxRecordCount;
    }

    public String getDefinitionExpression() {
        return this.definitionExpression;
    }

    public void setDefinitionExpression(String definitionExpression) {
        this.definitionExpression = definitionExpression;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

