/*
 * Decompiled with CFR 0.152.
 */
package com.esri.ges.manager.datastore.agsconnection;

import com.esri.arcgis.bds.EsriGeoHash;
import com.esri.core.geometry.SpatialReference;
import com.esri.ges.core.geoevent.FieldDefinition;
import com.esri.ges.manager.datastore.agsconnection.ArcGISServerType;
import com.esri.ges.manager.datastore.agsconnection.BDSObjectIdStrategy;
import com.esri.ges.util.GeometryUtil;
import java.util.List;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class PublishBDSServiceRequest {
    private String clusterName;
    private String path;
    private String serviceName;
    private String dataSourceName;
    private String dataSourceLayerName;
    private EsriGeoHash[] esriGeoHashes;
    private SpatialReference sr = GeometryUtil.WGS84_SR;
    private String geometryType;
    private String displayFieldName;
    private String timeInterval;
    private String timeIntervalUnits;
    private String hasLiveData;
    private boolean hasZ;
    private boolean enableZDefaults;
    private double zDefault;
    private String layerDrawingInfo;
    private List<FieldDefinition> fieldDefinitions;
    private ArcGISServerType serviceType;
    private BDSObjectIdStrategy objectIdStrategy;
    private String objectIdFieldName;
    private String globalIdFieldName;
    private int maxRecordCount;
    private String definitionExpression;
    private boolean sdsProvider;

    public PublishBDSServiceRequest() {
    }

    public PublishBDSServiceRequest(String clusterName, String path, String serviceName, String dataSourceName, String dataSourceLayerName, EsriGeoHash[] esriGeoHashes, String srid, String geometryType, String displayFieldName, String timeInterval, String timeIntervalUnits, String hasLiveData, boolean hasZ, boolean enableZDefaults, double zDefault, String layerDrawingInfo, List<FieldDefinition> fieldDefinitions, ArcGISServerType serviceType, BDSObjectIdStrategy objectIdStrategy, String objectIdFieldName, String globalIdFieldName, int maxRecordCount, String definitionExpression, boolean sdsProvider) {
        this.clusterName = clusterName;
        this.path = path;
        this.serviceName = serviceName;
        this.dataSourceName = dataSourceName;
        this.dataSourceLayerName = dataSourceLayerName;
        this.esriGeoHashes = esriGeoHashes;
        this.sr = GeometryUtil.lookupSpatialReference(srid);
        this.geometryType = geometryType;
        this.displayFieldName = displayFieldName;
        this.timeInterval = timeInterval;
        this.timeIntervalUnits = timeIntervalUnits;
        this.hasLiveData = hasLiveData;
        this.hasZ = hasZ;
        this.enableZDefaults = enableZDefaults;
        this.zDefault = zDefault;
        this.layerDrawingInfo = layerDrawingInfo;
        this.fieldDefinitions = fieldDefinitions;
        this.serviceType = serviceType;
        this.objectIdStrategy = objectIdStrategy;
        this.objectIdFieldName = objectIdFieldName;
        this.globalIdFieldName = globalIdFieldName;
        this.maxRecordCount = maxRecordCount;
        this.definitionExpression = definitionExpression;
        this.sdsProvider = sdsProvider;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public SpatialReference getSR() {
        return this.sr;
    }

    public void setSR(SpatialReference sr) {
        this.sr = sr;
    }

    public void setSR(String srid) {
        this.sr = GeometryUtil.lookupSpatialReference(srid);
    }

    public String getGeometryType() {
        return this.geometryType;
    }

    public void setGeometryType(String geometryType) {
        this.geometryType = geometryType;
    }

    public String getDisplayFieldName() {
        return this.displayFieldName;
    }

    public void setDisplayFieldName(String displayFieldName) {
        this.displayFieldName = displayFieldName;
    }

    public String getTimeInterval() {
        return this.timeInterval;
    }

    public void setTimeInterval(String timeInterval) {
        this.timeInterval = timeInterval;
    }

    public String getTimeIntervalUnits() {
        return this.timeIntervalUnits;
    }

    public void setTimeIntervalUnits(String timeIntervalUnits) {
        this.timeIntervalUnits = timeIntervalUnits;
    }

    public String getHasLiveData() {
        return this.hasLiveData;
    }

    public void setHasLiveData(String hasLiveData) {
        this.hasLiveData = hasLiveData;
    }

    public boolean getHasZ() {
        return this.hasZ;
    }

    public void setHasZ(boolean hasZ) {
        this.hasZ = hasZ;
    }

    public boolean getEnableZDefaults() {
        return this.enableZDefaults;
    }

    public void setEnableZDefaults(boolean enableZDefaults) {
        this.enableZDefaults = enableZDefaults;
    }

    public double getZDefault() {
        return this.zDefault;
    }

    public void setZDefault(double zDefault) {
        this.zDefault = zDefault;
    }

    public String getLayerDrawingInfo() {
        return this.layerDrawingInfo;
    }

    public void setLayerDrawingInfo(String layerDrawingInfo) {
        this.layerDrawingInfo = layerDrawingInfo;
    }

    public ArcGISServerType getServiceType() {
        return this.serviceType;
    }

    public void setServiceType(ArcGISServerType serviceType) {
        this.serviceType = serviceType;
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public void setDataSourceName(String dataSourceName) {
        this.dataSourceName = dataSourceName;
    }

    public String getDataSourceLayerName() {
        return this.dataSourceLayerName;
    }

    public void setDataSourceLayerName(String dataSourceLayerName) {
        this.dataSourceLayerName = dataSourceLayerName;
    }

    public EsriGeoHash[] getEsriGeoHashes() {
        return this.esriGeoHashes;
    }

    public void setEsriGeoHashes(EsriGeoHash[] esriGeoHashes) {
        this.esriGeoHashes = esriGeoHashes;
    }

    public List<FieldDefinition> getFieldDefinitions() {
        return this.fieldDefinitions;
    }

    public void setFieldDefinitions(List<FieldDefinition> fieldDefinitions) {
        this.fieldDefinitions = fieldDefinitions;
    }

    public BDSObjectIdStrategy getObjectIdStrategy() {
        return this.objectIdStrategy;
    }

    public void setObjectIdStrategy(BDSObjectIdStrategy objectIdStrategy) {
        this.objectIdStrategy = objectIdStrategy;
    }

    public String getObjectIdFieldName() {
        return this.objectIdFieldName;
    }

    public void setObjectIdFieldName(String objectIdFieldName) {
        this.objectIdFieldName = objectIdFieldName;
    }

    public String getGlobalIdFieldName() {
        return this.globalIdFieldName;
    }

    public void setGlobalIdFieldName(String globalIdFieldName) {
        this.globalIdFieldName = globalIdFieldName;
    }

    public int getMaxRecordCount() {
        return this.maxRecordCount;
    }

    public void setMaxRecordCount(int maxRecordCount) {
        this.maxRecordCount = maxRecordCount;
    }

    public String getDefinitionExpression() {
        return this.definitionExpression;
    }

    public void setDefinitionExpression(String definitionExpression) {
        this.definitionExpression = definitionExpression;
    }

    public boolean isSdsProvider() {
        return this.sdsProvider;
    }

    public void setSdsProvider(boolean sdsProvider) {
        this.sdsProvider = sdsProvider;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

