/*
 * Decompiled with CFR 0.152.
 */
package com.esri.ges.manager.datastore.agsconnection;

import com.esri.ges.core.AccessType;
import com.esri.ges.core.property.Property;
import com.esri.ges.framework.i18n.BundleLogger;
import com.esri.ges.framework.i18n.BundleLoggerFactory;
import com.esri.ges.jaxb.property.PropertyWrapper;
import com.esri.ges.manager.datastore.agsconnection.ArcGISServerConnection;
import com.esri.ges.util.GESNetUtil;
import com.esri.ges.util.Validator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.Collection;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang3.builder.EqualsBuilder;

@ApiModel(value="${com.esri.ges.rest.cxf-swagger.DS_AGSC_MODEL_LBL}", description="${com.esri.ges.rest.cxf-swagger.DS_AGSC_MODEL_DESC}")
@JsonIgnoreProperties(ignoreUnknown=true)
@XmlRootElement(name="arcgisServerConnectionDataStore")
public class ArcGISServerConnectionWrapper {
    private static final BundleLogger LOGGER = BundleLoggerFactory.getLogger(ArcGISServerConnectionWrapper.class);
    private static final String PROPS_PROP_NAME = "properties";
    @ApiModelProperty(value="${com.esri.ges.rest.cxf-swagger.DS_AGSC_MODEL_URL_NORMALIZED_LBL}", required=false, example="${com.esri.ges.rest.cxf-swagger.DS_AGSC_MODEL_URL_NORMALIZED_SAMPLE}")
    private boolean urlNormalized = false;
    @ApiModelProperty(value="${com.esri.ges.rest.cxf-swagger.DS_AGSC_MODEL_NAME_LBL}", required=true, example="${com.esri.ges.rest.cxf-swagger.DS_AGSC_MODEL_NAME_SAMPLE}")
    private String name;
    @ApiModelProperty(value="${com.esri.ges.rest.cxf-swagger.DS_AGSC_MODEL_LABEL_LBL}", required=true, example="${com.esri.ges.rest.cxf-swagger.DS_AGSC_MODEL_LABEL_SAMPLE}")
    private String label;
    @ApiModelProperty(value="${com.esri.ges.rest.cxf-swagger.DS_AGSC_MODEL_URL_LBL}", required=true, example="${com.esri.ges.rest.cxf-swagger.DS_AGSC_MODEL_URL_SAMPLE}")
    private String url;
    @ApiModelProperty(value="${com.esri.ges.rest.cxf-swagger.DS_AGSC_MODEL_TOKEN_LBL}", required=false, example="${com.esri.ges.rest.cxf-swagger.DS_AGSC_MODEL_TOKEN_SAMPLE}")
    private String token;
    @ApiModelProperty(value="${com.esri.ges.rest.cxf-swagger.DS_AGSC_MODEL_USERNAME_LBL}", required=false, example="${com.esri.ges.rest.cxf-swagger.DS_AGSC_MODEL_USERNAME_SAMPLE}")
    private String username;
    @ApiModelProperty(value="${com.esri.ges.rest.cxf-swagger.DS_AGSC_MODEL_PASSWORD_LBL}", required=false, example="${com.esri.ges.rest.cxf-swagger.DS_AGSC_MODEL_PASSWORD_SAMPLE}")
    private String password;
    @ApiModelProperty(value="${com.esri.ges.rest.cxf-swagger.DS_AGSC_MODEL_REFERER_LBL}", required=false, example="${com.esri.ges.rest.cxf-swagger.DS_AGSC_MODEL_REFERER_SAMPLE}")
    private String referer;
    @ApiModelProperty(value="${com.esri.ges.rest.cxf-swagger.DS_AGSC_MODEL_TOKEN_CONFIGURED_LBL}", required=false, example="${com.esri.ges.rest.cxf-swagger.DS_AGSC_MODEL_TOKEN_CONFIGURED_SAMPLE}")
    private boolean tokenConfigured = false;
    @ApiModelProperty(value="${com.esri.ges.rest.cxf-swagger.DS_AGSC_MODEL_UPDATE_INTERVAL_LBL}", required=true, example="${com.esri.ges.rest.cxf-swagger.DS_AGSC_MODEL_UPDATE_INTERVAL_SAMPLE}")
    private int updateIntervalSec = 300;
    @ApiModelProperty(value="${com.esri.ges.rest.cxf-swagger.DS_AGSC_MODEL_TYPE_LBL}", required=true, example="${com.esri.ges.rest.cxf-swagger.DS_AGSC_MODEL_TYPE_SAMPLE}", allowableValues="PORTAL,SERVER,AGOL")
    private String connectionType;
    @ApiModelProperty(value="${com.esri.ges.rest.cxf-swagger.DS_AGSC_MODEL_PROPERTIES_LBL}", required=false)
    private Collection<PropertyWrapper> properties;
    @ApiModelProperty(value="${com.esri.ges.rest.cxf-swagger.DS_AGSC_MODEL_ACCESS_TYPE_LBL}", required=true, example="${com.esri.ges.rest.cxf-swagger.DS_AGSC_MODEL_ACCESS_TYPE_SAMPLE}", allowableValues="editable,nonDeletable,readOnly")
    private AccessType accessType = AccessType.editable;

    public ArcGISServerConnectionWrapper() {
    }

    public ArcGISServerConnectionWrapper(ArcGISServerConnection seed) {
        this(seed, false);
    }

    public ArcGISServerConnectionWrapper(ArcGISServerConnection seed, boolean includeToken) {
        this.setName(seed.getName());
        this.setLabel(seed.getLabel());
        this.setUrl(seed.getUrl().toString());
        this.setAccessType(seed.getAccessType().toString());
        if (includeToken) {
            this.setToken(seed.getToken());
        }
        this.setConnectionType(seed.getConnectionType().toString());
        this.setUpdateIntervalSec(seed.getUpdateIntervalSec());
        Collection<Property> props = seed.getImplementationProperties();
        if (props != null) {
            ArrayList<PropertyWrapper> propsCollection = new ArrayList<PropertyWrapper>();
            for (Property property : props) {
                PropertyWrapper wrapper = new PropertyWrapper(property.getName(), property.getValueAsString(), property.getType(), !includeToken);
                propsCollection.add(wrapper);
            }
            this.setProperties(propsCollection);
        }
        this.setReferer(seed.getReferer());
        this.tokenConfigured = seed.isUserConfiguredToken();
        this.normalize();
    }

    @XmlAttribute
    public boolean isTokenConfigured() {
        return this.tokenConfigured;
    }

    public void setTokenConfigured(boolean tokenConfigured) {
        this.tokenConfigured = tokenConfigured;
    }

    @XmlElementWrapper(name="properties")
    @XmlElement(name="property")
    @JsonProperty(value="properties")
    public Collection<PropertyWrapper> getProperties() {
        return this.properties;
    }

    public void setProperties(Collection<PropertyWrapper> properties) {
        this.properties = properties;
    }

    @XmlAttribute
    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token == null ? null : token.trim();
    }

    @XmlAttribute
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.normalizeLabel();
    }

    @XmlAttribute(required=false)
    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    @XmlAttribute
    public String getUrl() {
        this.normalizeUrl();
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
        this.normalizeUrl();
    }

    @XmlAttribute
    public String getConnectionType() {
        return this.connectionType;
    }

    public void setConnectionType(String connectionType) {
        this.connectionType = connectionType;
    }

    @XmlAttribute
    public int getUpdateIntervalSec() {
        return this.updateIntervalSec;
    }

    public void setUpdateIntervalSec(int updateIntervalSec) {
        this.updateIntervalSec = updateIntervalSec;
    }

    @XmlAttribute
    public String getAccessType() {
        return this.accessType.toString();
    }

    public void setAccessType(String accessTypeStr) {
        AccessType accessType = AccessType.getAccessType(accessTypeStr);
        if (accessType == AccessType.unknown) {
            LOGGER.warn("INVALID_ACCESS_TYPE", new Object[]{accessTypeStr, AccessType.editable});
            this.accessType = AccessType.editable;
        } else {
            this.accessType = accessType;
        }
    }

    @XmlAttribute
    public String getReferer() {
        return this.referer;
    }

    public void setReferer(String referer) {
        this.referer = referer;
    }

    @XmlAttribute
    @JsonIgnore
    @Deprecated
    public String getUsername() {
        return this.username;
    }

    @Deprecated
    @JsonProperty
    public void setUsername(String username) {
        this.username = username;
    }

    @XmlAttribute
    @JsonIgnore
    @Deprecated
    public String getPassword() {
        return this.password;
    }

    @Deprecated
    @JsonProperty
    public void setPassword(String password) {
        this.password = password;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof ArcGISServerConnectionWrapper)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        ArcGISServerConnectionWrapper wrapper = (ArcGISServerConnectionWrapper)obj;
        if (this.getProperties() == null && wrapper.getProperties() != null) {
            return false;
        }
        if (this.getProperties() != null && wrapper.getProperties() == null) {
            return false;
        }
        EqualsBuilder equalsBuilder = new EqualsBuilder();
        if (this.getProperties() != null) {
            Collection<PropertyWrapper> myProps = this.getProperties();
            Collection<PropertyWrapper> otherProps = wrapper.getProperties();
            if (myProps.size() != otherProps.size()) {
                return false;
            }
            PropertyWrapper[] myPropsArray = myProps.toArray(new PropertyWrapper[myProps.size()]);
            PropertyWrapper[] otherPropsArray = otherProps.toArray(new PropertyWrapper[otherProps.size()]);
            for (int i = 0; i < myPropsArray.length; ++i) {
                equalsBuilder.append((Object)myPropsArray[i], (Object)otherPropsArray[i]);
            }
        }
        equalsBuilder.append((Object)this.getAccessType(), (Object)wrapper.getAccessType());
        equalsBuilder.append((Object)this.getConnectionType(), (Object)wrapper.getConnectionType());
        equalsBuilder.append((Object)this.getName(), (Object)wrapper.getName());
        equalsBuilder.append((Object)this.getReferer(), (Object)wrapper.getReferer());
        equalsBuilder.append(this.getUpdateIntervalSec(), wrapper.getUpdateIntervalSec());
        equalsBuilder.append((Object)this.getUrl(), (Object)wrapper.getUrl());
        equalsBuilder.append(this.isTokenConfigured(), wrapper.isTokenConfigured());
        if (this.isTokenConfigured()) {
            equalsBuilder.append((Object)this.getToken(), (Object)wrapper.getToken());
        }
        return equalsBuilder.isEquals();
    }

    public void normalize() {
        this.normalizeLabel();
        this.normalizeUrl();
    }

    public void normalizeLabel() {
        this.label = Validator.normalizeLabel(this.label, this.name);
    }

    public void normalizeUrl() {
        if (!this.urlNormalized && "default".equalsIgnoreCase(this.name) && "server".equalsIgnoreCase(this.connectionType)) {
            this.url = GESNetUtil.getLocalServerUrl();
            this.urlNormalized = true;
        }
    }
}

