/*
 * Decompiled with CFR 0.152.
 */
package com.esri.ges.manager.datastore.agsconnection;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class AGSConnectionResponse {
    private final String path;
    private final String serviceName;
    private final String[] urls;
    private final boolean hasFailed;
    private Collection<String> failureMessages = new ArrayList<String>();

    public AGSConnectionResponse(String path, String serviceName, String[] urls, boolean hasFailed) {
        this.path = path;
        this.serviceName = serviceName;
        this.hasFailed = hasFailed;
        this.urls = urls;
    }

    public AGSConnectionResponse(String path, String serviceName, boolean hasFailed, String failureMessage) {
        this.path = path;
        this.serviceName = serviceName;
        this.hasFailed = hasFailed;
        this.urls = null;
        this.addFailureMessage(failureMessage);
    }

    public AGSConnectionResponse(String path, String serviceName, boolean hasFailed, Collection<String> failureMessages) {
        this.path = path;
        this.serviceName = serviceName;
        this.hasFailed = hasFailed;
        this.failureMessages = failureMessages;
        this.urls = null;
    }

    public String getPath() {
        return this.path;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public boolean hasFailed() {
        return this.hasFailed;
    }

    public Collection<String> getFailureMessages() {
        return this.failureMessages;
    }

    public String[] getUrls() {
        return this.urls;
    }

    public void addFailureMessage(String failureMessage) {
        if (this.failureMessages == null) {
            this.failureMessages = new ArrayList<String>();
        }
        this.failureMessages.add(failureMessage);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

