/*
 * Decompiled with CFR 0.152.
 */
package com.esri.ges.jaxb.transport;

import com.esri.ges.core.property.PropertyDefinition;
import com.esri.ges.jaxb.property.PropertyDefinitionWrapper;
import com.esri.ges.transport.TransportDefinition;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@ApiModel(value="${com.esri.ges.rest.cxf-swagger.TRANSPORT_MODEL_LBL}", description="${com.esri.ges.rest.cxf-swagger.TRANSPORT_MODEL_DESC}")
@XmlRootElement(name="transport")
@XmlType(propOrder={"name", "label", "contact", "description", "version", "domain", "lastModified", "type", "propertyDefinitions"})
public class TransportWrapper {
    private static final String PROPDEFS_PROP_NAME = "propertyDefinitions";
    @ApiModelProperty(value="${com.esri.ges.rest.cxf-swagger.TRANSPORT_MODEL_NAME_LBL}", required=true, example="${com.esri.ges.rest.cxf-swagger.TRANSPORT_MODEL_NAME_SAMPLE}")
    private String name;
    @ApiModelProperty(value="${com.esri.ges.rest.cxf-swagger.TRANSPORT_MODEL_LABEL_LBL}", required=true, example="${com.esri.ges.rest.cxf-swagger.TRANSPORT_MODEL_LABEL_SAMPLE}")
    private String label;
    @ApiModelProperty(value="${com.esri.ges.rest.cxf-swagger.TRANSPORT_MODEL_CONTACT_LBL}", required=true, example="${com.esri.ges.rest.cxf-swagger.TRANSPORT_MODEL_CONTACT_SAMPLE}")
    private String contact;
    @ApiModelProperty(value="${com.esri.ges.rest.cxf-swagger.TRANSPORT_MODEL_DESCRIPTION_LBL}", required=false, example="${com.esri.ges.rest.cxf-swagger.TRANSPORT_MODEL_DESCRIPTION_SAMPLE}")
    private String description;
    @ApiModelProperty(value="${com.esri.ges.rest.cxf-swagger.TRANSPORT_MODEL_VERSION_LBL}", required=true, example="${com.esri.ges.rest.cxf-swagger.TRANSPORT_MODEL_VERSION_SAMPLE}")
    private String version;
    @ApiModelProperty(value="${com.esri.ges.rest.cxf-swagger.TRANSPORT_MODEL_DOMAIN_LBL}", required=true, example="${com.esri.ges.rest.cxf-swagger.TRANSPORT_MODEL_DOMAIN_SAMPLE}")
    private String domain;
    @ApiModelProperty(value="${com.esri.ges.rest.cxf-swagger.TRANSPORT_MODEL_LAST_MODIFIED_LBL}", required=false, example="${com.esri.ges.rest.cxf-swagger.TRANSPORT_MODEL_LAST_MODIFIED_SAMPLE}")
    private String lastModified;
    @ApiModelProperty(value="${com.esri.ges.rest.cxf-swagger.TRANSPORT_MODEL_TYPE_LBL}", required=true, example="${com.esri.ges.rest.cxf-swagger.TRANSPORT_MODEL_TYPE_SAMPLE}", allowableValues="inbound,outbound")
    private String type;
    @ApiModelProperty(value="${com.esri.ges.rest.cxf-swagger.TRANSPORT_MODEL_PROPERTIES_LBL}", required=true)
    private List<PropertyDefinitionWrapper> propertyDefinitions;

    public TransportWrapper() {
    }

    public TransportWrapper(TransportDefinition definition) {
        this.setName(definition.getName());
        this.setLabel(definition.getLabel());
        this.setContact(definition.getContactInfo());
        this.setDescription(definition.getDescription());
        this.setVersion(definition.getVersion());
        this.setDomain(definition.getDomain());
        this.setLastModified(definition.getLastModified());
        ArrayList<PropertyDefinitionWrapper> propDefs = new ArrayList<PropertyDefinitionWrapper>();
        for (PropertyDefinition propDef : definition.getPropertyDefinitions().values()) {
            propDefs.add(new PropertyDefinitionWrapper(propDef));
        }
        this.setPropertyDefinitions(propDefs);
        this.setType(definition.getTransportType().toString());
    }

    @XmlAttribute
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @XmlAttribute
    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    @XmlAttribute
    public String getContact() {
        return this.contact;
    }

    public void setContact(String contact) {
        this.contact = contact;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @XmlAttribute
    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    @XmlAttribute
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    @XmlAttribute
    public String getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(String lastModified) {
        this.lastModified = lastModified;
    }

    @XmlAttribute
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @XmlElementWrapper(name="propertyDefinitions")
    @XmlElement(name="propertyDefinition")
    @JsonProperty(value="propertyDefinitions")
    public List<PropertyDefinitionWrapper> getPropertyDefinitions() {
        return this.propertyDefinitions != null && this.propertyDefinitions.size() > 0 ? this.propertyDefinitions : null;
    }

    public void setPropertyDefinitions(List<PropertyDefinitionWrapper> propertyDefinitions) {
        this.propertyDefinitions = propertyDefinitions;
    }
}

