/*
 * Decompiled with CFR 0.152.
 */
package com.esri.ges.jaxb.property;

import com.esri.core.geometry.MapGeometry;
import com.esri.core.geometry.Point;
import com.esri.core.geometry.SpatialReference;
import com.esri.ges.core.ConfigurationException;
import com.esri.ges.core.property.LabeledValue;
import com.esri.ges.core.property.Property;
import com.esri.ges.core.property.PropertyDefinition;
import com.esri.ges.core.property.PropertyException;
import com.esri.ges.core.property.PropertyType;
import com.esri.ges.framework.i18n.BundleLogger;
import com.esri.ges.framework.i18n.BundleLoggerFactory;
import com.esri.ges.jaxb.common.LabeledValueWrapper;
import com.esri.ges.jaxb.property.PropertyDefinitionWrapper;
import com.esri.ges.jaxb.property.PropertyWrapper;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PropertyJaxbUtil {
    private static final BundleLogger LOGGER = BundleLoggerFactory.getLogger(PropertyJaxbUtil.class);

    private PropertyJaxbUtil() {
    }

    public static final void addPropertyDefinitions(List<PropertyDefinitionWrapper> wrapperPropertyDefinitions, Map<String, PropertyDefinition> propertyDefinitions) {
        if (wrapperPropertyDefinitions != null && wrapperPropertyDefinitions.size() > 0) {
            for (PropertyDefinitionWrapper pdw : wrapperPropertyDefinitions) {
                try {
                    List<LabeledValueWrapper> allowedValues = pdw.getAllowedValues();
                    if (allowedValues != null && !allowedValues.isEmpty()) {
                        ArrayList<LabeledValue> values = new ArrayList<LabeledValue>();
                        for (LabeledValueWrapper allowedValueWrapper : allowedValues) {
                            values.add(allowedValueWrapper.toLabeledValue());
                        }
                        propertyDefinitions.put(pdw.getPropertyName(), new PropertyDefinition(pdw.getPropertyName(), PropertyType.valueOf(pdw.getPropertyType()), pdw.getDefaultValue(), pdw.getLabel(), pdw.getDescription(), pdw.getDependsOn(), pdw.getDisplayOption(), pdw.isMandatory(), pdw.isReadOnly(), values));
                        continue;
                    }
                    propertyDefinitions.put(pdw.getPropertyName(), new PropertyDefinition(pdw.getPropertyName(), PropertyType.valueOf(pdw.getPropertyType()), pdw.getDefaultValue(), pdw.getLabel(), pdw.getDescription(), pdw.getDependsOn(), pdw.getDisplayOption(), (Boolean)pdw.isMandatory(), pdw.isReadOnly()));
                }
                catch (PropertyException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public static final Map<String, Property> createPropertyMap(Collection<PropertyWrapper> propertyReferences, Map<String, PropertyDefinition> propertyDefinitions) throws ConfigurationException {
        if (propertyReferences != null) {
            HashMap<String, Property> properties = new HashMap<String, Property>();
            for (PropertyWrapper propRef : propertyReferences) {
                String key = propRef.getName();
                try {
                    PropertyDefinition propertyDefinition = propertyDefinitions.get(key);
                    if (propertyDefinition == null) {
                        String keyList = "";
                        for (String k : propertyDefinitions.keySet()) {
                            keyList = keyList + k + ",";
                        }
                        throw new ConfigurationException(LOGGER.translate("INVALID_PROP_KEY", key, keyList));
                    }
                    switch (propertyDefinition.getType()) {
                        case Boolean: {
                            properties.put(key, new Property(propertyDefinition, propRef.getValue()));
                            break;
                        }
                        case Date: {
                            SimpleDateFormat format = new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy");
                            properties.put(key, new Property(propertyDefinition, format.parse(propRef.getValue())));
                            break;
                        }
                        case Double: {
                            properties.put(key, new Property(propertyDefinition, Double.valueOf(propRef.getValue())));
                            break;
                        }
                        case Float: {
                            properties.put(key, new Property(propertyDefinition, Float.valueOf(propRef.getValue())));
                            break;
                        }
                        case Geometry: {
                            String pointString = propRef.getValue();
                            String[] parts = pointString.split(",");
                            properties.put(key, new Property(propertyDefinition, new MapGeometry(new Point(Double.valueOf(parts[0]), Double.valueOf(parts[1])), SpatialReference.create(Integer.valueOf(parts[2])))));
                            break;
                        }
                        case Integer: {
                            properties.put(key, new Property(propertyDefinition, Integer.valueOf(propRef.getValue())));
                            break;
                        }
                        case Long: {
                            properties.put(key, new Property(propertyDefinition, Long.valueOf(propRef.getValue())));
                            break;
                        }
                        case Short: {
                            properties.put(key, new Property(propertyDefinition, Short.valueOf(propRef.getValue())));
                            break;
                        }
                        case ArcGISConnection: 
                        case ArcGISBDSConnection: 
                        case ArcGISBDSSource: 
                        case ArcGISBDSSourceLayer: 
                        case ArcGISFolder: 
                        case ArcGISFeatureService: 
                        case ArcGISStreamService: 
                        case ArcGISServiceType: 
                        case ArcGISLayer: 
                        case ArcGISLayerFieldNames: 
                        case ArcGISStreamLayer: 
                        case ArcGISField: 
                        case FolderDataStore: 
                        case Condition: 
                        case GeoEventField_Geometry: 
                        case GeoEventDefinition: 
                        case GeoEventDefinitionField: 
                        case Password: 
                        case ArcGISDateTimeField: 
                        case String: {
                            properties.put(key, new Property(propertyDefinition, propRef.getValue()));
                        }
                    }
                }
                catch (Exception e) {
                    String message = LOGGER.translate("ERROR_SETTING_PROPERTY", key, e.getMessage());
                    LOGGER.error(message, e);
                    throw new ConfigurationException(message);
                }
            }
            return properties;
        }
        return null;
    }
}

