/*
 * Decompiled with CFR 0.152.
 */
package com.esri.ges.jaxb.globalproperty;

import com.esri.ges.core.property.GlobalProperty;
import com.esri.ges.core.security.GeoEventServerCryptoService;
import com.esri.ges.jaxb.globalproperty.GlobalPropertyWrapper;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collection;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@JsonIgnoreProperties(ignoreUnknown=true)
@XmlRootElement(name="template")
@XmlType(propOrder={"globalProperties"})
public class GlobalPropertiesTemplateWrapper {
    private static final String GLOBPROPS_PROP_NAME = "globalProperties";
    private Collection<GlobalPropertyWrapper> globalProperties;
    private String version;
    private String cryptoKey;

    public GlobalPropertiesTemplateWrapper() {
        this.globalProperties = new ArrayList<GlobalPropertyWrapper>();
    }

    public GlobalPropertiesTemplateWrapper(Collection<GlobalProperty> props, String version, GeoEventServerCryptoService cryptoService, boolean encrypt) {
        this.version = version;
        boolean encrypted = false;
        this.globalProperties = new ArrayList<GlobalPropertyWrapper>();
        for (GlobalProperty prop : props) {
            GlobalPropertyWrapper wrapper = new GlobalPropertyWrapper(prop);
            if (encrypt && cryptoService != null) {
                try {
                    encrypted |= wrapper.encrypt(cryptoService, false);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.globalProperties.add(wrapper);
        }
        if (encrypted) {
            this.setCryptoKey(cryptoService.getCryptoKeyString());
        } else {
            this.setCryptoKey(null);
        }
    }

    @JsonProperty(value="globalProperties")
    @XmlElementWrapper(name="globalProperties")
    @XmlElement(name="globalProperty")
    public Collection<GlobalPropertyWrapper> getGlobalProperties() {
        return this.globalProperties;
    }

    public void setGlobalProperties(Collection<GlobalPropertyWrapper> globalProperties) {
        this.globalProperties = globalProperties;
    }

    @JsonProperty(value="key")
    @XmlAttribute(name="key", required=false)
    public String getCryptoKey() {
        return this.cryptoKey;
    }

    public void setCryptoKey(String cryptoKeyString) {
        this.cryptoKey = cryptoKeyString;
    }

    @JsonProperty(value="productVersion")
    @XmlAttribute(name="productVersion")
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }
}

