/*
 * Decompiled with CFR 0.152.
 */
package com.esri.ges.jaxb.datastore;

import com.esri.arcgis.bds.BDSField;
import com.esri.arcgis.bds.DataSource;
import com.esri.ges.jaxb.datastore.BDSFieldWrapper;
import com.esri.ges.jaxb.datastore.BDSServiceInfo;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@ApiModel(value="${com.esri.ges.rest.cxf-swagger.DS_BDS_RESULT_MODEL_LBL}", description="${com.esri.ges.rest.cxf-swagger.DS_BDS_RESULT_MODEL_DESC}")
@JsonIgnoreProperties(ignoreUnknown=true)
@XmlRootElement(name="BDSDataSource")
public class BDSDataSourceWrapper {
    private static final String PROPS_PROP_NAME = "properties";
    private static final String MAPSVCS_PROP_NAME = "mapServices";
    private static final String INDEXES_PROP_NAME = "indexes";
    private static final String FIELDS_PROP_NAME = "fields";
    private static final String FEATURESVCS_PROP_NAME = "featureServices";
    @ApiModelProperty(value="${com.esri.ges.rest.cxf-swagger.DS_BDS_RESULT_MODEL_NAME_LBL}", required=true, example="${com.esri.ges.rest.cxf-swagger.DS_BDS_RESULT_MODEL_NAME_SAMPLE}")
    private String name;
    @ApiModelProperty(value="${com.esri.ges.rest.cxf-swagger.DS_BDS_RESULT_MODEL_LAYER_NAME_LBL}", required=true, example="${com.esri.ges.rest.cxf-swagger.DS_BDS_RESULT_MODEL_LAYER_NAME_SAMPLE}")
    private String layerName;
    @ApiModelProperty(value="${com.esri.ges.rest.cxf-swagger.DS_BDS_RESULT_MODEL_INDEXES_LBL}", required=true)
    private Set<String> indexes;
    @ApiModelProperty(value="${com.esri.ges.rest.cxf-swagger.DS_BDS_RESULT_MODEL_FIELDS_LBL}", required=true)
    private List<BDSFieldWrapper> fields;
    @ApiModelProperty(value="${com.esri.ges.rest.cxf-swagger.DS_BDS_RESULT_MODEL_FS_LBL}", required=true)
    private List<BDSServiceInfo> featureServices;
    @ApiModelProperty(value="${com.esri.ges.rest.cxf-swagger.DS_BDS_RESULT_MODEL_MS_LBL}", required=true)
    private List<BDSServiceInfo> mapServices;
    @ApiModelProperty(value="${com.esri.ges.rest.cxf-swagger.DS_BDS_RESULT_MODEL_PROPS_LBL}", required=true)
    private Map<String, String> properties;

    public BDSDataSourceWrapper() {
        this.featureServices = new ArrayList<BDSServiceInfo>();
        this.mapServices = new ArrayList<BDSServiceInfo>();
        this.fields = new ArrayList<BDSFieldWrapper>();
        this.properties = new HashMap<String, String>();
        this.indexes = new HashSet<String>();
    }

    public BDSDataSourceWrapper(DataSource dataSource, List<BDSServiceInfo> featureServices, List<BDSServiceInfo> mapServices) {
        this.name = dataSource.getName();
        this.layerName = dataSource.getLayerName();
        this.featureServices = featureServices;
        this.mapServices = mapServices;
        this.properties = dataSource.getProperties();
        this.indexes = new HashSet<String>(Arrays.asList(dataSource.getIndexes()));
        this.fields = new ArrayList<BDSFieldWrapper>();
        for (BDSField field : dataSource.getFields()) {
            this.fields.add(new BDSFieldWrapper(field));
        }
    }

    @XmlAttribute
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @XmlAttribute(required=false)
    public String getLayerName() {
        return this.layerName;
    }

    public void setLayerName(String layerName) {
        this.layerName = layerName;
    }

    @XmlElementWrapper(name="fields", required=false)
    @XmlElement(name="field")
    @JsonProperty(value="fields")
    public List<BDSFieldWrapper> getFields() {
        return this.fields;
    }

    public void setFields(List<BDSFieldWrapper> fields) {
        this.fields = fields;
    }

    @XmlElementWrapper(name="featureServices", required=false)
    @XmlElement(name="service")
    @JsonProperty(value="featureServices")
    public List<BDSServiceInfo> getFeatureServices() {
        return this.featureServices;
    }

    public void setFeatureServices(List<BDSServiceInfo> featureServices) {
        this.featureServices = featureServices;
    }

    @XmlElementWrapper(name="mapServices", required=false)
    @XmlElement(name="service")
    @JsonProperty(value="mapServices")
    public List<BDSServiceInfo> getMapServices() {
        return this.mapServices;
    }

    public void setMapServices(List<BDSServiceInfo> mapServices) {
        this.mapServices = mapServices;
    }

    @XmlElementWrapper(name="properties", required=false)
    @XmlElement(name="property")
    @JsonProperty(value="properties")
    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    @XmlElementWrapper(name="indexes", required=false)
    @XmlElement(name="index")
    @JsonProperty(value="indexes")
    public Set<String> getIndexes() {
        return this.indexes;
    }

    public void setIndexes(Set<String> indexes) {
        this.indexes = indexes;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

