/*
 * Decompiled with CFR 0.152.
 */
package com.esri.ges.jaxb.datastore;

import com.esri.ges.jaxb.datastore.ArcGISServerLayerWrapper;
import com.esri.ges.manager.datastore.agsconnection.ArcGISServerConnection;
import com.esri.ges.manager.datastore.agsconnection.ArcGISServerType;
import com.esri.ges.manager.datastore.agsconnection.Datasource;
import com.esri.ges.manager.datastore.agsconnection.Layer;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="arcgisServerService")
public class ArcGISServerServiceWrapper {
    private static final String NAME_PROP_NAME = "name";
    private static final String URL_PROP_NAME = "url";
    private static final String LAYERS_PROP_NAME = "layers";
    private String name;
    private String url;
    private List<ArcGISServerLayerWrapper> layers;

    public ArcGISServerServiceWrapper() {
        this.name = null;
        this.layers = new ArrayList<ArcGISServerLayerWrapper>();
    }

    public ArcGISServerServiceWrapper(ArcGISServerConnection connection, String folderPath, String serviceName, JsonNode serviceDetails, ArcGISServerType serverType) {
        this.name = serviceName;
        JsonNode urlNode = serviceDetails == null ? null : serviceDetails.get(URL_PROP_NAME);
        this.url = urlNode == null || urlNode.isNull() ? "" : urlNode.asText();
        this.layers = new ArrayList<ArcGISServerLayerWrapper>();
        for (Layer layer : connection.getLayers(folderPath, serviceName, serverType)) {
            Datasource datasource = layer.getDatasource();
            ArcGISServerLayerWrapper layerWrapper = new ArcGISServerLayerWrapper(connection, folderPath, serviceName, layer.getName(), layer.getId(), layer.getUrl(), serverType, layer.isHasBDSDatasource(), datasource != null ? datasource.getProvider() : null, datasource != null ? datasource.getName() : null, datasource != null ? datasource.getLayerName() : null);
            this.layers.add(layerWrapper);
        }
    }

    @XmlElement(name="name")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @XmlElement(name="url")
    @JsonProperty(value="url")
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    @XmlElementWrapper(name="layers")
    @XmlElement(name="layers")
    @JsonProperty(value="layers")
    public List<ArcGISServerLayerWrapper> getLayers() {
        return this.layers;
    }

    public void setLayers(List<ArcGISServerLayerWrapper> layers) {
        this.layers = layers == null || layers.size() == 0 ? null : layers;
    }
}

