/*
 * Decompiled with CFR 0.152.
 */
package com.esri.ges.jaxb.adapter;

import com.esri.ges.core.Uri;
import com.esri.ges.core.property.Property;
import com.esri.ges.jaxb.property.PropertyWrapper;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.Collection;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

@ApiModel(value="${com.esri.ges.rest.cxf-swagger.ADAPTER_MODEL_LBL}", description="${com.esri.ges.rest.cxf-swagger.ADAPTER_MODEL_DESC}")
@XmlRootElement(name="adapter")
public class AdapterReference {
    private static final String PROPS_PROP_NAME = "properties";
    @ApiModelProperty(value="${com.esri.ges.rest.cxf-swagger.ADAPTER_MODEL_REF_LBL}", required=true, example="${com.esri.ges.rest.cxf-swagger.ADAPTER_MODEL_REF_SAMPLE}")
    private Uri ref;
    @ApiModelProperty(value="${com.esri.ges.rest.cxf-swagger.ADAPTER_MODEL_PROPERTIES_LBL}", required=true, example="${com.esri.ges.rest.cxf-swagger.ADAPTER_MODEL_PROPERTIES_SAMPLE}")
    private Collection<PropertyWrapper> properties;

    public AdapterReference() {
    }

    public AdapterReference(Uri adapterUri, Collection<Property> properties, boolean hideSensitiveProperties) {
        this.ref = adapterUri;
        if (properties != null && properties.size() > 0) {
            this.properties = new ArrayList<PropertyWrapper>();
            for (Property prop : properties) {
                this.properties.add(new PropertyWrapper(prop.getName(), prop.getValueAsString(), prop.getType(), hideSensitiveProperties));
            }
        }
    }

    @XmlAttribute
    public String getUri() {
        return this.ref != null ? this.ref.toString() : null;
    }

    public void setUri(String uri) {
        this.ref = Uri.parse(uri);
    }

    @XmlElementWrapper(name="properties")
    @XmlElement(name="property")
    @JsonProperty(value="properties")
    public Collection<PropertyWrapper> getProperties() {
        return this.properties;
    }

    public void setProperties(Collection<PropertyWrapper> properties) {
        this.properties = properties;
    }

    @XmlTransient
    @JsonIgnore
    public Uri getUriObject() {
        return this.ref;
    }

    public String toString() {
        return "AdapterReference [ref=" + this.ref + ", properties=" + this.properties + "]";
    }
}

