/*
 * Decompiled with CFR 0.152.
 */
package com.esri.ges.framework.streamservices.client;

import com.esri.ges.framework.i18n.BundleLogger;
import com.esri.ges.framework.i18n.BundleLoggerFactory;
import com.esri.ges.framework.streamservices.client.AbstractStreamServiceClient;
import com.esri.ges.framework.streamservices.client.StreamServiceClientType;
import com.esri.ges.manager.datastore.agsconnection.ArcGISServerConnectionManager;
import java.io.IOException;

public class StreamServiceClientImpl
extends AbstractStreamServiceClient {
    private static final BundleLogger LOGGER = BundleLoggerFactory.getLogger(StreamServiceClientImpl.class);

    public StreamServiceClientImpl(StreamServiceClientType type, String dataStoreName, String path, String serviceName, ArcGISServerConnectionManager agsConnectionMgr) {
        super(type, dataStoreName, path, serviceName, agsConnectionMgr);
    }

    @Override
    public void sendMessage(String message) throws IOException {
        if (this.getType() != StreamServiceClientType.OUTBOUND) {
            throw new UnsupportedOperationException(LOGGER.translate("SS_CLIENT_NOT_OUTBOUND", new Object[]{this.getType(), StreamServiceClientType.OUTBOUND}));
        }
        if (this.isRunning() && this.getSession() != null) {
            this.getSession().getRemote().sendString(message);
        } else {
            LOGGER.error("SS_CLIENT_SEND_MSG_NOT_RUNNING", this.toString(), this.getStatusDetails());
        }
    }

    public void onWebSocketBinary(byte[] payload, int offset, int len) {
    }

    public void onWebSocketText(String message) {
        this.notifyObservers(message);
    }

    public void onWebSocketError(Throwable cause) {
    }
}

