/*
 * Decompiled with CFR 0.152.
 */
package com.esri.ges.framework.streamservices.client;

import com.esri.ges.core.component.ConnectionListener;
import com.esri.ges.core.component.ConnectionState;
import com.esri.ges.core.component.RunningState;
import com.esri.ges.core.component.RunningStateListener;
import com.esri.ges.framework.i18n.BundleLogger;
import com.esri.ges.framework.i18n.BundleLoggerFactory;
import com.esri.ges.framework.streamservices.client.StreamServiceClient;
import com.esri.ges.framework.streamservices.client.StreamServiceClientType;
import com.esri.ges.manager.datastore.agsconnection.ArcGISServerConnection;
import com.esri.ges.manager.datastore.agsconnection.ArcGISServerConnectionManager;
import com.esri.ges.manager.datastore.agsconnection.ArcGISServerType;
import com.esri.ges.manager.datastore.agsconnection.LayerDetails;
import com.esri.ges.util.Validator;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.client.ClientUpgradeRequest;
import org.eclipse.jetty.websocket.client.WebSocketClient;

public abstract class AbstractStreamServiceClient
extends Observable
implements StreamServiceClient {
    public volatile boolean active = true;
    private String errorMessage;
    private RunningState runningState = RunningState.STOPPED;
    private String stateSemaphore = "stateSemaphore";
    private RunningStateListener runningStateListener = null;
    private StreamServiceClientType type = StreamServiceClientType.UNKNOWN;
    private ConnectionListener connectionListener = null;
    private ConnectionState connectionState = ConnectionState.DISCONNECTED;
    protected String layerDescriptionForLogs;
    private int streamWkid;
    private String outFields;
    private String whereClause;
    private String dataStoreName;
    private String path;
    private String serviceName;
    private ArcGISServerConnectionManager agsConnectionMgr;
    private WebSocketClient wsc = null;
    private ArrayList<URI> uris;
    private ReconnectThread reconnectThread;
    private Session session;
    private int defaultBufferSize = 0x100000;
    private int maxIdleTime = 86400000;
    private int maxTextMessageSize = 0x100000;
    private int maxBinaryMessageSize = 0x100000;
    private static final BundleLogger LOGGER = BundleLoggerFactory.getLogger(AbstractStreamServiceClient.class);
    private static final String OUT_SPATIAL_REFERENCE_PARAM = "outSR";
    private static final String WHERE_CLAUSE_PARAM = "where";
    private static final String OUT_FIELDS_PARAM = "outFields";

    public AbstractStreamServiceClient(StreamServiceClientType type, String dataStoreName, String path, String serviceName, ArcGISServerConnectionManager agsConnectionMgr) {
        this.type = type;
        this.dataStoreName = dataStoreName;
        this.path = path;
        this.serviceName = serviceName;
        this.agsConnectionMgr = agsConnectionMgr;
    }

    public void onWebSocketClose(int statusCode, String reason) {
        if (!this.active) {
            return;
        }
        if (statusCode == 1000) {
            return;
        }
        this.session.close();
        this.session = null;
        String errorMessage = LOGGER.translate("SS_CLIENT_WEBSOCKET_CLOSED_ERROR", String.valueOf(statusCode), reason);
        this.setErrorMessageAndStateAndReconnect(errorMessage);
    }

    public void onWebSocketConnect(Session session) {
        this.session = session;
        if (this.session != null && this.session.isOpen() && this.reconnectThread == null) {
            this.active = true;
            this.setRunningState(RunningState.STARTED);
            this.setConnectionState(ConnectionState.CONNECTED);
        }
    }

    @Override
    public synchronized void start() {
        this.startInternal();
    }

    protected synchronized void startInternal() {
        switch (this.getRunningState()) {
            case STARTING: 
            case STARTED: {
                return;
            }
        }
        this.setRunningState(RunningState.STARTING);
        Thread thread = new Thread(){

            @Override
            public void run() {
                AbstractStreamServiceClient.this.setup();
            }
        };
        thread.start();
    }

    @Override
    public synchronized void stop() {
        this.stopInternal();
    }

    @Override
    public void notifyObservers(Object event) {
        if (event != null) {
            this.setChanged();
            super.notifyObservers(event);
            this.clearChanged();
        }
    }

    protected void stopInternal() {
        switch (this.getRunningState()) {
            case STOPPED: 
            case STOPPING: {
                return;
            }
        }
        if (this.session != null) {
            this.active = false;
            if (this.session.isOpen()) {
                try {
                    this.session.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            this.session = null;
        }
        if (this.reconnectThread != null) {
            this.reconnectThread.cancel();
            this.reconnectThread = null;
        }
        if (this.getRunningState() != RunningState.ERROR) {
            this.errorMessage = null;
            this.setRunningState(RunningState.STOPPED);
        }
        this.reconnectFinish();
    }

    protected synchronized void setup() {
        try {
            this.errorMessage = null;
            ArcGISServerConnection dataStoreConn = this.getAgsConnection();
            if (dataStoreConn == null) {
                this.errorMessage = LOGGER.translate("SS_CLIENT_COULD_NOT_FIND_DS", this.dataStoreName, this.serviceName);
                this.setRunningState(RunningState.ERROR);
                return;
            }
            LayerDetails layerDetails = null;
            layerDetails = dataStoreConn.getLayerDetails(this.path, this.serviceName, 0, ArcGISServerType.StreamServer);
            if (layerDetails == null || !layerDetails.isAvailable()) {
                this.setErrorMessageAndStateAndReconnect(this.errorMessage);
                return;
            }
            this.layerDescriptionForLogs = "[" + this.dataStoreName + "][" + this.path + "][" + this.serviceName + "][" + (Object)((Object)ArcGISServerType.StreamServer) + "]";
            String typeUri = "";
            if (this.type == StreamServiceClientType.INBOUND) {
                typeUri = "/subscribe";
            } else if (this.type == StreamServiceClientType.OUTBOUND) {
                typeUri = "/broadcast";
            }
            List<String> uriString = layerDetails.getWebSocketUrl();
            if (this.type == StreamServiceClientType.OUTBOUND) {
                this.streamWkid = layerDetails.getWkid();
            }
            this.uris = new ArrayList();
            for (String u : uriString) {
                String encodedServiceName = URIUtil.encodePath((String)this.serviceName);
                encodedServiceName = URIUtil.encodePath((String)encodedServiceName);
                u = u.replace(this.serviceName, encodedServiceName);
                String queryString = "";
                if (this.type == StreamServiceClientType.INBOUND) {
                    queryString = this.buildQueryParameters(u);
                }
                if (u.contains("?")) {
                    String path = u.substring(0, u.indexOf(63));
                    String parameters = u.substring(u.indexOf(63));
                    if (StringUtils.isNotEmpty((CharSequence)queryString)) {
                        this.uris.add(new URI(path + typeUri + parameters + "&" + queryString));
                        continue;
                    }
                    this.uris.add(new URI(path + typeUri + parameters));
                    continue;
                }
                if (StringUtils.isNotEmpty((CharSequence)queryString)) {
                    this.uris.add(new URI(u + typeUri + "?" + queryString));
                    continue;
                }
                this.uris.add(new URI(u + typeUri));
            }
            this.session = this.getWebsocketSession();
        }
        catch (Exception ex) {
            LOGGER.error("SS_CLIENT_SETUP_FAILURE", this.serviceName, ex.getMessage());
            LOGGER.info(ex.getMessage(), ex);
            this.setErrorMessageAndStateAndReconnect(ex.getMessage());
        }
    }

    private Session getWebsocketSession() throws IOException {
        String errorMessage = LOGGER.translate("SS_CLIENT_NO_WEBSOCKETS");
        int offset = (int)Math.floor((double)this.uris.size() * Math.random());
        for (int i = 0; i < this.uris.size(); ++i) {
            URI uri = this.uris.get((i + offset) % this.uris.size());
            try {
                if (uri.toString().toLowerCase().startsWith("wss://")) {
                    SslContextFactory sslContextFactory = new SslContextFactory();
                    sslContextFactory.setTrustAll(true);
                    this.wsc = new WebSocketClient(sslContextFactory);
                } else {
                    this.wsc = new WebSocketClient();
                }
                this.wsc.setMaxIdleTimeout((long)this.maxIdleTime);
                this.wsc.setMaxTextMessageBufferSize(this.defaultBufferSize);
                this.wsc.setMaxBinaryMessageBufferSize(this.defaultBufferSize);
                this.wsc.getPolicy().setIdleTimeout((long)this.maxIdleTime);
                this.wsc.getPolicy().setMaxBinaryMessageBufferSize(this.defaultBufferSize);
                this.wsc.getPolicy().setMaxTextMessageBufferSize(this.defaultBufferSize);
                this.wsc.getPolicy().setInputBufferSize(this.defaultBufferSize);
                this.wsc.getPolicy().setMaxBinaryMessageSize(this.maxBinaryMessageSize);
                this.wsc.getPolicy().setMaxTextMessageSize(this.maxTextMessageSize);
                this.wsc.start();
                ClientUpgradeRequest request = new ClientUpgradeRequest();
                this.session = (Session)this.wsc.connect((Object)this, uri, request).get();
                return this.session;
            }
            catch (Exception error) {
                this.active = false;
                errorMessage = error.getMessage() + "[" + uri.toString() + "]";
                LOGGER.error(error.getMessage(), error);
                continue;
            }
        }
        if (Validator.isBlank(errorMessage)) {
            errorMessage = LOGGER.translate("SS_CLIENT_NO_WEBSOCKETS");
        }
        throw new IOException(errorMessage);
    }

    private String buildQueryParameters(String uri) throws URISyntaxException {
        StringBuffer queryString = new StringBuffer();
        if (this.streamWkid > 0) {
            queryString.append(OUT_SPATIAL_REFERENCE_PARAM).append("=").append(this.streamWkid);
        }
        if (!StringUtils.isEmpty((CharSequence)this.outFields)) {
            if (!StringUtils.isEmpty((CharSequence)queryString.toString())) {
                queryString.append("&");
            }
            queryString.append(OUT_FIELDS_PARAM).append("=").append(this.outFields);
        }
        if (!StringUtils.isEmpty((CharSequence)this.whereClause)) {
            if (!StringUtils.isEmpty((CharSequence)queryString.toString())) {
                queryString.append("&");
            }
            queryString.append(WHERE_CLAUSE_PARAM).append("=").append(this.whereClause);
        }
        return URIUtil.encodePath((String)queryString.toString());
    }

    private synchronized void reconnect() {
        if (this.reconnectThread == null) {
            this.reconnectThread = new ReconnectThread();
            this.reconnectThread.start();
        }
    }

    private void reconnectFinish() {
        if (this.reconnectThread != null) {
            this.reconnectThread.cancel();
            this.reconnectThread = null;
            this.setRunningState(RunningState.STARTED);
            this.setConnectionState(ConnectionState.CONNECTED);
        }
    }

    protected void setErrorMessageAndStateAndReconnect(String message) {
        this.errorMessage = message;
        this.setRunningState(RunningState.ERROR);
        this.reconnect();
    }

    protected void setErrorState(String message) {
        if (!this.runningState.equals((Object)RunningState.ERROR)) {
            LOGGER.error(message);
        }
        this.setRunningState(RunningState.ERROR);
        this.stopInternal();
        this.setErrorMessage(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RunningState getRunningState() {
        String string = this.stateSemaphore;
        synchronized (string) {
            return this.runningState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setRunningState(RunningState newState) {
        String string = this.stateSemaphore;
        synchronized (string) {
            if (this.runningState != newState) {
                this.runningState = newState;
                if (this.runningStateListener != null) {
                    this.runningStateListener.onStateChange(newState);
                }
            }
        }
    }

    @Override
    public boolean isRunning() {
        return RunningState.STARTED.equals((Object)this.getRunningState());
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    @Override
    public String getStatusDetails() {
        return this.errorMessage;
    }

    @Override
    public void setRunningStateListener(RunningStateListener listener) {
        this.runningStateListener = listener;
    }

    @Override
    public void setConnectionListener(ConnectionListener connectionListener) {
        this.connectionListener = connectionListener;
    }

    @Override
    public boolean isConnected() {
        return ConnectionState.CONNECTED == this.getConnectionState();
    }

    @Override
    public ConnectionState getConnectionState() {
        return this.connectionState;
    }

    protected void setConnectionState(ConnectionState state) {
        if (this.connectionState != state) {
            this.connectionState = state;
            if (this.connectionListener != null) {
                try {
                    this.connectionListener.onConnectionChange(this.connectionState);
                }
                catch (Exception error) {
                    LOGGER.error(error.getMessage(), error);
                }
            }
        }
    }

    @Override
    public Session getSession() {
        return this.session;
    }

    public String getDataStoreName() {
        return this.dataStoreName;
    }

    public String getPath() {
        return this.path;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public ArcGISServerConnection getAgsConnection() {
        return this.agsConnectionMgr.getArcGISServerConnection(this.dataStoreName);
    }

    public StreamServiceClientType getType() {
        return this.type;
    }

    @Override
    public int getStreamWkid() {
        return this.streamWkid;
    }

    @Override
    public void setStreamWkid(int streamWkid) {
        this.streamWkid = streamWkid;
    }

    @Override
    public String getOutFields() {
        return this.outFields;
    }

    @Override
    public void setOutFields(String outFields) {
        this.outFields = outFields;
    }

    @Override
    public String getWhereClause() {
        return this.whereClause;
    }

    @Override
    public void setWhereClause(String whereClause) {
        this.whereClause = whereClause;
    }

    @Override
    public void setDefaultBufferSize(int defaultBufferSize) {
        this.defaultBufferSize = defaultBufferSize;
    }

    @Override
    public void setMaxIdleTime(int maxIdleTime) {
        this.maxIdleTime = maxIdleTime;
    }

    @Override
    public void setMaxTextMessageSize(int maxTextMessageSize) {
        this.maxTextMessageSize = maxTextMessageSize;
    }

    @Override
    public void setMaxBinaryMessageSize(int maxBinaryMessageSize) {
        this.maxBinaryMessageSize = maxBinaryMessageSize;
    }

    public String toString() {
        return "[" + this.dataStoreName + "][" + this.path + "][" + this.serviceName + "][" + (Object)((Object)ArcGISServerType.StreamServer) + "]";
    }

    private class ReconnectThread
    extends Thread {
        private volatile boolean running;

        public ReconnectThread() {
            super("ReconnectThread-For-" + AbstractStreamServiceClient.this.layerDescriptionForLogs + "[" + (Object)((Object)AbstractStreamServiceClient.this.type) + "]");
            this.running = true;
            AbstractStreamServiceClient.this.setConnectionState(ConnectionState.DISCONNECTED);
        }

        private void cancel() {
            this.running = false;
        }

        @Override
        public void run() {
            while (this.running) {
                if (AbstractStreamServiceClient.this.session != null && AbstractStreamServiceClient.this.session.isOpen()) {
                    AbstractStreamServiceClient.this.reconnectFinish();
                    return;
                }
                if (AbstractStreamServiceClient.this.getRunningState() == RunningState.STOPPED || AbstractStreamServiceClient.this.getRunningState() == RunningState.STOPPING) {
                    AbstractStreamServiceClient.this.reconnectFinish();
                    return;
                }
                try {
                    ReconnectThread.sleep(10000L);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                AbstractStreamServiceClient.this.setRunningState(RunningState.ERROR);
                AbstractStreamServiceClient.this.startInternal();
            }
        }
    }
}

