/*
 * Decompiled with CFR 0.152.
 */
package com.esri.ges.framework.streamservices.client;

import com.esri.ges.core.component.RunningState;
import com.esri.ges.framework.i18n.BundleLogger;
import com.esri.ges.framework.i18n.BundleLoggerFactory;
import com.esri.ges.framework.streamservices.client.StreamServiceClientImpl;
import com.esri.ges.framework.streamservices.client.StreamServiceClientType;
import com.esri.ges.manager.datastore.agsconnection.ArcGISServerConnection;
import com.esri.ges.manager.datastore.agsconnection.ArcGISServerConnectionManager;
import com.esri.ges.manager.datastore.agsconnection.ArcGISServerConnectionStatus;
import com.esri.ges.manager.datastore.agsconnection.ArcGISServerConnectionStatusListener;
import com.esri.ges.manager.datastore.agsconnection.ArcGISServerType;

public class AGSConnectionStatusListenerStreamServiceClient
extends StreamServiceClientImpl
implements ArcGISServerConnectionStatusListener {
    private ArcGISServerConnectionManager connectionManager;
    private static final BundleLogger LOGGER = BundleLoggerFactory.getLogger(AGSConnectionStatusListenerStreamServiceClient.class);

    public AGSConnectionStatusListenerStreamServiceClient(StreamServiceClientType type, String dataStoreName, String path, String serviceName, ArcGISServerConnectionManager connectionManager) {
        super(type, dataStoreName, path, serviceName, connectionManager);
        this.connectionManager = connectionManager;
    }

    @Override
    protected synchronized void setup() {
        super.setup();
        if (this.connectionManager != null) {
            this.connectionManager.unregisterArcGISServerConnectionListener(this.getDataStoreName(), this);
            this.connectionManager.registerArcGISServerConnectionListener(this.getDataStoreName(), this);
        }
    }

    @Override
    public void stop() {
        this.stopInternal();
        if (this.connectionManager != null) {
            this.connectionManager.unregisterArcGISServerConnectionListener(this.getDataStoreName(), this);
        }
    }

    @Override
    public void onArcGISServerConnectionStatusChange(String connectionName, ArcGISServerConnectionStatus newStatus) {
        if (connectionName.equals(this.getDataStoreName())) {
            switch (newStatus) {
                case AVAILABLE: 
                case UPDATED: 
                case SYNC_SUCCESS: {
                    boolean validConnection = this.isArcGISConnectionConfigurationValid(this.getAgsConnection());
                    RunningState runningState = this.getRunningState();
                    if (runningState.equals((Object)RunningState.ERROR) && validConnection) {
                        LOGGER.info("AGS_SS_CLIENT_RESTARTING_MSG", this.layerDescriptionForLogs);
                        this.start();
                        break;
                    }
                    if (validConnection) break;
                    if (runningState.equals((Object)RunningState.ERROR)) {
                        this.setErrorState(LOGGER.translate("AGS_SS_CLIENT_FAILED_TO_RESTART", this.layerDescriptionForLogs));
                        break;
                    }
                    if (!this.isRunning()) break;
                    this.setErrorState(LOGGER.translate("AGS_SS_CLIENT_STOP_TRANSPORT_AFTER_SYNC", this.layerDescriptionForLogs));
                    break;
                }
                case DELETED: {
                    this.setErrorState(LOGGER.translate("AGS_SS_CLIENT_DS_CONNECTION_NA", this.getDataStoreName()));
                    break;
                }
                case SYNC_ERROR: {
                    if (this.isArcGISConnectionConfigurationValid(this.getAgsConnection())) break;
                    this.setErrorState(this.getAgsConnection() == null ? LOGGER.translate("AGS_SS_CLIENT_DS_CONNECTION_NA", this.getDataStoreName()) : LOGGER.translate("AGS_SS_CLIENT_LAYER_INFO_NA", this.layerDescriptionForLogs));
                }
            }
        }
    }

    private boolean isArcGISConnectionConfigurationValid(ArcGISServerConnection connection) {
        return connection != null && connection.isUseable(this.getPath(), this.getServiceName(), "0", ArcGISServerType.StreamServer);
    }
}

