/*
 * Decompiled with CFR 0.152.
 */
package com.esri.ges.core.property;

import com.esri.ges.core.property.KeyValueMap;
import com.esri.ges.core.property.PropertyType;
import com.esri.ges.core.property.SelectableMap;
import com.esri.ges.core.property.StringList;
import com.esri.ges.util.Converter;

public class PropertyUtil {
    public static Object valueToObject(Object value, PropertyType type) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return PropertyUtil.valueToObject((String)value, type);
        }
        return PropertyUtil.valueToObject(value.toString(), type);
    }

    public static Object valueToObject(String value, PropertyType type) {
        if (value == null) {
            return null;
        }
        switch (type) {
            case ArcGISConnection: 
            case ArcGISBDSConnection: 
            case ArcGISBDSSource: 
            case ArcGISBDSSourceLayer: 
            case ArcGISFolder: 
            case ArcGISFeatureService: 
            case ArcGISStreamService: 
            case ArcGISServiceType: 
            case ArcGISLayer: 
            case ArcGISLayerFieldNames: 
            case ArcGISStreamLayer: 
            case ArcGISField: 
            case ArcGISDateTimeField: 
            case FolderDataStore: 
            case Condition: 
            case GeoEventField_Geometry: 
            case GeoEventDefinition: 
            case GeoEventDefinitionField: 
            case Password: 
            case TaskSchedule: 
            case String: {
                return Converter.convertToString(value);
            }
            case Boolean: {
                return Converter.convertToBoolean(value);
            }
            case Double: {
                return Converter.convertToDouble(value);
            }
            case Float: {
                return Converter.convertToFloat(value);
            }
            case Integer: {
                return Converter.convertToInteger(value);
            }
            case Long: {
                return Converter.convertToLong(value);
            }
            case Short: {
                return Converter.convertToShort(value);
            }
            case Date: {
                return Converter.convertToDate(value);
            }
            case Geometry: {
                return Converter.convertToGeometry(value);
            }
            case Undefined: {
                return value;
            }
            case KeyValueMap: {
                return new KeyValueMap(value);
            }
            case SelectableFinalMap: {
                return new SelectableMap(value);
            }
            case StringList: {
                return new StringList(value);
            }
        }
        return null;
    }

    public static String valueToString(Object value, PropertyType type) {
        if (value == null) {
            return null;
        }
        switch (type) {
            case ArcGISConnection: 
            case ArcGISBDSConnection: 
            case ArcGISBDSSource: 
            case ArcGISBDSSourceLayer: 
            case ArcGISFolder: 
            case ArcGISFeatureService: 
            case ArcGISStreamService: 
            case ArcGISServiceType: 
            case ArcGISLayer: 
            case ArcGISLayerFieldNames: 
            case ArcGISStreamLayer: 
            case ArcGISField: 
            case ArcGISDateTimeField: 
            case FolderDataStore: 
            case Condition: 
            case GeoEventField_Geometry: 
            case GeoEventDefinition: 
            case GeoEventDefinitionField: 
            case Password: 
            case TaskSchedule: 
            case String: 
            case Boolean: 
            case Double: 
            case Float: 
            case Integer: 
            case Long: 
            case Short: 
            case Undefined: {
                return Converter.convertToString(value);
            }
            case Date: {
                return Converter.convertToString(value);
            }
            case Geometry: {
                return Converter.convertToGeometryJson(value);
            }
            case KeyValueMap: {
                return Converter.convertToString(value);
            }
            case SelectableFinalMap: {
                return Converter.convertToString(value);
            }
            case StringList: {
                return Converter.convertToString(value);
            }
        }
        return null;
    }

    public static boolean stringToBool(String value) {
        return Boolean.parseBoolean(value);
    }

    public static String boolToString(boolean value) {
        return String.valueOf(value);
    }
}

