/*
 * Decompiled with CFR 0.152.
 */
package com.esri.ges.core.property;

import com.esri.ges.core.property.LabeledValue;
import com.esri.ges.core.property.Property;
import com.esri.ges.core.property.PropertyException;
import com.esri.ges.core.property.PropertyType;
import com.esri.ges.framework.i18n.BundleLogger;
import com.esri.ges.framework.i18n.BundleLoggerFactory;
import com.esri.ges.util.Converter;
import com.esri.ges.util.Validator;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class PropertyDefinition {
    private String propertyName;
    private PropertyType type;
    private Object defaultValue;
    private final List<LabeledValue> allowedValues = new ArrayList<LabeledValue>();
    private String label;
    private String description;
    private Boolean mandatory;
    private Boolean readOnly;
    private String dependsOn;
    private String displayOption;
    private static final BundleLogger LOGGER = BundleLoggerFactory.getLogger(PropertyDefinition.class);

    public PropertyDefinition() {
    }

    public PropertyDefinition(String name, PropertyType type, Object defaultValue, String label, String description, Boolean mandatory, Boolean readOnly, List<LabeledValue> allowedValues) throws PropertyException {
        this.setPropertyName(name);
        if (this.propertyName.length() == 0) {
            throw new PropertyException(LOGGER.translate("PROPERTY_DEF_NAME_MISSING"));
        }
        if (type == null) {
            throw new PropertyException(LOGGER.translate("PROPERTY_DEF_TYPE_MISSING"));
        }
        this.type = type;
        this.setDescription(description);
        this.setDefaultValue(defaultValue);
        this.setLabel(label);
        this.setMandatory(mandatory);
        this.setReadOnly(readOnly);
        this.setDependsOn("");
        this.setDisplayOption("");
        if (allowedValues != null && allowedValues.size() > 0) {
            for (LabeledValue value : allowedValues) {
                this.allowedValues.add(this.validateValue(value));
            }
        }
    }

    public PropertyDefinition(String name, PropertyType type, Object defaultValue, String label, String description, Boolean mandatory, Boolean readOnly) throws PropertyException {
        this(name, type, defaultValue, label, description, mandatory, readOnly, null);
    }

    public PropertyDefinition(String name, PropertyType type, Object defaultValue, String label, String description, String dependsOn, Boolean mandatory, Boolean readOnly, List<LabeledValue> allowedValues) throws PropertyException {
        this(name, type, defaultValue, label, description, mandatory, readOnly, allowedValues);
        this.setDependsOn(dependsOn);
    }

    public PropertyDefinition(String name, PropertyType type, Object defaultValue, String label, String description, String dependsOn, Boolean mandatory, Boolean readOnly) throws PropertyException {
        this(name, type, defaultValue, label, description, dependsOn, mandatory, readOnly, null);
    }

    public PropertyDefinition(String name, PropertyType type, Object defaultValue, String label, String description, String dependsOn, String displayOption, Boolean mandatory, Boolean readOnly, List<LabeledValue> allowedValues) throws PropertyException {
        this(name, type, defaultValue, label, description, mandatory, readOnly, allowedValues);
        this.setDependsOn(dependsOn);
        this.setDisplayOption(displayOption);
    }

    public PropertyDefinition(String name, PropertyType type, String defaultValue, String label, String description, String dependsOn, String displayOption, Boolean mandatory, Boolean readOnly) throws PropertyException {
        this(name, type, defaultValue, label, description, dependsOn, displayOption, mandatory, readOnly, null);
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public void setPropertyName(String name) {
        this.propertyName = Validator.compactWhiteSpaces(name);
    }

    public PropertyType getType() {
        return this.type;
    }

    public void setType(PropertyType type) {
        this.type = type;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(Object defaultValue) {
        this.defaultValue = this.validateValue(defaultValue);
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String displayName) {
        this.label = Validator.compactWhiteSpaces(displayName);
    }

    public boolean isMandatory() {
        return this.mandatory;
    }

    public Boolean getMandatory() {
        return this.mandatory;
    }

    public void setMandatory(Boolean mandatory) {
        this.mandatory = mandatory != null ? mandatory : false;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public Boolean getReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(Boolean readOnly) {
        this.readOnly = readOnly != null ? readOnly : false;
    }

    public LabeledValue validateValue(LabeledValue value) {
        if (value == null) {
            return null;
        }
        value.setValue(this.validateValue(value.getValue()));
        return value;
    }

    public Object validateValue(Object value) {
        switch (this.type) {
            case ArcGISConnection: 
            case ArcGISBDSConnection: 
            case ArcGISBDSSource: 
            case ArcGISBDSSourceLayer: 
            case ArcGISFolder: 
            case ArcGISFeatureService: 
            case ArcGISStreamService: 
            case ArcGISServiceType: 
            case ArcGISLayer: 
            case ArcGISLayerFieldNames: 
            case ArcGISStreamLayer: 
            case ArcGISField: 
            case ArcGISDateTimeField: 
            case FolderDataStore: 
            case Condition: 
            case GeoEventField_Geometry: 
            case GeoEventDefinition: 
            case GeoEventDefinitionField: 
            case Password: 
            case String: {
                return Converter.convertToString(value);
            }
            case Boolean: {
                return Converter.convertToBoolean(value);
            }
            case Double: {
                return Converter.convertToDouble(value);
            }
            case Float: {
                return Converter.convertToFloat(value);
            }
            case Integer: {
                return Converter.convertToInteger(value);
            }
            case Long: {
                return Converter.convertToLong(value);
            }
            case Short: {
                return Converter.convertToShort(value);
            }
            case Date: {
                return Converter.convertToDate(value);
            }
            case Geometry: {
                return Converter.convertToGeometry(value);
            }
            case Undefined: {
                return value;
            }
        }
        return null;
    }

    public Property getDefaultProperty() {
        Property property = new Property();
        property.setDefinition(this);
        property.setValue(this.defaultValue);
        return property;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = Validator.compactWhiteSpaces(description);
    }

    public List<LabeledValue> getAllowedValues() {
        return this.allowedValues;
    }

    public void clearAllowedValues() {
        this.allowedValues.clear();
    }

    public void addAllowedValue(LabeledValue value) {
        this.allowedValues.add(this.validateValue(value));
    }

    public String getDependsOn() {
        return this.dependsOn;
    }

    public void setDependsOn(String dependsOn) {
        this.dependsOn = Validator.compactSpaces(dependsOn);
    }

    public String getDisplayOption() {
        return this.displayOption;
    }

    public void setDisplayOption(String displayOption) {
        this.displayOption = Validator.compactSpaces(displayOption);
    }

    public boolean equals(Object obj) {
        PropertyDefinition pd;
        if (obj != null && obj instanceof PropertyDefinition && this.propertyName.equals((pd = (PropertyDefinition)obj).getPropertyName()) && this.type.equals((Object)pd.getType()) && this.description.equals(pd.getDescription()) && (this.defaultValue == null && pd.getDefaultValue() == null || this.defaultValue != null && pd.getDefaultValue() != null && this.defaultValue.equals(pd.getDefaultValue())) && this.label.equals(pd.getLabel()) && this.mandatory.equals(pd.getMandatory()) && this.readOnly.equals(pd.getReadOnly()) && this.dependsOn.equals(pd.getDependsOn()) && this.displayOption.equals(pd.getDisplayOption()) && this.allowedValues.size() == pd.getAllowedValues().size()) {
            for (LabeledValue value : this.allowedValues) {
                if (pd.getAllowedValues().contains(value)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

