/*
 * Decompiled with CFR 0.152.
 */
package com.esri.ges.core.property;

import com.esri.ges.core.property.LabeledKeyValue;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import java.util.Map;

public class KeyValueMap
extends HashMap<String, LabeledKeyValue> {
    private static final long serialVersionUID = 1L;

    public KeyValueMap() {
    }

    public KeyValueMap(String json) {
        this.fromJson(json);
    }

    public boolean fromJson(String json) {
        Map createdMap;
        try {
            ObjectMapper mapper = new ObjectMapper();
            TypeReference<HashMap<String, LabeledKeyValue>> typeRef = new TypeReference<HashMap<String, LabeledKeyValue>>(){};
            createdMap = (Map)mapper.readValue(json, (TypeReference)typeRef);
        }
        catch (Exception e) {
            return false;
        }
        this.clear();
        this.putAll(createdMap);
        return true;
    }

    public String toJson() {
        String json = null;
        try {
            ObjectMapper mapper = new ObjectMapper();
            json = mapper.writeValueAsString((Object)this);
        }
        catch (Exception e) {
            return null;
        }
        return json;
    }

    public void add(LabeledKeyValue value) {
        this.put(value.getKey(), value);
    }

    @Override
    public String toString() {
        return this.toJson();
    }

    public static void main(String[] args) {
        KeyValueMap map = new KeyValueMap();
        map.add(new LabeledKeyValue("key1", "value1", "Key 1", "Value 1"));
        map.add(new LabeledKeyValue("key2", "value2", "Key 2", "Value 2"));
        map.add(new LabeledKeyValue("key3", "value3", "Key 3", "Value 3"));
        map.add(new LabeledKeyValue("key4", "value4", "Key 4", "Value 4"));
        map.add(new LabeledKeyValue("key5", "value5", "Key 5", "Value 5"));
        map.add(new LabeledKeyValue("key6", "value6", "Key 6", "Value 6"));
        map.add(new LabeledKeyValue("key7", "value7", "Key 7", "Value 7"));
        map.add(new LabeledKeyValue("key8", "value8", "Key 8", "Value 8"));
        String json = map.toJson();
        KeyValueMap map2 = new KeyValueMap(json);
        for (LabeledKeyValue lkv : map2.values()) {
            System.out.println(lkv.toJson());
        }
        for (String key : map.keySet()) {
            System.out.println("Key: " + key + " , value: " + ((LabeledKeyValue)map.get(key)).toJson());
        }
        for (String key : map.keySet()) {
            System.out.println("Key: " + key + " , value: " + ((LabeledKeyValue)map.get(key)).toJson());
        }
    }
}

