/*
 * Decompiled with CFR 0.152.
 */
package com.esri.ges.core.i18n;

import java.math.RoundingMode;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.commons.lang3.StringUtils;

public class NumberUtil {
    private NumberFormat parser = null;
    private NumberFormat formatter = null;

    private NumberUtil() {
        this(Locale.getDefault());
    }

    private NumberUtil(Locale locale) {
        this.parser = NumberFormat.getInstance(locale);
        this.formatter = NumberFormat.getInstance(locale);
        this.formatter.setGroupingUsed(false);
        this.formatter.setRoundingMode(RoundingMode.HALF_EVEN);
    }

    public static NumberUtil getInstance() {
        return new NumberUtil();
    }

    public static NumberUtil getInstance(String localeString) {
        Locale locale = NumberUtil.getLocale(localeString);
        NumberUtil util = new NumberUtil(locale);
        return util;
    }

    private static Locale getLocale(String localeString) {
        Locale locale = null;
        try {
            locale = LocaleUtils.toLocale((String)localeString);
        }
        catch (Exception error) {
            locale = Locale.getDefault();
        }
        return locale;
    }

    public Number parseNumber(String numberStr) throws ParseException {
        if (StringUtils.isEmpty((CharSequence)numberStr)) {
            return null;
        }
        return this.parser.parse(StringUtils.trim((String)numberStr));
    }

    public Float parseFloat(String numberStr) throws ParseException {
        Number number = this.parseNumber(numberStr);
        if (number != null) {
            return new Float(number.floatValue());
        }
        return null;
    }

    public float parseFloat(String numberStr, float defaultValue) throws ParseException {
        Number number = this.parseNumber(numberStr);
        if (number != null) {
            return number.floatValue();
        }
        return defaultValue;
    }

    public Double parseDouble(String numberStr) throws ParseException {
        Number number = this.parseNumber(numberStr);
        if (number != null) {
            return new Double(number.doubleValue());
        }
        return null;
    }

    public double parseDouble(String numberStr, double defaultValue) throws ParseException {
        Number number = this.parseNumber(numberStr);
        if (number != null) {
            return number.doubleValue();
        }
        return defaultValue;
    }

    public Integer parseInteger(String numberStr) throws ParseException {
        Number number = this.parseNumber(numberStr);
        if (number != null) {
            return new Integer(number.intValue());
        }
        return null;
    }

    public int parseInteger(String numberStr, int defaultValue) throws ParseException {
        Number number = this.parseNumber(numberStr);
        if (number != null) {
            return number.intValue();
        }
        return defaultValue;
    }

    public Long parseLong(String numberStr) throws ParseException {
        Number number = this.parseNumber(numberStr);
        if (number != null) {
            return new Long(number.longValue());
        }
        return null;
    }

    public long parseLong(String numberStr, long defaultValue) throws ParseException {
        Number number = this.parseNumber(numberStr);
        if (number != null) {
            return number.longValue();
        }
        return defaultValue;
    }

    public Short parseShort(String numberStr) throws ParseException {
        Number number = this.parseNumber(numberStr);
        if (number != null) {
            return new Short(number.shortValue());
        }
        return null;
    }

    public short parseShort(String numberStr, short defaultValue) throws ParseException {
        Number number = this.parseNumber(numberStr);
        if (number != null) {
            return number.shortValue();
        }
        return defaultValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String format(Number number) {
        int defaultPrecision;
        if (number == null) {
            return null;
        }
        int precision = defaultPrecision = this.formatter.getMaximumFractionDigits();
        if (number instanceof Double) {
            precision = this.numberOfDecimalPlaces((Double)number);
        } else if (number instanceof Float) {
            precision = this.numberOfDecimalPlaces((Float)number);
        }
        this.formatter.setMaximumFractionDigits(precision);
        try {
            String string = this.formatter.format(number);
            return string;
        }
        finally {
            this.formatter.setMaximumFractionDigits(defaultPrecision);
        }
    }

    private int numberOfDecimalPlaces(Double doubleValue) {
        if (doubleValue == null || doubleValue == 0.0) {
            return 0;
        }
        String string = String.valueOf(doubleValue);
        int index = string.indexOf(".");
        return index < 0 ? 0 : string.length() - index - 1;
    }

    private int numberOfDecimalPlaces(Float floatValue) {
        if (floatValue == null || floatValue.floatValue() == 0.0f) {
            return 0;
        }
        String string = String.valueOf(floatValue);
        int index = string.indexOf(".");
        return index < 0 ? 0 : string.length() - index - 1;
    }
}

