/*
 * Decompiled with CFR 0.152.
 */
package com.esri.ges.core.http;

import com.esri.ges.core.http.KeyValue;
import java.util.ArrayList;

public class KeyValueList
extends ArrayList<KeyValue> {
    private static final long serialVersionUID = 1L;

    @Override
    public boolean add(KeyValue kv) {
        return this.add(kv, true);
    }

    public boolean addAll(KeyValueList c) {
        return this.addAll(c, true);
    }

    public boolean add(KeyValue kv, boolean overrideKey) {
        String key = kv.getKey();
        if (overrideKey) {
            this.removeKey(key, true);
            return super.add(kv);
        }
        int keyIndex = this.findKey(key, true);
        if (keyIndex < 0) {
            return super.add(kv);
        }
        return false;
    }

    public boolean addAll(KeyValueList c, boolean overrideKey) {
        for (KeyValue kv : c) {
            this.add(kv, overrideKey);
        }
        return true;
    }

    public int findKey(String key, Boolean ignoreCase) {
        for (int index = 0; index < this.size(); ++index) {
            KeyValue kv = (KeyValue)this.get(index);
            if (key == null || !(ignoreCase != false ? key.equalsIgnoreCase(kv.getKey()) : key.equals(kv.getKey()))) continue;
            return index;
        }
        return -1;
    }

    private int removeKey(String key, boolean ignoreCase) {
        int removedCount = 0;
        int keyIndex = this.findKey(key, ignoreCase);
        while (keyIndex > 0) {
            ++removedCount;
            super.remove(keyIndex);
            keyIndex = this.findKey(key, ignoreCase);
        }
        return removedCount;
    }
}

