/*
 * Decompiled with CFR 0.152.
 */
package com.esri.ges.core.geoevent;

import com.esri.ges.core.validation.ValidationException;
import com.esri.ges.framework.i18n.BundleLogger;
import com.esri.ges.framework.i18n.BundleLoggerFactory;
import com.esri.ges.util.Validator;

public enum GeoEventPropertyName {
    TYPE,
    OWNER_ID,
    OWNER_URI,
    DEFINITION_NAME,
    DEFINITION_GUID,
    RECEIVED_TIME,
    LAST_VISITED_NODE;

    private static final BundleLogger LOGGER;

    public static GeoEventPropertyName parse(String s) throws ValidationException {
        String sName = Validator.compactWhiteSpaces(s);
        if (Validator.isBlank(sName)) {
            throw new ValidationException(LOGGER.translate("GED_PROPERTY_NAME_EMPTY"));
        }
        if (!sName.startsWith("$")) {
            throw new ValidationException(LOGGER.translate("GED_PROPERTY_INVALID_START_CHAR"));
        }
        GeoEventPropertyName pName = Validator.valueOfIgnoreCase(GeoEventPropertyName.class, s.substring(1), null);
        if (pName != null) {
            return pName;
        }
        throw new ValidationException(LOGGER.translate("GED_PROPERTY_INVALID_NAME", sName));
    }

    static {
        LOGGER = BundleLoggerFactory.getLogger(GeoEventPropertyName.class);
    }
}

