/*
 * Decompiled with CFR 0.152.
 */
package com.esri.ges.core.geoevent;

import com.esri.ges.core.geoevent.FieldExpression;
import com.esri.ges.core.geoevent.FieldExpressionException;
import com.esri.ges.core.geoevent.FieldExpressionTerm;
import com.esri.ges.core.operator.LogicalOperator;
import com.esri.ges.framework.i18n.BundleLogger;
import com.esri.ges.framework.i18n.BundleLoggerFactory;
import com.esri.ges.util.Converter;
import com.esri.ges.util.Validator;
import java.io.Serializable;
import java.util.LinkedList;

class FieldExpressionTermImpl
implements FieldExpressionTerm,
Serializable {
    private static final long serialVersionUID = 6455456999651546516L;
    private String name;
    private int index;
    private LogicalOperator operator;
    private static final BundleLogger LOGGER = BundleLoggerFactory.getLogger(FieldExpression.class);

    protected FieldExpressionTermImpl(String name, int index, LogicalOperator operator) throws FieldExpressionException {
        if (name.isEmpty()) {
            throw new FieldExpressionException(LOGGER.translate("VALIDATION_FIELD_EXP_TERM_NAME_EMPTY"));
        }
        if (!Validator.isValidFieldExpressionTerm(name)) {
            throw new FieldExpressionException(LOGGER.translate("VALIDATION_FIELD_EXP_INVALID_TERM_NAME", name));
        }
        this.name = name;
        this.index = index;
        this.operator = operator;
    }

    public static final FieldExpressionTerm parse(String term) throws FieldExpressionException {
        term = Validator.compactWhiteSpaces(term);
        LinkedList<Integer> openedSquareBrackets = new LinkedList<Integer>();
        int i = term.indexOf("[");
        while (i != -1) {
            openedSquareBrackets.add(i);
            i = term.indexOf("[", i + 1);
        }
        LinkedList<Integer> closedSquareBrackets = new LinkedList<Integer>();
        int i2 = term.indexOf("]");
        while (i2 != -1) {
            closedSquareBrackets.add(i2);
            i2 = term.indexOf("]", i2 + 1);
        }
        if (openedSquareBrackets.size() != closedSquareBrackets.size()) {
            throw new FieldExpressionException(LOGGER.translate("VALIDATION_FIELD_EXP_NUM_OF_BRACKETS", term));
        }
        if (openedSquareBrackets.size() > 1) {
            throw new FieldExpressionException(LOGGER.translate("VALIDATION_FIELD_EXP_MULTIPLE_INDEXES", term));
        }
        if (openedSquareBrackets.isEmpty()) {
            if (term.isEmpty()) {
                throw new FieldExpressionException(LOGGER.translate("VALIDATION_FIELD_EXP_TERM_NAME_EMPTY"));
            }
            if (term.indexOf("*") >= 0 || term.indexOf("?") >= 0) {
                throw new FieldExpressionException(LOGGER.translate("VALIDATION_FIELD_EXP_INVALID_CHARS", term));
            }
            return new FieldExpressionTermImpl(term, -1, null);
        }
        int i1 = (Integer)openedSquareBrackets.poll();
        int i22 = (Integer)closedSquareBrackets.poll();
        if (i1 == 0) {
            throw new FieldExpressionException(LOGGER.translate("VALIDATION_FIELD_EXP_TERM_NAME_IS_EMPTY"));
        }
        if (i22 < i1) {
            throw new FieldExpressionException(LOGGER.translate("VALIDATION_FIELD_EXP_INVALID_CLOSE_BRACKETS", term));
        }
        String index = term.substring(i1 + 1, i22).trim();
        if (index.isEmpty() || index.equals("*")) {
            return new FieldExpressionTermImpl(term.substring(0, i1), -1, LogicalOperator.AND);
        }
        if (index.equals("?")) {
            return new FieldExpressionTermImpl(term.substring(0, i1), -1, LogicalOperator.OR);
        }
        return new FieldExpressionTermImpl(term.substring(0, i1), Converter.convertToInteger(index, -1), null);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean hasOperator() {
        return this.operator != null;
    }

    @Override
    public LogicalOperator getOperator() {
        return this.operator;
    }

    @Override
    public boolean hasIndex() {
        return this.index != -1;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.name);
        if (this.hasIndex()) {
            sb.append("[").append(this.index).append("]");
        } else if (this.hasOperator()) {
            sb.append("[");
            switch (this.operator) {
                case AND: {
                    sb.append("*");
                    break;
                }
                case OR: {
                    sb.append("?");
                    break;
                }
                case NOT: {
                    sb.append("");
                }
            }
            sb.append("]");
        }
        return sb.toString();
    }
}

