/*
 * Decompiled with CFR 0.152.
 */
package com.esri.ges.core.geoevent;

import com.esri.ges.core.geoevent.FieldExpressionException;
import com.esri.ges.core.geoevent.FieldExpressionTerm;
import com.esri.ges.core.geoevent.FieldExpressionTermImpl;
import com.esri.ges.core.validation.ValidationException;
import com.esri.ges.framework.i18n.BundleLogger;
import com.esri.ges.framework.i18n.BundleLoggerFactory;
import com.esri.ges.util.Validator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.lang3.text.StrLookup;
import org.apache.commons.lang3.text.StrSubstitutor;

public class FieldExpression
implements List<FieldExpressionTerm>,
Serializable {
    private static final long serialVersionUID = -7763589376768307596L;
    private List<FieldExpressionTerm> terms = new LinkedList<FieldExpressionTerm>();
    private String expression;
    private String errorMessage;
    private static final BundleLogger LOGGER = BundleLoggerFactory.getLogger(FieldExpression.class);

    public FieldExpression(String expression) {
        this.expression = Validator.compactWhiteSpaces(expression);
        this.errorMessage = "";
        ArrayList<String> errors = new ArrayList<String>();
        for (String term : this.expression.split("\\.")) {
            try {
                this.terms.add(FieldExpressionTermImpl.parse(term));
            }
            catch (FieldExpressionException e) {
                errors.add(e.getMessage());
            }
        }
        if (errors.size() > 0) {
            StringBuffer sb = new StringBuffer(LOGGER.translate("FIELD_EXP_INVALID_HEADER", expression));
            for (String error : errors) {
                sb.append("\n").append(error);
            }
            this.errorMessage = sb.toString();
            this.terms.clear();
        }
    }

    public boolean isValid() {
        return this.errorMessage.isEmpty();
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    public boolean add(FieldExpressionTerm e) {
        return this.terms.add(e);
    }

    @Override
    public void add(int index, FieldExpressionTerm element) {
        this.terms.add(index, element);
    }

    @Override
    public boolean addAll(Collection<? extends FieldExpressionTerm> c) {
        return this.terms.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends FieldExpressionTerm> c) {
        return this.terms.addAll(index, c);
    }

    @Override
    public void clear() {
        this.terms.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.terms.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.terms.containsAll(c);
    }

    @Override
    public FieldExpressionTerm get(int index) {
        return this.terms.get(index);
    }

    @Override
    public int indexOf(Object o) {
        return this.terms.indexOf(o);
    }

    @Override
    public boolean isEmpty() {
        return this.terms.isEmpty();
    }

    @Override
    public Iterator<FieldExpressionTerm> iterator() {
        return this.terms.iterator();
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.terms.lastIndexOf(o);
    }

    @Override
    public ListIterator<FieldExpressionTerm> listIterator() {
        return this.terms.listIterator();
    }

    @Override
    public ListIterator<FieldExpressionTerm> listIterator(int index) {
        return this.terms.listIterator(index);
    }

    @Override
    public boolean remove(Object o) {
        return this.terms.remove(o);
    }

    @Override
    public FieldExpressionTerm remove(int index) {
        return this.terms.remove(index);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.terms.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.terms.retainAll(c);
    }

    @Override
    public FieldExpressionTerm set(int index, FieldExpressionTerm element) {
        return this.terms.set(index, element);
    }

    @Override
    public int size() {
        return this.terms.size();
    }

    @Override
    public List<FieldExpressionTerm> subList(int fromIndex, int toIndex) {
        return this.terms.subList(fromIndex, toIndex);
    }

    @Override
    public Object[] toArray() {
        return this.terms.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.terms.toArray(a);
    }

    public static FieldExpression parse(String s) throws ValidationException {
        final ArrayList fes = new ArrayList();
        StrSubstitutor subs = new StrSubstitutor((StrLookup)new StrLookup<String>(){

            public String lookup(String key) {
                fes.add(new FieldExpression(key));
                return "";
            }
        });
        String fe = Validator.compactWhiteSpaces(s);
        String result = subs.replace(fe).trim();
        if (fes.isEmpty()) {
            FieldExpression exp = new FieldExpression(result);
            if (exp.isValid()) {
                return exp;
            }
        } else if (fes.size() == 1 && ((FieldExpression)fes.get(0)).isValid() && result.isEmpty()) {
            return (FieldExpression)fes.get(0);
        }
        throw new ValidationException(LOGGER.translate("FIELD_EXP_INVALID", fe));
    }

    public String toString() {
        if (this.isValid()) {
            StringBuffer sb = new StringBuffer();
            for (FieldExpressionTerm term : this.terms) {
                if (sb.length() != 0) {
                    sb.append(".");
                }
                sb.append(term.toString());
            }
            return sb.toString();
        }
        return this.expression;
    }
}

