/*
 * Decompiled with CFR 0.152.
 */
package com.esri.ges.core.geoevent;

import com.esri.ges.core.AccessType;
import com.esri.ges.core.ConfigurationException;
import com.esri.ges.core.geoevent.FieldCardinality;
import com.esri.ges.core.geoevent.FieldDefinition;
import com.esri.ges.core.geoevent.FieldExpression;
import com.esri.ges.core.geoevent.FieldExpressionTerm;
import com.esri.ges.core.geoevent.FieldType;
import com.esri.ges.core.geoevent.GeoEventDefinition;
import com.esri.ges.core.validation.ValidationException;
import com.esri.ges.framework.i18n.BundleLogger;
import com.esri.ges.framework.i18n.BundleLoggerFactory;
import com.esri.ges.util.Converter;
import com.esri.ges.util.Validator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.UUID;

public class DefaultGeoEventDefinition
implements GeoEventDefinition {
    private static final long serialVersionUID = -4747911547174480363L;
    private String name;
    private String owner;
    private AccessType accessType = AccessType.editable;
    private UUID guid;
    private FieldDefinition[] fieldDefinitions;
    private final Map<String, Integer> indexes = new HashMap<String, Integer>();
    private final Map<String, List<FieldExpression>> tags = new HashMap<String, List<FieldExpression>>();
    private static BundleLogger LOGGER = BundleLoggerFactory.getLogger(DefaultGeoEventDefinition.class);

    public DefaultGeoEventDefinition() {
        this.clearFieldDefinitions();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = Validator.compactSpaces(name);
    }

    @Override
    public String getOwner() {
        return this.owner;
    }

    @Override
    public void setOwner(String owner) {
        this.owner = Validator.compactSpaces(owner);
    }

    @Override
    public AccessType getAccessType() {
        return this.accessType;
    }

    @Override
    public void setAccessType(AccessType accessType) {
        this.accessType = accessType;
    }

    @Override
    public UUID getGuidObject() {
        if (this.guid == null) {
            this.guid = UUID.randomUUID();
        }
        return this.guid;
    }

    @Override
    public String getGuid() {
        return this.getGuidObject().toString();
    }

    @Override
    public void setGuid(String guid) {
        this.guid = Converter.convert(guid);
    }

    @Override
    public synchronized FieldDefinition[] getFieldDefinitionsArray() {
        return this.fieldDefinitions;
    }

    @Override
    public synchronized List<FieldDefinition> getFieldDefinitions() {
        return this.fieldDefinitions != null ? Arrays.asList(this.fieldDefinitions) : null;
    }

    @Override
    public synchronized void setFieldDefinitions(List<FieldDefinition> fieldDefinitions) {
        this.clearFieldDefinitions();
        if (fieldDefinitions != null && fieldDefinitions.size() > 0) {
            this.fieldDefinitions = new FieldDefinition[fieldDefinitions.size()];
            fieldDefinitions.toArray(this.fieldDefinitions);
            for (int i = 0; i < this.fieldDefinitions.length; ++i) {
                FieldDefinition fd = this.fieldDefinitions[i];
                this.indexes.put(fd.getName(), i);
                if (fd.getTags() != null) {
                    for (String tag : fd.getTags()) {
                        this.indexes.put(tag, i);
                    }
                }
                this.buildFieldExpressionsForTags(fd, "");
            }
        }
    }

    private void buildFieldExpressionsForTags(FieldDefinition fd, String lineage) {
        String expression = lineage + fd.getName() + (FieldCardinality.Many.equals((Object)fd.getCardinality()) ? "[0]" : "");
        if (FieldType.Group.equals((Object)fd.getType())) {
            for (FieldDefinition child : fd.getChildren()) {
                this.buildFieldExpressionsForTags(child, expression + ".");
            }
        }
        if (fd.getTags() != null) {
            for (String tag : fd.getTags()) {
                if (!this.tags.containsKey(tag)) {
                    this.tags.put(tag, new ArrayList());
                }
                this.tags.get(tag).add(new FieldExpression(expression));
            }
        }
    }

    @Override
    public FieldDefinition getFieldDefinition(String fieldName) {
        if (this.indexes.containsKey(fieldName)) {
            return this.fieldDefinitions[this.indexes.get(fieldName)];
        }
        int index = fieldName.indexOf(".");
        if (index == -1) {
            return null;
        }
        String prefix = fieldName.substring(0, index);
        String suffix = fieldName.substring(index + 1);
        if (this.indexes.containsKey(prefix)) {
            FieldDefinition fd = this.fieldDefinitions[this.indexes.get(prefix)];
            if (fd.getType() != FieldType.Group) {
                return null;
            }
            return this.searchChildrenForField(fd.getChildren(), suffix);
        }
        return null;
    }

    private FieldDefinition searchChildrenForField(List<FieldDefinition> children, String fieldName) {
        if (children == null) {
            return null;
        }
        for (FieldDefinition child : children) {
            if (!child.getName().equals(fieldName)) continue;
            return child;
        }
        int index = fieldName.indexOf(".");
        if (index == -1) {
            return null;
        }
        String prefix = fieldName.substring(0, index);
        String suffix = fieldName.substring(index + 1);
        for (FieldDefinition child : children) {
            if (!child.getName().equals(prefix)) continue;
            return this.searchChildrenForField(child.getChildren(), suffix);
        }
        return null;
    }

    @Override
    @Deprecated
    public int getTrackId() {
        return this.getIndexOf("TRACK_ID");
    }

    @Override
    @Deprecated
    public int getGeometryId() {
        return this.getIndexOf("GEOMETRY");
    }

    @Override
    @Deprecated
    public int getStartTimeId() {
        return this.getIndexOf("TIME_START");
    }

    @Override
    public boolean isTaggedWithTrackId() {
        return this.isTaggedWith("TRACK_ID");
    }

    @Override
    public boolean isTaggedWithGeometry() {
        return this.isTaggedWith("GEOMETRY");
    }

    @Override
    public boolean isTaggedWithStartTime() {
        return this.isTaggedWith("TIME_START");
    }

    @Override
    public boolean isTaggedWithEndTime() {
        return this.isTaggedWith("TIME_END");
    }

    @Override
    public int getIndexOf(String name) {
        return this.indexes.containsKey(name) ? this.indexes.get(name) : -1;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        DefaultGeoEventDefinition ed = new DefaultGeoEventDefinition();
        ed.setName(this.name);
        ed.setOwner(this.owner);
        ArrayList<FieldDefinition> fds = new ArrayList<FieldDefinition>();
        for (FieldDefinition fd : this.fieldDefinitions) {
            fds.add((FieldDefinition)fd.clone());
        }
        ed.setFieldDefinitions(fds);
        return ed;
    }

    @Override
    public GeoEventDefinition augment(List<FieldDefinition> fds) throws ConfigurationException {
        try {
            GeoEventDefinition aed = (GeoEventDefinition)this.clone();
            aed.setName(this.name);
            aed.setOwner(this.owner);
            ArrayList<FieldDefinition> afds = new ArrayList<FieldDefinition>();
            for (FieldDefinition fd : this.fieldDefinitions) {
                afds.add((FieldDefinition)fd.clone());
            }
            if (fds != null && fds.size() > 0) {
                for (FieldDefinition fd : fds) {
                    afds.add((FieldDefinition)fd.clone());
                }
            }
            aed.setFieldDefinitions(afds);
            return aed;
        }
        catch (CloneNotSupportedException e) {
            throw new ConfigurationException(LOGGER.translate("GED_AUGMENT_FAILED", e.getMessage()));
        }
    }

    @Override
    public GeoEventDefinition reduce(List<String> fields) throws ConfigurationException {
        try {
            DefaultGeoEventDefinition red = new DefaultGeoEventDefinition();
            red.setName(this.name);
            red.setOwner(this.owner);
            ArrayList<FieldDefinition> rfds = new ArrayList<FieldDefinition>();
            for (FieldDefinition fd : this.fieldDefinitions) {
                if (this.indexOfIgnoreCase(fd.getName(), fields) != -1) continue;
                rfds.add((FieldDefinition)fd.clone());
            }
            red.setFieldDefinitions(rfds);
            return red;
        }
        catch (CloneNotSupportedException e) {
            throw new ConfigurationException(LOGGER.translate("GED_REDUCE_FAILED", e.getMessage()));
        }
    }

    private int indexOfIgnoreCase(String field, List<String> fields) {
        if (fields != null && fields.size() > 0) {
            for (int i = 0; i < fields.size(); ++i) {
                if (!field.equalsIgnoreCase(fields.get(i))) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.name);
        sb.append(": ");
        if (this.fieldDefinitions != null) {
            for (FieldDefinition ad : this.fieldDefinitions) {
                sb.append(ad.toString() + " ");
            }
        }
        return sb.toString();
    }

    public String toFeatureJson() {
        StringBuffer buf = new StringBuffer();
        buf.append("{");
        buf.append("}");
        return buf.toString();
    }

    @Override
    public void clearFieldDefinitions() {
        this.fieldDefinitions = null;
        this.indexes.clear();
        this.tags.clear();
    }

    @Override
    public FieldDefinition getFieldDefinition(FieldExpression expression) {
        if (expression != null && expression.isValid()) {
            List<FieldExpression> fes;
            FieldExpression fe = expression;
            if (this.isTaggedWith(fe.toString()) && !Validator.isEmpty(fes = this.getTagFieldExpressions(fe.toString()))) {
                fe = fes.get(0);
            }
            if (this.isFieldExist(fe)) {
                ListIterator<FieldExpressionTerm> iterator = fe.listIterator();
                while (iterator.hasNext()) {
                    int i = this.getIndexOf(iterator.next().getName());
                    if (i == -1) continue;
                    return this.getFieldDefinition(this.fieldDefinitions[i], iterator);
                }
            }
        }
        return null;
    }

    private FieldDefinition getFieldDefinition(FieldDefinition fd, ListIterator<FieldExpressionTerm> iterator) {
        FieldExpressionTerm term = iterator.previous();
        iterator.next();
        switch (fd.getType()) {
            case Group: {
                if (!iterator.hasNext()) break;
                String nextTermName = iterator.next().getName();
                if (!FieldCardinality.One.equals((Object)fd.getCardinality()) && (!FieldCardinality.Many.equals((Object)fd.getCardinality()) || term.hasOperator() || !term.hasIndex())) break;
                for (FieldDefinition gfd : fd.getChildren()) {
                    if (!gfd.getName().equals(nextTermName)) continue;
                    return this.getFieldDefinition(gfd, iterator);
                }
                break;
            }
            default: {
                return fd;
            }
        }
        return null;
    }

    @Override
    public boolean isFieldExist(FieldExpression expression) {
        if (expression != null && expression.isValid()) {
            ListIterator<FieldExpressionTerm> iterator = expression.listIterator();
            while (iterator.hasNext()) {
                int i = this.getIndexOf(iterator.next().getName());
                if (i == -1) continue;
                return this.isFieldExist(this.getFieldDefinitions().get(i), iterator);
            }
        }
        return false;
    }

    private boolean isFieldExist(FieldDefinition fd, ListIterator<FieldExpressionTerm> iterator) {
        FieldExpressionTerm term = iterator.previous();
        iterator.next();
        switch (fd.getType()) {
            case Group: {
                if (!iterator.hasNext()) break;
                FieldExpressionTerm nextTerm = iterator.next();
                if (!FieldCardinality.One.equals((Object)fd.getCardinality()) && (!FieldCardinality.Many.equals((Object)fd.getCardinality()) || term.hasOperator() || !term.hasIndex())) break;
                for (FieldDefinition gfd : fd.getChildren()) {
                    if (!gfd.getName().equals(nextTerm.getName())) continue;
                    return this.isFieldExist(gfd, iterator);
                }
                break;
            }
            default: {
                return FieldCardinality.Many.equals((Object)fd.getCardinality()) ? term.hasIndex() : true;
            }
        }
        return false;
    }

    @Override
    public boolean isTaggedWith(String tagName) {
        return this.tags.containsKey(tagName);
    }

    @Override
    public void removeTag(String meta) {
        this.removeTag(this.getFieldDefinitions(), meta);
    }

    private void removeTag(List<FieldDefinition> fds, String tagToRemove) {
        for (FieldDefinition fd : fds) {
            if (FieldType.Group.equals((Object)fd.getType())) {
                this.removeTag(fd.getChildren(), tagToRemove);
                continue;
            }
            if (!fd.getTags().contains(tagToRemove)) continue;
            fd.removeTag(tagToRemove);
        }
    }

    @Override
    public List<String> getTagNames() {
        ArrayList<String> tags = new ArrayList<String>();
        for (String tag : this.tags.keySet()) {
            tags.add(tag);
        }
        return tags;
    }

    @Override
    public List<FieldExpression> getTagFieldExpressions(String tagName) {
        if (this.isTaggedWith(tagName)) {
            ArrayList<FieldExpression> fes = new ArrayList<FieldExpression>();
            for (FieldExpression fe : this.tags.get(tagName)) {
                fes.add(fe);
            }
            return fes;
        }
        return null;
    }

    @Override
    public void validate() throws ValidationException {
        if (!Validator.isValidGeoEventDefinitionName(this.getName())) {
            throw new ValidationException(LOGGER.translate("GED_INVALID", this.getName()));
        }
        if (this.fieldDefinitions != null) {
            this.validateDuplicateField(this.fieldDefinitions);
            for (int i = 0; i < this.fieldDefinitions.length; ++i) {
                this.fieldDefinitions[i].validate();
            }
        }
    }

    private void validateDuplicateField(FieldDefinition[] fds) throws ValidationException {
        HashSet<String> names = new HashSet<String>();
        for (int i = 0; i < fds.length; ++i) {
            String fieldname;
            FieldDefinition[] subfds;
            if (fds[i].getType() == FieldType.Group && (subfds = fds[i].getChildren().toArray(new FieldDefinition[fds[i].getChildren().size()])) != null) {
                this.validateDuplicateField(subfds);
            }
            if (names.contains((fieldname = fds[i].getName()).toLowerCase())) {
                throw new ValidationException(LOGGER.translate("GED_DUPLICATE_FIELDS", this.getName()));
            }
            names.add(fieldname.toLowerCase());
        }
    }
}

