/*
 * Decompiled with CFR 0.152.
 */
package com.esri.ges.core.geoevent;

import com.esri.ges.core.ConfigurationException;
import com.esri.ges.core.geoevent.FieldCardinality;
import com.esri.ges.core.geoevent.FieldDefinition;
import com.esri.ges.core.geoevent.FieldType;
import com.esri.ges.core.validation.ValidationException;
import com.esri.ges.framework.i18n.BundleLogger;
import com.esri.ges.framework.i18n.BundleLoggerFactory;
import com.esri.ges.util.Converter;
import com.esri.ges.util.Validator;
import java.util.ArrayList;
import java.util.List;

public class DefaultFieldDefinition
implements FieldDefinition {
    private static final long serialVersionUID = 2834174224965842444L;
    private String name;
    private FieldType type;
    private FieldCardinality cardinality;
    private final List<String> tags = new ArrayList<String>();
    private List<FieldDefinition> children = null;
    private static BundleLogger LOGGER = BundleLoggerFactory.getLogger(DefaultFieldDefinition.class);

    public DefaultFieldDefinition(String name, FieldType type, String ... tags) throws ConfigurationException {
        this.setName(name);
        this.setType(type);
        if (type == FieldType.Group) {
            this.children = new ArrayList<FieldDefinition>();
        }
        this.setCardinality(FieldCardinality.One);
        if (tags != null && tags.length > 0) {
            for (String tag : tags) {
                if (this.tags.indexOf(tag) != -1) continue;
                this.tags.add(tag);
            }
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) throws ConfigurationException {
        this.name = Validator.compactSpaces(name);
        if (this.name.isEmpty()) {
            throw new ConfigurationException(LOGGER.translate("FIELD_DEF_NAME_EMPTY"));
        }
        if (!Validator.isValidFieldDefinitionName(name)) {
            throw new ConfigurationException(LOGGER.translate("FIELD_DEF_NAME_INVALID", name));
        }
    }

    @Override
    public FieldType getType() {
        return this.type;
    }

    @Override
    public void setType(FieldType type) throws ConfigurationException {
        if (type == null) {
            throw new ConfigurationException(LOGGER.translate("FIELD_DEF_INVALID_TYPE"));
        }
        this.type = type;
        if (type == FieldType.Group) {
            if (this.children == null) {
                this.children = new ArrayList<FieldDefinition>();
            }
        } else if (this.children != null) {
            this.children.clear();
        }
    }

    @Override
    public Object validateValue(Object value) {
        switch (this.type) {
            case Geometry: 
            case String: {
                return Converter.convertToString(value);
            }
            case Boolean: {
                return Converter.convertToBoolean(value);
            }
            case Double: {
                return Converter.convertToDouble(value);
            }
            case Float: {
                return Converter.convertToFloat(value);
            }
            case Long: {
                return Converter.convertToLong(value);
            }
            case Integer: {
                return Converter.convertToInteger(value);
            }
            case Short: {
                return Converter.convertToShort(value);
            }
            case Date: {
                return Converter.convertToDate(value);
            }
        }
        return null;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        try {
            DefaultFieldDefinition ad = new DefaultFieldDefinition(this.name, this.type, new String[0]);
            ad.setCardinality(this.cardinality);
            if (this.children != null && !this.children.isEmpty()) {
                for (FieldDefinition fd : this.children) {
                    ad.addChild((FieldDefinition)fd.clone());
                }
            }
            for (String tag : this.tags) {
                ad.addTag(tag);
            }
            return ad;
        }
        catch (ConfigurationException e) {
            throw new CloneNotSupportedException(LOGGER.translate("FIELD_DEF_CLONING_FAILED", e.getMessage()));
        }
    }

    @Override
    public FieldCardinality getCardinality() {
        return this.cardinality;
    }

    @Override
    public void setCardinality(FieldCardinality cardinality) throws ConfigurationException {
        this.cardinality = cardinality;
    }

    @Override
    public List<String> getTags() {
        return this.tags;
    }

    @Override
    public void addTag(String tag) {
        if (tag != null && !tag.isEmpty()) {
            for (String m : this.tags) {
                if (!m.equalsIgnoreCase(tag)) continue;
                return;
            }
        }
        this.tags.add(tag);
    }

    @Override
    public boolean hasTag(String tag) {
        List<String> tags = this.getTags();
        if (tags != null) {
            for (String thisTag : tags) {
                if (!thisTag.equals(tag)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void removeTag(String tag) {
        if (tag != null && !tag.isEmpty()) {
            for (String m : this.tags) {
                if (!m.equalsIgnoreCase(tag)) continue;
                this.tags.remove(m);
                break;
            }
        }
    }

    @Override
    public List<FieldDefinition> getChildren() {
        return this.children;
    }

    @Override
    public void addChild(FieldDefinition child) {
        if (child != null) {
            this.children.add(child);
        }
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.name);
        sb.append("<");
        sb.append((Object)this.type);
        sb.append(",");
        sb.append((Object)this.cardinality);
        sb.append(">");
        return sb.toString();
    }

    @Override
    public void validate() throws ValidationException {
        if (!Validator.isValidFieldDefinitionName(this.getName())) {
            throw new ValidationException(LOGGER.translate("FIELD_DEF_NAME_INVALID", this.getName()));
        }
        if (this.getChildren() != null) {
            for (FieldDefinition child : this.getChildren()) {
                child.validate();
            }
        }
    }
}

