/*
 * Decompiled with CFR 0.152.
 */
package com.esri.ges.core;

import com.esri.ges.framework.i18n.BundleLogger;
import com.esri.ges.framework.i18n.BundleLoggerFactory;
import java.io.InputStream;
import java.util.Properties;

public final class Version {
    private static final BundleLogger LOGGER = BundleLoggerFactory.getLogger(Version.class);
    private static int MAJOR_VERSION;
    private static int MINOR_VERSION;
    private static int INCREMENTAL_VERSION;
    private static int BUILD_NUMBER;
    private static String PROJECT_VERSION;
    private static String FULL_VERSION;
    private static double VERSION_AS_DOUBLE;
    private static String BUILD_ID;

    private Version() {
    }

    public static int getMajorVersion() {
        return MAJOR_VERSION;
    }

    public static int getMinorVersion() {
        return MINOR_VERSION;
    }

    public static String getProjectVersion() {
        return PROJECT_VERSION;
    }

    public static String getFullVersion() {
        return FULL_VERSION;
    }

    public static double getFullNumericVersion() {
        return VERSION_AS_DOUBLE;
    }

    public static String getBuildId() {
        return BUILD_ID;
    }

    public static int getBuildNumber() {
        return BUILD_NUMBER;
    }

    static {
        BUILD_NUMBER = 0;
        InputStream is = Version.class.getResourceAsStream("/version.properties");
        if (is != null) {
            Properties props = new Properties();
            try {
                props.load(is);
                MAJOR_VERSION = Integer.parseInt(props.getProperty("majorVersion"));
                MINOR_VERSION = Integer.parseInt(props.getProperty("minorVersion"));
                INCREMENTAL_VERSION = Integer.parseInt(props.getProperty("incrementalVersion"));
                PROJECT_VERSION = MAJOR_VERSION + "." + MINOR_VERSION + "." + INCREMENTAL_VERSION;
                FULL_VERSION = MAJOR_VERSION + "." + MINOR_VERSION + "" + INCREMENTAL_VERSION;
                VERSION_AS_DOUBLE = Double.parseDouble(FULL_VERSION);
                BUILD_ID = props.getProperty("buildId");
                String[] parts = BUILD_ID.split("\\.");
                if (parts.length == 4) {
                    try {
                        BUILD_NUMBER = Integer.parseInt(parts[3]);
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            }
            catch (Throwable t) {
                LOGGER.error("", t);
            }
        }
    }
}

