/*
 * Decompiled with CFR 0.152.
 */
package com.esri.ges.adapter;

import com.esri.ges.adapter.AdapterBase;
import com.esri.ges.adapter.AdapterDefinition;
import com.esri.ges.adapter.AdapterType;
import com.esri.ges.adapter.OutboundAdapter;
import com.esri.ges.core.component.ComponentException;
import com.esri.ges.core.geoevent.GeoEvent;
import com.esri.ges.framework.i18n.BundleLogger;
import com.esri.ges.framework.i18n.BundleLoggerFactory;
import com.esri.ges.messaging.GeoEventAwareByteListener;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;

public abstract class OutboundAdapterBase
extends AdapterBase
implements OutboundAdapter {
    private GeoEventAwareByteListener byteListener = null;
    private static final BundleLogger LOGGER = BundleLoggerFactory.getLogger(OutboundAdapterBase.class);

    public OutboundAdapterBase(AdapterDefinition definition) throws ComponentException {
        super(definition);
        if (definition.getAdapterType() == null || !definition.getAdapterType().equals((Object)AdapterType.OUTBOUND)) {
            throw new ComponentException(LOGGER.translate("ADAPTER_INIT_ERROR", this.getClass().getName()));
        }
    }

    @Override
    public boolean isByteListenerAvailable() {
        return this.byteListener != null;
    }

    @Override
    public void setByteListener(GeoEventAwareByteListener byteListener) {
        this.byteListener = byteListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void receive(ByteBuffer buffer, String channelId, GeoEvent geoEvent) {
        if (this.isByteListenerAvailable()) {
            GeoEventAwareByteListener geoEventAwareByteListener = this.byteListener;
            synchronized (geoEventAwareByteListener) {
                this.byteListener.receive(buffer, channelId, geoEvent);
            }
        } else {
            LOGGER.info("OUTPUT_MSG_INFO");
        }
    }

    @Override
    public byte[] processData(Map<String, List<GeoEvent>> geoevents) throws ComponentException {
        throw new ComponentException(LOGGER.translate("METHOD_NOT_IMPLEMENTED", "processData"));
    }

    @Override
    public String getMIMEType() throws ComponentException {
        throw new ComponentException(LOGGER.translate("METHOD_NOT_IMPLEMENTED", "getMIMEType"));
    }
}

