/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry.ogc;

import com.esri.core.geometry.Envelope;
import com.esri.core.geometry.Envelope1D;
import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.GeometryCollection;
import com.esri.core.geometry.GeometryCursor;
import com.esri.core.geometry.GeometryCursorAppend;
import com.esri.core.geometry.GeometryEngine;
import com.esri.core.geometry.JsonGeometryException;
import com.esri.core.geometry.JsonParserReader;
import com.esri.core.geometry.MapGeometry;
import com.esri.core.geometry.MapOGCStructure;
import com.esri.core.geometry.MultiPoint;
import com.esri.core.geometry.NumberUtils;
import com.esri.core.geometry.OGCStructure;
import com.esri.core.geometry.OperatorBuffer;
import com.esri.core.geometry.OperatorConvexHull;
import com.esri.core.geometry.OperatorExportToGeoJson;
import com.esri.core.geometry.OperatorExportToWkb;
import com.esri.core.geometry.OperatorImportFromESRIShape;
import com.esri.core.geometry.OperatorImportFromGeoJson;
import com.esri.core.geometry.OperatorImportFromWkb;
import com.esri.core.geometry.OperatorImportFromWkt;
import com.esri.core.geometry.OperatorIntersection;
import com.esri.core.geometry.OperatorSimplify;
import com.esri.core.geometry.OperatorSimplifyOGC;
import com.esri.core.geometry.OperatorUnion;
import com.esri.core.geometry.Point;
import com.esri.core.geometry.Polygon;
import com.esri.core.geometry.Polyline;
import com.esri.core.geometry.SimpleGeometryCursor;
import com.esri.core.geometry.SpatialReference;
import com.esri.core.geometry.ogc.OGCConcreteGeometryCollection;
import com.esri.core.geometry.ogc.OGCLineString;
import com.esri.core.geometry.ogc.OGCMultiLineString;
import com.esri.core.geometry.ogc.OGCMultiPoint;
import com.esri.core.geometry.ogc.OGCMultiPolygon;
import com.esri.core.geometry.ogc.OGCPoint;
import com.esri.core.geometry.ogc.OGCPolygon;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Stack;

public abstract class OGCGeometry {
    public SpatialReference esriSR;

    public int dimension() {
        return this.getEsriGeometry().getDimension();
    }

    public int coordinateDimension() {
        int d = 2;
        if (this.getEsriGeometry().getDescription().hasAttribute(2)) {
            ++d;
        }
        if (this.getEsriGeometry().getDescription().hasAttribute(1)) {
            ++d;
        }
        return d;
    }

    public abstract String geometryType();

    public int SRID() {
        if (this.esriSR == null) {
            return 0;
        }
        return this.esriSR.getID();
    }

    public OGCGeometry envelope() {
        Envelope env = new Envelope();
        this.getEsriGeometry().queryEnvelope(env);
        Polygon polygon = new Polygon();
        polygon.addEnvelope(env, false);
        return new OGCPolygon(polygon, this.esriSR);
    }

    public String asText() {
        return GeometryEngine.geometryToWkt(this.getEsriGeometry(), 0);
    }

    public ByteBuffer asBinary() {
        return OperatorExportToWkb.local().execute(0, this.getEsriGeometry(), null);
    }

    public String asGeoJson() {
        return OperatorExportToGeoJson.local().execute(this.esriSR, this.getEsriGeometry());
    }

    String asGeoJsonImpl(int export_flags) {
        return OperatorExportToGeoJson.local().execute(export_flags, this.esriSR, this.getEsriGeometry());
    }

    public String asJson() {
        return GeometryEngine.geometryToJson(this.esriSR, this.getEsriGeometry());
    }

    public boolean isEmpty() {
        return this.getEsriGeometry().isEmpty();
    }

    public double MinZ() {
        Envelope1D e = this.getEsriGeometry().queryInterval(1, 0);
        return e.vmin;
    }

    public double MaxZ() {
        Envelope1D e = this.getEsriGeometry().queryInterval(1, 0);
        return e.vmax;
    }

    public double MinMeasure() {
        Envelope1D e = this.getEsriGeometry().queryInterval(2, 0);
        return e.vmin;
    }

    public double MaxMeasure() {
        Envelope1D e = this.getEsriGeometry().queryInterval(2, 0);
        return e.vmax;
    }

    public boolean isSimple() {
        return OperatorSimplifyOGC.local().isSimpleOGC(this.getEsriGeometry(), this.esriSR, true, null, null);
    }

    public boolean isSimpleRelaxed() {
        return OperatorSimplify.local().isSimpleAsFeature(this.getEsriGeometry(), this.esriSR, true, null, null);
    }

    @Deprecated
    public OGCGeometry MakeSimpleRelaxed(boolean forceProcessing) {
        return this.makeSimpleRelaxed(forceProcessing);
    }

    public OGCGeometry makeSimpleRelaxed(boolean forceProcessing) {
        return OGCGeometry.createFromEsriGeometry(OperatorSimplify.local().execute(this.getEsriGeometry(), this.esriSR, forceProcessing, null), this.esriSR);
    }

    public OGCGeometry makeSimple() {
        return this.simplifyBunch_(this.getEsriGeometryCursor());
    }

    public boolean is3D() {
        return this.getEsriGeometry().getDescription().hasAttribute(1);
    }

    public boolean isMeasured() {
        return this.getEsriGeometry().getDescription().hasAttribute(2);
    }

    public abstract OGCGeometry boundary();

    public boolean Equals(OGCGeometry another) {
        if (this == another) {
            return true;
        }
        if (another == null) {
            return false;
        }
        Geometry geom1 = this.getEsriGeometry();
        Geometry geom2 = another.getEsriGeometry();
        return GeometryEngine.equals(geom1, geom2, this.getEsriSpatialReference());
    }

    public boolean disjoint(OGCGeometry another) {
        Geometry geom1 = this.getEsriGeometry();
        Geometry geom2 = another.getEsriGeometry();
        return GeometryEngine.disjoint(geom1, geom2, this.getEsriSpatialReference());
    }

    public boolean intersects(OGCGeometry another) {
        return !this.disjoint(another);
    }

    public boolean touches(OGCGeometry another) {
        Geometry geom1 = this.getEsriGeometry();
        Geometry geom2 = another.getEsriGeometry();
        return GeometryEngine.touches(geom1, geom2, this.getEsriSpatialReference());
    }

    public boolean crosses(OGCGeometry another) {
        Geometry geom1 = this.getEsriGeometry();
        Geometry geom2 = another.getEsriGeometry();
        return GeometryEngine.crosses(geom1, geom2, this.getEsriSpatialReference());
    }

    public boolean within(OGCGeometry another) {
        Geometry geom1 = this.getEsriGeometry();
        Geometry geom2 = another.getEsriGeometry();
        return GeometryEngine.within(geom1, geom2, this.getEsriSpatialReference());
    }

    public boolean contains(OGCGeometry another) {
        Geometry geom1 = this.getEsriGeometry();
        Geometry geom2 = another.getEsriGeometry();
        return GeometryEngine.contains(geom1, geom2, this.getEsriSpatialReference());
    }

    public boolean overlaps(OGCGeometry another) {
        Geometry geom1 = this.getEsriGeometry();
        Geometry geom2 = another.getEsriGeometry();
        return GeometryEngine.overlaps(geom1, geom2, this.getEsriSpatialReference());
    }

    public boolean relate(OGCGeometry another, String matrix) {
        Geometry geom1 = this.getEsriGeometry();
        Geometry geom2 = another.getEsriGeometry();
        return GeometryEngine.relate(geom1, geom2, this.getEsriSpatialReference(), matrix);
    }

    public abstract OGCGeometry locateAlong(double var1);

    public abstract OGCGeometry locateBetween(double var1, double var3);

    public double distance(OGCGeometry another) {
        Geometry geom1 = this.getEsriGeometry();
        Geometry geom2 = another.getEsriGeometry();
        return GeometryEngine.distance(geom1, geom2, this.getEsriSpatialReference());
    }

    private OGCGeometry simplifyBunch_(GeometryCursor gc) {
        Geometry resMP;
        GeometryCursor res;
        Geometry resMP2;
        MultiPoint dstMultiPoint = null;
        ArrayList<Geometry> dstPolylines = new ArrayList<Geometry>();
        ArrayList<Geometry> dstPolygons = new ArrayList<Geometry>();
        Geometry g = gc.next();
        while (g != null) {
            switch (g.getType()) {
                case Point: {
                    if (dstMultiPoint == null) {
                        dstMultiPoint = new MultiPoint();
                    }
                    dstMultiPoint.add((Point)g);
                    break;
                }
                case MultiPoint: {
                    if (dstMultiPoint == null) {
                        dstMultiPoint = new MultiPoint();
                    }
                    dstMultiPoint.add((MultiPoint)g, 0, -1);
                    break;
                }
                case Polyline: {
                    dstPolylines.add((Polyline)g.copy());
                    break;
                }
                case Polygon: {
                    dstPolygons.add((Polygon)g.copy());
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
            g = gc.next();
        }
        ArrayList<Geometry> result = new ArrayList<Geometry>(3);
        if (dstMultiPoint != null) {
            resMP2 = OperatorSimplifyOGC.local().execute(dstMultiPoint, this.esriSR, true, null);
            result.add(resMP2);
        }
        if (dstPolylines.size() > 0) {
            if (dstPolylines.size() == 1) {
                resMP2 = OperatorSimplifyOGC.local().execute((Geometry)dstPolylines.get(0), this.esriSR, true, null);
                result.add(resMP2);
            } else {
                res = OperatorUnion.local().execute(new SimpleGeometryCursor(dstPolylines), this.esriSR, null);
                Geometry resPolyline = res.next();
                resMP = OperatorSimplifyOGC.local().execute(resPolyline, this.esriSR, true, null);
                result.add(resMP);
            }
        }
        if (dstPolygons.size() > 0) {
            if (dstPolygons.size() == 1) {
                resMP2 = OperatorSimplifyOGC.local().execute((Geometry)dstPolygons.get(0), this.esriSR, true, null);
                result.add(resMP2);
            } else {
                res = OperatorUnion.local().execute(new SimpleGeometryCursor(dstPolygons), this.esriSR, null);
                Geometry resPolygon = res.next();
                resMP = OperatorSimplifyOGC.local().execute(resPolygon, this.esriSR, true, null);
                result.add(resMP);
            }
        }
        return OGCGeometry.createFromEsriCursor(new SimpleGeometryCursor(result), this.esriSR);
    }

    public OGCGeometry buffer(double distance) {
        if (distance == 0.0) {
            return this;
        }
        double[] d = new double[]{distance};
        GeometryCursor cursor = OperatorBuffer.local().execute(this.getEsriGeometryCursor(), this.getEsriSpatialReference(), d, true, null);
        return OGCGeometry.createFromEsriGeometry(cursor.next(), this.esriSR);
    }

    public OGCGeometry convexHull() {
        GeometryCursor cursor = OperatorConvexHull.local().execute(this.getEsriGeometryCursor(), true, null);
        return OGCGeometry.createFromEsriCursor(cursor, this.esriSR);
    }

    public OGCGeometry intersection(OGCGeometry another) {
        GeometryCursor cursor = OperatorIntersection.local().execute(this.getEsriGeometryCursor(), another.getEsriGeometryCursor(), this.getEsriSpatialReference(), null, 7);
        return OGCGeometry.createFromEsriCursor(cursor, this.esriSR, true);
    }

    public OGCGeometry union(OGCGeometry another) {
        GeometryCursorAppend ap = new GeometryCursorAppend(this.getEsriGeometryCursor(), another.getEsriGeometryCursor());
        GeometryCursor cursor = OperatorUnion.local().execute(ap, this.getEsriSpatialReference(), null);
        return OGCGeometry.createFromEsriCursor(cursor, this.esriSR);
    }

    public OGCGeometry difference(OGCGeometry another) {
        Geometry geom1 = this.getEsriGeometry();
        Geometry geom2 = another.getEsriGeometry();
        return OGCGeometry.createFromEsriGeometry(GeometryEngine.difference(geom1, geom2, this.getEsriSpatialReference()), this.esriSR);
    }

    public OGCGeometry symDifference(OGCGeometry another) {
        Geometry geom1 = this.getEsriGeometry();
        Geometry geom2 = another.getEsriGeometry();
        return OGCGeometry.createFromEsriGeometry(GeometryEngine.symmetricDifference(geom1, geom2, this.getEsriSpatialReference()), this.esriSR);
    }

    public abstract Geometry getEsriGeometry();

    public GeometryCursor getEsriGeometryCursor() {
        return new SimpleGeometryCursor(this.getEsriGeometry());
    }

    public SpatialReference getEsriSpatialReference() {
        return this.esriSR;
    }

    public static OGCGeometry createFromEsriCursor(GeometryCursor gc, SpatialReference sr) {
        return OGCGeometry.createFromEsriCursor(gc, sr, false);
    }

    public static OGCGeometry createFromEsriCursor(GeometryCursor gc, SpatialReference sr, boolean skipEmpty) {
        ArrayList<OGCGeometry> geoms = new ArrayList<OGCGeometry>(10);
        Geometry emptyGeom = null;
        Geometry g = gc.next();
        while (g != null) {
            emptyGeom = g;
            if (!skipEmpty || !g.isEmpty()) {
                geoms.add(OGCGeometry.createFromEsriGeometry(g, sr));
            }
            g = gc.next();
        }
        if (geoms.size() == 1) {
            return (OGCGeometry)geoms.get(0);
        }
        if (geoms.size() == 0) {
            return OGCGeometry.createFromEsriGeometry(emptyGeom, sr);
        }
        return new OGCConcreteGeometryCollection(geoms, sr);
    }

    public static OGCGeometry fromText(String text) {
        OGCStructure ogcStructure = OperatorImportFromWkt.local().executeOGC(0, text, null);
        return OGCGeometry.createFromOGCStructure(ogcStructure, SpatialReference.create(4326));
    }

    public static OGCGeometry fromBinary(ByteBuffer binary) {
        OGCStructure ogcStructure = OperatorImportFromWkb.local().executeOGC(0, binary, null);
        return OGCGeometry.createFromOGCStructure(ogcStructure, SpatialReference.create(4326));
    }

    public static OGCGeometry fromEsriShape(ByteBuffer buffer) {
        Geometry g = OperatorImportFromESRIShape.local().execute(0, Geometry.Type.Unknown, buffer);
        return OGCGeometry.createFromEsriGeometry(g, SpatialReference.create(4326));
    }

    public static OGCGeometry fromJson(String string) throws Exception {
        try {
            MapGeometry mapGeom = GeometryEngine.jsonToGeometry(JsonParserReader.createFromString(string));
            return OGCGeometry.createFromEsriGeometry(mapGeom.getGeometry(), mapGeom.getSpatialReference());
        }
        catch (Exception ex) {
            throw new JsonGeometryException(ex.getMessage());
        }
    }

    public static OGCGeometry fromGeoJson(String string) throws Exception {
        MapOGCStructure mapOGCStructure = OperatorImportFromGeoJson.local().executeOGC(0, string, null);
        return OGCGeometry.createFromOGCStructure(mapOGCStructure.m_ogcStructure, mapOGCStructure.m_spatialReference);
    }

    public static OGCGeometry createFromEsriGeometry(Geometry geom, SpatialReference sr) {
        return OGCGeometry.createFromEsriGeometry(geom, sr, false);
    }

    public static OGCGeometry createFromEsriGeometry(Geometry geom, SpatialReference sr, boolean multiType) {
        if (geom == null) {
            return null;
        }
        Geometry.Type t = geom.getType();
        if (t == Geometry.Type.Polygon) {
            if (!multiType && ((Polygon)geom).getExteriorRingCount() == 1) {
                return new OGCPolygon((Polygon)geom, sr);
            }
            return new OGCMultiPolygon((Polygon)geom, sr);
        }
        if (t == Geometry.Type.Polyline) {
            if (!multiType && ((Polyline)geom).getPathCount() == 1) {
                return new OGCLineString((Polyline)geom, 0, sr);
            }
            return new OGCMultiLineString((Polyline)geom, sr);
        }
        if (t == Geometry.Type.MultiPoint) {
            if (!multiType && ((MultiPoint)geom).getPointCount() <= 1) {
                if (geom.isEmpty()) {
                    return new OGCPoint(new Point(), sr);
                }
                return new OGCPoint(((MultiPoint)geom).getPoint(0), sr);
            }
            return new OGCMultiPoint((MultiPoint)geom, sr);
        }
        if (t == Geometry.Type.Point) {
            if (!multiType) {
                return new OGCPoint((Point)geom, sr);
            }
            return new OGCMultiPoint((Point)geom, sr);
        }
        if (t == Geometry.Type.Envelope) {
            Polygon p = new Polygon();
            p.addEnvelope((Envelope)geom, false);
            return OGCGeometry.createFromEsriGeometry(p, sr, multiType);
        }
        if (t == Geometry.Type.GeometryCollection) {
            GeometryCollection gc = (GeometryCollection)geom;
            ArrayList<OGCGeometry> resGeoms = new ArrayList<OGCGeometry>(gc.getGeometryCount());
            for (Geometry g : gc) {
                OGCGeometry ogc_g = OGCGeometry.createFromEsriGeometry(g, sr, multiType);
                resGeoms.add(ogc_g);
            }
            return new OGCConcreteGeometryCollection(resGeoms, sr);
        }
        throw new UnsupportedOperationException();
    }

    public static OGCGeometry createFromOGCStructure(OGCStructure ogcStructure, SpatialReference sr) {
        if (ogcStructure.m_type == 0) {
            ogcStructure = ogcStructure.m_structures.get(0);
        }
        Stack<OGCStructure> structureStack = new Stack<OGCStructure>();
        structureStack.push(ogcStructure);
        Stack<OGCConcreteGeometryCollection> ogcCollectionStack = new Stack<OGCConcreteGeometryCollection>();
        OGCGeometry g = null;
        while (!structureStack.isEmpty()) {
            OGCStructure lastStructure = (OGCStructure)structureStack.pop();
            OGCConcreteGeometryCollection lastCollection = null;
            if (!ogcCollectionStack.isEmpty()) {
                lastCollection = (OGCConcreteGeometryCollection)ogcCollectionStack.pop();
            }
            int type = lastStructure.m_type;
            switch (type) {
                case 1: {
                    g = new OGCPoint((Point)lastStructure.m_geometry, sr);
                    break;
                }
                case 2: {
                    g = new OGCLineString((Polyline)lastStructure.m_geometry, 0, sr);
                    break;
                }
                case 3: {
                    g = new OGCPolygon((Polygon)lastStructure.m_geometry, 0, sr);
                    break;
                }
                case 4: {
                    g = new OGCMultiPoint((MultiPoint)lastStructure.m_geometry, sr);
                    break;
                }
                case 5: {
                    g = new OGCMultiLineString((Polyline)lastStructure.m_geometry, sr);
                    break;
                }
                case 6: {
                    g = new OGCMultiPolygon((Polygon)lastStructure.m_geometry, sr);
                    break;
                }
                case 0: 
                case 7: {
                    ArrayList<OGCGeometry> geometries = new ArrayList<OGCGeometry>();
                    OGCConcreteGeometryCollection col = new OGCConcreteGeometryCollection(geometries, sr);
                    g = col;
                    int n = lastStructure.m_structures.size();
                    for (int i = 0; i < n; ++i) {
                        structureStack.push(lastStructure.m_structures.get(n - i - 1));
                        ogcCollectionStack.push(col);
                    }
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
            if (lastCollection == null) continue;
            lastCollection.geometries.add(g);
            g = lastCollection;
        }
        return g;
    }

    protected boolean isConcreteGeometryCollection() {
        return false;
    }

    public void setSpatialReference(SpatialReference esriSR_) {
        this.esriSR = esriSR_;
    }

    public abstract OGCGeometry convertToMulti();

    public String toString() {
        String snippet = this.asText();
        if (snippet.length() > 200) {
            snippet = snippet.substring(0, 197) + "...";
        }
        return String.format("%s: %s", this.getClass().getSimpleName(), snippet);
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (other.getClass() != this.getClass()) {
            return false;
        }
        OGCGeometry another = (OGCGeometry)other;
        Geometry geom1 = this.getEsriGeometry();
        Geometry geom2 = another.getEsriGeometry();
        if (geom1 == null ? geom2 != null : !geom1.equals(geom2)) {
            return false;
        }
        if (this.esriSR == another.esriSR) {
            return true;
        }
        if (this.esriSR != null && another.esriSR != null) {
            return this.esriSR.equals(another.esriSR);
        }
        return false;
    }

    public int hashCode() {
        int hash = 1;
        Geometry geom1 = this.getEsriGeometry();
        if (geom1 != null) {
            hash = geom1.hashCode();
        }
        if (this.esriSR != null) {
            hash = NumberUtils.hashCombine(hash, this.esriSR.hashCode());
        }
        return hash;
    }

    private static interface GeoJsonValues {
        public static final int Point = 1;
        public static final int LineString = 2;
        public static final int Polygon = 3;
        public static final int MultiPoint = 4;
        public static final int MultiLineString = 5;
        public static final int MultiPolygon = 6;
        public static final int GeometryCollection = 7;
    }
}

