/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry.ogc;

import com.esri.core.geometry.Envelope;
import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.GeometryCursor;
import com.esri.core.geometry.GeometryException;
import com.esri.core.geometry.NumberUtils;
import com.esri.core.geometry.OperatorExportToGeoJson;
import com.esri.core.geometry.Polygon;
import com.esri.core.geometry.SpatialReference;
import com.esri.core.geometry.ogc.OGCGeometry;
import com.esri.core.geometry.ogc.OGCGeometryCollection;
import com.esri.core.geometry.ogc.OGCPolygon;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;

public class OGCConcreteGeometryCollection
extends OGCGeometryCollection {
    List<OGCGeometry> geometries;

    public OGCConcreteGeometryCollection(List<OGCGeometry> geoms, SpatialReference sr) {
        this.geometries = geoms;
        this.esriSR = sr;
    }

    public OGCConcreteGeometryCollection(OGCGeometry geom, SpatialReference sr) {
        this.geometries = new ArrayList<OGCGeometry>(1);
        this.geometries.add(geom);
        this.esriSR = sr;
    }

    @Override
    public int dimension() {
        int maxD = 0;
        int n = this.numGeometries();
        for (int i = 0; i < n; ++i) {
            maxD = Math.max(this.geometryN(i).dimension(), maxD);
        }
        return maxD;
    }

    @Override
    public int coordinateDimension() {
        return this.isEmpty() ? 2 : this.geometryN(0).coordinateDimension();
    }

    @Override
    public boolean is3D() {
        return !this.isEmpty() && this.geometries.get(0).is3D();
    }

    @Override
    public boolean isMeasured() {
        return !this.isEmpty() && this.geometries.get(0).isMeasured();
    }

    @Override
    public OGCGeometry envelope() {
        GeometryCursor gc = this.getEsriGeometryCursor();
        Envelope env = new Envelope();
        Geometry g = gc.next();
        while (g != null) {
            Envelope e = new Envelope();
            g.queryEnvelope(e);
            env.merge(e);
            g = gc.next();
        }
        Polygon polygon = new Polygon();
        polygon.addEnvelope(env, false);
        return new OGCPolygon(polygon, this.esriSR);
    }

    @Override
    public int numGeometries() {
        return this.geometries.size();
    }

    @Override
    public OGCGeometry geometryN(int n) {
        return this.geometries.get(n);
    }

    @Override
    public String geometryType() {
        return "GeometryCollection";
    }

    @Override
    public String asText() {
        int n;
        StringBuilder sb = new StringBuilder("GEOMETRYCOLLECTION ");
        if (this.is3D()) {
            sb.append('Z');
        }
        if (this.isMeasured()) {
            sb.append('M');
        }
        if (this.is3D() || this.isMeasured()) {
            sb.append(' ');
        }
        if ((n = this.numGeometries()) == 0) {
            sb.append("EMPTY");
            return sb.toString();
        }
        sb.append('(');
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.geometryN(i).asText());
        }
        sb.append(')');
        return sb.toString();
    }

    @Override
    public ByteBuffer asBinary() {
        ArrayList<ByteBuffer> buffers = new ArrayList<ByteBuffer>(0);
        int size = 9;
        int n = this.numGeometries();
        for (int i = 0; i < n; ++i) {
            ByteBuffer buffer = this.geometryN(i).asBinary();
            buffers.add(buffer);
            size += buffer.capacity();
        }
        ByteBuffer wkbBuffer = ByteBuffer.allocate(size).order(ByteOrder.nativeOrder());
        byte byteOrder = (byte)(wkbBuffer.order() == ByteOrder.LITTLE_ENDIAN ? 1 : 0);
        int wkbType = 7;
        if (this.is3D()) {
            wkbType += 1000;
        }
        if (this.isMeasured()) {
            wkbType += 2000;
        }
        wkbBuffer.put(0, byteOrder);
        wkbBuffer.putInt(1, wkbType);
        wkbBuffer.putInt(5, n);
        int offset = 9;
        for (int i = 0; i < n; ++i) {
            byte[] arr = ((ByteBuffer)buffers.get(i)).array();
            System.arraycopy(arr, 0, wkbBuffer.array(), offset, arr.length);
            offset += arr.length;
        }
        return wkbBuffer;
    }

    @Override
    public String asGeoJson() {
        return this.asGeoJsonImpl(0);
    }

    @Override
    String asGeoJsonImpl(int export_flags) {
        StringBuilder sb = new StringBuilder();
        sb.append("{\"type\":\"GeometryCollection\",\"geometries\":");
        sb.append("[");
        int n = this.numGeometries();
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            if (this.geometryN(i) == null) continue;
            sb.append(this.geometryN(i).asGeoJsonImpl(8));
        }
        sb.append("],\"crs\":");
        if (this.esriSR != null) {
            String crs_value = OperatorExportToGeoJson.local().exportSpatialReference(0, this.esriSR);
            sb.append(crs_value);
        } else {
            sb.append("\"null\"");
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean isEmpty() {
        return this.numGeometries() == 0;
    }

    @Override
    public double MinZ() {
        double z = Double.NaN;
        int n = this.numGeometries();
        for (int i = 0; i < n; ++i) {
            z = i == 0 ? this.geometryN(i).MinZ() : Math.min(this.geometryN(i).MinZ(), z);
        }
        return z;
    }

    @Override
    public double MaxZ() {
        double z = Double.NaN;
        int n = this.numGeometries();
        for (int i = 0; i < n; ++i) {
            z = i == 0 ? this.geometryN(i).MaxZ() : Math.min(this.geometryN(i).MaxZ(), z);
        }
        return z;
    }

    @Override
    public double MinMeasure() {
        double z = Double.NaN;
        int n = this.numGeometries();
        for (int i = 0; i < n; ++i) {
            z = i == 0 ? this.geometryN(i).MinMeasure() : Math.min(this.geometryN(i).MinMeasure(), z);
        }
        return z;
    }

    @Override
    public double MaxMeasure() {
        double z = Double.NaN;
        int n = this.numGeometries();
        for (int i = 0; i < n; ++i) {
            z = i == 0 ? this.geometryN(i).MaxMeasure() : Math.min(this.geometryN(i).MaxMeasure(), z);
        }
        return z;
    }

    @Override
    public boolean isSimple() {
        int n = this.numGeometries();
        for (int i = 0; i < n; ++i) {
            if (this.geometryN(i).isSimple()) continue;
            return false;
        }
        return true;
    }

    @Override
    public OGCGeometry makeSimple() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isSimpleRelaxed() {
        int n = this.numGeometries();
        for (int i = 0; i < n; ++i) {
            if (this.geometryN(i).isSimpleRelaxed()) continue;
            return false;
        }
        return true;
    }

    @Override
    public OGCGeometry makeSimpleRelaxed(boolean forceProcessing) {
        throw new UnsupportedOperationException();
    }

    @Override
    public OGCGeometry boundary() {
        throw new UnsupportedOperationException();
    }

    @Override
    public OGCGeometry locateAlong(double mValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public OGCGeometry locateBetween(double mStart, double mEnd) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Geometry getEsriGeometry() {
        return null;
    }

    @Override
    public GeometryCursor getEsriGeometryCursor() {
        return new GeometryCursorOGC(this.geometries);
    }

    @Override
    protected boolean isConcreteGeometryCollection() {
        return true;
    }

    @Override
    public void setSpatialReference(SpatialReference esriSR_) {
        this.esriSR = esriSR_;
        int n = this.geometries.size();
        for (int i = 0; i < n; ++i) {
            if (this.geometries.get(i) == null) continue;
            this.geometries.get(i).setSpatialReference(esriSR_);
        }
    }

    @Override
    public OGCGeometry convertToMulti() {
        return this;
    }

    @Override
    public String asJson() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (other.getClass() != this.getClass()) {
            return false;
        }
        OGCConcreteGeometryCollection another = (OGCConcreteGeometryCollection)other;
        if (this.geometries != null ? !this.geometries.equals(another.geometries) : another.geometries != null) {
            return false;
        }
        if (this.esriSR == another.esriSR) {
            return true;
        }
        if (this.esriSR != null && another.esriSR != null) {
            return this.esriSR.equals(another.esriSR);
        }
        return false;
    }

    @Override
    public boolean Equals(OGCGeometry another) {
        throw new GeometryException("not implemented");
    }

    @Override
    public int hashCode() {
        int hash = 1;
        if (this.geometries != null) {
            hash = this.geometries.hashCode();
        }
        if (this.esriSR != null) {
            hash = NumberUtils.hashCombine(hash, this.esriSR.hashCode());
        }
        return hash;
    }

    static class GeometryCursorOGC
    extends GeometryCursor {
        private int m_index;
        private int m_ind;
        private List<OGCGeometry> m_geoms;
        GeometryCursor m_curs;

        GeometryCursorOGC(List<OGCGeometry> geoms) {
            this.m_geoms = geoms;
            this.m_index = -1;
            this.m_curs = null;
            this.m_ind = 0;
        }

        @Override
        public Geometry next() {
            int i;
            do {
                if (this.m_curs != null) {
                    Geometry g = this.m_curs.next();
                    if (g != null) {
                        ++this.m_index;
                        return g;
                    }
                    this.m_curs = null;
                }
                if (this.m_ind < this.m_geoms.size()) continue;
                return null;
            } while (this.m_geoms.get(i = this.m_ind++) == null);
            if (!this.m_geoms.get(i).isConcreteGeometryCollection()) {
                ++this.m_index;
                return this.m_geoms.get(i).getEsriGeometry();
            }
            OGCConcreteGeometryCollection gc = (OGCConcreteGeometryCollection)this.m_geoms.get(i);
            this.m_curs = new GeometryCursorOGC(gc.geometries);
            return this.next();
        }

        @Override
        public int getGeometryID() {
            return this.m_index;
        }
    }
}

