/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.VertexDescription;
import java.util.concurrent.atomic.AtomicReferenceArray;

final class VertexDescriptionHash {
    static final int m_block_size = 64;
    static final int m_block_size_power = 6;
    static final int m_block_count = 32;
    static final VertexDescription VD2D = new VertexDescription(1);
    static final VertexDescription VD3D = new VertexDescription(3);
    static final VertexDescriptionHash INSTANCE = new VertexDescriptionHash();
    private final AtomicReferenceArray<AtomicReferenceArray<VertexDescription>> m_descriptionsOther = new AtomicReferenceArray(32);

    private VertexDescriptionHash() {
    }

    public final VertexDescription FindOrAdd(int bitSet) {
        VertexDescription vd;
        if (bitSet == 1) {
            return VD2D;
        }
        if (bitSet == 3) {
            return VD3D;
        }
        int pos = bitSet >>> 1;
        int iarr = pos >>> 6;
        int ipos = pos - (iarr << 6);
        AtomicReferenceArray<VertexDescription> arr = this.m_descriptionsOther.get(iarr);
        if (arr == null && !this.m_descriptionsOther.compareAndSet(iarr, null, arr = new AtomicReferenceArray(64))) {
            arr = this.m_descriptionsOther.get(iarr);
        }
        if ((vd = arr.get(ipos)) == null && !arr.compareAndSet(ipos, null, vd = new VertexDescription(bitSet))) {
            vd = arr.get(ipos);
        }
        return vd;
    }
}

