/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.AngularUnitImpl;
import com.esri.core.geometry.AreaUnitImpl;
import com.esri.core.geometry.GeometryException;
import com.esri.core.geometry.HadoopSDKExcluded;
import com.esri.core.geometry.LinearUnitImpl;
import com.esri.core.geometry.Unit;
import com.esri.sde.sdk.pe.engine.PeAngunit;
import com.esri.sde.sdk.pe.engine.PeAreaunit;
import com.esri.sde.sdk.pe.engine.PeLinunit;
import com.esri.sde.sdk.pe.engine.PeProjectionException;
import java.io.InvalidObjectException;
import java.io.ObjectStreamException;
import java.io.Serializable;

@HadoopSDKExcluded
final class UnitSerializer
implements Serializable {
    private static final long serialVersionUID = 1L;
    Unit.UnitType unitType;
    String unitString = null;

    UnitSerializer() {
    }

    Object readResolve() throws ObjectStreamException {
        try {
            if (this.unitType == Unit.UnitType.Linear) {
                PeLinunit lin = PeLinunit.fromString((String)this.unitString);
                return new LinearUnitImpl(lin);
            }
            if (this.unitType == Unit.UnitType.Angular) {
                PeAngunit ang = PeAngunit.fromString((String)this.unitString);
                return new AngularUnitImpl(ang);
            }
            if (this.unitType == Unit.UnitType.Area) {
                PeAreaunit area = PeAreaunit.fromString((String)this.unitString);
                return new AreaUnitImpl(area);
            }
            throw new InvalidObjectException("Cannot read Unit class from stream: " + this.unitType.toString());
        }
        catch (PeProjectionException ex) {
            throw new InvalidObjectException("Cannot read Unit class from stream. Reason: " + ex.getMessage());
        }
    }

    public void setUnitByValue(Unit unit) throws ObjectStreamException {
        this.unitType = unit.getUnitType();
        if (this.unitType == Unit.UnitType.Linear) {
            LinearUnitImpl u = (LinearUnitImpl)unit;
            this.unitString = u.getPEUnit().toString();
            return;
        }
        if (this.unitType == Unit.UnitType.Angular) {
            AngularUnitImpl u = (AngularUnitImpl)unit;
            this.unitString = u.m_peUnit.toString();
            return;
        }
        if (this.unitType == Unit.UnitType.Area) {
            AreaUnitImpl u = (AreaUnitImpl)unit;
            this.unitString = u.m_peUnit.toString();
            return;
        }
        throw GeometryException.GeometryInternalError();
    }
}

