/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.AndroidSDKExcluded;
import com.esri.core.geometry.AndroidSDKPublic;
import com.esri.core.geometry.AngularUnitImpl;
import com.esri.core.geometry.AreaUnitImpl;
import com.esri.core.geometry.GeometryException;
import com.esri.core.geometry.HadoopSDKExcluded;
import com.esri.core.geometry.LinearUnitImpl;
import com.esri.core.geometry.NumberUtils;
import com.esri.core.geometry.PeInitializer;
import com.esri.core.geometry.USrlzr;
import com.esri.sde.sdk.pe.engine.PeAngunit;
import com.esri.sde.sdk.pe.engine.PeAreaunit;
import com.esri.sde.sdk.pe.engine.PeLinunit;
import com.esri.sde.sdk.pe.engine.PeObject;
import com.esri.sde.sdk.pe.engine.PeUnit;
import com.esri.sde.sdk.pe.factory.PeFactory;
import java.io.ObjectStreamException;
import java.io.Serializable;

@AndroidSDKExcluded
@HadoopSDKExcluded
public abstract class Unit
implements Serializable {
    protected double m_factor;

    @AndroidSDKPublic
    public abstract UnitType getUnitType();

    @AndroidSDKPublic
    public static Unit create(int wkid) {
        if (wkid == 9001) {
            return new LinearUnitImpl(null);
        }
        PeInitializer.touch();
        PeUnit peUnit = PeFactory.unit((int)wkid);
        if (peUnit == null) {
            PeAreaunit peAreaUnit = PeFactory.areaunit((int)wkid);
            if (peAreaUnit != null) {
                return new AreaUnitImpl(peAreaUnit);
            }
            throw new IllegalArgumentException("Invalid or unsupported Unit: " + wkid);
        }
        if (PeFactory.getType((PeObject)peUnit) == 256) {
            return new LinearUnitImpl((PeLinunit)peUnit);
        }
        if (PeFactory.getType((PeObject)peUnit) == 512) {
            return new AngularUnitImpl((PeAngunit)peUnit);
        }
        throw GeometryException.GeometryInternalError();
    }

    @AndroidSDKPublic
    public abstract String getName();

    @AndroidSDKPublic
    public abstract int getID();

    @AndroidSDKPublic
    public abstract String getDisplayName();

    @AndroidSDKPublic
    public abstract String getPluralDisplayName();

    @AndroidSDKPublic
    public abstract String getAbbreviation();

    @AndroidSDKPublic
    public abstract double getConversionFactor(Unit var1);

    @AndroidSDKPublic
    public static double convertUnits(double valueIn, Unit unitFrom, Unit unitTo) {
        double f = unitFrom.getConversionFactor(unitTo);
        return f * valueIn;
    }

    @AndroidSDKPublic
    public static void convertUnits(double[] valueIn, int countIn, Unit unitFrom, Unit unitTo, double[] valueOut) {
        double f = unitFrom.getConversionFactor(unitTo);
        for (int i = 0; i < countIn; ++i) {
            valueOut[i] = valueIn[i] * f;
        }
    }

    @AndroidSDKPublic
    public double getUnitToBaseFactor() {
        return this.m_factor;
    }

    @AndroidSDKPublic
    public boolean equals(Object other) {
        if (this.getClass() != other.getClass()) {
            return false;
        }
        return this.getUnitToBaseFactor() == ((Unit)other).getUnitToBaseFactor();
    }

    @AndroidSDKPublic
    public int hashCode() {
        return NumberUtils.hash(this.getUnitToBaseFactor());
    }

    Object writeReplace() throws ObjectStreamException {
        USrlzr unitSerializer = new USrlzr();
        unitSerializer.setUnitByValue(this);
        return unitSerializer;
    }

    @AndroidSDKPublic
    public static enum UnitType {
        Linear(0),
        Angular(1),
        Area(2);

        private int enumValue;

        public int value() {
            return this.enumValue;
        }

        private UnitType(int val) {
            this.enumValue = val;
        }

        public static UnitType intToUnitType(int vv) {
            UnitType[] v = UnitType.values();
            for (int i = 0; i < v.length; ++i) {
                if (v[i].value() != vv) continue;
                return v[i];
            }
            throw new IllegalArgumentException();
        }
    }
}

