/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.AngularUnitImpl;
import com.esri.core.geometry.AreaUnitImpl;
import com.esri.core.geometry.GeometryException;
import com.esri.core.geometry.HadoopSDKExcluded;
import com.esri.core.geometry.LinearUnitImpl;
import com.esri.core.geometry.Unit;
import com.esri.sde.sdk.pe.engine.PeAngunit;
import com.esri.sde.sdk.pe.engine.PeAreaunit;
import com.esri.sde.sdk.pe.engine.PeLinunit;
import com.esri.sde.sdk.pe.engine.PeProjectionException;
import java.io.InvalidObjectException;
import java.io.ObjectStreamException;
import java.io.Serializable;

@HadoopSDKExcluded
final class USrlzr
implements Serializable {
    private static final long serialVersionUID = 1L;
    String unitString = null;
    int unitType;

    USrlzr() {
    }

    Object readResolve() throws ObjectStreamException {
        try {
            if (this.unitType == Unit.UnitType.Linear.value()) {
                PeLinunit lin = PeLinunit.fromString((String)this.unitString);
                return new LinearUnitImpl(lin);
            }
            if (this.unitType == Unit.UnitType.Angular.value()) {
                PeAngunit ang = PeAngunit.fromString((String)this.unitString);
                return new AngularUnitImpl(ang);
            }
            if (this.unitType == Unit.UnitType.Area.value()) {
                PeAreaunit area = PeAreaunit.fromString((String)this.unitString);
                return new AreaUnitImpl(area);
            }
            throw new InvalidObjectException("Cannot read Unit class from stream: " + new Integer(this.unitType).toString());
        }
        catch (PeProjectionException ex) {
            throw new InvalidObjectException("Cannot read Unit class from stream. Reason: " + ex.getMessage());
        }
    }

    public void setUnitByValue(Unit unit) throws ObjectStreamException {
        this.unitType = unit.getUnitType().value();
        if (this.unitType == Unit.UnitType.Linear.value()) {
            LinearUnitImpl u = (LinearUnitImpl)unit;
            this.unitString = u.getPEUnit().toString();
            return;
        }
        if (this.unitType == Unit.UnitType.Angular.value()) {
            AngularUnitImpl u = (AngularUnitImpl)unit;
            this.unitString = u.m_peUnit.toString();
            return;
        }
        if (this.unitType == Unit.UnitType.Area.value()) {
            AreaUnitImpl u = (AreaUnitImpl)unit;
            this.unitString = u.m_peUnit.toString();
            return;
        }
        throw GeometryException.GeometryInternalError();
    }
}

