/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.AndroidSDKPublic;
import com.esri.core.geometry.Envelope2D;
import com.esri.core.geometry.GeometryException;
import com.esri.core.geometry.HadoopSDKPublic;
import com.esri.core.geometry.MathUtils;
import com.esri.core.geometry.NumberUtils;
import com.esri.core.geometry.Point;
import com.esri.core.geometry.Point2D;

@AndroidSDKPublic
@HadoopSDKPublic
public final class Transformation2D {
    @AndroidSDKPublic
    @HadoopSDKPublic
    public double xx;
    @AndroidSDKPublic
    @HadoopSDKPublic
    public double xy;
    @AndroidSDKPublic
    @HadoopSDKPublic
    public double xd;
    @AndroidSDKPublic
    @HadoopSDKPublic
    public double yx;
    @AndroidSDKPublic
    @HadoopSDKPublic
    public double yy;
    @AndroidSDKPublic
    @HadoopSDKPublic
    public double yd;

    @AndroidSDKPublic
    @HadoopSDKPublic
    public Transformation2D() {
        this.setIdentity();
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public Transformation2D(double scale) {
        this.setScale(scale);
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public void setZero() {
        this.xx = 0.0;
        this.yy = 0.0;
        this.xy = 0.0;
        this.yx = 0.0;
        this.xd = 0.0;
        this.yd = 0.0;
    }

    void transform(Point2D psrc, Point2D pdst) {
        double x = this.xx * psrc.x + this.xy * psrc.y + this.xd;
        double y = this.yx * psrc.x + this.yy * psrc.y + this.yd;
        pdst.x = x;
        pdst.y = y;
    }

    double transformX(double x, double y) {
        return this.xx * x + this.xy * y + this.xd;
    }

    double transformY(double x, double y) {
        return this.yx * x + this.yy * y + this.yd;
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Transformation2D)) {
            return false;
        }
        Transformation2D that = (Transformation2D)other;
        return this.xx == that.xx && this.xy == that.xy && this.xd == that.xd && this.yx == that.yx && this.yy == that.yy && this.yd == that.yd;
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public int hashCode() {
        int hash = NumberUtils.hash(this.xx);
        hash = NumberUtils.hash(hash, this.xy);
        hash = NumberUtils.hash(hash, this.xd);
        hash = NumberUtils.hash(hash, this.yx);
        hash = NumberUtils.hash(hash, this.yy);
        hash = NumberUtils.hash(hash, this.yd);
        return hash;
    }

    @HadoopSDKPublic
    public void transform(Point2D[] points, int start, int count) {
        int n = Math.min(points.length, start + count);
        for (int i = start; i < n; ++i) {
            this.transform(points[i], points[i]);
        }
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public void transform(Point[] pointsIn, int count, Point[] pointsOut) {
        for (int i = 0; i < count; ++i) {
            double xIn = pointsIn[i].getX();
            double yIn = pointsIn[i].getY();
            double x = this.xx * xIn + this.xy * yIn + this.xd;
            double y = this.yx * xIn + this.yy * yIn + this.yd;
            if (pointsOut[i] == null) {
                pointsOut[i] = new Point(x, y);
                continue;
            }
            pointsOut[i].dropAllAttributes();
            pointsOut[i].setXY(x, y);
        }
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public void transform(Point2D[] pointsIn, int count, Point2D[] pointsOut) {
        for (int i = 0; i < count; ++i) {
            double xIn = pointsIn[i].x;
            double yIn = pointsIn[i].y;
            double x = this.xx * xIn + this.xy * yIn + this.xd;
            double y = this.yx * xIn + this.yy * yIn + this.yd;
            if (pointsOut[i] != null) {
                pointsOut[i].setCoords(x, y);
                continue;
            }
            pointsOut[i] = new Point2D(x, y);
        }
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public void transform(double[] pointsXYInterleaved, int start, int count) {
        int n = Math.min(pointsXYInterleaved.length, (start + count) * 2) / 2;
        for (int i = start; i < n; ++i) {
            double px = pointsXYInterleaved[2 * i];
            double py = pointsXYInterleaved[2 * i + 1];
            pointsXYInterleaved[2 * i] = this.xx * px + this.xy * py + this.xd;
            pointsXYInterleaved[2 * i + 1] = this.yx * px + this.yy * py + this.yd;
        }
    }

    public void transform(double[] pointsXYInterleaved, int srcPos2D, double[] dstPointsXYInterleaved, int dstPos2D, int pointCount) {
        int i = 2 * srcPos2D;
        int j = 2 * dstPos2D;
        int n = 2 * (srcPos2D + pointCount);
        while (i < n) {
            double px = pointsXYInterleaved[i];
            double py = pointsXYInterleaved[i + 1];
            dstPointsXYInterleaved[j] = this.xx * px + this.xy * py + this.xd;
            dstPointsXYInterleaved[j + 1] = this.yx * px + this.yy * py + this.yd;
            i += 2;
            j += 2;
        }
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public void multiply(Transformation2D right) {
        Transformation2D.multiply(this, right, this);
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public void mulLeft(Transformation2D left) {
        Transformation2D.multiply(left, this, this);
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public static void multiply(Transformation2D a, Transformation2D b, Transformation2D result) {
        double xx = a.xx * b.xx + a.yx * b.xy;
        double xy = a.xy * b.xx + a.yy * b.xy;
        double xd = a.xd * b.xx + a.yd * b.xy + b.xd;
        double yx = a.xx * b.yx + a.yx * b.yy;
        double yy = a.xy * b.yx + a.yy * b.yy;
        double yd = a.xd * b.yx + a.yd * b.yy + b.yd;
        result.xx = xx;
        result.xy = xy;
        result.xd = xd;
        result.yx = yx;
        result.yy = yy;
        result.yd = yd;
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public Transformation2D copy() {
        Transformation2D result = new Transformation2D();
        result.xx = this.xx;
        result.xy = this.xy;
        result.xd = this.xd;
        result.yx = this.yx;
        result.yy = this.yy;
        result.yd = this.yd;
        return result;
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public void getCoefficients(double[] coefs) {
        if (coefs.length < 6) {
            throw new GeometryException("Buffer is too small. coefs needs 6 members");
        }
        coefs[0] = this.xx;
        coefs[1] = this.xy;
        coefs[2] = this.xd;
        coefs[3] = this.yx;
        coefs[4] = this.yy;
        coefs[5] = this.yd;
    }

    void transform(Envelope2D env) {
        if (env.isEmpty()) {
            return;
        }
        Point2D[] buf = new Point2D[4];
        env.queryCorners(buf);
        this.transform(buf, buf);
        env.setFromPoints(buf, 4);
    }

    void transform(Point2D[] pointsIn, Point2D[] pointsOut) {
        for (int i = 0; i < pointsIn.length; ++i) {
            Point2D p = pointsIn[i];
            double x = this.xx * p.x + this.xy * p.y + this.xd;
            double y = this.yx * p.x + this.yy * p.y + this.yd;
            if (pointsOut[i] != null) {
                pointsOut[i].setCoords(x, y);
                continue;
            }
            pointsOut[i] = new Point2D(x, y);
        }
    }

    void initializeFromRect(Envelope2D src, Envelope2D dest) {
        if (src.isEmpty() || dest.isEmpty() || 0.0 == src.getWidth() || 0.0 == src.getHeight()) {
            this.setZero();
        } else {
            this.yx = 0.0;
            this.xy = 0.0;
            this.xx = dest.getWidth() / src.getWidth();
            this.yy = dest.getHeight() / src.getHeight();
            this.xd = dest.xmin - src.xmin * this.xx;
            this.yd = dest.ymin - src.ymin * this.yy;
        }
    }

    void initializeFromRectIsotropic(Envelope2D src, Envelope2D dest) {
        if (src.isEmpty() || dest.isEmpty() || 0.0 == src.getWidth() || 0.0 == src.getHeight()) {
            this.setZero();
        } else {
            this.yx = 0.0;
            this.xy = 0.0;
            this.xx = dest.getWidth() / src.getWidth();
            this.yy = dest.getHeight() / src.getHeight();
            if (this.xx > this.yy) {
                this.xx = this.yy;
            } else {
                this.yy = this.xx;
            }
            double destCenterX = dest.getCenterX();
            double destCenterY = dest.getCenterY();
            double srcCenterX = src.getCenterX();
            double srcCenterY = src.getCenterY();
            this.xd = destCenterX - srcCenterX * this.xx;
            this.yd = destCenterY - srcCenterY * this.yy;
        }
    }

    void initializeFromCurveParameters(Point2D Position, Point2D Tangent, double Offset) {
    }

    Point2D transformSize(Point2D SizeSrc) {
        Point2D pt = new Point2D();
        pt.x = Math.sqrt(this.xx * this.xx + this.yx * this.yx) * SizeSrc.x;
        pt.y = Math.sqrt(this.xy * this.xy + this.yy * this.yy) * SizeSrc.y;
        return pt;
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public double transform(double tolerance) {
        double d2;
        double d1 = (MathUtils.sqr(this.xx - this.xy) + MathUtils.sqr(this.yx - this.yy)) * 0.5;
        return tolerance * (d1 > (d2 = (MathUtils.sqr(this.xx + this.xy) + MathUtils.sqr(this.yx + this.yy)) * 0.5) ? Math.sqrt(d1) : Math.sqrt(d2));
    }

    void transformWithoutShift(Point2D[] pointsIn, int from, int count, Point2D[] pointsOut) {
        int n = from + count;
        for (int i = from; i < n; ++i) {
            Point2D p = pointsIn[i];
            double new_x = this.xx * p.x + this.xy * p.y;
            double new_y = this.yx * p.x + this.yy * p.y;
            if (pointsOut[i] != null) {
                pointsOut[i].setCoords(new_x, new_y);
                continue;
            }
            pointsOut[i] = new Point2D(new_x, new_y);
        }
    }

    Point2D transformWithoutShift(Point2D srcPoint) {
        double new_x = this.xx * srcPoint.x + this.xy * srcPoint.y;
        double new_y = this.yx * srcPoint.x + this.yy * srcPoint.y;
        return Point2D.construct(new_x, new_y);
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public void setIdentity() {
        this.xx = 1.0;
        this.xy = 0.0;
        this.xd = 0.0;
        this.yx = 0.0;
        this.yy = 1.0;
        this.yd = 0.0;
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public boolean isIdentity() {
        return this.xx == 1.0 && this.yy == 1.0 && 0.0 == this.xy && 0.0 == this.xd && 0.0 == this.yx && 0.0 == this.yd;
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public boolean isIdentity(double tol) {
        double t2 = tol * tol;
        if (MathUtils.sqr(this.xd) + MathUtils.sqr(this.yd) > t2) {
            return false;
        }
        if (MathUtils.sqr(this.xy + this.xd) + MathUtils.sqr(this.yy + this.yd - 1.0) > t2) {
            return false;
        }
        return !(MathUtils.sqr(this.xx + this.xd - 1.0) + MathUtils.sqr(this.yx + this.yd) > t2);
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public boolean isReflective() {
        return this.xx * this.yy - this.yx * this.xy < 0.0;
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public boolean isUniform(double eps) {
        double v1 = this.xx * this.xx + this.yx * this.yx;
        double v2 = this.xy * this.xy + this.yy * this.yy;
        double e = (v1 + v2) * eps;
        return Math.abs(v1 - v2) <= e && Math.abs(this.xx * this.xy + this.yx * this.yy) <= e;
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public boolean isShift() {
        return this.xx == 1.0 && this.yy == 1.0 && 0.0 == this.xy && 0.0 == this.yx;
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public boolean isShift(double tol) {
        Point2D pt = this.transformWithoutShift(Point2D.construct(0.0, 1.0));
        pt.y -= 1.0;
        if (pt.sqrLength() > tol * tol) {
            return false;
        }
        pt = this.transformWithoutShift(Point2D.construct(1.0, 0.0));
        pt.x -= 1.0;
        return pt.sqrLength() <= tol * tol;
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public boolean isOrthonormal(double tol) {
        Transformation2D r = new Transformation2D();
        r.xx = this.xx * this.xx + this.xy * this.xy;
        r.xy = this.xx * this.yx + this.xy * this.yy;
        r.yx = this.yx * this.xx + this.yy * this.xy;
        r.yy = this.yx * this.yx + this.yy * this.yy;
        r.xd = 0.0;
        r.yd = 0.0;
        return r.isIdentity(tol);
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public boolean isDegenerate(double tol) {
        return Math.abs(this.xx * this.yy - this.yx * this.xy) <= 2.0 * tol * (Math.abs(this.xx * this.yy) + Math.abs(this.yx * this.xy));
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public boolean isScaleAndShift(double tol) {
        return this.xy * this.xy + this.yx * this.yx <= (this.xx * this.xx + this.yy * this.yy) * tol;
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public void setShift(double x, double y) {
        this.xx = 1.0;
        this.xy = 0.0;
        this.xd = x;
        this.yx = 0.0;
        this.yy = 1.0;
        this.yd = y;
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public void setScale(double x, double y) {
        this.xx = x;
        this.xy = 0.0;
        this.xd = 0.0;
        this.yx = 0.0;
        this.yy = y;
        this.yd = 0.0;
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public void setScale(double _scale) {
        this.setScale(_scale, _scale);
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public void setFlipX(double x0, double x1) {
        this.xx = -1.0;
        this.xy = 0.0;
        this.xd = x0 + x1;
        this.yx = 0.0;
        this.yy = 1.0;
        this.yd = 0.0;
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public void setFlipY(double y0, double y1) {
        this.xx = 1.0;
        this.xy = 0.0;
        this.xd = 0.0;
        this.yx = 0.0;
        this.yy = -1.0;
        this.yd = y0 + y1;
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public void setShear(double proportionX, double proportionY) {
        this.xx = 1.0;
        this.xy = proportionX;
        this.xd = 0.0;
        this.yx = proportionY;
        this.yy = 1.0;
        this.yd = 0.0;
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public void setRotate(double angle_in_Radians) {
        this.setRotate(Math.cos(angle_in_Radians), Math.sin(angle_in_Radians));
    }

    Transformation2D setSwapCoordinates() {
        this.xx = 0.0;
        this.xy = 1.0;
        this.xd = 0.0;
        this.yx = 1.0;
        this.yy = 0.0;
        this.yd = 0.0;
        return this;
    }

    void setRotate(double angle_in_Radians, Point2D rotationCenter) {
        this.setRotate(Math.cos(angle_in_Radians), Math.sin(angle_in_Radians), rotationCenter);
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public void setRotate(double cosA, double sinA) {
        this.xx = cosA;
        this.xy = -sinA;
        this.xd = 0.0;
        this.yx = sinA;
        this.yy = cosA;
        this.yd = 0.0;
    }

    void setRotate(double cosA, double sinA, Point2D rotationCenter) {
        this.setShift(-rotationCenter.x, -rotationCenter.y);
        Transformation2D temp = new Transformation2D();
        temp.setRotate(cosA, sinA);
        this.multiply(temp);
        this.shift(rotationCenter.x, rotationCenter.y);
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public void shift(double x, double y) {
        this.xd += x;
        this.yd += y;
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public void scale(double x, double y) {
        this.xx *= x;
        this.xy *= x;
        this.xd *= x;
        this.yx *= y;
        this.yy *= y;
        this.yd *= y;
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public void flipX(double x0, double x1) {
        this.xx = -this.xx;
        this.xy = -this.xy;
        this.xd = x0 + x1 - this.xd;
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public void flipY(double y0, double y1) {
        this.yx = -this.yx;
        this.yy = -this.yy;
        this.yd = y0 + y1 - this.yd;
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public void shear(double proportionX, double proportionY) {
        Transformation2D temp = new Transformation2D();
        temp.setShear(proportionX, proportionY);
        this.multiply(temp);
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public void rotate(double angle_in_Radians) {
        Transformation2D temp = new Transformation2D();
        temp.setRotate(angle_in_Radians);
        this.multiply(temp);
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public void rotate(double cos, double sin) {
        Transformation2D temp = new Transformation2D();
        temp.setRotate(cos, sin);
        this.multiply(temp);
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public void rotate(double cos, double sin, Point2D rotationCenter) {
        Transformation2D temp = new Transformation2D();
        temp.setRotate(cos, sin, rotationCenter);
        this.multiply(temp);
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public void inverse(Transformation2D inverse) {
        double det = this.xx * this.yy - this.xy * this.yx;
        if (det == 0.0) {
            inverse.setZero();
            return;
        }
        det = 1.0 / det;
        inverse.xd = (this.xy * this.yd - this.xd * this.yy) * det;
        inverse.yd = (this.xd * this.yx - this.xx * this.yd) * det;
        inverse.xx = this.yy * det;
        inverse.xy = -this.xy * det;
        inverse.yx = -this.yx * det;
        inverse.yy = this.xx * det;
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public void inverse() {
        this.inverse(this);
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public void extractScaleTransform(Transformation2D scale, Transformation2D rotateNshearNshift) {
        scale.setScale(Math.sqrt(this.xx * this.xx + this.xy * this.xy), Math.sqrt(this.yx * this.yx + this.yy * this.yy));
        rotateNshearNshift.setScale(1.0 / scale.xx, 1.0 / scale.yy);
        rotateNshearNshift.multiply(this);
    }
}

