/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.AngleUtils;
import com.esri.core.geometry.AttributeStreamOfDbl;
import com.esri.core.geometry.Envelope;
import com.esri.core.geometry.Envelope2D;
import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.GeometryException;
import com.esri.core.geometry.HadoopSDKExcluded;
import com.esri.core.geometry.MathUtils;
import com.esri.core.geometry.MultiPoint;
import com.esri.core.geometry.MultiVertexGeometryImpl;
import com.esri.core.geometry.OperatorClip;
import com.esri.core.geometry.OperatorDensifyByLength;
import com.esri.core.geometry.OperatorGeodeticLength;
import com.esri.core.geometry.OperatorProject;
import com.esri.core.geometry.OperatorSimplify;
import com.esri.core.geometry.Point2D;
import com.esri.core.geometry.Polygon;
import com.esri.core.geometry.ProgressTracker;
import com.esri.core.geometry.ProjectionTransformation;
import com.esri.core.geometry.SpatialReference;
import com.esri.core.geometry.SpatialReferenceImpl;
import com.esri.core.geometry.SpatialReferencePrecisionDescriptor;
import com.esri.core.geometry.Transformation2D;
import com.esri.sde.sdk.pe.engine.PeCSTransformations;
import com.esri.sde.sdk.pe.engine.PeCoordsys;
import com.esri.sde.sdk.pe.engine.PeGeogcs;
import com.esri.sde.sdk.pe.engine.PeLinunit;
import com.esri.sde.sdk.pe.engine.PeParameter;
import com.esri.sde.sdk.pe.engine.PeProjcs;
import com.esri.sde.sdk.pe.engine.PeProjection;
import com.esri.sde.sdk.pe.factory.PeFactory;
import java.util.concurrent.locks.ReentrantLock;

@HadoopSDKExcluded
class ShapePreservingArea {
    private SpatialReference m_sr;
    private SpatialReference m_gcs;
    private ProjectionTransformation m_transformPcs2Gcs;
    private ProgressTracker m_progress_tracker;
    private static SpatialReference[] st_fixed_SRs = new SpatialReference[7];
    private static final ReentrantLock st_lock = new ReentrantLock();
    private int m_progress_counter = 0;

    public ShapePreservingArea(SpatialReference sr, ProgressTracker progress_tracker) {
        this.m_sr = sr;
        if (sr == null || sr.getCoordinateSystemType() == SpatialReference.Type.Local || sr.getCoordinateSystemType() == SpatialReference.Type.Image) {
            throw new IllegalArgumentException();
        }
        this.m_transformPcs2Gcs = !sr.isGCS() ? sr.getSRtoGCStransform() : null;
        this.m_gcs = sr.getGCS();
        this.m_progress_tracker = progress_tracker;
    }

    public double execute(Geometry geometry) {
        if (geometry.isEmpty() || geometry.getDimension() < 2) {
            return 0.0;
        }
        if (geometry.getGeometryType() == 197) {
            Polygon poly = new Polygon();
            poly.addEnvelope((Envelope)geometry, false);
            return this.execute(poly);
        }
        Geometry geom1 = geometry;
        if (geom1.getDescription().getAttributeCount() > 1) {
            geom1 = (Polygon)geom1.copy();
            geom1.dropAllAttributes();
        }
        Geometry geom = geom1;
        Polygon simplePolygon = (Polygon)OperatorSimplify.local().execute(geom, this.m_sr, false, this.m_progress_tracker);
        if (simplePolygon.isEmpty()) {
            return 0.0;
        }
        if (simplePolygon == geometry) {
            simplePolygon = (Polygon)geometry.copy();
        }
        if (this.m_sr.isPannable()) {
            return this._ExecuteShapePreservingAreaPannable(simplePolygon);
        }
        return this._ExecuteShapePreservingAreaNonPannable(simplePolygon);
    }

    private double calculate_pannable_sub_area_(Polygon simplePolygon, Envelope2D clipWindow) {
        assert (simplePolygon.calculateArea2D() >= 0.0);
        Polygon clippedPolygon = (Polygon)OperatorClip.local().execute(simplePolygon, clipWindow, this.m_sr, this.m_progress_tracker);
        assert (clippedPolygon.calculateArea2D() >= 0.0);
        double perimeter = clippedPolygon.calculateLength2D();
        double bpu = this.m_sr.getUnit().getUnitToBaseFactor();
        double densifyCount = this.m_sr.getCoordinateSystemType() == SpatialReference.Type.Geographic ? bpu * perimeter / AngleUtils.convertToRadians(10.0) : bpu * perimeter / 1000000.0;
        if (densifyCount > 1.0) {
            double densifyLength = perimeter / Math.ceil(densifyCount);
            clippedPolygon = (Polygon)OperatorDensifyByLength.local().execute(clippedPolygon, densifyLength, this.m_progress_tracker);
        }
        if (clippedPolygon != null && !clippedPolygon.isEmpty()) {
            return this.calculate_pannable_sub_area_helper_(clippedPolygon);
        }
        return 0.0;
    }

    private double calculate_pannable_sub_area_helper_(Polygon polygon) {
        if (!this.normalizeX_pannable_(polygon, this.m_sr)) {
            throw GeometryException.GeometryInternalError();
        }
        double area_2 = this._ExecuteIterativeApproachPannable(polygon);
        return area_2;
    }

    private double calculate_pannable_sub_area_densify_(Polygon simplePolygon, Envelope2D clipWindow) {
        double area = 0.0;
        Polygon clippedPolygon = (Polygon)OperatorClip.local().execute(simplePolygon, clipWindow, this.m_sr, this.m_progress_tracker);
        if (!clippedPolygon.isEmpty()) {
            this.normalizeX_pannable_(clippedPolygon, this.m_sr);
            area = this.calculate_pannable_sub_area_densify_helper_(clippedPolygon);
        }
        return area;
    }

    private double calculate_pannable_sub_area_densify_helper_(Polygon clippedPolygon) {
        double area = 0.0;
        DensificationInfoPair densification_info = this.calc_densification_for_pannable_(clippedPolygon);
        double area_2 = this._ExecuteShapePreservingAreaPannableDensifyHelper(clippedPolygon, densification_info.first);
        int subdivisionCount = 0;
        double diff = 0.0;
        do {
            densification_info.first *= 0.5;
            densification_info.second *= 2.0;
            area = this._ExecuteShapePreservingAreaPannableDensifyHelper(clippedPolygon, densification_info.first);
            diff = Math.abs(area - area_2);
        } while (Math.abs(area_2 = area) > 1.0 && diff > 1.0E-8 * Math.abs(area_2) && (densification_info.second < 65000.0 && ++subdivisionCount < 8 || subdivisionCount < 4));
        return area;
    }

    private double _ExecuteShapePreservingAreaPannable(Polygon simplePolygon) {
        double y90 = 90.0;
        double y85 = 85.0;
        double y75 = 75.0;
        double yn60 = -60.0;
        double yn85 = -85.0;
        double yn90 = -90.0;
        double rpu = this.m_gcs.getUnit().getUnitToBaseFactor();
        if (rpu == 1.0) {
            y90 *= Math.PI / 180;
            y85 *= Math.PI / 180;
            y75 *= Math.PI / 180;
            yn60 *= Math.PI / 180;
            yn85 *= Math.PI / 180;
            yn90 *= Math.PI / 180;
        }
        if (this.m_sr.getCoordinateSystemType() == SpatialReference.Type.Projected) {
            double[][] points = new double[6][2];
            PeProjcs PE_projcs = (PeProjcs)((SpatialReferenceImpl)this.m_sr).getPECoordSys();
            points[0][0] = 0.0;
            points[0][1] = y90;
            points[1][0] = 0.0;
            points[1][1] = y85;
            points[2][0] = 0.0;
            points[2][1] = y75;
            points[3][0] = 0.0;
            points[3][1] = yn60;
            points[4][0] = 0.0;
            points[4][1] = yn85;
            points[5][0] = 0.0;
            points[5][1] = yn90;
            int c_points_out = PeCSTransformations.geogToProj((PeProjcs)PE_projcs, (int)6, (double[][])points);
            assert (c_points_out == 6);
            y90 = points[0][1];
            y85 = points[1][1];
            y75 = points[2][1];
            yn60 = points[3][1];
            yn85 = points[4][1];
            yn90 = points[5][1];
        }
        Envelope2D polygonExtent = new Envelope2D();
        simplePolygon.queryEnvelope2D(polygonExtent);
        Envelope2D pannable_extent = this.m_sr.getPannableExtent();
        double width = 0.6666666666666666 * pannable_extent.getWidth();
        double xmin = polygonExtent.xmin - polygonExtent.getWidth() * 0.01;
        Envelope2D clipWindow = new Envelope2D();
        double total_area = 0.0;
        do {
            clipWindow.xmin = xmin;
            clipWindow.xmax = Math.min(xmin + width, polygonExtent.xmax);
            clipWindow.ymin = y85;
            clipWindow.ymax = y90;
            total_area += this.calculate_pannable_sub_area_densify_(simplePolygon, clipWindow);
            clipWindow.ymin = y75;
            clipWindow.ymax = y85;
            total_area += this.calculate_pannable_sub_area_(simplePolygon, clipWindow);
            clipWindow.ymin = yn60;
            clipWindow.ymax = y75;
            total_area += this.calculate_pannable_sub_area_(simplePolygon, clipWindow);
            clipWindow.ymin = yn85;
            clipWindow.ymax = yn60;
            total_area += this.calculate_pannable_sub_area_(simplePolygon, clipWindow);
            clipWindow.ymin = yn90;
            clipWindow.ymax = yn85;
            total_area += this.calculate_pannable_sub_area_densify_(simplePolygon, clipWindow);
            xmin = clipWindow.xmax;
        } while (clipWindow.xmax < polygonExtent.xmax);
        return total_area;
    }

    private double _ExecuteIterativeApproachPannable(Polygon polygon) {
        double total_area;
        Polygon gcsPolygon;
        boolean inputIsGCS;
        PeProjcs peInputProjcs = null;
        boolean bl = inputIsGCS = this.m_transformPcs2Gcs == null;
        if (!inputIsGCS) {
            peInputProjcs = (PeProjcs)((SpatialReferenceImpl)this.m_sr).getPECoordSys();
            gcsPolygon = (Polygon)OperatorProject.local().execute(polygon, this.m_transformPcs2Gcs, this.m_progress_tracker);
            if (gcsPolygon.getPointCount() != polygon.getPointCount()) {
                return this.calculate_pannable_sub_area_densify_helper_(polygon);
            }
        } else {
            gcsPolygon = polygon;
        }
        assert (gcsPolygon.calculateArea2D() >= 0.0);
        Envelope2D gcsEnvelope = new Envelope2D();
        gcsPolygon.queryEnvelope2D(gcsEnvelope);
        SpatialReference equal_area_PCS = this.get_equal_area_PCS_instance_(this.m_gcs, gcsEnvelope, true);
        ProjectionTransformation equalAreaTransform = ProjectionTransformation.createEx(this.m_gcs, equal_area_PCS, null);
        Polygon equalAreaPolygon = (Polygon)OperatorProject.local().execute(gcsPolygon, equalAreaTransform, this.m_progress_tracker);
        if (equalAreaPolygon.getPointCount() != polygon.getPointCount()) {
            return this.calculate_pannable_sub_area_densify_helper_(polygon);
        }
        assert (equalAreaPolygon.calculateArea2D() >= 0.0);
        MultiPoint gcsMultiPoint = new MultiPoint();
        gcsMultiPoint.add(gcsPolygon, 0, -1);
        MultiPoint equalAreaPoints = (MultiPoint)OperatorProject.local().execute(gcsMultiPoint, equalAreaTransform, this.m_progress_tracker);
        if (equalAreaPoints.getPointCount() != polygon.getPointCount()) {
            return this.calculate_pannable_sub_area_densify_helper_(polygon);
        }
        MultiVertexGeometryImpl vertexGeometryImplEqAr = (MultiVertexGeometryImpl)equalAreaPoints._getImpl();
        AttributeStreamOfDbl xyStreamEqAr = (AttributeStreamOfDbl)vertexGeometryImplEqAr.getAttributeStreamRef(0);
        MultiVertexGeometryImpl vertexGeometryImplInput = (MultiVertexGeometryImpl)polygon._getImpl();
        AttributeStreamOfDbl xyStreamInput = (AttributeStreamOfDbl)vertexGeometryImplInput.getAttributeStreamRef(0);
        double equalAreaPolygonArea = equalAreaPolygon.calculateArea2D();
        equalAreaPolygon = null;
        assert (equalAreaPolygonArea >= 0.0);
        double critical_area = Math.abs(equalAreaPolygonArea) * 1.0E-10 + 1.0E-8;
        assert (critical_area >= 1.0E-8);
        int max_top_stack = 40;
        double[][] points = new double[1][2];
        StackStruct[] stack_struct_array = new StackStruct[40];
        int[] stack_extra_splits = new int[40];
        SpatialReferenceImpl equal_area_PCS_impl = (SpatialReferenceImpl)equal_area_PCS;
        PeProjcs peEqualAreaProjcs = (PeProjcs)equal_area_PCS_impl.getPECoordSys();
        int c_parts = gcsPolygon.getPathCount();
        int c_extra_splits = 0;
        double diff = 0.0;
        double area2 = 0.0;
        MathUtils.KahanSummator added_area = new MathUtils.KahanSummator(0.0);
        Point2D pEqAr1 = new Point2D();
        Point2D pInput1 = new Point2D();
        Point2D pEqAr2 = new Point2D();
        Point2D pInput2 = new Point2D();
        Point2D pEqAr = new Point2D();
        Point2D pInput = new Point2D();
        StackStruct stack_1 = new StackStruct();
        StackStruct stack_2 = new StackStruct();
        do {
            total_area = equalAreaPolygonArea;
            added_area.reset();
            int i_1 = gcsPolygon.getPathStart(0);
            for (int i_part = 0; i_part < c_parts; ++i_part) {
                int i_2 = gcsPolygon.getPathEnd(i_part);
                xyStreamEqAr.read(i_2 - 1 << 1, pEqAr1);
                xyStreamInput.read(i_2 - 1 << 1, pInput1);
                for (int i = i_1; i < i_2; ++i) {
                    xyStreamEqAr.read(i << 1, pEqAr2);
                    xyStreamInput.read(i << 1, pInput2);
                    stack_1.setValues(0.0, pEqAr1);
                    stack_2.setValues(1.0, pEqAr2);
                    int extra_splits = c_extra_splits;
                    stack_struct_array[0] = stack_2.setTo(stack_struct_array[0]);
                    stack_extra_splits[0] = c_extra_splits;
                    int stack_top = 0;
                    while (stack_top >= 0) {
                        int c_points_out;
                        this.progress();
                        double factor = (stack_1.m_factor + stack_2.m_factor) * 0.5;
                        pInput.x = (pInput2.x - pInput1.x) * factor + pInput1.x;
                        pInput.y = (pInput2.y - pInput1.y) * factor + pInput1.y;
                        pInput.queryCoords(points[0]);
                        if (!inputIsGCS) {
                            c_points_out = PeCSTransformations.projToGeog((PeProjcs)peInputProjcs, (int)1, (double[][])points);
                            assert (c_points_out == 1);
                        }
                        c_points_out = PeCSTransformations.geogToProj((PeProjcs)peEqualAreaProjcs, (int)1, (double[][])points);
                        assert (c_points_out == 1);
                        pEqAr.setCoords(points[0]);
                        double offset = -pEqAr.offset(stack_1.m_pEqAr, stack_2.m_pEqAr);
                        double distance = Point2D.distance(stack_1.m_pEqAr, stack_2.m_pEqAr);
                        double area = 0.5 * offset * distance;
                        assert (!Double.isNaN(area));
                        added_area.add(area);
                        if (Math.abs(area) > critical_area || Math.abs(area) > 0.0 && extra_splits > 0) {
                            GeometryException.releaseAssert(stack_top < 40);
                            stack_2.setValues(factor, pEqAr);
                            stack_struct_array[++stack_top] = stack_2.setTo(stack_struct_array[stack_top]);
                            if (Math.abs(area) <= critical_area) {
                                stack_extra_splits[stack_top - 1] = --extra_splits;
                                stack_extra_splits[stack_top] = extra_splits;
                                continue;
                            }
                            stack_extra_splits[stack_top] = extra_splits = stack_extra_splits[stack_top - 1];
                            continue;
                        }
                        if (stack_top == 0) break;
                        stack_1.assign(stack_2);
                        stack_2.assign(stack_struct_array[--stack_top]);
                        extra_splits = stack_extra_splits[stack_top];
                    }
                    pEqAr1.setCoords(pEqAr2);
                    pInput1.setCoords(pInput2);
                }
                i_1 = i_2;
            }
            diff = Math.abs((total_area += added_area.getResult()) - area2);
        } while (Math.abs(area2 = total_area) > 1.0 && diff > 1.0E-8 * Math.abs(area2) && ++c_extra_splits < 7);
        return area2;
    }

    private double _ExecuteShapePreservingAreaPannableDensifyHelper(Polygon polygon, double densification) {
        Polygon densePolygon = (Polygon)OperatorDensifyByLength.local().execute(polygon, densification, this.m_progress_tracker);
        Polygon gcsDensePolygon = this.m_transformPcs2Gcs != null ? (Polygon)OperatorProject.local().execute(densePolygon, this.m_transformPcs2Gcs, this.m_progress_tracker) : densePolygon;
        Envelope2D gcsEnvelope = new Envelope2D();
        gcsDensePolygon.queryEnvelope2D(gcsEnvelope);
        SpatialReference equal_area_PCS = this.get_equal_area_PCS_instance_(this.m_gcs, gcsEnvelope, true);
        ProjectionTransformation equalAreaTrans = ProjectionTransformation.createEx(this.m_gcs, equal_area_PCS, null);
        Polygon equalAreaPolygon = (Polygon)OperatorProject.local().execute(gcsDensePolygon, equalAreaTrans, this.m_progress_tracker);
        double area = equalAreaPolygon.calculateArea2D();
        return area;
    }

    private DensificationInfoPair calc_densification_for_pannable_(Polygon geom) {
        return this.calc_densification_for_non_pannable_(geom);
    }

    private DensificationInfoPair calc_densification_for_non_pannable_(Polygon geom) {
        double perimeter = geom.calculateLength2D();
        double len = OperatorGeodeticLength.local().execute(geom, this.m_sr, 4, this.m_progress_tracker);
        double count = len / 25000.0;
        double aveLength05 = perimeter / (double)geom.getSegmentCount() * 2.0;
        double densification = Math.min(aveLength05, perimeter / count);
        if (densification == 0.0) {
            densification = 1.0;
        }
        DensificationInfoPair res = new DensificationInfoPair(densification, perimeter / densification);
        return res;
    }

    private double _ExecuteShapePreservingAreaNonPannable(Polygon simplePolygon) {
        DensificationInfoPair densification_info = this.calc_densification_for_non_pannable_(simplePolygon);
        double area_2 = this._ExecuteShapePreservingAreaNonPannableHelper(simplePolygon, densification_info.first);
        int subdivisionCount = 1;
        double diff = 0.0;
        double area = 0.0;
        do {
            ++subdivisionCount;
            densification_info.first *= 0.5;
            if (densification_info.first < this.m_sr.getTolerance(0) * 50.0) {
                return area_2;
            }
            densification_info.second *= 2.0;
            area = this._ExecuteShapePreservingAreaNonPannableHelper(simplePolygon, densification_info.first);
            diff = Math.abs(area - area_2);
        } while (Math.abs(area_2 = area) > 1.0 && diff > 1.0E-8 * Math.abs(area_2) && (densification_info.second < 65000.0 && subdivisionCount < 8 || subdivisionCount < 4));
        return area;
    }

    private double _ExecuteShapePreservingAreaNonPannableHelper(Polygon polygon, double densification) {
        Polygon densePolygon = (Polygon)OperatorDensifyByLength.local().execute(polygon, densification, this.m_progress_tracker);
        Polygon gcsDensePolygon = this.m_transformPcs2Gcs != null ? (Polygon)OperatorProject.local().execute(densePolygon, this.m_transformPcs2Gcs, this.m_progress_tracker) : densePolygon;
        double rpu = this.m_gcs.getUnit().getUnitToBaseFactor();
        double scale = rpu == 1.0 ? Math.PI / 180 : 1.0;
        Envelope2D polygonExtent = new Envelope2D();
        gcsDensePolygon.queryEnvelope2D(polygonExtent);
        Envelope2D northEnv = new Envelope2D();
        Envelope2D midEnv = new Envelope2D();
        Envelope2D southEnv = new Envelope2D();
        northEnv.setCoords(polygonExtent.xmin, 75.0 * scale, polygonExtent.xmax, 90.0 * scale);
        midEnv.setCoords(polygonExtent.xmin, -60.0 * scale, polygonExtent.xmax, 75.0 * scale);
        southEnv.setCoords(polygonExtent.xmin, -90.0 * scale, polygonExtent.xmax, -60.0 * scale);
        northEnv.inflate(northEnv.getWidth() * 0.01, 0.0);
        midEnv.inflate(midEnv.getWidth() * 0.01, 0.0);
        southEnv.inflate(southEnv.getWidth() * 0.01, 0.0);
        double total_area = 0.0;
        total_area += this._ExecuteShapePreservingAreaNonPannableHelper2(gcsDensePolygon, northEnv);
        total_area += this._ExecuteShapePreservingAreaNonPannableHelper2(gcsDensePolygon, midEnv);
        return total_area += this._ExecuteShapePreservingAreaNonPannableHelper2(gcsDensePolygon, southEnv);
    }

    private double _ExecuteShapePreservingAreaNonPannableHelper2(Polygon gcsDensePolygon, Envelope2D env) {
        Polygon clippedPolygon = (Polygon)OperatorClip.local().execute(gcsDensePolygon, env, this.m_gcs, this.m_progress_tracker);
        if (clippedPolygon != null && !clippedPolygon.isEmpty()) {
            Envelope2D envelope = new Envelope2D();
            clippedPolygon.queryEnvelope2D(envelope);
            SpatialReference equal_area_PCS = this.get_equal_area_PCS_instance_(this.m_gcs, envelope, false);
            ProjectionTransformation equalAreaTrans = ProjectionTransformation.createEx(this.m_gcs, equal_area_PCS, null);
            Polygon equalAreaPolygon = (Polygon)OperatorProject.local().execute(clippedPolygon, equalAreaTrans, this.m_progress_tracker);
            return equalAreaPolygon.calculateArea2D();
        }
        return 0.0;
    }

    private boolean normalizeX_pannable_(Polygon polygon, SpatialReference sr) {
        Envelope2D polygonExtent = new Envelope2D();
        polygon.queryEnvelope2D(polygonExtent);
        Envelope2D pannable_extent = sr.getPannableExtent();
        double delta = pannable_extent.getWidth() * 1.0E-4;
        pannable_extent.inflate(-delta, 0.0);
        if (!pannable_extent.contains(polygonExtent)) {
            double x_shift = pannable_extent.getCenterX() - polygonExtent.getCenterX();
            Transformation2D trans = new Transformation2D();
            trans.setShift(x_shift, 0.0);
            polygon.applyTransformation(trans);
            polygonExtent.move(x_shift, 0.0);
            return pannable_extent.contains(polygonExtent);
        }
        return true;
    }

    private SpatialReference get_equal_area_pcs_fixed_(SpatialReference gcs, Envelope2D envelope, boolean pannableCase) {
        PeProjection PE_proj_ptr;
        double rpu = gcs.getUnit().getUnitToBaseFactor();
        Point2D env_center = envelope.getCenter();
        env_center.scale(rpu * 180.0 / Math.PI);
        Point2D projCenter = new Point2D(0.0, 0.0);
        int fixed_SR_index = 0;
        if (pannableCase) {
            Envelope2D pannableExtentDeflated = gcs.getPannableExtent();
            double degree = Math.PI / 180 / rpu;
            pannableExtentDeflated.inflate(-degree, -degree * 5.0);
            if (pannableExtentDeflated.contains(envelope)) {
                fixed_SR_index = 6;
                projCenter.x = pannableExtentDeflated.getCenterX();
                projCenter.y = 0.0;
            }
        }
        if (fixed_SR_index == 0) {
            double dist;
            if (env_center.y > 45.0) {
                projCenter.y = 1.5707963267948966;
                fixed_SR_index = 0;
            } else if (env_center.y < -45.0) {
                projCenter.y = -1.5707963267948966;
                fixed_SR_index = 1;
            } else if (env_center.x >= 45.0 && env_center.x < 135.0) {
                projCenter.x = 1.5707963267948966;
                fixed_SR_index = 2;
            } else if (env_center.x >= 135.0 || env_center.x < -135.0) {
                projCenter.x = 1.5707963267948966;
                fixed_SR_index = 3;
            } else if (env_center.x < -45.0 && env_center.x >= -135.0) {
                projCenter.x = -1.5707963267948966;
                fixed_SR_index = 4;
            } else {
                projCenter.x = 0.0;
                fixed_SR_index = 5;
            }
            double env_diag = rpu * Math.sqrt(MathUtils.sqr(envelope.xmin - envelope.xmax) + MathUtils.sqr(envelope.ymin - envelope.ymax));
            Point2D projCenterAdjusted = new Point2D(projCenter);
            Point2D env_center_rad = envelope.getCenter();
            env_center_rad.scale(rpu);
            if (fixed_SR_index < 2) {
                projCenterAdjusted.x = env_center_rad.x;
            }
            if ((dist = Point2D.distance(projCenterAdjusted, env_center_rad)) + env_diag * 0.5 > 1.5707963267948966) {
                return null;
            }
        }
        st_lock.lock();
        SpatialReference sr = st_fixed_SRs[fixed_SR_index];
        st_lock.unlock();
        if (sr != null && sr.getGCS().equalHorizontal(gcs)) {
            return sr;
        }
        PeLinunit PE_linunit_ptr = PeFactory.linunit((int)9001);
        PeGeogcs PE_geogcs_ptr = (PeGeogcs)((SpatialReferenceImpl)gcs).getPECoordSys().clone();
        PeParameter[] PE_param_arr = new PeParameter[16];
        for (int i = 0; i < 16; ++i) {
            PE_param_arr[i] = null;
        }
        PE_param_arr[2] = PeParameter.fromArgs((String)"Central_Meridian", (double)projCenter.x);
        PE_param_arr[6] = PeParameter.fromArgs((String)"Latitude_of_Origin", (double)projCenter.y);
        PE_param_arr[0] = PeParameter.fromArgs((String)"False_Easting", (double)0.0);
        PE_param_arr[1] = PeParameter.fromArgs((String)"False_Northing", (double)0.0);
        if (fixed_SR_index != 6) {
            PE_proj_ptr = PeFactory.projection((int)43033);
        } else {
            assert (pannableCase);
            PE_param_arr[3] = PeParameter.fromArgs((String)"Standard_Parallel_1", (double)0.0);
            PE_proj_ptr = PeFactory.projection((int)43034);
        }
        PeProjcs PE_coord_sys = PeProjcs.fromArgs((String)"EqualAreaPCS", (PeGeogcs)PE_geogcs_ptr, (PeProjection)PE_proj_ptr, (PeParameter[])PE_param_arr, (PeLinunit)PE_linunit_ptr);
        SpatialReferenceImpl equalAreaPcs = SpatialReferenceImpl.createImpl((PeCoordsys)PE_coord_sys, null, SpatialReferencePrecisionDescriptor.Precision.Integer64);
        st_lock.lock();
        ShapePreservingArea.st_fixed_SRs[fixed_SR_index] = equalAreaPcs;
        st_lock.unlock();
        return equalAreaPcs;
    }

    private SpatialReference get_equal_area_PCS_instance_(SpatialReference gcs, Envelope2D envelope, boolean pannableCase) {
        PeProjection PE_proj_ptr;
        SpatialReference equalAreaSr = this.get_equal_area_pcs_fixed_(gcs, envelope, pannableCase);
        if (equalAreaSr != null) {
            return equalAreaSr;
        }
        PeLinunit PE_linunit_ptr = PeFactory.linunit((int)9001);
        PeGeogcs PE_geogcs_ptr = (PeGeogcs)((SpatialReferenceImpl)gcs).getPECoordSys().clone();
        PeParameter[] PE_param_arr = new PeParameter[16];
        for (int i = 0; i < 16; ++i) {
            PE_param_arr[i] = null;
        }
        double rpu = gcs.getUnit().getUnitToBaseFactor();
        PE_param_arr[2] = PeParameter.fromArgs((String)"Central_Meridian", (double)((envelope.xmin + envelope.getWidth() / 2.0) * rpu));
        PE_param_arr[6] = PeParameter.fromArgs((String)"Latitude_of_Origin", (double)((envelope.ymin + envelope.getHeight() / 2.0) * rpu));
        PE_param_arr[0] = PeParameter.fromArgs((String)"False_Easting", (double)0.0);
        PE_param_arr[1] = PeParameter.fromArgs((String)"False_Northing", (double)0.0);
        if (envelope.ymin * rpu >= 1.3089969389957472 || envelope.ymax * rpu <= -1.0471975511965976) {
            PE_proj_ptr = PeFactory.projection((int)43033);
        } else if (envelope.ymin > 0.0 || envelope.ymax < 0.0) {
            PE_param_arr[3] = PeParameter.fromArgs((String)"Standard_Parallel_1", (double)((envelope.ymin + 0.3333333333333333 * envelope.getHeight()) * rpu));
            PE_param_arr[4] = PeParameter.fromArgs((String)"Standard_Parallel_2", (double)((envelope.ymin + 0.6666666666666666 * envelope.getHeight()) * rpu));
            PE_proj_ptr = PeFactory.projection((int)43007);
        } else {
            PE_param_arr[3] = PeParameter.fromArgs((String)"Standard_Parallel_1", (double)((envelope.ymin + 0.6666666666666666 * envelope.getHeight()) * rpu));
            PE_proj_ptr = PeFactory.projection((int)43034);
        }
        PeProjcs PE_coord_sys = PeProjcs.fromArgs((String)"EqualAreaPCS", (PeGeogcs)PE_geogcs_ptr, (PeProjection)PE_proj_ptr, (PeParameter[])PE_param_arr, (PeLinunit)PE_linunit_ptr);
        return SpatialReferenceImpl.createImpl((PeCoordsys)PE_coord_sys, null, SpatialReferencePrecisionDescriptor.Precision.Integer64);
    }

    private void progress() {
        ++this.m_progress_counter;
        if ((this.m_progress_counter & 0xFFF) == 0) {
            ProgressTracker.checkAndThrow(this.m_progress_tracker);
            this.m_progress_counter = 0;
        }
    }

    private final class StackStruct {
        Point2D m_pEqAr = new Point2D();
        double m_factor;

        private StackStruct() {
        }

        void setValues(double factor, Point2D pEqAr) {
            this.m_factor = factor;
            this.m_pEqAr.setCoords(pEqAr);
        }

        StackStruct setTo(StackStruct dst_) {
            StackStruct dst = dst_;
            if (dst == null) {
                dst = new StackStruct();
            }
            dst.m_factor = this.m_factor;
            dst.m_pEqAr.setCoords(this.m_pEqAr);
            return dst;
        }

        void assign(StackStruct src) {
            this.m_factor = src.m_factor;
            this.m_pEqAr.setCoords(src.m_pEqAr);
        }
    }

    private static class DensificationInfoPair {
        double first;
        double second;

        DensificationInfoPair(double v1, double v2) {
            this.first = v1;
            this.second = v2;
        }
    }
}

